	.TITLE	TABLEC.ASL

;	--------------------------------------
;		(C) 1987 - Daniel Roux
;	--------------------------------------

; Rev	Date		Amliorations
; -----------------------------------------------------------------------
; 1.3	16.12.87	ROUND
; 1.2	01.10.87	CHERCHEID: nouvelle opration (doit tre =)
;			CHERCHEID: chanes possibles dans 1re liste
;			CHNB,NBCH,CHDA,DACH,CHHE,HECH,NBDA,DANB,NBHE,HENB
; 1.1	18.08.87	MATH64: utilise toujours le bit BM64AVAVDER
; 1.0			Premire version diffuse



	.PROC	M680002		; mnmonics CALM 2
	.RADIX	10.		; base 10 par dfaut
	.HEX			; listing en hexadcima

	.REF	SMAKY
	.REF	MODULES
	.REF	TABLEC




; Constantes
; ----------

MAJREV	=	1		; rvision
MINREV	=	3		; version

KEYDBOX	=	H'7E00



	.REV	MAJREV,MINREV
	.TEXT	"(C)  Daniel ROUX et EPSITEC-system sa"





; Oprations mathmatiques
; ------------------------

	.LOC	0

FOPNIL:		.BLKB	1	; pas d'opration
FOPEVEN:	.BLKB	1	; pour rendre l'adresse paire

FOPNB:		.BLKB	1	; nombre:	<8 bytes> nombre <0>
FOPDAT:		.BLKB	1	; date:		<8 bytes> date <0>
FOPTIM:		.BLKB	1	; heure:	<8 bytes> heure <0>
FOPSTR:		.BLKB	1	; chane:	<8 bytes> chane <0>
FOPERR:		.BLKB	1	; erreur:	<8 bytes>
FOPCEL:		.BLKB	1	; cellule:	<4 bytes>
FOPNOM:		.BLKB	1	; nom:		<4 bytes>
FOPFILE:	.BLKB	1	; fichier:	nom <0>
		.BLKB	19

FOPCONST:			; ----- constantes -----
FOPPI:		.BLKB	1	; constante PI
FOPE:		.BLKB	1	; constante E
FOPFALSE:	.BLKB	1	; constante faux (0)
FOPTRUE:	.BLKB	1	; constante vrai (1)
FOPTODAY:	.BLKB	1	; constante aujourd'hui
FOPNOW:		.BLKB	1	; constante maintenant
		.BLKB	19

FOP1:				; ----- type 1 -----
FOPPO:		.BLKB	1	; "("
FOPPF:		.BLKB	1	; ")"
FOPSEP:		.BLKB	1	; ","
FOPTO:		.BLKB	1	; ":"
FOPADD:		.BLKB	1	; addition
FOPSUB:		.BLKB	1	; soustraction
FOPMUL:		.BLKB	1	; multiplication
FOPDIV:		.BLKB	1	; division
FOPPOW:		.BLKB	1	; puissance
FOPEQ:		.BLKB	1	; gal
FOPNE:		.BLKB	1	; diffrent
FOPLS:		.BLKB	1	; plus petit ou gal
FOPHS:		.BLKB	1	; plus grand ou gal
FOPLO:		.BLKB	1	; plus petit
FOPHI:		.BLKB	1	; plus grand
		.BLKB	22

FOP2:				; ----- type 2 -----
FOPSQR:		.BLKB	1	; racine carre
FOPLOGE:	.BLKB	1	; log naturel
FOPEXPE:	.BLKB	1	; exp naturel
FOPLOG10:	.BLKB	1	; log dcimal
FOPEXP10:	.BLKB	1	; exp dcimal (pas utilis)
FOPSIN:		.BLKB	1	; sinus
FOPCOS:		.BLKB	1	; cosinus
FOPTAN:		.BLKB	1	; tangente
FOPASIN:	.BLKB	1	; arc-sinus
FOPACOS:	.BLKB	1	; arc-cosinus
FOPATAN:	.BLKB	1	; arc-tangente
FOPSINH:	.BLKB	1	; sinus hyperbolique
FOPCOSH:	.BLKB	1	; cosinus hyperbolique
FOPTANH:	.BLKB	1	; tangente hyperbolique
FOPABS:		.BLKB	1	; valeur absolue
FOPINT:		.BLKB	1	; partie entire
FOPFRAC:	.BLKB	1	; partie fractionnaire
FOPNEG:		.BLKB	1	; changement de signe
FOPNOT:		.BLKB	1	; non
FOPCHNB:	.BLKB	1	; chane <-- nombre
FOPNBCH:	.BLKB	1	; nombre <-- chane
FOPCHDA:	.BLKB	1	; chane <-- date
FOPDACH:	.BLKB	1	; date <-- chane
FOPCHHE:	.BLKB	1	; chane <-- heure
FOPHECH:	.BLKB	1	; heure <-- chane
FOPNBDA:	.BLKB	1	; nombre <-- date
FOPDANB:	.BLKB	1	; date <-- nombre
FOPNBHE:	.BLKB	1	; nombre <-- heure
FOPHENB:	.BLKB	1	; heure <-- nombre
		.BLKB	9

FOPLEN:		.BLKB	1	; longueur
FOPUPPER:	.BLKB	1	; majuscules
FOPLOWER:	.BLKB	1	; minuscules
		.BLKB	10

FOPWEEK:	.BLKB	1	; jour de la semaine
FOPDAY:		.BLKB	1	; jour
FOPMONTH:	.BLKB	1	; mois
FOPYEAR:	.BLKB	1	; anne
FOPHOUR:	.BLKB	1	; heure
FOPMINUTE:	.BLKB	1	; minute
		.BLKB	8

FOP3:				; ----- type 3 -----
FOPSUM:		.BLKB	1	; somme
FOPAVG:		.BLKB	1	; moyenne
FOPNUM:		.BLKB	1	; nb d'lments
FOPVAR:		.BLKB	1	; variance
FOPSTD:		.BLKB	1	; cart type
FOPMIN:		.BLKB	1	; valeur minimale
FOPMAX:		.BLKB	1	; valeur maximale
FOPIF:		.BLKB	1	; test
FOPCHOOSE:	.BLKB	1	; index
FOPLOOKUP:	.BLKB	1	; cherche
FOPNPV:		.BLKB	1	; valeur actuelle nette
FOPAND:		.BLKB	1	; et
FOPOR:		.BLKB	1	; ou
FOPLOOKEQ:	.BLKB	1	; cherche id.
FOPROUND:	.BLKB	1	; arrondi
FOPCNT:		.BLKB	1	; compte
		.BLKB	12

FOPMID:		.BLKB	1	; milieu
FOPLEFT:	.BLKB	1	; gauche
FOPRIGHT:	.BLKB	1	; droite
FOPWORD:	.BLKB	1	; mot
		.BLKB	10

FOPDATE:	.BLKB	1	; date
FOPTIME:	.BLKB	1	; temps
		.BLKB	9

		.IF	.>256
		Dsol, mais c'est trop long !!!
		.ENDIF


TYPEALPHA=	'A		; type alphabtique
TYPEDATE=	'D		; type date
TYPETIME=	'T		; type temps
TYPENB	=	'R		; type nombre rel
TYPERR	=	'E		; type erreur




; Table pour les noms
; -------------------

MAXTN	=	100		; nb max de noms/rfrences

LGMNOM	=	20		; lg max d'un nom
LGMREF	=	30		; lg max d'une rfrence code

	.LOC	0
OTNHAC:	.BLKB	4		; valeur "h"
OTNNOM:	.BLKB	LGMNOM		; nom
OTNREF:	.BLKB	LGMREF		; rfrence code
LTN:




; Variables globales
; ------------------

	.LOC	0
OCHECK:	.BLKB	4		; mot de contrle

OCHMATH64:.BLKB	2		; canal du module math64
OCHMATH:.BLKB	4		; canal interne de math64

OGVNOM:	.BLKB	4		; ^routine GETVARNOM

OFLAGS:	.BLKB	1		; flags divers
;BCALC	...
	.EVEN

OEXUA6:	.BLKB	4		; A6 de l'utilisateur
OEXREF:	.BLKB	4		; cellule de rfrence
OEXBST:	.BLKB	1000		; buffer des chanes de caractres

OCNTSP:	.BLKB	1		; nb d'espaces
OCNTPT:	.BLKB	1		; nb de "."
OCNTSL:	.BLKB	1		; nb de "/"
OCNTPP:	.BLKB	1		; nb de ":"
OCNT09:	.BLKB	1		; nb de chiffres
OCNTAZ:	.BLKB	1		; nb de lettres
	.EVEN

OPFIL1:	.BLKB	4		; ^nom de fichier (avant cellule)
OPFIL2:	.BLKB	4		; ^nom de fichier (pour rcursion)

OAJREF:	.BLKB	4		; ajust: rfrence
OAJP1:	.BLKB	4		; ajust: P1
OAJP2:	.BLKB	4		; ajust: P2
OAJDEP:	.BLKB	4		; ajust: dplacement

ONM:
ONMLG:	.BLKB	2		; nom: lg pour i/o
ONMNB:	.BLKB	2		; nom: nb de noms/rfrences
ONMSEM:	.BLKB	4		; nom: semence pour "h"
ONMFAN:	.BLKB	1		; nom: fanions
	.BLKB	9		; nom: rserve
ONMTA:	.BLKB	LTN*MAXTN	; nom: table des noms/rfrences
LNM	=  .-ONM

ONMSLV:	.BLKB	LSLVAR		; nom: variables scroll-list
ONMHAC:	.BLKB	4		; nom: valeur "h"
ONMNOM:	.BLKB	LGMNOM+2	; nom: nom
ONMTMP:	.BLKB	LGMNOM+2	; nom: nom temporaire
ONMREF:	.BLKB	LGMREF+2	; nom: rfrence dcode
ONMCOD:	.BLKB	LGMREF*2	; nom: rfrence code

ORNDMO:	.BLKB	4		; rnd: mode
ORNDBU:	.BLKB	10		; rnd: dition nb de dcimales

LGVAR:




; En-tte du module LIB
; ---------------------

	.LOC	0
	TABLEC_	FIRST		; code du premier appel
	TABLEC_	LAST		; code du dernier appel
	.B	0		; nombre d'installations
	.FILLB	(OHLREV-.),0
	.B	MAJREV,MINREV	; rvision.version
	.W	0,END_TABLEC	; longueur
	.W	(PATHLIB&H'FFFF0000)/H'10000 ; pattern de dbut
	.W	PATHLIB&H'FFFF	; pattern de dbut
	.FILLB	(OHLNAM-.),0
	.ASCII	"TABLEC"	; nom du module
	.FILLB	(LGHLIB-.),0

	.W	_TABLEC_OPEN
	.W	_TABLEC_CLOSE
	.W	_TABLEC_MODE
	.W	_TABLEC_EXPR
	.W	_TABLEC_ASCI
	.W	_TABLEC_FP
	.W	_TABLEC_CODE
	.W	_TABLEC_DECO
	.W	_TABLEC_RND
	.W	_TABLEC_CELN
	.W	_TABLEC_CELR
	.W	_TABLEC_CEL09
	.W	_TABLEC_CELAZ
	.W	_TABLEC_GETN
	.W	_TABLEC_MENU
	.W	_TABLEC_MINS
	.W	_TABLEC_ERROR
	.W	_TABLEC_DBER
	.W	_TABLEC_AJUST
	.W	_TABLEC_COMP
	.W	_TABLEC_NOM
	.W	_TABLEC_ITER





; Codes des appels
; ----------------




;-------------\\
; _TABLEC_OPEN >
;=============/

; Ouvre le module TABLEC.
; C'est cet appel qui charge et ouvre MATH64 !

; in	A2.L	^routine (*)
; out	D6.L	canal
;	D7.W	erreur
; mod	D6.L, D7.W

; La routine (*) GETVARNOM est appele directement depuis TABLEC pour
; connatre les noms de n'importe quel tableau.
; Elle reoit les paramtres suivants :
;
; in	A6.L	^variables utilisateur
;	A3.L	^nom du tableau
; out	A4.L	^variables pour les noms
;	D7.W	erreur
; mod	D7.W, A4.L

_TABLEC_OPEN:
	PUSHM.L	D0,D1,D3,D4,A4..A6

	LOAD.L	A5,A6

	LOAD.L	D4,#LGVAR
	LOAD.W	D1,#MTYPCP
	GESMEM	?GETMEM		; demande mmoire pour variables
	JUMP,NE 90$
	LOAD.L	A6,A4		; A6 <-- ^variables
10$:
	CLR.B	(A4+)		; met toutes les variables  zro
	DEC.W	D4
	JUMP,NE 10$

	LOAD.L	(A6)+OCHECK,A6	; init mot de contrle
	LOAD.L	(A6)+OEXUA6,A5	; mm. A6 de l'utilisateur
	LOAD.L	(A6)+OGVNOM,A2	; init ^routine GETVARNOM

	LOAD.L	A3,#R16"NMMATH64
	LOAD.W	D3,#MATH64_FIRST
	LIB_	OPEN		; charge le module MATH64
	JUMP,NE 80$
	LOAD.W	(A6)+OCHMATH64,D1

	CLR.L	D0		; D0 <-- mode par dfaut
	MATH64_	OPEN		; ouvre le module MATH64
	JUMP,NE 70$
	LOAD.L	(A6)+OCHMATH,A5

	LOAD.B	(A6)+OFLAGS,#2^BCALCF

	LOAD.L	D6,A6		; D6 <-- canal
	CLR.W	D7		; D7 <-- ok
	JUMP	90$

70$:
	PUSH.W	D7
	LOAD.W	D1,(A6)+OCHMATH64
	LIB_	CLOSE		; ferme MATH64
	POP.W	D7
80$:
	PUSH.W	D7
	LOAD.L	A4,A6
	LOAD.W	D1,#MTYPCP
	GESMEM	?GIVMEM		; rend les variables
	POP.W	D7
90$:
	POPM.L	D0,D1,D3,D4,A4..A6
	TEST.W	D7		; retour EQ/NE
	RET


;--------------\\
; _TABLEC_CLOSE >
;==============/

; Ferme le module TABLEC.
; C'est cet appel qui ferme et libre MATH64 !

; in	D6.L	canal
; out	-
; mod	D7.W

_TABLEC_CLOSE:
	PUSHM.L	D0,D1,A4..A6

	LOAD.W	D7,#ERTCCHA

	LOAD.L	A6,D6		; A6 <-- ^variables
	COMP.L	D6,(A6)+OCHECK	; mot de contrle ok ?
	JUMP,NE 90$		; non => 90$

	LOAD.L	A5,(A6)+OCHMATH	; A5 <-- canal interne de math64
	MATH64_	CLOSE		; ferme le module MATH64

	LOAD.W	D1,(A6)+OCHMATH64
	LIB_	CLOSE		; libre le module MATH64

	LOAD.L	A4,A6
	LOAD.W	D1,#MTYPCP
	GESMEM	?GIVMEM		; libre la mmoire des variables

	CLR.W	D7		; D7 <-- ok
90$:
	POPM.L	D0,D1,A4..A6
	TEST.W	D7		; retour EQ/NE
	RET


;-------------\\
; _TABLEC_MODE >
;=============/

; Change le mode de travail de TABLEC.

; in	D3.W	flags BCALC..
;	D4.L	zro
;	D6.L	canal
; out	D7.W	erreur
; mod	D7.W

_TABLEC_MODE:
	PUSHM.L	D3,A6

	LOAD.W	D7,#ERTCCHA

	LOAD.L	A6,D6		; A6 <-- ^variables
	COMP.L	D6,(A6)+OCHECK	; mot de contrle ok ?
	JUMP',NE 90$		; non => 90$

	TEST.L	D3:#BCALCF
	JUMP',BS 50$
	TEST.L	D3:#BCALCE
	JUMP',BS 50$
	TSET.L	D3:#BCALCF	; D3 <-- franais par dfaut
50$:
	LOAD.B	(A6)+OFLAGS,D3
	CLR.W	D7		; D7 <-- ok
90$:
	POPM.L	D3,A6
	TEST.W	D7		; retour EQ/NE
	RET





	.INS	TABLECNOM.ASI
	.INS	TABLECEXPR.ASI
	.INS	TABLECOPER.ASI
	.INS	TABLECSPEC.ASI
	.INS	TABLECAJUS.ASI
	.INS	TABLECDATE.ASI
	.INS	TABLECCODE.ASI
	.INS	TABLECERR.ASI
	.INS	TABLECCEL.ASI
	.INS	TABLECRND.ASI
	.INS	TABLECMENU.ASI





DOKCR:
	LOAD.W	D3,#CR
	RET

DOKEND:
	LOAD.W	D3,#END
	RET

DOKOUI:
	LOAD.W	D3,#'O
	RET

DOKNON:
	LOAD.W	D3,#'N
	RET

DOKF0:
	LOAD.W	D3,#F0
	RET

DOKF1:
	LOAD.W	D3,#F1
	RET

DOKF2:
	LOAD.W	D3,#F2
	RET

DOKF3:
	LOAD.W	D3,#F3
	RET

DOKF4:
	LOAD.W	D3,#F4
	RET

DOKF5:
	LOAD.W	D3,#F5
	RET

DOKF6:
	LOAD.W	D3,#F6
	RET

DOKF7:
	LOAD.W	D3,#F7
	RET

DOKF8:
	LOAD.W	D3,#F8
	RET

DOKF9:
	LOAD.W	D3,#F9
	RET

DOKF10:
	LOAD.W	D3,#F10
	RET

DOKF11:
	LOAD.W	D3,#F11
	RET

DOKF12:
	LOAD.W	D3,#F12
	RET

DOKF13:
	LOAD.W	D3,#F13
	RET

DOKF14:
	LOAD.W	D3,#F14
	RET

DOKF15:
	LOAD.W	D3,#F15
	RET

DOKMGR:
	LOAD.W	D3,#KEYMGR
	RET

DOKMGP:
	LOAD.W	D3,#KEYMGP
	RET






; Textes
; ------


NMMATH64:.ASCIZ	"MATH64"
	.EVEN




END_TABLEC:


	.END
