
	.TITLE	 	CENTRO
	.PROC		M68020

; Pilote pour interface centronique sur tous les Smakys
; -----------------------------------------------------


	.IDENT		"(C) 1997 Pierre Arnaud, OPaC bright ideas"

	.REF		SMAKY
;	.REF 		MON
	.REF 		BIOSDRIV
	.REF		BIOS
	.REF		SMAKYX86

MAJREV	= 0
MINREV	= 1

	.REV	MAJREV,MINREV



	.LOC		0
ADRZERO:

; Entte du pilote : 
;===================

	.16		0,D0BASE			; Add fin entte pilote
	.16		2**7
D0ID:							; Offset routine :
	.16		D0OPEN-D0BASE			; Open
	.16		D0COMMAND-D0BASE		; Command
	.16		D0RSTATUS-D0BASE		; Read status
	.16		-1				; Read
	.16		D0WRITE-D0BASE			; Write
	.16		D0CLOSE-D0BASE			; Close
	.16		D0STOPTR-D0BASE			; Stop
	.16		D0STARTR-D0BASE			; Start
	.16		D0AVOTR-D0BASE			; Avort
	.16		-1				; Auxiliaire 1
	.16		-1				; Auxiliaire 2
	.16		D0RESET-D0BASE			; Reset
	.16		D0KILL-D0BASE			; Kill
	.16		-1				; 
	.16		-1				; 
	.16		-1				; 
D0NAB:
	.ASCII	 	"CENTRO_0"			; Nom pilote
D0NAF:	.FILL.8		LGDNAM-(D0NAF-D0NAB),0		; Renpli le reste avec des 0
	.8		16'88				; Numro pilote
	.8		TYPIO				; Type : entre/sortie
	.8		MAJREV,MINREV			; Rvision - version
	.8		20				; Priorit dans pilote
	.8		0				; no bios high

	.8		0				; Attribut 1
;	.8		2**BDWROK.OR.2**BDNORT		; Attribut 0
	.8		2**BDWROK			; Attribut 0

	.FILL.8		LGDDESC-(APC-D0ID),0		; Le reste avec des 0
D0BASE:




;--------------\\
;     RESET     >
;--------------/

; in	A2.32		^paramtres ligne de commande
; out	A6.32		^variables locales du pilote
; 	D7.16		Erreur
; mod	D0.32, D1.32, A0.32, A1.32, A6.32, D7.16

D0RESET:
	CLR.16	D7
	RET


;--------------\\
;     KILL      >
;--------------/

; in	A6.32		^variable du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0KILL:
	CLR.16	D7
	RET


;--------------\\
;     OPEN      >
;--------------/

; in	A6.32		^variable du pilote
; out	D7.16		Erreur
; mod	D0..A1.32 , D7.16

D0OPEN:
	CLR.16	D7
	RET


;--------------\\
;     CLOSE     >
;--------------/

; In	A6.32		^variable du pilote
; Out	D7.16		erreur
; Mod	D0..A1.32, D7.16

D0CLOSE:
	MOVE.16	#-1,AddrCentro		; termine le job (flush vers l'imprimante)
	CLR.16	D7
	RET

;--------------\\
;    RSTATUS    >
;--------------/

; in	A6.32		^variable du pilote
;	A4.32		^buffer pour les status
;	D4.32		Nombre de bytes  lire
; Out	D4.32		Longueur lue effectivement
;	D7.16		Erreur
; Mod	D0..A1.32, D4.32, D7.16

D0RSTATUS:
	CLR.16		D7
	RET



;--------------\\
;   COMMAND     >
;--------------/

; in	A6.32		^variable du pilote
;	A4.32		^table des commandes termine par un 0
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0COMMAND:
	CLR.16		d7
	RET


;--------------\\
;    WRITE      >
;--------------/

; in	A6.32		^variables du pilote
;	A4.32		^ la zone mmoire
;	D5.32		Lg  crire
; out	D5.32		Lg effectivement crite
;	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0WRITE:
	PUSHM.32	D3|D5|A4

	TEST.32		D5
	JUMP,EQ		R8^EXIT$

	MOVE.32		#0,D3

LOOP$:	MOVE.8		{A4+},D3
	MOVE.16		D3,AddrCentro
	DEC.32		D5
	JUMP,NE		LOOP$

EXIT$:	POPM.32		D3|D5|A4
	CLR.16		D7
	RET




;--------------\\
;     AVOTR     >
;--------------/
;    Routine appelle par un processus pour stopper un transfert
; en cours en lui faisant gnrer une erreur lors d'un WRITE.
; tant que le pilote est ouvert, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'AVOTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32 , D7.16

D0AVOTR:
	CLR.16	D7
	RET



;--------------\\
;    STOPTR     >
;--------------/

; Routine appelle par un processus pour arrter provisoire-
; ment un transfert en cours en le faisant attendre dans le
; pilote dans WRITE, aussi longtemps que la routine STARTR
; n'est excute.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STOPTR:
	RET



;--------------\\
;    STARTR     >
;--------------/

; Routine appelle par un processus pour redmarrer un
; transfert en cours stopp auparavant par STOPTR.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en attente au moment de l'AVOTR.
; Cependant, l'appel  cette routine doit correspondre  un
; appel  la routine STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STARTR:
	RET



	.END
