; $CALM:

	.TITLE	CLOCK.ASD

	.PROC	M68000
	.BASE	10'10

	.REF	MON
	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	SMAKYX86

REVMAJ	= 0
REVMIN	= 1


;	Date	  Rv	Remarques
;	---------------------------------------------------------------------------------
;	02/12/96	
;	---------------------------------------------------------------------------------


PCCODE	= 0
PCVAR	= 1

		.LOC	0

OMSGBAL:	.BLK.32	1
OMODE:		.BLK.8	1
		.EVEN
ODELAY:		.BLK.16	1
LGVAR:
		.LOC	0


	.REV	REVMAJ, REVMIN
	.START	-1


;	En-tte gnral du pilote
;	-------------------------

	.LOC	0

	.16	0,CLK0BASE		; un seul pilote
	.16	2**7


; =============================================================
;		    DRIVER $CLOCK_0		No 16'38
; =============================================================

CLK0ID:
	.16	CLK0OPEN-CLK0BASE
	.16	CLK0COMMAND-CLK0BASE
	.16	CLK0RSTATUS-CLK0BASE
	.16	CLK0READ-CLK0BASE
	.16	-1			; WRITE
	.16	CLK0CLOSE-CLK0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; AUX1
	.16	-1			; AUX2
	.16	CLK0RESET-CLK0BASE
	.16	CLK0KILL-CLK0BASE
	.16	-1			; STRT
	.16	-1			; TSTRT
	.16	-1			; START

CLK0NAB:
	.ASCII	"CLOCK_0"		; nom driver
	.FILL.8 LGDNAM-(APC-CLK0NAB),0

	.8	16'38			; numro driver
	.8	TYPIO			; type de priphrique

	.8	REVMAJ,REVMIN		; rvision - version
	.8	-1,0			; priorit dans le driver

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8 LGDDESC-(APC-CLK0ID),0	; le reste.
CLK0BASE:



;------------\\
;  CLK0RESET  >
;============/

; Initialise le pilote.

; in	A0.32	^adresse de base du pilote
; out	A6.32	^variables du pilote
;	D7.16	erreur
; mod	A6.32, D7.16, D0,D1,A0,A1

CLK0RESET:
	PUSHM.32 D4|A4|A5

	MOVE.32	#R16^CLK0BASE,A1
	MOVE.32	#MTYPBD,D1
	MOVE.32	#LGVAR,D4
	GESMEM	?GETMEM
	JUMP,NE	EXIT$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6			; pour rendre le ^var.

	MOVE.32	#0,D4
	NTREL	?CREBAL
	MOVE.32	A5,{A6}+OMSGBAL

EXIT$:	POPM.32	D4|A4|A5
	RET





;------------\\
;  CLK0KILL   >
;============/

; Destruction du pilote.

; in	A6.32	^variables
; out	D7.16	#ERKLPR, driver indestructible
; mod	D7.16

CLK0KILL:
	MOVE.16	#ERKLPR,D7
	RET



;-----------\\
;  CLK0OPEN  >
;===========/

; Ouvre.
; Ici, on ne fait rien !

; in	A6.32	^variables
; out	D7.16	erreur
; mod	D7.16, D0,D1,A0,A1

CLK0OPEN:
	CLR.16	D7
	RET




;------------\\
;  CLK0CLOSE  >
;============/

; Ferme.
; Ici, on ne fait rien !

; in	A6.32	^variables
; out	D7.16	erreur
; mod	D7.16, D0,D1,A0,A1

CLK0CLOSE:
	CLR.16	D7
	RET


;-----------\\
;  CLK0READ  >
;===========/

; Lit.

; in	A4.32	^buffer texte
;	D5.32	longueur  lire
;	A6.32	^variables
; out	D5.32	longueur effectivement lue
;	D7.16	erreur
; mod	D7.16, D5.32, D0,D1,A0,A1

CLK0READ:
	CLR.16	D7
	COMP.32	#7,D5
	JUMP,LE	R8^OK$

	MOVE.32	#7,D5
	MOVE.16	#EROUTF,D7

OK$:	MOVE.32	#AddrTimeDate,A0	; A0 <-- ^ss:mm:hh:jj:mm:aa:ww
	MOVE.32	A4,A1
	MOVE.32	D5,D1
	JUMP,EQ	R8^EXIT$

LOOP$:	MOVE.8	{A0+},{A1+}
	DEC.8	D1
	JUMP,NE	LOOP$

EXIT$:	RET




;--------------\\
;  CLK0RSTATUS  >
;==============/

;

; in	A4.32	^buffer
;	D4.32	longueur du buffer
;	A6.32	^variables
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
;		  #ERIRLG, la longueur est illgale
;		  #ERNPRV, ce proc. n'a pas le privilge suffisant
; mod	D4.32, D7.16, D0,D1,A0,A1

CLK0RSTATUS:
	COMP.32	#16,D4
	JUMP,NE	BAD$

	MOVE.16	#0,{A4}+0		; clock: status
	MOVE.32	#{A6}+OMODE,A0
	MOVE.32	A0,{A4}+2		; clock: ^bits
	MOVE.32	{A6}+OMSGBAL,{A4}+6	; clock: ^BAL
	MOVE.32	#{A6}+ODELAY,A0
	MOVE.32	A0,{A4}+10		; clock: ^delai
	MOVE.16	#0,{A4}+14		; clock: max. messages

	CLR.16	D7
	RET

BAD$:	MOVE.16	#ERIRLG,D7
	RET




;--------------\\
;  CLK0COMMAND  >
;==============/

; Envoie une commande.

; in	A4.32	^commande pour $CLOCK
;	A6.32	^variables
; out	D7.16	erreur
;		  #ERILLO, commande illgale
; mod	D7.16, D0,D1,A0,A1

CLK0COMMAND:
	CLR.16	D7

	COMP.8	#"M",{A4}		; muet ?
	JUMP,EQ	R8^MUET$
	COMP.8	#"R",{A4}		; rveiller ?
	JUMP,EQ	R8^REV$

	MOVE.16	#ERILLO,D7
	RET

MUET$:	TSET.8	{A6}+OMODE:#1
	RET

REV$:	TCLR.8	{A6}+OMODE:#1
	RET


	.END
