
	.TITLE	DISK.ASD

	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.REF	SMAKYX86

	.PROC	M68000

	.REF	MFMT
	.REF	MON

REVMAJ	= 0
REVMIN	= 2

PRIO	= 13

LGFILE	= 200

	.IDENT	"(C) 1997  Pierre Arnaud, OPaC bright ideas"
	.REV	REVMAJ,REVMIN
	.START	-1


;	Dfinition des variables globales
;	---------------------------------

		.LOC	0

OgEXCL:		.BLK.32	1		; exclusion globale
LGVAR:

		.LOC	0

OlocPVAR:	.BLK.32	1		; ^variables globales
OlocEXCL:	.BLK.32	1		;  exclusion globale
OlocID:		.BLK.32	1		;  ID de ce drive
OlocBLKFOS:	.BLK.32	1		; ^variables de BLKFOS
LGlocVAR:


;	Driver mmoire de masse
;	-----------------------


	.LOC	0

DEBUT:	.16	0, F0BASE
	.16	1, F1BASE
	.16	2, F2BASE
	.16	3, F3BASE
	.16	2**7

; ------------------------------------------
; 		DRIVER $DISK_0	   No 16'64
; ------------------------------------------

F0ID:	.16	F0OPEN-F0BASE
	.16	F0COMMAND-F0BASE
	.16	F0RSTATUS-F0BASE
	.16	F0READ-F0BASE
	.16	F0WRITE-F0BASE
	.16	F0CLOSE-F0BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F0RESET-F0BASE
	.16	F0KILL-F0BASE
	.16	-1
	.16	-1
	.16	-1

F0NAME:	.ASCIZE	"DISK_0"
F0NAMF:	.FILL.8	LGDNAM-(F0NAMF-F0NAME),0

	.8	16'64			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F0ID),0
F0BASE:

; ------------------------------------------
; 		DRIVER $DISK_1	   No 16'65
; ------------------------------------------

F1ID:	.16	F1OPEN-F1BASE
	.16	F1COMMAND-F1BASE
	.16	F1RSTATUS-F1BASE
	.16	F1READ-F1BASE
	.16	F1WRITE-F1BASE
	.16	F1CLOSE-F1BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F1RESET-F1BASE
	.16	F1KILL-F1BASE
	.16	-1
	.16	-1
	.16	-1

F1NAME:	.ASCIZE	"DISK_1"
F1NAMF:	.FILL.8	LGDNAM-(F1NAMF-F1NAME),0

	.8	16'65			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F1ID),0
F1BASE:

; ------------------------------------------
; 		DRIVER $DISK_2	   No 16'66
; ------------------------------------------

F2ID:	.16	F2OPEN-F2BASE
	.16	F2COMMAND-F2BASE
	.16	F2RSTATUS-F2BASE
	.16	F2READ-F2BASE
	.16	F2WRITE-F2BASE
	.16	F2CLOSE-F2BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F2RESET-F2BASE
	.16	F2KILL-F2BASE
	.16	-1
	.16	-1
	.16	-1

F2NAME:	.ASCIZE	"DISK_2"
F2NAMF:	.FILL.8	LGDNAM-(F2NAMF-F2NAME),0

	.8	16'66			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F2ID),0
F2BASE:

; ------------------------------------------
; 		DRIVER $DISK_3	   No 16'67
; ------------------------------------------

F3ID:	.16	F3OPEN-F3BASE
	.16	F3COMMAND-F3BASE
	.16	F3RSTATUS-F3BASE
	.16	F3READ-F3BASE
	.16	F3WRITE-F3BASE
	.16	F3CLOSE-F3BASE
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	-1
	.16	F3RESET-F3BASE
	.16	F3KILL-F3BASE
	.16	-1
	.16	-1
	.16	-1

F3NAME:	.ASCIZE	"DISK_3"
F3NAMF:	.FILL.8	LGDNAM-(F3NAMF-F3NAME),0

	.8	16'67			; numro
	.8	TYPMM			; type de driver
	.8	REVMAJ,REVMIN		; version
	.8	PRIO,0			; priorit
	.8	0
	.8	2**BDRDOK.OR.2**BDWROK

	.FILL.8	LGDDESC-(APC-F3ID),0
F3BASE:



; --------------------------------------------------------
;		ROUTINES BAS NIVEAU DU DRIVER
; --------------------------------------------------------

; On peut modifier D0/D1 et A0/A1 comme registres. D7.16 rend l'erreur



;--------\\
;  RESET  >
;========/

; Installe le driver

; in	A2.32	^paramtres
; out	D7.16
; mod	...

F0RESET:
	MOVE.32	#0,D0
	JUMP	R8^RESET

F1RESET:
	MOVE.32	#1,D0
	JUMP	R8^RESET

F2RESET:
	MOVE.32	#2,D0
	JUMP	R8^RESET

F3RESET:
	MOVE.32	#3,D0
;;	JUMP	R8^RESET

RESET:	PUSHM.32 D0..D6|A0..A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVAR,D4
	FOS	?GETcomMEM
	JUMP,NE	ERR$

	MOVE.32	A4,A6

	TEST.32	{A6}+OgEXCL		; exclusion dj prte ?
	JUMP,T	OK$

	MOVE.32	#1,D4
	NTREL	?CRESEM			; A5 <-- smaphore d'exclusion
	JUMP,NE	ERR$

	MOVE.32	A5,{A6}+OgEXCL		; prend note de l'exclusion globale

OK$:	MOVE.32	#MTYPBD,D1		; D1 <-- type driver
	MOVE.32	A0,A1			; A1 <-- descripteur
	MOVE.32	#LGlocVAR,D4
	GESMEM	?GETMEM
	JUMP,NE	ERR$

	MOVE.32	A6,{A4}+OlocPVAR
	MOVE.32	{A6}+OgEXCL,{A4}+OlocEXCL
	MOVE.32	D0,{A4}+OlocID
	MOVE.32	A4,A6			; A6 <-- ^variables

	PUSHM.32 D2..D6|A2..A4
	MOVE.32	#1440*1024/4,D2		; D2 <-- taille totale en blocs FOS
	MOVE.32	#512,D3			; D3 <-- taille physique d'un bloc
	MOVE.32	#16,D4			; D4 <-- blocs/piste
	MOVE.32	#16'10,D5		; D5 <-- offset FOS
	MOVE.32	#0,D6			; D6 <-- mode d'ouverture
	MOVE.32	#R16^READ,A3
	MOVE.32	#R16^WRITE,A4
	MOVE.32	A6,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_OPENBLKFOS
	POPM.32	D2..D6|A2..A4

	MOVE.32	A5,{A6}+OlocBLKFOS

	CLR.16	D7

ERR$:	POPM.32 D0..D6|A0..A5
	TEST.16	D7
	RET



;-------\\
;  KILL  >
;=======/

; D-installe le driver, ferme le fichier utilis.

; in	-
; out	D7.16
; mod	...

F0KILL:
F1KILL:
F2KILL:
F3KILL:
	PUSHM.32 A4|A5

	PUSH.32	A0
	MOVE.32	{A6}+OlocBLKFOS,A5	; canal
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_CLOSEBLKFOS
	POP.32	A0

	MOVE.32	#MTYPBD,D1		; D1 <-- type driver
	MOVE.32	A0,A1			; A1 <-- descripteur
	MOVE.32	A6,A4
	GESMEM	?GIVMEM

	POPM.32	A4|A5
	CLR.16	D7			; on ne fait rien du tout !
	RET


CLEARBLKFOS:
	PUSHM.32 D0|D1|A0|A1|A5

	MOVE.32	{A6}+OlocBLKFOS,A5		; canal
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_CLEARBLKFOS

	POPM.32	D0|D1|A0|A1|A5
	RET


;--------\\
;  WRITE  >
;========/

; Ecrit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...

F0WRITE:
F1WRITE:
F2WRITE:
F3WRITE:
	PUSH.32 A5

	CALL	STARTLOCK
	JUMP,NE	ERR$

	MOVE.32	{A6}+OlocBLKFOS,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_WRITEBLKFOS
	CALL	ENDLOCK

ERR$:	POP.32	A5
	RET


WRITE:	PUSH.32 D1

	CLR.16	D7

	TEST.32	D5				; y a-t-il qqch ?
	JUMP,F	R8^END$				; non => ne fait rien

	MOVE.32	{A5}+OlocID,D1

	MOVE.32	D4,AddrDiskPos			; position du bloc disque
	MOVE.16	D1,AddrDiskID			; ID du disque
	MOVE.32	D5,AddrDiskNum			; nombre de blocs
	MOVE.32	A4,AddrDiskPtr			; ^buffer
	MOVE.16	#X86DiskWrite,AddrDiskOp	; criture

WAIT$:	COMP.16	#X86DiskIdle,AddrDiskOp		; attend que l'opration soit termine
	JUMP,NE	WAIT$

	MOVE.16	AddrDiskStatus,D7		; reprend le statut

END$:	POP.32	D1
	TEST.16	D7
	RET



;-------\\
;  READ  >
;=======/

; Lit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...


F0READ:
F1READ:
F2READ:
F3READ:
	PUSH.32 A5

	CALL	STARTLOCK
	JUMP,NE	ERR$

	MOVE.32	{A6}+OlocBLKFOS,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_READBLKFOS
	CALL	ENDLOCK

ERR$:	POP.32	A5
	RET

READ:	PUSH.32 D1

	CLR.16	D7

	TEST.32	D5				; y a-t-il qqch ?
	JUMP,F	R8^END$				; non => ne fait rien

	MOVE.32	{A5}+OlocID,D1

	MOVE.32	D4,AddrDiskPos			; position du bloc disque
	MOVE.16	D1,AddrDiskID			; ID du disque
	MOVE.32	D5,AddrDiskNum			; nombre de blocs
	MOVE.32	A4,AddrDiskPtr			; ^buffer
	MOVE.16	#X86DiskRead,AddrDiskOp		; lecture

WAIT$:	COMP.16	#X86DiskIdle,AddrDiskOp		; attend que l'opration soit termine
	JUMP,NE	WAIT$

	MOVE.16	AddrDiskStatus,D7		; reprend le statut

END$:	POP.32	D1
	TEST.16	D7
	RET




;----------\\
;  COMMAND  >
;==========/

; Commande au pilote

; in	A4.32	^commandes
; out	D7.16
; mod	...

F0COMMAND:
F1COMMAND:
F2COMMAND:
F3COMMAND:

COMMAND:
	PUSHM.32 D0..D6|A0..A5

	MOVE.8	{A4+},D3
	CALL	MINMAJ

	COMP.8	#"F",D3				; F => formate "physiquement" le mdia
	JUMP,EQ	R8^OKFORMAT$
	COMP.8	#"E",D3				; E => EPSITEC 512
	JUMP,EQ	R8^OK$

ER$:	MOVE.16	#ERILLO,D7			; commande incorrecte
	JUMP	ERR$

OKFORMAT$:
OK$:	CLR.16	D7

ERR$:	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET

MINMAJ:	COMP.8	#96,D3
	JUMP,LT	R8^OK$
	SUB.8	#32,D3				; transforme un "a" en un "A"
OK$:	RET



;----------\\
;  RSTATUS  >
;==========/

; Rend le status du driver

; in	D4.32	taille du buffer
;	A4.32	^buffer
; out	D7.16
; mod	...

F0RSTATUS:
F1RSTATUS:
F2RSTATUS:
F3RSTATUS:
RSTATUS:
	PUSHM.32 D0..D6|A0..A5

	CALL	STARTLOCK
	JUMP,NE	ERR$

	MOVE.32	D4,D0
	MOVE.8	#MTFLO,{A4}+OMTYPE	; type mmoire de masse

; Demande la capacit  l'mulateur :-)

	MOVE.32	{A6}+OlocID,D1
	MOVE.16	D1,AddrDiskID		 ; ID du disque
	MOVE.16	#X86DiskQuery,AddrDiskOp ; demande la capacit

WAIT$:	COMP.16	#X86DiskIdle,AddrDiskOp	; attend que l'opration soit termine
	JUMP,NE	WAIT$

	MOVE.32	AddrDiskStatus,D4	; reprend la capacit (blocs de 512)
	SL.32	#.LOG2.2,D4		; taille du disque en blocs FOS
	SUB.32	#16'10,D4		; rserve quelques blocs pour le FOS

	MOVE.32	D4,{A4}+OMNBLK		; nombre de blocs
	CLR.32	{A4}+OMRBLK		; bloc le plus rapide

	COMP.32	#LGMAM3,D0
	JUMP,LT	END$

	ADD.32	#16'10,D4
	MOVE.32	D4,{A4}+OMTBLK		; nombre total de blocs
	CLR.8	{A4}+OMTTYP		; pas un WINCH, pas de type de WINCH !
	MOVE.16	#1,{A4}+oMNBFmtRec	; 1 record pour le moment

	SUB.32	#LGMAM3,D0
	JUMP,LE	END$

	MOVE.32	#{A4}+LGMAM3,A4
	MOVE.32	D4,D3

	MOVE.32	D0,D4
	MOVE.32	#R16^TABLE0$,A3
;	MOVE.32	A4,A4
	GESMEM	?COPYMEM

	COMP.16	#1440*4,D3
	JUMP,EQ	R8^MOD0$

	JUMP	END$

MOD0$:	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*0+oMFmtFlag

END$:	CALL	ENDLOCK

ERR$:	POPM.32	D0..D6|A0..A5
	CLR.16	D7
	RET


TABLE0$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	1440/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"E512"
	.32	0
	.FILL.8	14,0



;-------\\
;  OPEN  >
;=======/

; On ouvre une unit !

F0OPEN:
F1OPEN:
F2OPEN:
F3OPEN:
	CALL	CLEARBLKFOS

	PUSHM.32 D1|A5

	CALL	STARTLOCK
	JUMP,NE	ERR$

	MOVE.32	{A6}+OlocID,D1

	MOVE.16	D1,AddrDiskID			; ID du disque
	MOVE.16	#X86DiskOpen,AddrDiskOp		; ouvre l'unit

WAIT$:	COMP.16	#X86DiskIdle,AddrDiskOp		; attend que l'opration soit termine
	JUMP,NE	WAIT$

	MOVE.16	AddrDiskStatus,D7		; reprend le statut

END$:	CALL	ENDLOCK

ERR$:	POPM.32	D1|A5
	RET


;--------\\
;  CLOSE  >
;========/

; On referme l'unit (et le fichier .DI)

F0CLOSE:
F1CLOSE:
F2CLOSE:
F3CLOSE:
	PUSHM.32 D1|A5

	CALL	STARTLOCK
	JUMP,NE	ERR$

	MOVE.32	{A6}+OlocID,D1

	MOVE.16	D1,AddrDiskID			; ID du disque
	MOVE.16	#X86DiskClose,AddrDiskOp	; ferme l'unit

WAIT$:	COMP.16	#X86DiskIdle,AddrDiskOp		; attend que l'opration soit termine
	JUMP,NE	WAIT$

	MOVE.16	AddrDiskStatus,D7		; reprend le statut

END$:	CALL	ENDLOCK

ERR$:	POPM.32	D1|A5
	RET





;------------\\
;  STARTLOCK  >
;============/

; Dbut de l'exclusion pour faire un SPOS + (READ/WRITE)

; in	A6.32	^variables
; out	D7.16	erreur (time-out)
; mod	D7.16

STARTLOCK:
	PUSH.32 A5
	MOVE.32	{A6}+OlocEXCL,A5
	NTREL	?LOCK
	POP.32	A5
	TEST.16	D7
	RET


;----------\\
;  ENDLOCK  >
;==========/

; Fin de l'exclusion. Teste D7.16 comme pass en entre.

; in	D7.16	erreur
;	A6.32	^variables
; out	-	(flags mis  jour selon D7.16 in)
; mod	-

ENDLOCK:
	PUSHM.32 D7|A5
	MOVE.32	{A6}+OlocEXCL,A5
	NTREL	?UNLOCK
ERR$:	POPM.32	D7|A5
	TEST.16	D7
	RET


	.END
