
	.TITLE	KEY.ASD

	.PROC	M68000
	.BASE	10'10

MAJREV	= 0
MINREV	= 1

; Date	    Rev	 Auteur	Amliorations
; ------------------------------------------------------------------------------
; 06.12.96  0.1   PA	Premire version.
;-------------------------------------------------------------------------------

	.REV	MAJREV,MINREV

	.IDENT	"(C) 1996 Pierre ARNAUD, OPaC bright ideas, CH-1437 Suscevaz"

	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.REF	MON
	.REF	SMAKYX86


; Constantes
; ----------

NB_KEYBOARD	= 20			; nb max numros de claviers
NB_KEYLIST	= 40			; lg max d'une liste de touches




; Dfinition des variables gnrales des drivers clavier
; ------------------------------------------------------

		.LOC	0

OgSEMASSIGN:	.BLK.32	1		; ^desc sm d'arbit de l'assign

OgTAKEY:	.BLK.32	NB_KEYBOARD	; table des ^descript claviers
OgTAGLOKEY:	.BLK.8	NB_KEYLIST	; liste globale touches inter-programmes

OgKEYACT:	.BLK.32	1		; ^descr. du seul clavier actif

OSEMA1:		.BLK.32	1		; smaphore du FIFO 1.
OFIFO1:		.BLK.32	1		; ^descripteur du premier FIFO

LGVAR:


; Dfinition d'un descripteur de clavier pseudo-physique
; ------------------------------------------------------

		.LOC	0

OdKEYBAL:	.BLK.32	1		; ^BAL pour rception de touches
OdPVAR:		.BLK.32	1		; ^variables globales
OdWSEMA:	.BLK.32	1		; ^smaphore pour WFSKEY
OdWKEY:		.BLK.32	1		; touche reue pour WFSKEY
OdKEYCOUNT:	.BLK.16	1		; nombre de touches en attente
OdKEYNUM:	.BLK.8	1		; numro du clavier
		.EVEN
OdTaGloKey:	.BLK.8	NB_KEYLIST	; liste touches inter-prog.
OdTaLocKey:	.BLK.8	NB_KEYLIST	; liste touches dans prog.
LGdKEY:



; Dfinition de constantes de gestion internes
; --------------------------------------------

; Arrivant depuis la routine d'interruption:

BPSEUDO	=	10'15
BRELEASE=	10'7

;	|---------------|---------------|
;	|0   fonction	|   code ascii	|  code ascii press
;	|---------------|---------------|
;
;	|---------------|---------------|
;	|1   fonction	|0  pseudo-code	|  pseudo-code press
;	|---------------|---------------|
;
;	temps ...
;
;	|---------------|---------------|
;	|1   fonction	|1  pseudo-code	|  pseudo-code relach
;	|---------------|---------------|


; Macro pour gnrer un header de driver

   .MACRO _Header ; log num, phys num
   .LOCALMACRO Start,Name
Start:
	.16	KOPEN-K%1BASE
	.16	KCOMMAND-K%1BASE
	.16	KRSTATUS-K%1BASE
	.16	KREAD-K%1BASE
	.16	-1		; KWRITE
	.16	KCLOSE-K%1BASE
	.16	-1		; STOPTR
	.16	-1		; STARTR
	.16	-1		; AVORTTR
	.16	KAUX1-K%1BASE
	.16	-1		; KAUX2
      .IF %1.EQ.0
	.16	K0RESET-K%1BASE
	.16	K0KILL-K%1BASE
      .ELSE
	.16	KRESET-K%1BASE
	.16	KKILL-K%1BASE
      .ENDIF
	.16	-1		; KSTRT
	.16	-1		; KTSTRT
	.16	-1		; KSTART

Name:	.ASCII	"KEY_%1"	; Nom driver
	.FILL.8 LGDNAM-(APC-Name), 0

	.8	%2		; Numro driver
	.8	TYPKEY		; Type de priphrique

	.8	MAJREV,MINREV	; Rvision - version
	.8	-1,0		; Priorit ds driver

	.8	0		; Attribut 1
      .IF %1.EQ.0
	.8	0		; Attribut 0
      .ELSE
	.8	2**BDRDOK.OR.2**BDAPRG; Attribut 0
      .ENDIF

	.FILL.8 	LGDDESC-(APC-Start), 0 ; Le reste.
K%1BASE:
	.16	%1		; Numro logique (drivers plus conscutifs)
LASTDRIV == %1
   .ENDMACRO


; Entte gnrale du fichier driver.
; ----------------------------------

	.LOC	0

Start:
	.16	10'0, K0BASE
	.16	10'1, K1BASE
	.16	10'2, K2BASE
	.16	10'3, K3BASE
	.16	10'4, K4BASE
	.16	10'5, K5BASE
	.16	10'6, K6BASE
	.16	10'7, K7BASE
	.16	10'8, K8BASE
	.16	10'9, K9BASE
	.16	10'10,K10BASE
	.16	10'11,K11BASE
	.16	10'12,K12BASE
	.16	10'13,K13BASE
	.16	10'14,K14BASE
	.16	10'15,K15BASE
	.16	10'16,K16BASE
	.16	10'17,K17BASE
	.16	10'18,K18BASE
	.16	10'19,K19BASE
	.16	2**7


; Entte des diffrents drivers:
; ------------------------------

	_Header	0,  16'00
	_Header	1,  16'01
	_Header	2,  16'02
	_Header	3,  16'03
	_Header	4,  16'04
	_Header	5,  16'05
	_Header	6,  16'06
	_Header	7,  16'07
	_Header	8,  16'08
	_Header	9,  16'09
	_Header	10, 16'0A
	_Header	11, 16'0B
	_Header	12, 16'0C
	_Header	13, 16'0D
	_Header	14, 16'0E
	_Header	15, 16'0F
	_Header	16, 16'18
	_Header 17, 16'19
	_Header 18, 16'1A
	_Header 19, 16'1B

; La tranche 16'18  16'1F est rserve pour le clavier ...

.IF	LASTDRIV+1.NE.NB_KEYBOARD
.ERROR	"nombre de drivers (NBKEYB) faux !!!"
.ENDIF


; Routines de gestion correspondantes
; -----------------------------------

;----------\\
;  K0RESET  >
;==========/

; in	A0.32	^adresse de base du descipteur de $KEY_0
; out	D7.16	Si erreur:
;			Celles de ?GETMEM
;	A6	^variables
; mod	D0..A1, D7.16

K0RESET:
	PUSHM.32 D2|D4|D5|A2|A0|A3|A4|A5

	MOVE.32	#LGVAR,D4		; s'attribue les variables
	MOVE.32	#R16^Start,A4
	FOS	?GETcomMEM
	JUMP,NE	EXIT$

	MOVE.32	#MTYPBD,D1		; D1 <-- type driver
	MOVE.32	A0,A1			; A1 <-- descripteur

	MOVE.32	A4,A6			; initialise les variables  0

; Cre le smaphore d'arbitration de la gestion de l'attribution du clavier.

	MOVE.32	#1,D4			; sm. d'exclusion mutuelle
	NTREL	?CRESEM
	JUMP,NE	EXIT$

	MOVE.32	A5,{A6}+OgSEMASSIGN	; mmorise l'identificateur

; Cre le FIFO primaire, agissant entre la routine d'interruption et le
; processus gestionnaire.

	MOVE.32	#4,D0			; D0 <-- Longueur d'un lment
	MOVE.32	#100,D2			; D2 <-- Nombre d'lments
					; D1,A1 : paramtres pour compte mmoire
	CALL	32^_INIFIFO		; cre et vide le FIFO
	JUMP,NE	EXIT$

	MOVE.32	A0,{A6}+OFIFO1		; mmorise le ^au FIFO

; Cre le smaphore associ au FIFO 1.

	MOVE.32	#0,D4			; smaphore de synchronisation
	NTREL	?CRESEM
	JUMP,NE	EXIT$

	MOVE.32	A5,{A6}+OSEMA1		; mmorise le ^au descritpeur

; Cre le processus gestionnaire.

	MOVE.32	#0,D5			; longueur du stack user (ignore)
	MOVE.32	#R16^PGEST,A5		; adr de dmarrage
	MOVE.16	#3+2**BTDRIV,D4		; priorit + proc fils + mode superviseur
	MOVE.32	#R16^TXPGEST,A3		; nom du processus, A6: transmet ^variables
	NTREL	?CRETASK		; cre la tche.
	JUMP,NE	EXIT$

; Initialise le vecteur d'interruption pour lire le clavier.

	MOVE.32	_INDNTR,A4
	MOVE.32	#R16^ADRINT,A1
	MOVE.32	#67*4,A0
	CALL	{A4}+OIN_INITVECTOR
	MOVE.8	#1,AddrConsoleKey

EXIT$:	POPM.32	D2|D4|D5|A0|A2|A3|A4|A5
	TEST.16	D7			; ok ?
	JUMP,EQ	KRESET			; oui => continue avec un pilote clavier normal
	RET



;----------\\
;  K0KILL   >
;==========/

; Destruction des drivers clavier (KILLDRIV de $KEY_0)

; in	A6	^variables
; out	D7.16	Erreur= #ERKLPR	Driver indestructible.
; mod	D7.16

K0KILL:
	MOVE.16	#ERKLPR,D7
	RET


;---------\\
;  RESET   >
;=========/

; in	A0.32	^descripteur du driver
; out	D7.16	si erreur
;	A6	^variables
; mod	D0..A1, D7.16

KRESET:
	PUSHM.32 D2|D4|A4|A5

	MOVE.32	#LGVAR,D4		; s'attribue les variables
	MOVE.32	#R16^Start,A4
	FOS	?GETcomMEM
	MOVE.32	A4,A6			; A6 <-- ^variables globales

	MOVE.32	#LGdKEY,D4		; rserve le descripteur du
	MOVE.32	#MTYPBD,D1		; clavier pseudo-physique
	MOVE.32	A0,A1			; sur le compte du driver
	GESMEM	?GETMEM			; A1 ^descripteur de driver
	JUMP,NE	EXIT$

	GESMEM	?CLEARMEM

	MOVE.32	#100,D4
	NTREL	?CREBAL
	JUMP,NE	EXIT$

	MOVE.32	A5,{A4}+OdKEYBAL
	MOVE.32	A6,{A4}+OdPVAR

	MOVE.32	#0,D4			; D4 <-- sm. synchronisation
	NTREL	?CRESEM			; cre sm. pour WFSKEY
	JUMP,NE	EXIT$

	MOVE.32	A5,{A4}+OdWSEMA		; mmorise le ^au descritpeur

	MOVE.8	{A1}+ODHNUM,{A4}+OdKEYNUM

	MOVE.32	A1,A0			; A0 ^descript du driver
	CALL	MEMKPT			; mmorise le ^au descripteur
	MOVE.32	A4,A6

EXIT$:	POPM.32	D2|D4|A4|A5
	RET


;-------\\
;  OPEN  >
;=======/

; in	A0.32	^descripteur du driver
;	A6	^variables
; out	D7.16	si erreur
; mod	D0..A1, D7.16

KOPEN:
	MOVE.32	{A6}+OdPVAR,A1
	MOVE.32	A6,{A1}+OgKEYACT
	CLR.16	D7
	RET


;---------\\
;  CLOSE   >
;=========/

; Effectue la fonction CLOSE dans le driver

; in	A0.32	^descripteur du driver
;	A6	^variables
; out	D7.16	si erreur
; mod	D0..A1, D7.16

KCLOSE:
	CLR.16	D7
	RET


;---------\\
;  KILL    >
;=========/

; Enlve le clavier de la liste des claviers pseudo-physiques
; actifs du systme.

; in	A0.32	^descripteur du driver
;	A6	^variables
; out	D7.16	si erreur
; mod	D0..A1, D7.16

KKILL:
	PUSHM.32 D4|A4|A5|A6

	MOVE.32	A6,A4
	MOVE.32	{A4}+OdPVAR,A6

	MOVE.32	A0,A1			; A1 ^descripteur de driver
	CALL	CLRKPT			; enlve le ^au descripteur

	MOVE.32	{A6}+OgSEMASSIGN,A5
	NTREL	?LOCK			; attend l'exclusivit d'accs
	JUMP,NE	EXIT$

	COMP.32	{A6}+OgKEYACT,A4	; clavier courant ?
	JUMP,NE	SKIP$			; non => suite
	CLR.32	{A6}+OgKEYACT		; oui => plus de clavier cour.

SKIP$:	NTREL	?UNLOCK			; rend les droits d'exclusivit

	MOVE.32	{A4}+OdWSEMA,A5
	NTREL	?KILLSEM

	MOVE.32	{A4}+OdKEYBAL,A5
	NTREL	?KILLBAL

	GESMEM	?GBAMEM			; rend toute la mm associe

EXIT$:	POPM.32	D4|A4|A5|A6
	RET



;--------\\
;  READ   >
;========/

; in	A4.32	^buffer texte
;	D5.32	len  lire (ici doit tre <=  3)
;	A6	^variables
; out	D5.32	len effectivement lue
;	D7.16	erreur
; mod	D0..A1, D7.16, D5.32

KREAD:
	PUSHM.32 D3|D4|D5|A4|A5|A6

	CLR.16	D7

	TEST.8	D5			; lecture de zro byte ?
	JUMP,EQ	EXIT$			; oui => termine

	COMP.32	#3,D5			; longueur correcte ?
	JUMP,HI	ERR$			; non => erreur
	MOVE.32	A4,A1			; sauve le ^buffer

	MOVE.32	{A6}+OdKEYBAL,A5
	MOVE.32	#0,D3
	MOVE.32	#0,D4
	NTREL	?GETMS
	JUMP,NE	EXIT$

	MOVE.32	A4,D4			; message reu

	DEC.16	{A6}+OdKEYCOUNT		; une touche de moins

	MOVE.8	D4,{A1+}		; le code ASCII
	DEC.8	D5
	JUMP,EQ	EXIT$

	SR.32	#8,D4
	MOVE.8	D4,{A1+}		; les touches-fnct associes
	DEC.8	D5
	JUMP,EQ	EXIT$

	SR.32	#8,D4
	MOVE.8	D4,{A1+}		; le pseudo-code correspondant

	JUMP	EXIT$

ERR$:	MOVE.16	#ERIRDL,D7		; erreur 'longueur de READ ill'

EXIT$:	POPM.32	D3|D4|D5|A4|A5|A6
	RET



;----------\\
;  WFSKEY   >	( Wait For Special Key )
;==========/

; in	A6	^variables
; out	D3.32	-pseudo-fonc-code press
;	D7.16	erreur
; mod	D0..A1, D3.32, D7.16, D5.32

KAUX1:
	PUSHM.32 D4|A5

	MOVE.32	{A6}+OdWSEMA,A5
	NTREL	?WAITEV			; attend le signal
	JUMP,NE	R8^EXIT$

	MOVE.32	{A6}+OdWKEY,D3		; D3 <-- touche presse

EXIT$:	POPM.32	D4|A5
	RET




;-----------\\
;  KRSTATUS  >
;===========/

; in	A4.32	^buffer
;	D4.32	longueur buffer
;	A6	^variables
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

KRSTATUS:
	COMP.32	#4,D4
	JUMP,NE	R8^Not4$

; Un RSTATUS de longueur 4 rend le ^ sur le nombre de caractres dans le FIFO
; C'est bien laid, mais MOUSE doit connatre cette valeur  chaque changement 
; de position de la souris, alors ...

	MOVE.32	#{A6}+OdKEYCOUNT,A0	; A0 <- ^nombre de caractres dans FIFO
	MOVE.32	A0,{A4}
	JUMP	R8^EXIT$

Not4$:	MOVE.16	#ERIRLG,D7
	JUMP	R8^RET$

EXIT$:	CLR.16	D7			; D7 <-- ok

RET$:	RET



;------------\\
;  KCOMMAND   >
;============/

; in	A4.32	^table des commandes termine par zro
;	A6	^variables
; out	D7.16	erreur
;	A4.32	^commande innexistante, si erreur ERILLO
; mod	D0..A1, D7.16

KCOMMAND:
	MOVE.8	{A4+},D0
	COMP.8	#9,D0
	JUMP,EQ	R8^DKEYASS
	COMP.8	#10,D0
	JUMP,EQ	R8^DKEYSND

	DEC.32	A4
	CLR.16	D7
	RET


;--------\\
; DKEYASS >
;========/

; R-assigne le clavier physique  un clavier logique.

; Params:	no_de_clavier

DKEYASS:
	PUSHM.32 D4|A5

	CLR.16	D0
	MOVE.8	{A4+},D0		; D0 <-- numro de clavier
	JUMP,EQ	ERR$
	COMP.8	#NB_KEYBOARD,D0
	JUMP,HS	ERR$

	MOVE.32	{A6}+OdPVAR,A0
	MOVE.32	{A0}+OgSEMASSIGN,A5
	NTREL	?LOCK
	JUMP,NE	EXIT$

	SL.16	#2,D0
	MOVE.32	{A0}+A16^{D0}+OgTAKEY,A1 ; ^descript du clavier  assigner
	MOVE.32	A1,D0			 ; voulu ?
	JUMP,T	R8^OK$			 ; oui => prend note

	MOVE.16	#ERKYIN,D7		; D7 <-- err 'Clavier innexistant'
	JUMP	R8^END$

OK$:	MOVE.32	A1,{A0}+OgKEYACT	; ok => mmorise le clavier

END$:	PUSH.16	D7
	NTREL	?UNLOCK
	POP.16	D7
	JUMP	R8^EXIT$

ERR$:	MOVE.16	#ERKYIL,D7

EXIT$:	POPM.32	D4|A5
	RET


DKEYSND:
	PUSHM.32 D3|D4|A0|A4|A5

	MOVE.32	{A6}+OdPVAR,A5
	MOVE.32	{A5}+OgKEYACT,A5	; A5 <-- ^descripteur du clavier actif
	MOVE.32	A5,D4
	JUMP,EQ	R8^NONE$

	MOVE.32	#{A5}+OdKEYCOUNT,A0

	MOVE.32	{A5}+OdKEYBAL,A5
	MOVE.32	#2**BMSNBR,D3
	MOVE.32	#0,D0
	MOVE.8	{A4+},D0		; [--:touche]
	SWAP.16	D0
	MOVE.8	{A4+},D0		; [touche:fonction]
	SWAP.16	D0			; [0:0:fonction:touche]
	MOVE.32	D0,A4
	NTREL	?GIVMS
	JUMP,NE	NONE$

	INC.16	{A0}			; une "touche" de plus

NONE$:	POPM.32	D3|D4|A0|A4|A5
	CLR.16	D7
	RET



;==============================================================
;	SOUS-ROUTINES UTILITAIRES.
;==============================================================



;---------\\
;  MEMKPT  >
;=========/

; Mmorise le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.32	^variables globales du programme
;	A0.32	^descripteur du driver
;	A4.32	^descripteur du clavier
; out	-
; mod	F

MEMKPT:
	PUSH.32	D0
	CALL	CALCOFS			 ; calcule l'offset
	MOVE.32	A4,{A6}+A16^{D0}+OgTAKEY ; mmorise l'identificateur
	POP.32	D0
	RET



;---------\\
;  CLRKPT  >
;=========/

; Annule le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.32	^variables globales du programme
;	A0.32	^descripteur du driver
; out	-
; mod	F

CLRKPT:
	PUSH.32	A4
	SUB.32	A4,A4
	CALL	MEMKPT
	POP.32	A4
	RET


;--------\\
; CALCOFS >
;--------/

; in	A0.32	^descripteur du driver
; out	#{A6}+A16^{D0}+OgTAKEY ^au ^descript du clavier
; mod	D0.W,F

CALCOFS:
	MOVE.16	{A0},D0			; le no logique est aprs le header
	SL.16	#2,D0			; *4 (.32) ==> offset
	RET



	.INS 	KEYFILS.ASI		; traitement des codes



	.END

