
	.TITLE 	MOUSE.ASD
	.BASE	10'10
	.LAYOUT HEX

	.REF	MON

;;BIOS?NAMDRIV	=	16'21		; viel appel, encore utilis !!!

MajRev	= 0
MinRev	= 1

	.REV	MajRev, MinRev
	.PROC	M68000

; Date     Rv      Modifications
; -----------------------------------------------------------------
; 14/12/96 1.1  PA  Dbut des travaux effectus par Pierre


	.REF	SMAKY
	.REF 	BIOS
	.REF 	BIOSDRIV
	.REF	SMAKYX86


; Dfinitions des variables
; -------------------------

	.LOC	0

	.BLK.8	LGMOU2			; table dfinie dans DRIVERS
;.... 	 Cf DRIVERS

OMOPOS:	.BLK.16	2			; position de la souris [y;x]
OMOBUT:	.BLK.8	1			; tat des boutons de la souris
	.EVEN
OSEMA:	.BLK.32	1			; id smaphore de synchro
LGVAR:


; Dbut du code du driver
; -----------------------


	.LOC	0

	.16	0,D0BASE
	.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $MOUSE_0		No H'10
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	-1			; D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"MOUSE_0"		; Nom driver
D0NAF:	.FILL.8 	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'10			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK ;;!2**BDNORT	; Attribut 0

	.FILL.8 LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:


; Points d'entres pour les routines de bases
; -------------------------------------------



;--------\\
;  RESET  >
;========/

; Le reset n'est pas possible (retour avec une erreur) si
; la souris n'est pas branche ou si les trois boutons
; sont presss.

; in	-
; out	A6	^variables
;	D7.16	erreur
; mod	D0..A1, D7.16

D0RESET:
	PUSHM.32 D2|D3|D4|D5|A2|A3|A4|A5

	MOVE.32	#R16^D0BASE,A1
	MOVE.32	#MTYPBD,D1
	MOVE.32	#LGVAR,D4
	GESMEM	?GETMEM
	JUMP,NE	EXIT$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6			; pour rendre le ^var.

	MOVE.32	#0,D4
	NTREL	?CRESEM
	JUMP,NE	EXIT$

	MOVE.32	A5,{A6}+OSEMA		; init ^smaphore synchro

	CALL	INITINT			; active l'interruption

	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D2|D3|D4|D5|A2|A3|A4|A5
	RET



;--------\\
;  KILL   >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0KILL:
	PUSHM.32 A4|A5

	CALL	DISABLEINT		; dsactive l'interruption

	MOVE.32	{A6}+OSEMA,A5		; A5 <-- ^smaphore synchro
	NTREL	?KILLSEM		; dtruit smaphore synchro

	MOVE.32	A6,A4
	MOVE.32	#R16^D0BASE,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM

	POPM.32	A4|A5
	RET



;--------\\
;  OPEN   >
;========/

; Rserve le pav numrique pour simuler la souris.

; in	A6	^variables
; out	-
; mod	D0..A1

D0OPEN:
	CLR.32	{A6}+OMOPOS
	CLR.8	{A6}+OMOBUT

	MOVE.8	#5,{A6}+OMOVI2		; Prpare pour RDSTATUS
	MOVE.8	#5,{A6}+OMOVI3

	CLR.16	D7			; D7 <-- ok
	RET


;--------\\
;  CLOSE  >
;========/

; Libre le pav numrique pour simuler la souris.
; Il faudrait le faire dans KILL, mais cela n'est pas
; possible, car le BIOS interdit d'excuter un ?DCOMMAND
; dans un KILL !!!

; in	A6	^variables
; out	-
; mod	D0..A1

D0CLOSE:
	CLR.16	D7			; D7 <-- ok
	RET



;--------\\
; COMMAND >
;========/

; in	A4.32	^table des commandes termine par zro
;	A6	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16

D0COMMAND:
	PUSH.32 A4

LOOP$:	TEST.8	{A4}			; fin de la table ?
	JUMP,EQ	R8^END$
	CALL	WRONEC			; excute une commande
	TEST.16	D7			; commande ok ?
	JUMP,NE	R8^EXIT$		; non => arrte
	JUMP	LOOP$

END$:	CLR.16	D7			; D7 <-- ok

EXIT$:	POP.32	A4
	RET


;--------\\
; WRONEC  >
;========/

; Excute une commande.

; in	A4.32	^commande  excuter
;	A6.32	^variables
; out	A4.32	^commande suivante
; mod	D7.16, A4.32

WRONEC:
	PUSHM.32 D0..D1|A5

	CLR.16	D7			; D7 <-- ok

	MOVE.8	{A4+},D0		; D0 <-- type de la commande
	COMP.8	#MOUPOS,D0
	JUMP,EQ	mPOS$			; Positionnement
	COMP.8	#MOUSCA,D0
	JUMP,EQ	mSCA$			; Changement d'chelle
	COMP.8	#MOUACC,D0
	JUMP,EQ	mACC$			; Rglage de la bote  vitesses

	JUMP	ERR$			; Retour avec erreur

mPOS$:	MOVE.32	{A4+},{A6}+OMOPOS	; [y;x]
	MOVE.32	{A6}+OSEMA,A5		; A5 <-- ^smaphore
	NTREL	?SSIGNEV		; dbloque processus read
	CLR.16	D7			; D7 <-- ok
	JUMP	EXIT$

mSCA$:	MOVE.8	{A4+},D0		; D0 <-- l'chelle
	JUMP	EXIT$

mACC$:	CLR.16	D0
	MOVE.8	{A4+},D0		; D0 <-- limite 1re vitesse (5=moyen)
	CLR.16	D1
	MOVE.8	{A4+},D1		; D1 <-- limite 2me vitesse (5=moyen)

	MOVE.8	D0,{A6}+OMOVI2		; Prpare pour RDSTATUS
	MOVE.8	D1,{A6}+OMOVI3
	JUMP	EXIT$

ERR$:	MOVE.16	#ERIRLG,D7		; D7 <-- erreur

EXIT$:	POPM.32	D0..D1|A5
	RET




;--------\\
; RSTATUS >
;========/

; in	A4.32	^buffer
;	D4.32	longueur buffer
;	A6.32	^variables
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

D0RSTATUS:
	CLR.8	{A4}+OMOSIM		; met un "zro"
	MOVE.32	#LGMOU1,D0		; Prpare la longueur  rendre
	COMP.32	#LGMOU2,D4		; A-t-on demand plus ?
	JUMP,LO	EXIT$			; non => fin

	MOVE.8	{A6}+OMOSCA,{A4}+OMOSCA	; Rend l'chelle utilise
	MOVE.8	{A6}+OMOVI2,{A4}+OMOVI2	; Ainsi que les 2 changements de vitesses
	MOVE.8	{A6}+OMOVI3,{A4}+OMOVI3
	MOVE.32	#LGMOU2,D0		; Prpare aussi la longueur  rendre

EXIT$:	MOVE.32	D0,D4			; Rend la longueur effective dans D4
	CLR.16	D7			; D7 <-- ok
	RET





;--------\\
;  READ   >
;========/

; in	A4.32	^buffer texte
;	D5.32	lg  lire
;	D7.16	=0
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D7.16, D5.32

D0READ:
	PUSHM.32 D3|D4|A4

	COMP.32	#4,D5
	JUMP,LO	R8^ERR$
	COMP.32	#6,D5
	JUMP,HI	R8^ERR$

	CALL	RDONE			; lit la souris
	JUMP,NE	R8^EXIT$

	MOVE.16	D4,{A4}+0		; [x]
	SWAP.32	D4
	MOVE.16	D4,{A4}+2		; [y]

	COMP.8	#4,D5
	JUMP,EQ	R8^EXIT$

	MOVE.8	D3,{A4}+4		; met les boutons

	COMP.8	#5,D5
	JUMP,EQ	R8^EXIT$

	CLR.8	{A4}+5			; met un "zro"
	JUMP	R8^EXIT$

ERR$:	MOVE.16	#ERIRDL,D7		; D7 <-- "lg read illgale"

EXIT$:	POPM.32	D3|D4|A4
	RET





;--------\\
;  RDONE  >
;========/

; Lit une coordonne de la souris, et attend si tout est
; immobile.
; Si un signal arrive et que les informations lues sont
; identiques  la dernire lecture, attend encore !

; in	A6.32	^variables
;	D7.16	=0
; out	D3.8	boutons
;	D4.32	coorodnnes (Y;X)
;	D7.16	erreur
; mod	D3.8, D4.32, D7.16

RDONE:
	PUSHM.32 D0|A5

	MOVE.32	{A6}+OSEMA,A5		; A5 <-- ^smaphore
	NTREL	?WAITEV			; attend un mouvement ...
	JUMP,NE	EXIT$

	MOVE.32	#0,D0
	MOVE.8	{A6}+OMOBUT,D0
	MOVE.8	R8^TABLE$+A16^{D0},D3	; D3 <-- boutons
	MOVE.32	{A6}+OMOPOS,D4		; D4 <-- position souris (Y;X)

.IF	0
	MON	?AFTIM
	.ASCIZE	"Mouse: D4="
	MON	?AFX8
	MON	?AFTIM
	.ASCIZE	", D3="
	EX.32	D3,D4
	MON	?AFX2
	EX.32	D3,D4
	MON	?AFCR
.ENDIF

EXIT$:	POPM.32	D0|A5
	TEST.16	D7
	RET

TABLE$:	.8	0
	.8	2**BMOLEFT
	.8	2**BMORIGHT
	.8	2**BMOLEFT.OR.2**BMORIGHT
	.8	2**BMOCENT
	.8	2**BMOCENT.OR.2**BMOLEFT
	.8	2**BMOCENT.OR.2**BMORIGHT
	.8	2**BMOCENT.OR.2**BMOLEFT.OR.2**BMORIGHT




;---------\\
; INITINT  >
;=========/

; active l'interruption souris

; in	-
; out	int. active
; mod	D0,D1,A0,A1,A4,F

INITINT:
	MOVE.32	_INDNTR,A4
	MOVE.32	#R16^INTMOUSE,A1
	MOVE.32	#66*4,A0
	CALL	{A4}+OIN_INITVECTOR	; initialise le vecteur d'interruption
	MOVE.16	#1,AddrConsoleKey+2
	RET


;---------\\
; INTMOUSE >
;=========/

; Routine d'interruption...

; in	A0	^variables
; registres sauvs par le SHI: D0..D3|A0..A1|D7

INTMOUSE:
	MOVE.16	AddrMouseX,{A0}+OMOPOS+2
	MOVE.16	AddrMouseY,{A0}+OMOPOS+0
	MOVE.16	AddrMouseBut,D0
	MOVE.8	D0,{A0}+OMOBUT

	MOVE.32	{A0}+OSEMA,A1
	JUMP	32^_ISSIGNEV		; signale l'arrive d'un vnement





;------------\\
; DISABLEINT  >
;============/

; Dsactive l'interruption souris

; in	-
; out	int. dsactive
; mod	D0,D1,A0,A1,A4,F

DISABLEINT:
	MOVE.32	_INDNTR,A4
	SUB.32	A1,A1
	MOVE.32	#66*4,A0
	CALL	{A4}+OIN_INITVECTOR	; initialise le vecteur d'interruption
	RET




	.END

