
	.TITLE	TESTPIPE.ASM

	.PROC	M68000
	.REF	SMAKY
	.REF	COMMREQ

CMD_NONE	= 0
CMD_CREATE	= 1
CMD_CONNECT	= 2
CMD_DISCONNECT	= 3
CMD_OPEN	= 4
CMD_CLOSE	= 5
CMD_READ	= 6
CMD_WRITE	= 7

		.LOC	0

OcmdCMD:	.BLK.16	1
OcmdRES1:	.BLK.16	1
OcmdRES2:	.BLK.32	1
OcmdHANDLE:	.BLK.32	1
OcmdID:		.BLK.32	1
OcmdLENGTH:	.BLK.32	1
OcmdBUFFER:	.BLK.32	1
OcmdNAME:	.BLK.8	200
LGCMD:

		.LOC	0

OstsERROR:	.BLK.16	1
OstsPENDING:	.BLK.8	1
OstsRES1:	.BLK.8	1
OstsRES2:	.BLK.32	1
OstsHANDLE:	.BLK.32	1
OstsID:		.BLK.32	1
OstsLENGTH:	.BLK.32	1
LGSTATUS:

		.LOC	0


OBARID:		.BLK.32	1
OREQUEST:	.BLK.8	RQ_LEN
OCOMMAND:	.BLK.8	LGCMD
OSTATUS:	.BLK.8	LGSTATUS
LGVAR:

	.LOC	0
	.START	START

START:
	MOVE.32	A4,A6
	MOVE.32	#R16^NMBAR$,A3
	MOVE.32	#2**BCBOPEN,D4
	NTREL	?CREBAR
	JUMP,NE	ERR$

	MOVE.32	A5,{A6}+OBARID
	MOVE.32	#0,D4
	NTREL	?CRESEM

	MOVE.32	#{A6}+OREQUEST,A4
	MOVE.8	#PRI_FILE,{A4}+RQ_PRI
	MOVE.16	#PORT_NTPIPE,{A4}+RQ_PORTNO
	MOVE.32	A5,{A4}+RQ_REPLYSEM

	MOVE.32	#R16^NMPIPE$,A3
	CALL	CREATE
	EXIT
	CALL	CLOSE

ERR$:	LIB	?AFERROR
	LIB	?AFCR
	EXIT

NMBAR$:		.ASCIZ	"#:PCCOMMBAR"
NMPIPE$:	.ASCIZ	"\\\\.\\pipe\\Smaky Communication"
		.EVEN	

CREATE:
	PUSHM.32 A0|A3|A4|A5

	MOVE.32	#{A6}+OSTATUS,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#LGSTATUS,{A4}+RQ_RDATALEN
	MOVE.32	#{A6}+OCOMMAND,A0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#LGCMD,{A4}+RQ_SDATALEN
	MOVE.16	#CMD_CREATE,{A0}+OcmdCMD
	MOVE.32	#{A0}+OcmdNAME,A0
COPY$:	MOVE.8	{A3+},{A0+}
	JUMP,NE	COPY$

	MOVE.32	{A6}+OBARID,A5
	NTREL	?OFFERBAR
	NTREL	?ENDOFFERBAR
	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?WAITEV

	MOVE.32	{A6}+OSTATUS+OstsHANDLE,D5

	POPM.32	A0|A3|A4|A5
	RET

CLOSE:
	PUSHM.32 A0|A3|A4|A5

	MOVE.32	#{A6}+OSTATUS,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#LGSTATUS,{A4}+RQ_RDATALEN
	MOVE.32	#{A6}+OCOMMAND,A0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#LGCMD,{A4}+RQ_SDATALEN
	MOVE.16	#CMD_CLOSE,{A0}+OcmdCMD
	MOVE.32	D5,{A0}+OcmdHANDLE

	MOVE.32	{A6}+OBARID,A5
	NTREL	?OFFERBAR
	NTREL	?ENDOFFERBAR
	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?WAITEV

	POPM.32	A0|A3|A4|A5
	RET




	.END

