
	.TITLE	400_AUDIO.ASD

;	------------------------------------------
;	  (C) 1997 - Daniel Roux & Pierre Arnaud
;	------------------------------------------

; Source du pilote 400_AUDIO.DRIV. Dveloppement initial par
; Daniel Roux, maintenance, corrections et amliorations par
; Pierre Arnaud.

	.PROC	M68020
	.PROCSET M68040

	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	AUDIO
	.REF	COMMREQ
	.REF	MON

	.BASE	10'10
	.LAYOUT HEX


MAJREV	= 0			; rvision
MINREV	= 4			; version


;  Rv	Date		Amliorations
; --------------------------------------------------------------------------
;  0.3	29.09.97   PA	rendu non r-entrant (vite des plantes)
;  0.2	21.09.97   PA	utilise la priorit audio officielle
;  0.1	08.09.97   DR	premire version
; --------------------------------------------------------------------------

	.REV	MAJREV,MINREV
	.IDENT	"(C) Daniel ROUX, Pierre ARNAUD et EPSITEC SA"



; Variables
; ---------

	.LOC	0
OCBAR:	.BLK.32 1		; ^BAR de communication avec le PC
ORQ:	.BLK.8	RQ_LEN		; request buffer
OBEEPA:	.BLK.32	1		; answer buffer

OLEVEL:	.BLK.8	1		; niveau (0..255)
	.EVEN
ORDNIV:	.BLK.8	2		; read: niveau  atteindre avant dpart
ORDTIM:	.BLK.8	4		; read: timeout
LGVAR:





	.LOC	0
DEBUT:
	.16	0,S0BASE
	.16	2**7


; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $AUDIO_0		No H'4F
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	-1			; S0RSTATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; S0AUX1-S0BASE
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"AUDIO_0"		; nom driver
S0NAF:	.FILL.8	LGDNAM-(S0NAF-S0NAB),0

	.8	16'4F			; numro driver
	.8	TYPIO			; type streamer

	.8	MAJREV,MINREV		; rvision - version
	.8	0			; priorit
	.8	0			; rserve
	.8	0			; attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDNORT
					; attribut 0 (non r-entrant)

	.FILL.8	LGDDESC-(APC-S0ID),0	; le reste
S0BASE:





;--------\\
; S0RESET >
;========/

; Initialisation du pilote.

; in	-
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	D7.16, A6.32

S0RESET:
	PUSHM.32 D4|A3..A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVAR,D4
	FOS	?GETCOMMEM
	JUMP,NE	R8^EXIT$
	MOVE.32	A4,A6			; A6 <-- ^variables globales

	MOVE.8	#255,{A6}+OLEVEL

	MOVE.32	#{A6}+ORQ,A4		; A4 <-- ^request buffer
	MOVE.8	#PRI_AUDIO,{A4}+RQ_PRI
	MOVE.16	#PORT_AUDIO,{A4}+RQ_PORTNO
	MOVE.32	#0,D4
	NTREL	?CRESEM
	JUMP,NE	R8^EXIT$

	MOVE.32	A5,{A4}+RQ_REPLYSEM
RETRY$:
	MOVE.32	#A8^1,D4
	MOVE.32	#R16^BARNM$,A3
	NTREL	?CREBAR
	JUMP,EQ	R16^OKBAR$
	MOVE.32	#4,D4
	NTREL	?DELMS			; on attend que pccomm dmarre
	JUMP	RETRY$
OKBAR$:
	MOVE.32	A5,{A6}+OCBAR		; OCBAR <-- ^bar de communication

	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D4|A3..A5
	TEST.16	D7			; retour EQ/NE
	RET

BARNM$:	.ASCIZE "#:PCCOMMBAR"


;--------\\
; S0OPEN  >
;========/

; Ouverture d'un son.

; in	A6.32	^variables globales
; out	D7.16	erreur
; mod	D7.16

S0OPEN:
	CLR.16	D7			; retour EQ
	RET



;--------\\
; S0WRITE >
;========/

; Ecrit un son.

; in	A6.32	^variables globales
;	A4.32	^data
;	D5.32	lg data
; out	D7.16	erreur
; mod	D7.16

S0WRITE:
	PUSHM.32 D0..D6|A0..A5

	TEST.8	{A6}+OLEVEL		; niveau zro ?
	JUMP,EQ R8^OK$			; oui => OK$ (silence total)

	MOVE.32	#-1,D4
	NTREL	?MODTIM			; time-out temporairement infini

	MOVE.32	A4,A3			; A3 <-- ^data
	MOVE.32	#{A6}+ORQ,A4		; A4 <-- ^request buffer
	MOVE.32	#{A6}+OBEEPA,A2		; A2 <-- petit buffer

	MOVE.32	D5,{A2}
	MOVE.32	A2,{A4}+RQ_SDATAPTR
	MOVE.32	#4,{A4}+RQ_SDATALEN
	MOVE.32	#0,{A4}+RQ_RDATALEN
	MOVE.32	{A6}+OCBAR,A5		; A5 <-- ^bar de communication
	NTREL	?OFFERBAR		; envoi la requte au PC (lg)
	NTREL	?ENDOFFERBAR
	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?WAITEV			; attend synchro

	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	D5,{A4}+RQ_SDATALEN
	MOVE.32	#1,{A4}+RQ_RDATALEN
	MOVE.32	A2,{A4}+RQ_RDATAPTR
	MOVE.32	{A6}+OCBAR,A5		; A5 <-- ^bar de communication
	NTREL	?OFFERBAR		; envoi la requte au PC (data)
	NTREL	?ENDOFFERBAR
	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?WAITEV			; attend synchro (et fin du son)
	NTREL	?SETTIM			; reprend time-out initial

OK$:	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0..D6|A0..A5
	TEST.16	D7			; retour EQ/NE
	RET


;-------\\
; S0READ >
;=======/

; Lecture d'un son.

; in	A6.32	^variables globales
;	A4.32	^buffer
;	D5.32	lg buffer
; out	D5.32	lg lue
;	D7.16	erreur
; mod	D5.32, D7.16

S0READ:
	MOVE.16	#ERADRDIN,D7		; D7 <-- interface pas connect
	CLR.32	D5			; D5 <-- rien lu
	TEST.16	D7			; retour EQ/NE
	RET




;--------\\
; S0CLOSE >
;========/

; Termine le son, attend sa fin et ferme tout.

; in	A6.32	^variables globales
; out	D7.16	erreur
; mod	D7.16

S0CLOSE:
	CLR.16	D7		; D7 <-- ok
	RET




;----------\\
; S0COMMAND >
;==========/

; Excute une liste de commandes.
; Les commandes disponibles sont :
;	"L<niveau.B>"	niveau gnral
;	"RL<bruit.W>"	lecture: niveau du bruit
;	"RT<timeout.L>"	lecture: timeout (ADFREQ=1s)

; in	A6.32	^variables globales
;	A4.32	^table des commandes termine par zro
; out	D7.16	erreur
; mod	D7.16

S0COMMAND:
	PUSH.32 A4

	CLR.16	D7		; D7 <-- ok

LOOP$:	TEST.8	{A4}		; fin de la table ?
	JUMP,EQ	 R8^EXIT$	; oui => EXIT$

	CALL	WRONEC		; excute une commande
	JUMP,EQ LOOP$

EXIT$:	POP.32	A4
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; WRONEC  >
;========/

; Excute une commande.

; in	A4.32	^commande
; out	A4.32	^commande suivante
;	D7.16	erreur
; mod	D7.16, A4.32

WRONEC:
	PUSH.32 D4

	MOVE.8	{A4+},D4	; D4 <-- commande
	COMP.8	#"L",D4
	JUMP,EQ	 R8^LEVEL$
	COMP.8	#"R",D4
	JUMP,EQ	 R8^READ$

ERROR$:	MOVE.16	#ERADILCO,D7	; D7 <-- commande illgale
	JUMP	R8^EXIT$

LEVEL$:	MOVE.8	{A4+},{A6}+OLEVEL ; D4 <-- volume (0..255)
	JUMP	R8^OK$

READ$:	MOVE.8	{A4+},D4	; D4 <-- sous-commande
	COMP.8	#"L",D4
	JUMP,EQ	R8^RL$
	COMP.8	#"T",D4
	JUMP,EQ	R8^RT$
	JUMP	ERROR$

RL$:				; "RL" (read-level)
	MOVE.16	{A4+},{A6}+ORDNIV
	JUMP	R8^OK$

RT$:				; "RT" (read-timeout)
	MOVE.32	{A4+},{A6}+ORDTIM
;	JUMP	R8^OK$

OK$:	CLR.16	D7		; D7 <-- ok

EXIT$:	POP.32	D4
	TEST.16	D7		; retour EQ/NE
	RET



;--------\\
; S0KILL  >
;========/

; Libration du pilote.

; in	A6.32	^variables globales
; out	D7.16	erreur
; mod	D7.16, A6.32

S0KILL:
	CLR.16	D7		; retour EQ
	RET



	.END
