	.TITLE	 	PCCENTRO.ASD

	.PROC		M68020

; Pilote pour interface centronic du Smaky 400
; -----------------------------------------------

	.IDENT		"Pilote Centronic Smaky 400 (c) Alain Malek 3/97"

	.REF	SMAKY
	.REF 	MON
	.REF	BIOS
	.REF	BIOSDRIV
	.REF	COMMREQ


	MAJREV	=	1				; Rvision majeur
	MINREV	=	2				; Rvision mineur
	.REV	MAJREV,MINREV				; Met revision dans entte binaire

; Variables globales
; ------------------

		.LOC	0

COMMBAR:	.BLK.32 1
REQUEST:	.BLK.8	RQ_LEN

CMD:		.BLK.16	1		; buffer pour la commande a envoyer
		.BLK.16	1		; pour alignement
SIZE:		.BLK.32 1		; buffer pour communiquer la taille
RESULT:		.BLK.16	1		; buffer pour la rponse du PC
		.BLK.16	1

REPLYSEM:	.BLK.32 1

LGVAR:							; Longueur des variables globales

CMD_OPEN	= 1
CMD_CLOSE	= 2
CMD_WRITE	= 3

		.LOC	0

; Entte du pilote : 
;===================

	.16		0,D0BASE			; Add fin entte pilote
	.16		2**7
D0ID:							; Offset routine :
	.16		D0OPEN-D0BASE			; Open
	.16		D0COMMAND-D0BASE		; Command
	.16		D0RSTATUS-D0BASE		; Read status
	.16		-1				; Read
	.16		D0WRITE-D0BASE			; Write
	.16		D0CLOSE-D0BASE			; Close
	.16		D0STOPTR-D0BASE			; Stop
	.16		D0STARTR-D0BASE			; Start
	.16		D0AVOTR-D0BASE			; Avort
	.16		-1				; Auxiliaire 1
	.16		-1				; Auxiliaire 2
	.16		D0RESET-D0BASE			; Reset
	.16		D0KILL-D0BASE			; Kill
	.16		-1				; 
	.16		-1				; 
	.16		-1				; 
D0NAB:
	.ASCII	 	"CENTRO_0"			; Nom pilote
D0NAF:	.FILL.8		LGDNAM-(D0NAF-D0NAB),0		; Renpli le reste avec des 0
	.8		16'88				; Numro pilote
	.8		TYPIO				; Type : entre/sortie
	.8		MAJREV,MINREV			; Rvision - version
	.8		20				; Priorit dans pilote
	.8		0				; no bios high

	.8		0				; Attribut 1
	.8		2**BDWROK.OR.2**BDNORT		; Attribut 0
;	.8		2**BDWROK			; Attribut 0

	.FILL.8		LGDDESC-(APC-D0ID),0		; Le reste avec des 0
D0BASE:

;--------
; RESET
;========

; in	A2.32		^paramtres ligne de commande
; out	A6.32		^variables locales du pilote
; 	D7.16		Erreur
; mod	D0.32, D1.32, A0.32, A1.32, A6.32, D7.16

D0RESET:	PUSHM.32 D2..D6|A0..A5

		MOVE.32	#R16^D0BASE,A1
		MOVE.32	#MTYPBD,D1
		MOVE.32	#LGVAR,D4
		GESMEM	?GETMEM
		JUMP,NE	R16^ERROR$
		MOVE.32	A4,A6			;pour rendre ^var.
		GESMEM	?CLEARMEM

		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree reply sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+REPLYSEM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.8	#PRI_CENTRO,{A4}+RQ_PRI
		MOVE.16	#PORT_CENTRO,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM

		MOVE.32	#A8^1,D4
		MOVE.32	#R16^BARNAME,A3
		NTREL	?CREBAR
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+COMMBAR

		CLR.16	D7

ERROR$:
		POPM.32	D2..D6|A0..A5
		RET

BARNAME:	.ASCIZE "#:PCCOMMBAR"

;--------
; KILL
;========

; in	A6.32		^variable du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0KILL:		PUSHM.32 A4..A5

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?KILLSEM

		MOVE.32	A6,A4
		MOVE.32	#R16^D0BASE,A1
		MOVE.32	#MTYPBD,D1
		GESMEM	?GIVMEM

		CLR.16	D7

		POPM.32	A4..A5
		RET

;--------
; OPEN
;========

; in	A6.32		^variable du pilote
; out	D7.16		Erreur
; mod	D0..A1.32 , D7.16

D0OPEN:		PUSHM.32 D2..D6|A2..A5

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.32	#{A6}+CMD,A0
		MOVE.16	#CMD_OPEN,{A0}
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#8,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR	;envoi la cmd au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV		;attend la rponse du PC
		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+RESULT,D7

		POPM.32	D2..D6|A2..A5
		RET

;--------
; CLOSE
;========

; In	A6.32		^variable du pilote
; Out	D7.16		erreur
; Mod	D0..A1.32, D7.16

D0CLOSE:	PUSHM.32 D2..D6|A2..A5

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.32	#{A6}+CMD,A0
		MOVE.16	#CMD_CLOSE,{A0}
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#8,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN
		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR	;envoi la cmd au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV		;attend la rponse du PC
		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+RESULT,D7

		POPM.32	D2..D6|A2..A5

		RET


;--------
; RSTATUS
;========

; in	A6.32		^variable du pilote
;	A4.32		^buffer pour les status
;	D4.32		Nombre de bytes  lire
; Out	D4.32		Longueur lue effectivement
;	D7.16		Erreur
; Mod	D0..A1.32, D4.32, D7.16

D0RSTATUS:	CLR.16	D7
		RET

;--------
; COMMAND
;========

; in	A6.32		^variable du pilote
;	A4.32		^table des commandes termine par un 0
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0COMMAND:	MOVE.16	#ERILLO,D7
		RET

;--------
; WRITE
;========

; in	A6.32		^variables du pilote
;	A4.32		^ la zone mmoire
;	D5.32		Lg  crire
; out	D5.32		Lg effectivement crite
;	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0WRITE:	PUSHM.32 D2..D6|A2..A5

		MOVE.32	A4,A2

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.32	#{A6}+CMD,A0
		MOVE.16	#CMD_WRITE,{A0}
		MOVE.32	D5,{A6}+SIZE
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#8,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR	;envoi la cmd au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV		;attend la rponse du PC

		MOVE.16	{A6}+RESULT,D7
		JUMP,NE	ERROR$		; le PC accepte ?

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.32	A2,{A4}+RQ_SDATAPTR
		MOVE.32	{A6}+SIZE,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR	;envoi les donnes au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV		;attend la rponse du PC

		MOVE.16	{A6}+RESULT,D7

ERROR$:
		POP.16	D4
		PUSH.16	D7
		NTREL	?SETTIM
		POP.16	D7

		POPM.32	D2..D6|A2..A5

		RET


;--------
; AVOTR
;========

; Routine appelle par un processus pour stopper un transfert
; en cours en lui faisant gnrer une erreur lors d'un WRITE.
; tant que le pilote est ouvert, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'AVOTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32 , D7.16

D0AVOTR:
		CLR.16	D7
		RET


;--------
; STOPTR
;========

; Routine appelle par un processus pour arrter provisoire-
; ment un transfert en cours en le faisant attendre dans le
; pilote dans WRITE, aussi longtemps que la routine STARTR
; n'est excute.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en criture au moment de l'STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STOPTR:
		RET


;--------
; STARTR
;========

; Routine appelle par un processus pour redmarrer un
; transfert en cours stopp auparavant par STOPTR.
; Tant que le pilote existe, cet appel-systme ne rend pas
; d'erreur et mmorise la requte, s'il n'y a pas de processus
; en attente au moment de l'AVOTR.
; Cependant, l'appel  cette routine doit correspondre  un
; appel  la routine STOPTR.

; in	A6.32		^variables du pilote
; out	D7.16		Erreur
; mod	D0..A1.32, D7.16

D0STARTR:
		RET

	.END
