	.TITLE	CLOCK.ASD

; Driver horloge pour carte SM400

; Alain Malek


	.BASE	10'10
	.LAYOUT HEX
	.REF	MON
	.PROC	M68020
	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.REF	COMMREQ

READ_CMD	= 1

MajRev	= 1
MinRev	= 0

.REV	MajRev,MinRev

;***********************************************************************************


; Constantes diverses
; -------------------

MAXMESS	= 30			; nombre maximum de messages en attente
MAXMNUM	= MAXMESS+1		; numero de message maximum, (aprs on recommence  1)


; Offsets pour ?RSTATUS
; ---------------------

	.LOC	0

OCLSTAT:	.BLK.16	1
OCLPWATCH:	.BLK.32	1
LGCLOCK1:

OCLPBAL:	.BLK.32	1
OCLPDEL:	.BLK.32	1
OCLMAXMESS:	.BLK.16	1
LGCLOCK2:


;***********************************************************************************


; Variables
; ---------

	.LOC	0

COMMBAR:	.BLK.32 1
REQUEST:	.BLK.8	RQ_LEN
REPLYSEM:	.BLK.32 1
CMD_SEND:	.BLK.16	1			; donnes envoyes au PC
TIME_READ:	.BLK.8	8			; sec,min,heure,jour,mois,anne,jsem,0	


OMESSATT:	.BLK.16		MAXMESS		; messages en attente
OSCPOS:		.BLK.32		1
PSEMA:		.BLK.32		1
PBALMESS:	.BLK.32		1
OCPTMESS:	.BLK.16		1

DAY:		.BLK.16		1
FABORT:		.BLK.16		1
FLAG:		.BLK.16		1
FLAGM:		.BLK.16		1
FLAGT:		.BLK.16		1
 BDEBUG	= 0
BUFFER:		.BLK.8		10'10
FLHEURE:	.BLK.8		1
FLDATE:		.BLK.8		1
WATCH:		.BLK.8		1
 BWMODIF	= 0
 BWNOAFF	= 1
 BWMEM		= 2
 BWDIR		= 3
 BWMOU		= 4
 BWMESS		= 5

LGVAR:

;***********************************************************************************


; Constantes
; ----------

FSIECLE	= 16'75		; frontire 21me sicle



; Dbut du code du driver
; -----------------------

DEBUT:
.LOC	0

	.16	0,D0BASE
	.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $CLOCK_0		No H'94
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"CLOCK_0"		; Nom driver
D0NAF:	.FILL.8	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'94			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:



;***********************************************************************************



; Points d'entres pour les routines de bases
; -------------------------------------------



;--------\\
; RESET   >
;========/

; in	-
; out	-
; mod	D0..A1, D7.W

D0RESET:	PUSHM.32 D0..D6|A0..A5

		MOVE.32	#LGVAR,D4
		MOVE.32	#R16^DEBUT,A4
		FOS	?GETComMem		; Demande la mmoire, rendue vent. par le FOS
		JUMP,NE	ERROR$
		MOVE.32	A4,A6			; ^variables

		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree reply sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+REPLYSEM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.8	#PRI_CLOCK,{A4}+RQ_PRI
		MOVE.16	#PORT_CLOCK,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM

RETRY$:		MOVE.32	#A8^1,D4
		MOVE.32	#R16^BARNAME,A3
		NTREL	?CREBAR			;ouvre la bar de communication
		JUMP,EQ	R8^OKBAR$
		MOVE.16	#4,D4
		NTREL	?DELMS			; on attend que pccomm dmarre
		JUMP	R8^RETRY$
OKBAR$:		MOVE.32	A5,{A6}+COMMBAR

		CLR.8	{A6}+FLAG
		CLR.8	{A6}+FLAGM
		CLR.8	{A6}+FLAGT
		CLR.8	{A6}+WATCH
		CLR.16	{A6}+OCPTMESS

		MOVE.32	#-1,D4
		NTREL	?CREBAL
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+PBALMESS


		MOVE.32	#{A6}+BUFFER,A4
		MOVE.32	#10'7,D5
		CALL	D0READ

		CLR.8	{A6}+FLDATE
		CLR.8	{A6}+FLHEURE

		MOVE.32	#{A6}+BUFFER+0,A4
		CALL	HEUREOK?
		SET.8,NE {A6}+FLHEURE

		MOVE.32	#{A6}+BUFFER+3,A4
		CALL	DATEOK?
		SET.8,NE {A6}+FLDATE

		CLR.16	D7

ERROR$:
		POPM.32	D0..D6|A0..A5

		RET

BARNAME:	.ASCIZE "#:PCCOMMBAR"

HEUREOK?:
		MOVE.8	{A4}+0,D0
		COMP.8	#16'60,D0
		JUMP,HS	L90$
		CALL	BCD?
		JUMP,NE	L90$

		MOVE.8	{A4}+1,D0
		COMP.8	#16'60,D0
		JUMP,HS	L90$
		CALL	BCD?
		JUMP,NE	L90$

		MOVE.8	{A4}+2,D0
		COMP.8	#16'24,D0
		JUMP,HS	L90$
		CALL	BCD?
		JUMP,NE	L90$
	
		CLR.16	D7
		RET

L90$:		MOVE.16	#1,D7
		RET




DATEOK?:
		MOVE.8	{A4}+0,D0
		COMP.8	#16'31+1,D0
		JUMP,HS	L90$
		TEST.8	D0
		JUMP,EQ	L90$
		CALL	BCD?
		JUMP,NE	L90$

		MOVE.8	{A4}+1,D0
		COMP.8	#16'12+1,D0
		JUMP,HS	L90$
		TEST.8	D0
		JUMP,EQ	L90$
		CALL	BCD?
		JUMP,NE	L90$

		MOVE.8	{A4}+2,D0
		CALL	BCD?
		JUMP,NE	L90$

		COMP.8	#16'87,D0
		JUMP,LO	L10$

L11$:		CLR.16	D7
		RET

L10$:		COMP.8	#FSIECLE,D0
		JUMP,LO	L11$

L90$:		MOVE.16	#1,D7
		RET


;***********************************************************************************


;--------\\
; KILL    >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0KILL:
		RET

;***********************************************************************************

;--------\\
; OPEN    >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0OPEN:
		RET



;--------\\
; CLOSE   >
;========/

; in	A6	^variables
; out	-
; mod	D0..A1

D0CLOSE:
		RET

;***********************************************************************************

;--------\\
; COMMAND >
;========/

; in	A4.32	^table des commandes termine par zro
;	A6	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16

D0COMMAND:	PUSHM.32 D3|D4|A3|A4|A5

		CLR.16	D7

NEXT$:		MOVE.8	{A4+},D3
		JUMP,EQ	EXIT$
		COMP.8	#"R",D3
		JUMP,EQ	L10$
		COMP.8	#"M",D3
		JUMP,EQ	L20$
		COMP.8	#"N",D3
		JUMP,EQ	L30$
		COMP.8	#"C",D3
		JUMP,EQ	L40$
		COMP.8	#"D",D3
		JUMP,EQ	L50$
		COMP.8	#"S",D3
		JUMP,EQ	L60$
		COMP.8	#"T",D3
		JUMP,EQ	L70$
		COMP.8	#"A",D3
		JUMP,EQ	MESS$
		COMP.8	#"K",D3
		JUMP,EQ	LMESS$
		MOVE.16	#ERILLO,D7
		JUMP	EXIT$

L20$:		TSET.8	{A6}+WATCH:#BWNOAFF
		JUMP	NEXT$

L10$:		TCLR.8	{A6}+WATCH:#BWMODIF
		TCLR.8	{A6}+WATCH:#BWNOAFF
		JUMP	NEXT$

L30$:		TSET.8	{A6}+WATCH:#BWMEM
		TCLR.8	{A6}+WATCH:#BWDIR
		TCLR.8	{A6}+WATCH:#BWMOU
		JUMP	NEXT$

L40$:		TCLR.8	{A6}+WATCH:#BWMEM
		TCLR.8	{A6}+WATCH:#BWDIR
		TCLR.8	{A6}+WATCH:#BWMOU
		JUMP	NEXT$

L60$:		TCLR.8	{A6}+WATCH:#BWMEM
		TCLR.8	{A6}+WATCH:#BWDIR
		TSET.8	{A6}+WATCH:#BWMOU
		JUMP	NEXT$

L50$:		TSET.8	{A6}+WATCH:#BWDIR
		TCLR.8	{A6}+WATCH:#BWMEM
		TCLR.8	{A6}+WATCH:#BWMOU
		JUMP	NEXT$

L70$:		TNOT.8	{A6}+FLAGT:#BDEBUG
		JUMP	NEXT$


; libre message dtruit

LMESS$:		CALL	GET16D3
		MOVE.16	#MAXMESS,D4
		MOVE.32	#{A6}+OMESSATT,A5

LLOOP$:		COMP.16	{A5+},D3
		JUMP,EQ	LTROUV$
		DEC.16	D4
		JUMP,NE	LLOOP$
		JUMP	NEXT$

LTROUV$:	CLR.16	{A5}-2
		JUMP	LLOOP$


; envoi d'un message
; ------------------

; format du message "A[aa.B][bb.B][cc.B][dd.B]Hallo bonjour !<0>"

; aa = nombre de dfilements
; bb = dure du message sonore
; cc = delay entre chaque  dcalage
; dd = type de message

MESS$:
		MOVE.32	{A6}+PBALMESS,A5

		MOVE.32	#6,D4
		PUSH.32	A4

		ADD.32	#1+1+1+1+1,A4

MESS1$:		TEST.8	{A4+}
		JUMP,EQ	MESS2$
		INC.32	D4
		JUMP	MESS1$

MESS2$:		POP.32	A4

		INC.16	{A6}+OCPTMESS
		COMP.16	#MAXMNUM,{A6}+OCPTMESS
		JUMP,NE	MESS3$
		MOVE.16	#1,{A6}+OCPTMESS

MESS3$:		MOVE.8	#2**BMSCOPY,D3
		NTREL	?GIVMS
		JUMP,NE	EXIT$
		MOVE.8	#2**BMSNBR,D3
		MOVE.16	{A6}+OCPTMESS,D4
		SUB.32	A4,A4
		MOVE.A16 D4,A4
		NTREL	?GIVMS
		JUMP,NE	EXIT$

		MOVE.16	{A6}+OCPTMESS,D7
		MOVE.32	#{A6}+OMESSATT,A5
		MOVE.32	#MAXMESS-1,D3		; au plus .. messages dans la table !

LOOPM$:		TEST.16	{A5+}
		JUMP,EQ	R8^InsertInTable$
		DJ.16,NMO D3,LOOPM$
		JUMP	R8^EXIT$		; pas de place, on ne fait rien :-(

InsertInTable$:
		MOVE.16	D7,{A5}-2

; fini trmin

EXIT$:		TEST.16	D7
		POPM.32	D3|D4|A3|A4|A5

		RET


; fait un MOVE.16 {A4+},D3 mme si A4 est impair

GET16D3:	MOVE.8	{A4+},D3
		SL.16	#8,D3
		MOVE.8	{A4+},D3
		RET

;***********************************************************************************

;--------\\
; RSTATUS >
;========/

; in	A4.32	^buffer
;	D4.32	longueur buffer
;	A6	^variables
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

; O --> pile ok
; V --> pile vide

D0RSTATUS:	PUSHM.32 D1|A0|A3|A4

		MOVE.32	#R16^TLONG,A0
		CALL	32^_CNVLGS
		JUMP,NE	FIN$

		TEST.8	{A6}+FLAG
		JUMP,EQ	L1$
		MOVE.8	#"V",{A4}+OCLSTAT
		JUMP	L90$

L1$:		TEST.8	{A6}+FLAGM
		JUMP,EQ	L2$
		MOVE.8	#"M",{A4}+OCLSTAT
		JUMP	L90$

L2$:		MOVE.8	#"O",{A4}+OCLSTAT

L90$:
		MOVE.32	#{A6}+WATCH,A3
		MOVE.32	A3,{A4}+OCLPWATCH
		COMP.32	#LGCLOCK1,D4
		JUMP,EQ	FIN$

		MOVE.32	{A6}+PBALMESS,{A4}+OCLPBAL
		MOVE.32	#{A6}+OMESSATT,A3
		MOVE.32	A3,{A4}+OCLPDEL
		MOVE.16	#MAXMESS,{A4}+OCLMAXMESS

		CLR.16	D7

FIN$:		POPM.32	D1|A0|A3|A4
		RET


TLONG:		.16	LGCLOCK1
		.16	LGCLOCK2
		.16	0

;***********************************************************************************

;--------\\
; WRITE   >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement crite
;	D7.W	erreur
; mod	D7.W, D5.L

D0WRITE:			; on ne fait rien. (Rglage depuis le PC)
		RET

;***********************************************************************************

;--------\\
; READ    >
;========/

; in	A4.L	^buffer texte
;	A1.L	^liste de terminateurs
;	D5.L	lg maximale du texte
;	A6	^variables
; out	D5.L	lg effectivement lue
;	D7.W	erreur
; mod	D7.W, D5.L

D0READ:		PUSHM.32 D3|D4|A0|A4|A5
		MOVE.32	D5,D1			; D1 <-- nb de bytes  lire
		JUMP,EQ	Out$

		PUSH.32	A4
		MOVE.32	#{A6}+REQUEST,A4

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM
		
		MOVE.32	#{A6}+CMD_SEND,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.16	#READ_CMD,D3
		SWAP.16	D3
		MOVE.16	D3,{A0}
		MOVE.32	#2,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+TIME_READ,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#8,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR		;envoi la requte au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV			;attend la rponse du PC

		POP.16	D4
		NTREL	?SETTIM
		POP.32	A4

		MOVE.32	#{A6}+TIME_READ,A0

		MOVE.8	{A0+},{A4+}		; secondes
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; minutes
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; heures
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; jour
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; mois
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; anne
		DEC.32	D1
		JUMP,EQ	Out$

		MOVE.8	{A0+},{A4+}		; jour de la semaine
		DEC.32	D1
		JUMP,EQ	Out$

		TEST.32	D1			; reste qq chose  lire ?
		JUMP,EQ	R8^Out$			; non (ok) => 80$
		MOVE.16	#EROUTF, D7		; oui => erreur
Out$:
		SUB.32		D1, D5		; D5 <-- nb de bytes lus
		TEST.16		D7
		POPM.32	D3|D4|A0|A4|A5
		RET

;***********************************************************************************

;------\\
; BCD?  >
;======/

; regardre si D0 est un nombre BCD

; in	D0.8	nombre
; out	D5.16	<>0 => pas de nombre BCD
;		=0  => nombre BCD
; mod 	D5.16

BCD?:		PUSHM.32 D0|D1|D5
		CLR.16	D5
		MOVE.8	D0,D1
		AND.8	#16'0F,D1
		COMP.8	#16'9,D1
		JUMP,LS	L1$
		INC.16	D5

L1$:		MOVE.8	D0,D1
		AND.8	#16'F0,D1
		COMP.8	#16'90,D1
		JUMP,LS	L2$
		INC.16	D5

L2$:		TEST.16	D5

		POPM.32	D0|D1|D5
		RET

;***********************************************************************************

	.END
