
	.TITLE	DISK.ASD

	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.REF	MON
	.REF	COMMREQ

	.PROC	M68020

REVMAJ	= 2
REVMIN	= 6

; Date           Rv	Commentaire
; ----------------------------------------------------------------------------------------
; 06/11/99  PA   2.6	Retourne l'erreur "disque absent" en cas d'absence de ZIP.
; 14/11/97  PA   2.5	Supporte aussi des disquettes 720 KB.
; 01/10/97  PA	 2.4	Corrig RSTATUS (ne dborde plus).
; 23/09/97  PA   2.3	Supporte positions absolues.
; 21/09/97  PA   2.2	Etendu  7 instances du pilote (comme $SCSI).
; 18/09/97  PA   2.1	Compatible avec des units physiques
; 17/09/97  PA   2.0	Revu en profondeur le fonctionnement. Repris  partir de $PCFILE
; ----------------------------------------------------------------------------------------

PRIO	= 13

MAXPIL	= 7		; nb max de pilotes $DISK
NOBASE	= 16'0070	; numro de base des pilotes (comme $SCSI)

LGFILE	= 256

	.IDENT	"(C) Copyright 1996-1997, Alain Malek, Pierre Arnaud & EPSITEC SA"
	.REV	REVMAJ,REVMIN
	.START	-1

DEBUG	= FALSE

	.MACRO	_DEBUGD7
.IF DEBUG
	PUSH.16	D4
	MOVE.16	D7,D4
	MON	?AFTIM
	.ASCIZE	"$DISK:%1:"
	MON	?AFX4
	MON	?AFCR
	POP.16	D4
	TEST.16	D7
.ENDIF
	.ENDMACRO

;	Variables globales
;	------------------

		.LOC	0

OCOMMBAR:	.BLK.32 1			; pointeur sur la BAR de communication
ONOM:		.BLK.8	LGFILE			; nom du fichier
OCOMMREQ:	.BLK.8	RQ_LEN			; structure de requte
OEXCLSEM:	.BLK.32 1			; semaphore d'exclusion pour le port
OREPLYSEM:	.BLK.32 1			; reply semaphore pour COMM
OSENDDATA:	.BLK.32 3			; pour envoyer les commandes et no de blocs
ORECVDATA:	.BLK.8	20			; pour recevoir le resultat des cmds
OCOMPT:		.BLK.16	1			; compteur d'utilisation (OPEN,CLOSE)
ONO:		.BLK.16	1			; numro logique du pilote
OISPHYSICAL:	.BLK.8	1			; TRUE => unit physique
		.ALIGN	4

OCHBLKFOS:	.BLK.32	1			; pour le cache FOS des floppys
OADBASE:	.BLK.32	1			; ^base du driver

OWINCAPACITY:	.BLK.32	1			; taille en blocs FOS
OWINLGBLK:	.BLK.32	1			; taille d'un bloc
OWINSHIFT:	.BLK.32	1			; shift pour blocs FOS
OWINOFFSET:	.BLK.32	1			; offset de dpart
OWINDISKCAP:	.BLK.32	1			; capacit du disque (bytes)
LGVAR:

;	Commandes pour le serveur
;	-------------------------

CMD_OPEN 	= 2
CMD_CLOSE 	= 3
CMD_READ 	= 4
CMD_WRITE 	= 5
CMD_POS 	= 6
CMD_GETSIZE 	= 7
CMD_KILL	= 8
CMD_RESET	= 9
CMD_COMMAND	= 10


;	Macro pour gnrer un en-tte de driver
;	---------------------------------------

   .MACRO _Header
   .LOCALMACRO Start, Name

Start:
	.16	FnOPEN-F%1BASE
	.16	FnCOMMAND-F%1BASE
	.16	FnRSTATUS-F%1BASE
	.16	FnREAD-F%1BASE
	.16	FnWRITE-F%1BASE
	.16	FnCLOSE-F%1BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; F0AUX1-F0BASE
	.16	-1			; F0AUX2-F0BASE
	.16	FnRESET-F%1BASE
	.16	FnKILL-F%1BASE
	.16	-1			; F0STRT-F0BASE
	.16	-1			; F0TSTRT-F0BASE
	.16	-1			; F0START-F0BASE

Name:	.ASCII	"DISK_%1"		; Nom driver
	.FILL.8	LGDNAM-(APC-Name),0

	.8	(%2).AND.255		; Numro driver (low byte)
	.8	TYPMM			; Type

	.8	REVMAJ,REVMIN		; Rvision - version -
	.8	PRIO
	.8	(%2).DIV.256		; Numro driver (high byte)

	.8	0			; Attribut
	.8	2**BDRDOK.OR.2**BDWROK	; Attribut

	.FILL.8	LGDDESC-(APC-Start),0	; Le reste.
F%1BASE:
	.16	%1			; numro logique
LASTDRIV == %1
   .ENDMACRO


;------- Dbut du driver ------------------------------------

	.LOC	0

DEBUT:
	.16	0,F0BASE
	.16	1,F1BASE
	.16	2,F2BASE
	.16	3,F3BASE
	.16	4,F4BASE
	.16	5,F5BASE
	.16	6,F6BASE
	.16	2**7

	_Header 0,NOBASE
	_Header 1,NOBASE+1
	_Header 2,NOBASE+2
	_Header 3,NOBASE+3
	_Header 4,NOBASE+4
	_Header 5,NOBASE+5
	_Header 6,NOBASE+6

.IF	(LastDriv+1).NE.MAXPIL
.ERROR	"Nombre max de pilotes (MAXPIL) faux !!!"
.ENDIF


; --------------------------------------------------------
;		ROUTINES BAS NIVEAU DU DRIVER
; --------------------------------------------------------


;----------\\
;  FnRESET  >
;==========/

; in	A2.32	^paramtres
; out	D7.16	erreur
; mod	D0,D1,A0,A1

FnRESET:
	PUSHM.32 D2..D6|A2..A5

	MOVE.32	#LGVAR,D4
	MOVE.32	#MTYPBD,D1
	MOVE.32	A0,A1
	GESMEM	?GETMEM			; alloue mem pour les vars locales
	JUMP,NE	ERROR$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6
	MOVE.32	A1,{A6}+OADBASE

RETRY$:	MOVE.32	#A8^1,D4
	MOVE.32	#R16^BARNAME$,A3
	NTREL	?CREBAR
	JUMP,EQ	R8^OKBAR$

	MOVE.32	#A8^10,D4
	NTREL	?DELMS
	JUMP	R8^RETRY$

OKBAR$:	MOVE.32	A5,{A6}+OCOMMBAR

.IF DEBUG
	MON	?AFTIM
	.ASCIZE	"$DISK OpenBar successful<CR>"
.ENDIF
	MOVE.32	#25,D4
	NTREL	?DELMS

	MOVE.16	{A1},{A6}+ONO		; copie le no logique

	MOVE.32	#{A6}+ONOM,A0
	MOVE.16	#LGFILE-2,D0
COPY$:	MOVE.8	{A2+},{A0+}		; on copie le nom du fichier
	SKIP,EQ DJ.16,NMO D0,COPY$
	CLR.8	{A0}

	CLR.16	{A6}+OCOMPT		; 0 fois ouvert

	MOVE.32	#A8^1,D4
	NTREL	?CRESEM			; smaphore d'exclusion
	JUMP,NE	ERROR$

	MOVE.32	A5,{A6}+OEXCLSEM

	MOVE.32	#A8^0,D4
	NTREL	?CRESEM			; smaphore de synchro pour communication
	JUMP,NE	ERROR$

	MOVE.32	A5,{A6}+OREPLYSEM

	MOVE.32	#256,{A6}+OWINLGBLK
	MOVE.32	#16,{A6}+OWINOFFSET

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.8	#PRI_FILE,{A4}+RQ_PRI
	MOVE.32	#R16^PTABLE$,A0
	MOVE.16	{A6}+ONO,D0
	MOVE.16	{A0}+A16^{D0}*2,{A4}+RQ_PORTNO
	MOVE.32	{A6}+OREPLYSEM,{A4}+RQ_REPLYSEM

	MOVE.32	#{A6}+ONOM,A0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#LGFILE,{A4}+RQ_SDATALEN
	MOVE.32 #{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#12,{A4}+RQ_RDATALEN
	CALL	SyncRequest

.IF DEBUG
	MON	?AFTIM
	.ASCIZE	"$DISK initial request OK.<CR>"
.ENDIF

	MOVE.8	{A0}+2,{A6}+OISPHYSICAL	; TRUE => unit physique
	MOVE.16	{A0}+0,D7		; erreur
	JUMP,NE	ERROR$

	TEST.8	{A6}+OISPHYSICAL	; unit physique
	JUMP,F	R8^NOFLO$		; non => pas de dcoupage FOS

	MOVE.32	#0,D1
	MOVE.32	#0,D5
	MOVE.32	#0,D3
	MOVE.32	#0,D2

	MOVE.8	{A0}+3,D1		; shift pour passer en blocs FOS
	MOVE.16	{A0}+4,D5		; offset
	MOVE.16	{A0}+6,D3		; taille d'un bloc physique
	MOVE.32	{A0}+8,D2		; capacit en blocs FOS

;;	MOVE.32	#1440*1024/256,D2	; taille d'une disquette en blocs FOS
;;	MOVE.32	#512,D3			; taille d'un bloc physique
;;	MOVE.32	#16,D5			; offset au dbut du disque
;;	MOVE.32	#1,D1			; shift pour passer en blocs FOS

	MOVE.32	D2,D4
	SL.32	#8,D4

	MOVE.32	D4,{A6}+OWINDISKCAP	; taille en bytes
	MOVE.32	D2,{A6}+OWINCAPACITY	; taille en blocs FOS
	MOVE.32	D3,{A6}+OWINLGBLK	; taille d'un bloc
	MOVE.32	D5,{A6}+OWINOFFSET	; offset de dmarrage FOS
	MOVE.32	D1,{A6}+OWINSHIFT	; dcalage (log2 de la taille de bloc)

	CALL	OPENBLKFOS		; ouvre le mode "cache" du floppy

NOFLO$:	CLR.16	D7

ERROR$:	_DEBUGD7 Install
	POPM.32	D2..D6|A2..A5
	TEST.16	D7
	RET

BARNAME$:
	.ASCIZE "#:PCCOMMBAR"

PTABLE$:
	.16	PORT_PCFILE0
	.16	PORT_PCFILE1
	.16	PORT_PCFILE2
	.16	PORT_PCFILE3
	.16	PORT_PCFILE4
	.16	PORT_PCFILE5
	.16	PORT_PCFILE6
;	.16	PORT_PCFILE7
;	.16	PORT_PCFILE8
;	.16	PORT_PCFILE9

;-------\\
;  KILL  >
;=======/

; D-installe le driver.

; in	-
; out	D7.16
; mod	...

FnKILL:
	PUSHM.32 D0..D6|A0..A5

	CALL	StartLock
	JUMP,NE	NOLOCK$

	TEST.8	{A6}+OISPHYSICAL
	JUMP,F	R8^NOFLO$

	CALL	CloseBlkFOS

NOFLO$:	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A0
	MOVE.16	#CMD_KILL,D3
	SWAP.16	D3
	MOVE.16	D3,{A0}
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	CALL	EndLock

	MOVE.32	{A6}+OREPLYSEM,A5
	NTREL	?KILLSEM

	MOVE.32	{A6}+OEXCLSEM,A5
	NTREL	?KILLSEM

	MOVE.32	A6,A4
	MOVE.32	#R16^F0BASE,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM
	CLR.16	D7

NOLOCK$:
	_DEBUGD7 Deinstall
	POPM.32 D0..D6|A0..A5
	TEST.16	D7
	RET




;--------\\
;  WRITE  >
;========/

; Ecrit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...

WRITE:
	PUSHM.32 D0..D6|A0..A6
	MOVE.32	A5,A6			; A6 <-- ^variables
	MOVE.32	{A6}+OWINSHIFT,D0
	SL.32	D0,D4			; D4 <--  premier bloc FOS
	SL.32	D0,D5			; D5 <--  nombre de blocs FOS
	CALL	DoWrite
	POPM.32 D0..D6|A0..A6
	TEST.16	D7
	RET

FnWRITE:
	PUSHM.32 D0..D6|A0..A6
	CALL	StartLock
	JUMP,NE	R8^WNOLOCK$

	TEST.8	{A6}+OISPHYSICAL
	JUMP,F	R8^NOFLO$

	TEST.32	D4:#31			; position ngative ?
	JUMP,T	R8^FOS$			; oui => forcment une position FOS
	TCLR.32	D4:#30			; position absolue ?
	JUMP,F	R8^FOS$			; non => position FOS
	SUB.32	{A6}+OWINOFFSET,D4	; oui => repositionne en fonction de l'en-tte

FOS$:	MOVE.32	{A6}+OchBLKFOS,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_WRITEBLKFOS
	JUMP	DELOCK$

NOFLO$:	ADD.32	#16'10,D4		; offset (on a 16 blocs de dmarrage, etc..)
	CALL	DoWrite

DELOCK$:
	CALL	EndLock

WNOLOCK$:
WEXIT$:
	_DEBUGD7 Write
	POPM.32 D0..D6|A0..A6
	TEST.16	D7
	RET



DoWrite:
	SL.32	#8,D4
	SL.32	#8,D5

	TEST.32	D5			; qqch  crire ?
	JUMP,EQ	WERR$			; non => ne fait rien

	MOVE.32	A4,A3
	MOVE.32	D5,D2

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.16	#CMD_WRITE,D3
	SWAP.16	D3
	MOVE.16	D3,{A0+}
	CLR.16	{A0+}
	SWAP.16	D4
	SWAP.32	D4
	SWAP.16	D4
	MOVE.32	D4,{A0+}
	SWAP.16	D2
	SWAP.32	D2
	SWAP.16	D2
	MOVE.32	D2,{A0+}
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest

	MOVE.16	{A6}+ORECVDATA,D7	; criture possible ?
	JUMP,NE	R16^WERR$

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	D5,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	MOVE.16	{A6}+ORECVDATA,D7	; code d'erreur

WERR$:	RET




;-------\\
;  READ  >
;=======/

; Lit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...

READ:
	PUSHM.32 D0..D6|A0..A6
	MOVE.32	A5,A6			; A6 <-- ^variables
	MOVE.32	{A6}+OWINSHIFT,D0
	SL.32	D0,D4			; D4 <--  premier bloc FOS
	SL.32	D0,D5			; D5 <--  nombre de blocs FOS
	CALL	DoRead
	POPM.32 D0..D6|A0..A6
	TEST.16	D7
	RET



FnREAD:
	PUSHM.32 D0..D6|A0..A6

	CALL	StartLock
	JUMP,NE	R8^RNOLOCK$

	TEST.8	{A6}+OISPHYSICAL
	JUMP,F	R8^NOFLO$

	TEST.32	D4:#31			; position ngative ?
	JUMP,T	R8^FOS$			; oui => forcment une position FOS
	TCLR.32	D4:#30			; position absolue ?
	JUMP,F	R8^FOS$			; non => position FOS
	SUB.32	{A6}+OWINOFFSET,D4	; oui => repositionne en fonction de l'en-tte

FOS$:	MOVE.32	{A6}+OchBLKFOS,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_READBLKFOS
	JUMP	R8^DELOCK$

NOFLO$:	ADD.32	#16'10,D4		; offset (on a 16 blocs de dmarrage, etc..)
	CALL	DoRead

DELOCK$:
	CALL	EndLock

RNOLOCK$:
REXIT$:	_DEBUGD7 Read
	POPM.32 D0..D6|A0..A6
	TEST.16	D7
	RET



DOREAD:
	SL.32	#8,D4
	SL.32	#8,D5
	TEST.32	D5			; qqch  lire ?
	JUMP,EQ	RERR$			; non => fini

	MOVE.32	A4,A2

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A3
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.16	#CMD_READ,D3
	SWAP.16	D3
	MOVE.16	D3,{A3+}
	CLR.16	{A3+}
	MOVE.32	D5,D3
	SWAP.16	D5
	SWAP.32	D5
	SWAP.16	D5
	SWAP.16	D4
	SWAP.32	D4
	SWAP.16	D4
	MOVE.32	D4,{A3+}			; pos
	MOVE.32	D5,{A3+}			; size
	MOVE.32	#{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	MOVE.16	{A6}+ORECVDATA,D7		; lecture ok ?
	JUMP,NE	RERR$

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A3
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.16	#CMD_READ,D0
	SWAP.16	D0
	MOVE.16	D0,{A3+}
	CLR.16	{A3+}
	MOVE.32	D4,{A3+}			; pos
	MOVE.32	D5,{A3+}			; size
	MOVE.32	A2,{A4}+RQ_RDATAPTR
	MOVE.32	D3,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	CLR.16	D7
RERR$:	RET






;----------\\
;  COMMAND  >
;==========/

; Commande au pilote $DISK :

; SIZ[taille.16] -> agrandit au nombre de blocs voulu (SIze)
; REL		 -> fait un release du fichier utilis (faire ensuite RELEASE/ENTER -> rcup)

; in	A4.32	^commandes
; out	D7.16
; mod	...

FnCOMMAND:
	PUSHM.32 D0..D6|A0..A5

	CALL	StartLock
	JUMP,NE	NOLOCK$

	MOVE.32	{A4}+0,{A6}+OSENDDATA+4
	MOVE.32	{A4}+4,{A6}+OSENDDATA+8

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A3
	MOVE.16	#CMD_COMMAND.SL.8,D3
	MOVE.16	D3,{A3}
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A3
	MOVE.32	A3,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	MOVE.16	{A6}+ORECVDATA,D7

OK$:	CALL	EndLock
NOLOCK$:
	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET




; in	A6	^variables
; out	D4.32	taille en blocs FOS
;	{A6}+OWINDISKCAP
;	{A6}+OWINCAPACITY
;	D7.16	ok / erreur

ReadMediaSize:
	PUSHM.32 D3|A3|A4|A5

	MOVE.32	{A6}+OCOMMBAR,A5

	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A3
	MOVE.16	#CMD_GETSIZE,D3
	SWAP.16	D3
	MOVE.16	D3,{A3}
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A3
	MOVE.32	A3,{A4}+RQ_RDATAPTR
	MOVE.32	#4,{A4}+RQ_RDATALEN
	CALL	SyncRequest

	MOVE.32	{A6}+ORECVDATA,D4
	SWAP.16	D4
	SWAP.32	D4
	SWAP.16	D4

	MOVE.32	D4,{A6}+OWINDISKCAP
	SR.32	#8,D4
	MOVE.32	D4,{A6}+OWINCAPACITY
	TEST.32	D4
	JUMP,NE	R8^OK$

	MOVE.16	#ERMRDY,D7		; erreur "disque absent"

OK$:	POPM.32	D3|A3|A4|A5
	TEST.16	D7
	RET



;----------\\
;  RSTATUS  >
;==========/

; Rend le status du driver

; in	D4.32	taille du buffer
;	A4.32	^buffer
; out	D7.16
; mod	...

FnRSTATUS:
	PUSHM.32 D0..D6|A0..A5

	CALL	StartLock
	JUMP,NE	NOLOCK$

	GESMEM	?CLEARMEM			; efface le buffer avant d'y crire

	MOVE.32	D4,D0
	MOVE.8	#MTFLO,{A4}+OMTYPE		; type mmoire de masse
	COMP.16	#16,{A6}+OWINOFFSET+2		; un floppy par dfaut (16 blocs rservs)
	JUMP,EQ	R8^ISFLO$
	MOVE.8	#MTWIN,{A4}+OMTYPE		; un disque dur sinon (32 blocs rservs)

ISFLO$:	CALL	ReadMediaSize			; lit la taille du mdia en blocs FOS
	JUMP,NE	END$				; pas possible (mdia absent) => erreur !

	SUB.32	{A6}+OWINOFFSET,D4		; taille disponible en blocs FOS

	MOVE.32	D4,{A4}+OMNBLK			; nombre de blocs FOS (sans boot)
;	CLR.32	{A4}+OMRBLK			; bloc le plus rapide
;	COMP.32	#LGMAM0,D0			; statut minimal ?
;	JUMP,LE	END$				; oui => OK

;	CLR.16	{A4}+OMACER			; erreur(s) dernier accs
;	CLR.16	{A4}+OMTRER			; somme des erreurs en lecture
;	CLR.16	{A4}+OMTWER			; somme des erreurs en criture
	COMP.32	#LGMAM1,D0			; tout ce qu'il faut ?
	JUMP,LE	END$				; oui => OK

	MOVE.16	{A6}+OWINOFFSET+2,{A4}+OMNBBO	; offset en dbut d'unit
	MOVE.16	{A6}+OWINLGBLK+2,{A4}+OMLGBLK	; taille d'un bloc physique

	COMP.32	#LGMAM3,D0
	JUMP,LT	END$

	ADD.32	{A6}+OWINOFFSET,D4
	MOVE.32	D4,{A4}+OMTBLK			; nombre total de blocs (avec boot)
	COMP.8	#MTFLO,{A4}+OMTYPE		; type floppy ?
	JUMP,NE	END$				; non => ce sera tout
	COMP.16	#256,{A6}+OWINLGBLK+2		; type floppy mais "soft" ?
	JUMP,EQ	END$				; oui => ce sera tout (pas d'infos pour .DI)

	MOVE.16	#2,{A4}+oMNBFmtRec		; 2 records MFMT pour le moment

	COMP.32	#LGMAM3,D0
	JUMP,LE	END$

	MOVE.32	D4,D0				; taille en blocs FOS

	MOVE.32	#{A4}+LGMAM3,A4
	MOVE.32	#LgMFmtRec*2,D4
	GESMEM	?CLEARMEM

; Valeurs incorrectes pour autre chose qu'un floppy !

	MOVE.16	#2,{A4}+oMFmtFace
	MOVE.16	#18,{A4}+oMFmtCyl
	MOVE.16	#80,{A4}+oMFmtSect
	MOVE.16	#512,{A4}+oMFmtLgSect
	MOVE.8	#FmtPSOS,{A4}+oMFmtOs
	COMP.32	#1440*4,D0			; cette capacit ?
	JUMP,NE	R8^NOT1440$
	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+oMFmtFlag
NOT1440$:
	MOVE.8	#"M",{A4}+oMFmtModeCmd+0
	MOVE.8	#"P",{A4}+oMFmtModeCmd+1
	MOVE.8	#"C",{A4}+oMFmtModeCmd+2
	MOVE.8	#"2",{A4}+oMFmtModeCmd+3

	MOVE.16	#2,{A4}+LgMFmtRec+oMFmtFace
	MOVE.16	#9,{A4}+LgMFmtRec+oMFmtCyl
	MOVE.16	#80,{A4}+LgMFmtRec+oMFmtSect
	MOVE.16	#512,{A4}+LgMFmtRec+oMFmtLgSect
	MOVE.8	#FmtPSOS,{A4}+LgMFmtRec+oMFmtOs
	COMP.32	#720*4,D0			; cette capacit ?
	JUMP,NE	R8^NOT720$
	MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec+oMFmtFlag
NOT720$:
	MOVE.8	#"M",{A4}+LgMFmtRec+oMFmtModeCmd+0
	MOVE.8	#"P",{A4}+LgMFmtRec+oMFmtModeCmd+1
	MOVE.8	#"C",{A4}+LgMFmtRec+oMFmtModeCmd+2
	MOVE.8	#"5",{A4}+LgMFmtRec+oMFmtModeCmd+3

END$:	CALL	EndLock

NOLOCK$:
	POPM.32	D0..D6|A0..A5
	CLR.16	D7
	RET



;-------\\
;  OPEN  >
;=======/

; On ouvre une unit !

FnOPEN:
	PUSHM.32 D0..D6|A0..A5

	CALL	StartLock
	JUMP,NE	NOLOCK$

	TEST.16	{A6}+OCOMPT
	JUMP,EQ	R8^DOOPEN$

	INC.16	{A6}+OCOMPT
	CLR.16	D7
	JUMP	OK$

DOOPEN$:
	INC.16	{A6}+OCOMPT

	TEST.8	{A6}+OISPHYSICAL
	JUMP,F	R8^NOFLO$

	CALL	ClearBlkFOS		; libre le cache
	CALL	ReadMediaSize		; taille dans D4, met  jour OWINCAPACITY...
	CALL	ClOpBlkFOS		; rinitialise correctement le cache

NOFLO$:	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A0
	MOVE.16	#CMD_OPEN,D3
	SWAP.16	D3
	MOVE.16	D3,{A0}
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A0
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	MOVE.16	{A6}+ORECVDATA,D7
	JUMP,EQ	OK$

	DEC.16	{A6}+OCOMPT

OK$:	CALL	EndLock

NOLOCK$:
	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET



;--------\\
;  CLOSE  >
;========/

; On referme l'unit (et le fichier .DI)

FnCLOSE:
	PUSHM.32 D0..D6|A0..A5

	CALL	StartLock
	JUMP,NE	NOLOCK$

	TEST.8	{A6}+OISPHYSICAL
	JUMP,F	R8^NOFLO$

	CALL	ClearBlkFOS

NOFLO$:	DEC.16	{A6}+OCOMPT
	JUMP,EQ	R8^DOCLOSE$
	CLR.16	D7
	JUMP	R16^OK$

DOCLOSE$:
	MOVE.32	#{A6}+OCOMMREQ,A4
	MOVE.32	#{A6}+OSENDDATA,A3
	MOVE.16	#CMD_CLOSE,D3
	SWAP.16	D3
	MOVE.16	D3,{A3}
	MOVE.32	A3,{A4}+RQ_SDATAPTR
	MOVE.32	#12,{A4}+RQ_SDATALEN
	MOVE.32	#{A6}+ORECVDATA,A3
	MOVE.32	A3,{A4}+RQ_RDATAPTR
	MOVE.32	#2,{A4}+RQ_RDATALEN

	CALL	SyncRequest
	MOVE.16	{A6}+ORECVDATA,D7

OK$:	CALL	EndLock
NOLOCK$:
	POPM.32	D0..D6|A0..A5
	TEST.16	D7
	RET


;------------\\
;  StartLock  >
;============/

; Dbut de l'exclusion sur un port.

; in	A3.32	^variables locales
; out	D7.16	error
; mod	D7.16

StartLock:
	PUSH.32 A5
	MOVE.32	{A6}+OEXCLSEM,A5
	NTREL	?LOCK
	POP.32	A5
	RET


;----------\\
;  EndLock  >
;==========/

; Fin de l'exclusion.

; in	A6.32	^variables
; out
; mod

EndLock:
	PUSHM.32 D7|A5
	MOVE.32	{A6}+OEXCLSEM,A5
	NTREL	?UNLOCK
	POPM.32	D7|A5
	RET


;------------\\
; SyncRequest >
;============/

; Dialogue synchrone avec la couche de communication et le serveur
; qui tourne sur le Smaky 400.

; in	A4.32	^requte
;	A6.32	^variables
; out	-
; mod	D7.16

SyncRequest:
	PUSHM.32 D4|A5

.IF DEBUG
	MOVE.32	{A4}+RQ_RDATALEN,D4
	MON	?AFTIM
	.ASCIZE	"[Read "
	MON	?AFX8
	MON	?AFTIM
	.ASCIZE	" on port "
	MOVE.16	{A4}+RQ_PORTNO,D4
	MON	?AFX4
.ENDIF

	MOVE.32	#-1,D4
	NTREL	?MODTIM
	MOVE.32	{A6}+OCOMMBAR,A5
	NTREL	?OFFERBAR
	NTREL	?ENDOFFERBAR

.IF DEBUG
	MON	?AFTIM
	.ASCIZE	" waiting]<CR>"
.ENDIF

	MOVE.32	{A6}+OREPLYSEM,A5
	NTREL	?WAITEV

.IF DEBUG
	MON	?AFTIM
	.ASCIZE	"[done]<CR>"
.ENDIF

	NTREL	?SETTIM
	POPM.32	D4|A5
	RET




;-------------\\
;  OPENBLKFOS  >
;=============/

; Ouverture de l'accs  des tranches de blocs FOS.

; in	A6.32	^variables locales
; out	D7.16	erreur
; mod	D7.16

OPENBLKFOS:
	PUSHM.32 D1..D6|A0..A5

	MOVE.32	{A6}+OADBASE,A1			; ^base du driver
	MOVE.32	#MTYPBD,D1			; compte mmoire de type driver BIOS
	MOVE.32	{A6}+OWINCAPACITY,D2
	MOVE.32	{A6}+OWINLGBLK,D3
	MOVE.32	{A6}+OWINOFFSET,D5
	MOVE.32	#0,D4				; D4 <-- blocs/piste pas utilis
	MOVE.32	#0,D6				; D6 <-- mode d'ouverture normal
	MOVE.32	#R16^READ,A3
	MOVE.32	#R16^WRITE,A4
	MOVE.32	A6,A5
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_OPENBLKFOS
	JUMP,NE	R8^RET$

	MOVE.32	A5,{A6}+OCHBLKFOS		; mmorise le canal

RET$:	POPM.32	D1..D6|A0..A5
	TEST.16	D7
	RET



;--------------\\
;  CLOSEBLKFOS  >
;==============/

; Fermeture de l'accs  des tranches de blocs FOS.

; in	A6.32	^variables locales
; out	D7.16	erreur
; mod	D7.16

CLOSEBLKFOS:
	PUSHM.32 A0|A1|A5

	MOVE.32	{A6}+OCHBLKFOS,A5		; canal
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_CLOSEBLKFOS		; !!!!! BUG !!!!! : mod A1

	CLR.32	{A6}+OchBLKFOS

	POPM.32	A0|A1|A5
;;;;	TEST.16	D7
	RET



;-------------\\
;  CLOPBLKFOS  >
;=============/

; Rgnration des variables pour accs  des tranches de blocs FOS.
; Il faut appeler cette routine  chaque changement de format physique
; (changement de la taille des blocs / du nombre de blocs).

; in	A6.32	^variables locales
; out	D7.16	erreur
; mod	D7.16

CLOPBLKFOS:
	TEST.32	{A6}+OCHBLKFOS
	JUMP,EQ	R8^OPEN$
	CALL	CLOSEBLKFOS
	JUMP,NE	R8^RET$

OPEN$:	CALL	OPENBLKFOS

RET$:
;;;;	TEST.16	D7
	RET



;--------------\\
;  CLEARBLKFOS  >
;==============/

; Efface le cache de piste pour accs  des tranches de blocs FOS.

; in	A6.32	^variables locales
; out	D7.16	erreur
; mod	D7.16

CLEARBLKFOS:
	PUSHM.32 A0|A5

	MOVE.32	{A6}+OCHBLKFOS,A5		; canal
	MOVE.32	_INDNTR,A0
	CALL	{A0}+OIN_CLEARBLKFOS

	POPM.32	A0|A5
;;;;	TEST.16	D7
	RET


	.END

