
; FILE driver pour Smaky Integre dans un PC
; Alain Malek Juin 1996

; AM 12/2/97 rajout PCFILE_1, PCFILE_2, PCFILE_3, PCFILE_4 (FLO_0)

	.TITLE	FILE.ASD
	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.PROC	M68020
	.REF	MON
	.REF	COMMREQ

REVMAJ	= 1
REVMIN	= 2
PRIO	= 13

DEBUG	= 0		; flag de compilation

MAXPIL	= 5		; nb max de pilotes PCFILE
NOBASE	= 16'6C		; numro de base des pilotes non floppy (6C - 6F)
FLONO	= 4		; numro du premier pilote floppy ($PCFILE_4)

LGFILE	= 256

	.IDENT	"PC File driver. Alain Malek Juin 1996"
	.REV	REVMAJ,REVMIN
	.START	-1

;------- Variables ----------------------------------------

	.LOC	0

OCOMMBAR:	.BLK.32 1			; pointeur sur la BAR de communication
ONOM:		.BLK.8	LGFILE			; nom du fichier
OCOMMREQ:	.BLK.8	RQ_LEN			; structure de requte
OEXCLSEM:	.BLK.32 1			; semaphore d'exclusion pour le port
OREPLYSEM:	.BLK.32 1			; reply semaphore pour COMM
OSENDDATA:	.BLK.32 3			; pour envoyer les commandes et no de blocs
ORECVDATA:	.BLK.32 1			; pour recevoir le resultat des cmds
OCOMPT:		.BLK.16	1			; compteur d'utilisation (OPEN,CLOSE)
ONO:		.BLK.16	1			; numro logique du pilote
OLOCBLKFOS:	.BLK.32	1			; pour le cache FOS des floppys

LGVAR:

;------- Liste des commandes envoyes par le driver au serveur -------

CMD_OPEN 	= 2
CMD_CLOSE 	= 3
CMD_READ 	= 4
CMD_WRITE 	= 5
CMD_POS 	= 6
CMD_GETSIZE 	= 7
CMD_KILL	= 8
CMD_RESET	= 9

; Macro pour gnrer un en-tte de driver
; ---------------------------------------

   .MACRO _Header
   .LOCALMACRO Start, Name

Start:
	.16	FnOPEN-F%1BASE
	.16	FnCOMMAND-F%1BASE
	.16	FnRSTATUS-F%1BASE
	.16	FnREAD-F%1BASE
	.16	FnWRITE-F%1BASE
	.16	FnCLOSE-F%1BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; F0AUX1-F0BASE
	.16	-1			; F0AUX2-F0BASE
	.16	FnRESET-F%1BASE
	.16	FnKILL-F%1BASE
	.16	-1			; F0STRT-F0BASE
	.16	-1			; F0TSTRT-F0BASE
	.16	-1			; F0START-F0BASE

Name:	.ASCII	"PCFILE_%1"		; Nom driver
	.FILL.8	LGDNAM-(APC-Name),0

	.8	%2			; Numro driver
	.8	TYPMM			; Type

	.8	REVMAJ,REVMIN		; Rvision - version -
	.8	PRIO,0

	.8	0			; Attribut
	.8	2**BDRDOK.OR.2**BDWROK	; Attribut

	.FILL.8	LGDDESC-(APC-Start),0	; Le reste.
F%1BASE:
	.16	%1			; numro logique
LASTDRIV == %1
   .ENDMACRO


;------- Dbut du driver ------------------------------------

		.LOC	0

DEBUT:		.16	0,F0BASE
		.16	1,F1BASE
		.16	2,F2BASE
		.16	3,F3BASE
		.16	4,F4BASE
		.16	2**7

		_Header 0,NOBASE
		_Header 1,NOBASE+1
		_Header 2,NOBASE+2
		_Header 3,NOBASE+3
		_Header 4,16'64		; $FLO_0 -> A: (\\.\A:)

		.IF	(LastDriv+1).NE.MAXPIL
		.ERROR	"Nombre max de pilotes (MAXPIL) faux !!!"
		.ENDIF


; --------------------------------------------------------
;		ROUTINES BAS NIVEAU DU DRIVER
; --------------------------------------------------------

; On peut modifier D0/D1 et A0/A1 comme registres. D7.16 rend l'erreur

;----------\\
;  FnRESET  >
;==========/

; in	A2.32	^paramtres
; out	D7.16	erreur
; mod	D0..D1|D7|A0..A1

FnRESET:	PUSHM.32 D2..D6|A2..A5
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  RESET<CR>"
	.ENDIF
		MOVE.32	#LGVAR,D4
		MOVE.32	#MTYPBD,D1
		MOVE.32	A0,A1
		GESMEM	?GETMEM			; alloue mem pour les vars locales
		JUMP,NE	ERROR$
		GESMEM	?CLEARMEM

		MOVE.32	A4,A6

RETRY$:		MOVE.32	#A8^1,D4
		MOVE.32	#R16^BARNAME,A3
		NTREL	?CREBAR
		JUMP,EQ	OKBAR$
		MOVE.32	#A8^10,D4
		NTREL	?DELMS
		JUMP	R8^RETRY$
OKBAR$:
		MOVE.32	A5,{A6}+OCOMMBAR

		MOVE.16	{A1},{A6}+ONO		; copie le no logique

		MOVE.32	#{A6}+ONOM,A0
		MOVE.16	#LGFILE-2,D0
COPY$:		MOVE.8	{A2+},{A0+}		;on copie le nom du fichier
		SKIP,EQ DJ.16,NMO D0,COPY$
		CLR.8	{A0}

		CLR.16	{A6}+OCOMPT		; 0 fois ouvert

		MOVE.32	#A8^1,D4
		NTREL	?CRESEM			;cree excl sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+OEXCLSEM

		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree reply sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+OREPLYSEM

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.8	#PRI_FILE,{A4}+RQ_PRI
		MOVE.32	#R16^PORT_TABLE,A0
		MOVE.16	{A6}+ONO,D0
		MOVE.16	{A0}+A16^{D0}*2,{A4}+RQ_PORTNO
		MOVE.32	{A6}+OREPLYSEM,{A4}+RQ_REPLYSEM

		MOVE.32	#{A6}+ONOM,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#LGFILE,{A4}+RQ_SDATALEN
		MOVE.32 #{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	{A6}+OCOMMBAR,A5
		NTREL	?OFFERBAR		;on envoi le nom du fichier
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV			;on attend la rponse

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7
		JUMP,NE	ERROR$

		COMP.16	#FLONO,{A6}+ONO		; Pilote floppy ?
		JUMP,CS	NOFLO$
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE: FLO RESET<CR>"
	.ENDIF

		MOVE.32	#1440*1024/4,D2		; D2 <-- taille totale en blocs FOS
		MOVE.32	#512,D3			; D3 <-- taille physique d'un bloc
		MOVE.32	#18,D4			; D4 <-- blocs/piste
		MOVE.32	#16'10,D5		; D5 <-- offset FOS
		MOVE.32	#0,D6			; D6 <-- mode d'ouverture
		MOVE.32	#R16^READ,A3
		MOVE.32	#R16^WRITE,A4
		MOVE.32	A6,A5
		MOVE.32	_INDNTR,A0
		CALL	{A0}+OIN_OPENBLKFOS

		MOVE.32	A5,{A6}+OlocBLKFOS

NOFLO$:

		CLR.16	D7

ERROR$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: RESET = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF
		POPM.32	D2..D6|A2..A5
		TEST.16	D7
		RET

BARNAME:	.ASCIZE "#:PCCOMMBAR"

PORT_TABLE:	.16	PORT_PCFILE0
		.16	PORT_PCFILE1
		.16	PORT_PCFILE2
		.16	PORT_PCFILE3
		.16	PORT_PCFILE4

;-------\\
;  KILL  >
;=======/

; D-installe le driver.

; in	-
; out	D7.16
; mod	...

FnKILL:		PUSHM.32 D0..D6|A0..A5
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  KILL<CR>"
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	NOLOCK$

		COMP.16	#FLONO,{A6}+ONO		; Pilote floppy ?
		JUMP,CS	NOFLO$

		MOVE.32	{A6}+OlocBLKFOS,A5	; canal
		MOVE.32	_INDNTR,A0
		CALL	{A0}+OIN_CLOSEBLKFOS
NOFLO$:

		MOVE.32	{A6}+OCOMMBAR,A5

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.32	#{A6}+OSENDDATA,A0
		MOVE.16	#CMD_KILL,D3
		SWAP.16	D3
		MOVE.16	D3,{A0}
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		CALL	R16^ENDLOCK
	
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?KILLSEM

		MOVE.32	{A6}+OEXCLSEM,A5
		NTREL	?KILLSEM

		MOVE.32	A6,A4
		MOVE.32	#R16^F0BASE,A1
		MOVE.32	#MTYPBD,D1
		GESMEM	?GIVMEM

		CLR.16	D7			;no error
NOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: KILL = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF


		POPM.32 D0..D6|A0..A5
		TEST.16	D7
		RET

; clear du cache FOS pour les floppys

CLEARBLKFOS:	PUSHM.32 D0|D1|A0|A1|A5

		MOVE.32	{A6}+OlocBLKFOS,A5		; canal
		MOVE.32	_INDNTR,A0
		CALL	{A0}+OIN_CLEARBLKFOS

		POPM.32	D0|D1|A0|A1|A5
		RET

;--------\\
;  WRITE  >
;========/

; Ecrit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...
WRITE:		PUSHM.32 D0..D6|A0..A6
		MOVE.32	A5,A6
		ADD.32	D4,D4
		ADD.32	D5,D5
		CALL	DOWRITE
		POPM.32 D0..D6|A0..A6
		TEST.16	D7
		RET

FnWRITE:	PUSHM.32 D0..D6|A0..A6

	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  WRITE<CR>"
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	WNOLOCK$

		COMP.16	#FLONO,{A6}+ONO		; Pilote floppy ?
		JUMP,CS	NOFLO$

		MOVE.32	{A6}+OlocBLKFOS,A5
		MOVE.32	_INDNTR,A0
		CALL	{A0}+OIN_WRITEBLKFOS
		JUMP	DELOCK$

NOFLO$:		ADD.32	#16'10,D4		; offset (on a 16 blocs de dmarrage, etc..)
		CALL	DOWRITE
DELOCK$:	CALL	R16^ENDLOCK

WNOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: WRITE = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

WEXIT$:		POPM.32 D0..D6|A0..A6
		TEST.16	D7
		RET



DOWRITE:	SL.32	#8,D4
		SL.32	#8,D5

		TEST.32	D5			; qqc  crire
		JUMP,EQ	WERR$

		MOVE.32	A4,A3

		MOVE.32	D5,D2
		
		MOVE.32	#{A6}+OCOMMREQ,A4

		MOVE.32	#{A6}+OSENDDATA,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.16	#CMD_WRITE,D3
		SWAP.16	D3
		MOVE.16	D3,{A0+}
		CLR.16	{A0+}
		SWAP.16	D4
		SWAP.32	D4
		SWAP.16	D4
		MOVE.32	D4,{A0+}
		SWAP.16	D2
		SWAP.32	D2
		SWAP.16	D2
		MOVE.32	D2,{A0+}
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	{A6}+OCOMMBAR,A5
		NTREL	?OFFERBAR		;on envoi la pos et la longueur
		NTREL	?ENDOFFERBAR
		
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7	; criture possible ?
		JUMP,NE	R16^WERR$

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.32	A3,{A4}+RQ_SDATAPTR
		MOVE.32	D5,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	{A6}+OCOMMBAR,A5
		NTREL	?OFFERBAR		;on envoi les bloc
		NTREL	?ENDOFFERBAR
		
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7	; code d'erreur

WERR$:
		RET




;-------\\
;  READ  >
;=======/

; Lit un certain nombre de blocs

; in	D4.32	premier bloc
;	D5.32	nombre de blocs
;	A4.32	^buffer
; out	D7.16
; mod	...

READ:		PUSHM.32 D0..D6|A0..A6
		MOVE.32	A5,A6
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE: FOS BLKREAD<CR>"
	.ENDIF
		ADD.32	D4,D4
		ADD.32	D5,D5
		CALL	DOREAD

		POPM.32 D0..D6|A0..A6
		TEST.16	D7
		RET



FnREAD:		PUSHM.32 D0..D6|A0..A6

	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  READ<CR>"
		PUSH.32	D4
		MON	?AFX8
		MOVE.32	D5,D4
		MON	?AFX8
		MON	?AFCR
		POP.32	D4
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	RNOLOCK$

		COMP.16	#FLONO,{A6}+ONO		; Pilote floppy ?
		JUMP,CS	NOFLO$

	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE: FLO READ<CR>"
	.ENDIF

		MOVE.32	{A6}+OlocBLKFOS,A5
		MOVE.32	_INDNTR,A0
		CALL	{A0}+OIN_READBLKFOS
		JUMP	DELOCK$

NOFLO$:		ADD.32	#16'10,D4		; offset (on a 16 blocs de dmarrage, etc..)

		CALL	DOREAD

DELOCK$:	CALL	R16^ENDLOCK

RNOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: READ = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

REXIT$:		POPM.32 D0..D6|A0..A6
		TEST.16	D7
		RET



DOREAD:		SL.32	#8,D4
		SL.32	#8,D5

		TEST.32	D5			; qqc  lire
		JUMP,EQ	RERR$

		MOVE.32	A4,A2

		MOVE.32	{A6}+OCOMMBAR,A5
		MOVE.32	#{A6}+OCOMMREQ,A4

		MOVE.32	#{A6}+OSENDDATA,A3
		MOVE.32	A3,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.16	#CMD_READ,D3
		SWAP.16	D3
		MOVE.16	D3,{A3+}
		CLR.16	{A3+}
		MOVE.32	D5,D3
		SWAP.16	D5
		SWAP.32	D5
		SWAP.16	D5
		SWAP.16	D4
		SWAP.32	D4
		SWAP.16	D4
		MOVE.32	D4,{A3+}			; pos
		MOVE.32	D5,{A3+}			; size
		MOVE.32	#{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR		; envoi la commande
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7	; lecture ok ?
		JUMP,NE	RERR$

		MOVE.32	{A6}+OCOMMBAR,A5
		MOVE.32	#{A6}+OCOMMREQ,A4

		MOVE.32	#{A6}+OSENDDATA,A3
		MOVE.32	A3,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.16	#CMD_READ,D0
		SWAP.16	D0
		MOVE.16	D0,{A3+}
		CLR.16	{A3+}
		MOVE.32	D4,{A3+}			; pos
		MOVE.32	D5,{A3+}			; size
		MOVE.32	A2,{A4}+RQ_RDATAPTR
		MOVE.32	D3,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR		; recoit les donnes
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		CLR.16	D7
RERR$:
		RET






;----------\\
;  COMMAND  >
;==========/

; Commande au pilote $FILE :

; SIZ[taille.16] -> agrandit au nombre de blocs voulu (SIze)
; REL		 -> fait un release du fichier utilis (faire ensuite RELEASE/ENTER -> rcup)

; in	A4.32	^commandes
; out	D7.16
; mod	...

FnCOMMAND:	PUSHM.32 D0..D6|A0..A5

	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE: COMMAND<CR>"
	.ENDIF

		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"S",D3
		JUMP,EQ	OKSIZ$				; SIZ[taille.16] ?
		COMP.8	#"R",D3
		JUMP,EQ	OKREC$				; REL => recup aura lieu sur le disque
		COMP.8	#"M",D3
		JUMP,EQ	OKMOD$
		COMP.8	#"F",D3				; F => formate "physiquement" le mdia
		JUMP,EQ	OKFORMAT$

ER$:		MOVE.16	#ERILLO,D7			; commande incorrecte
		JUMP	ERR$

OKFORMAT$:	CLR.16	D7			;no error
		JUMP	ERR$

OKMOD$:		COMP.8	#"a",{A4}+0
		JUMP,NE	R8^ISMOD$

		COMP.8	#"-",{A4}+1
		JUMP,NE	ER$

		MOVE.8	{A4}+2,D3
		MOVE.32	#50000*4,D4			; malle de 50 MB
		SUB.8	#"0",D3
		JUMP,EQ	BLOC$
		SL.32	D4				; malle de 100 MB
		DEC.8	D3
		JUMP,EQ	BLOC$
		ADD.32	#50000*4,D4			; malle de 150 MB
		DEC.8	D3
		JUMP,EQ	BLOC$
		ADD.32	#50000*4,D4			; malle de 200 MB
		DEC.8	D3
		JUMP,EQ	BLOC$

		JUMP	ER$

ISMOD$:		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"O",D3
		JUMP,NE	ER$

		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"D",D3
		JUMP,NE	ER$

		MOVE.8	{A4+},D3
		MOVE.32	#2880,D4

		SUB.8	#"0",D3
		JUMP,EQ	BLOC$

		SL.32	D4
		DEC.8	D3
		JUMP,EQ	BLOC$

		SL.32	D4
		DEC.8	D3
		JUMP,EQ	BLOC$

		MOVE.32	#3200*4,D4
		DEC.8	D3
		JUMP,EQ	BLOC$

		JUMP	ER$


OKREC$:		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"E",D3
		JUMP,NE	ER$

		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"L",D3
		JUMP,NE	ER$

;		FOS	?CLOSE
		CLR.16	D7
		JUMP	ERR$

OKSIZ$:		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"I",D3
		JUMP,NE	ER$

		MOVE.8	{A4+},D3
		CALL	MINMAJ
		COMP.8	#"Z",D3
		JUMP,NE	ER$

		CLR.32	D4
		MOVE.8	{A4+},D4
		SL.16	#8,D4
		MOVE.8	{A4+},D4

BLOC$:		SL.32	#8,D4				; pour atteindre nombre d'octets
		CLR.32	D3				; taille  atteindre
;		FOS	?SPOSPLUS			; agrandit si ncessaire
		CLR.16	D7
		JUMP,NE	R8^ERR$

;		FOS	?TRUNC				; tronque le reste

ERR$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: COMMAND = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

	CLR.16	D7

		POPM.32	D0..D6|A0..A5
		TEST.16	D7
		RET

MINMAJ:		COMP.8	#96,D3
		JUMP,LT	R8^OK$
		SUB.8	#32,D3				; transforme un "a" en un "A"
OK$:		RET



;----------\\
;  RSTATUS  >
;==========/

; Rend le status du driver

; in	D4.32	taille du buffer
;	A4.32	^buffer
; out	D7.16
; mod	...

FnRSTATUS:	PUSHM.32 D0..D6|A0..A5
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  STATUS<CR>"
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	NOLOCK$

		MOVE.32	D4,D0

		PUSH.32	A4

		MOVE.8	#MTFLO,{A4}+OMTYPE	; type mmoire de masse
	
		MOVE.32	{A6}+OCOMMBAR,A5

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.32	#{A6}+OSENDDATA,A3
		MOVE.16	#CMD_GETSIZE,D3
		SWAP.16	D3
		MOVE.16	D3,{A3}
		MOVE.32	A3,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A3
		MOVE.32	A3,{A4}+RQ_RDATAPTR
		MOVE.32	#4,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		POP.32	A4
		MOVE.32	{A6}+ORECVDATA,D4	; file size
		SWAP.16	D4
		SWAP.32	D4
		SWAP.16	D4

		SR.32	#8,D4
		SUB.32	#16'10,D4

		MOVE.32	D4,{A4}+OMNBLK		; nombre de blocs
		CLR.32	{A4}+OMRBLK		; bloc le plus rapide

		COMP.32	#LGMAM3,D0
		JUMP,LT	END$

		ADD.32	#16'10,D4
		MOVE.32	D4,{A4}+OMTBLK		; nombre total de blocs
		CLR.8	{A4}+OMTTYP		; pas un WINCH, pas de type de WINCH !
		MOVE.16	#4,{A4}+oMNBFmtRec	; 3 records pour le moment

		SUB.32	#LGMAM3,D0
		JUMP,LE	END$

		MOVE.32	#{A4}+LGMAM3,A4
		MOVE.32	D4,D3

		MOVE.32	D0,D4
		MOVE.32	#R16^TABLE0$,A3
;		MOVE.32	A4,A4
		GESMEM	?COPYMEM

		COMP.16	#2880,D3
		JUMP,EQ	R8^MOD0$
		COMP.16	#2880*2,D3
		JUMP,EQ	R8^MOD1$
		COMP.16	#2880*4,D3
		JUMP,EQ	R8^MOD2$
		COMP.16	#12800,D3
		JUMP,EQ	R8^MOD3$

		JUMP	END$

MOD0$:		MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*0+oMFmtFlag
		JUMP	END$

MOD1$:		MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*1+oMFmtFlag
		JUMP	END$

MOD2$:		MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*2+oMFmtFlag
		JUMP	END$

MOD3$:		MOVE.8	#2**BitMFmtDiskIn+2**BitMFmtCurMode,{A4}+LgMFmtRec*3+oMFmtFlag

END$:
		CALL	R16^ENDLOCK

NOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: STATUS = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

		POPM.32	D0..D6|A0..A5
		CLR.16	D7
		RET


TABLE0$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	720/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD0"
	.32	0
	.FILL.8	14,0

TABLE1$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	1440/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD1"
	.32	0
	.FILL.8	14,0

TABLE2$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	2880/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD2"
	.32	0
	.FILL.8	14,0

TABLE3$:
	.8	0
	.8	FmtPSOS				; format PSOS
	.16	2				; nb faces
	.16	2				; nb cylindres
	.16	3200/2				; nb sect./piste
	.16	256*2				; nb bytes/sect.
	.ASCII	"MOD3"
	.32	0
	.FILL.8	14,0



;-------\\
;  OPEN  >
;=======/

; On ouvre une unit !

FnOPEN:		PUSHM.32 D0..D6|A0..A5
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  OPEN<CR>"
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	NOLOCK$

		TEST.16	{A6}+OCOMPT
		JUMP,EQ	DOOPEN$

		INC.16	{A6}+OCOMPT
		CLR.16	D7
		JUMP	OK$

DOOPEN$:
		INC.16	{A6}+OCOMPT

		MOVE.32	{A6}+OCOMMBAR,A5

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.32	#{A6}+OSENDDATA,A0
		MOVE.16	#CMD_OPEN,D3
		SWAP.16	D3
		MOVE.16	D3,{A0}
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7
		JUMP,EQ	OK$
		DEC.16	{A6}+OCOMPT

OK$:		CALL	R16^ENDLOCK

NOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: OPEN = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

		POPM.32	D0..D6|A0..A5
		TEST.16	D7
		RET



;--------\\
;  CLOSE  >
;========/

; On referme l'unit (et le fichier .DI)

FnCLOSE:	PUSHM.32 D0..D6|A0..A5
	.IF	DEBUG
		MON	?AFTIM
		.ASCIZE	"PCFILE:  CLOSE<CR>"
	.ENDIF

		CALL	R16^STARTLOCK
		JUMP,NE	NOLOCK$

		COMP.16	#FLONO,{A6}+ONO		; Pilote floppy ?
		JUMP,CS	NOFLO$
		CALL	CLEARBLKFOS		
NOFLO$:
		DEC.16	{A6}+OCOMPT
		JUMP,EQ	R8^DOCLOSE$
		CLR.16	D7
		JUMP	R16^OK$

DOCLOSE$:	MOVE.32	{A6}+OCOMMBAR,A5

		MOVE.32	#{A6}+OCOMMREQ,A4
		MOVE.32	#{A6}+OSENDDATA,A3
		MOVE.16	#CMD_CLOSE,D3
		SWAP.16	D3
		MOVE.16	D3,{A3}
		MOVE.32	A3,{A4}+RQ_SDATAPTR
		MOVE.32	#12,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+ORECVDATA,A3
		MOVE.32	A3,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		NTREL	?OFFERBAR
		NTREL	?ENDOFFERBAR
		MOVE.32	{A6}+OREPLYSEM,A5
		NTREL	?WAITEV

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+ORECVDATA,D7

OK$:		CALL	R16^ENDLOCK
NOLOCK$:
	.IF	DEBUG
		PUSH.16	D7
		MON	?AFTIM
		.ASCIZE	"PCFILE: CLOSE = "
		MOVE.16	D7,D4
		MON	?AFX4
		MON	?AFCR
		POP.16	D7
	.ENDIF

		POPM.32	D0..D6|A0..A5
		TEST.16	D7
		RET



NMMOD0:	.ASCIZ	"MOD0"
	.ASCIZ	"Ma-0"
NMMOD1:	.ASCIZ	"MOD1"
	.ASCIZ	"Ma-1"
NMMOD2:	.ASCIZ	"MOD2"
	.ASCIZ	"Ma-2"
NMMOD3:	.ASCIZ	"MOD3"
	.ASCIZ	"Ma-3"

NMCMDF:	.ASCIZ	"F"
NMFILS:	.ASCIZ	"FFORMAT"
	.EVEN

;------------\\
;  STARTLOCK  >
;============/

; Dbut de l'exclusion sur un port.

; in	A3.32	^variables locales
; out	D7.16	error
; mod	D7.16

STARTLOCK:	PUSHM.32 D4|A5

		MOVE.32	{A6}+OEXCLSEM,A5
		NTREL	?LOCK

		POPM.32	D4|A5
		RET


;----------\\
;  ENDLOCK  >
;==========/

; Fin de l'exclusion.

; in	A6.32	^variables
; out
; mod

ENDLOCK:	PUSHM.32 D4|D7|A5

		MOVE.32	{A6}+OEXCLSEM,A5
		NTREL	?UNLOCK

		POPM.32	D4|D7|A5
		RET


	.END

