
; Pilote clavier pour carte SM400
; Alain Malek 12/96

	.TITLE	KEY.ASD
	.PROC	M68020
	.BASE	10'10
	.LAYOUT	HEX

DEBUG		= 0		; option de compilation

MajRevKey	= 2
MinRevKey	= 0

; Date	    Rev. Quid	Quoi
; ----------------------------------------------------------------------------
; 15/04/98  2.0   PA	Evite d'accumuler les touches en rptition auto.
; ----------------------------------------------------------------------------


	.REV	MajRevKey,MinRevKey
	.IDENT	"Pilote clavier pour carte PCI Smaky400"

;	.REF	SHIDRIV130
	.REF	SMAKY
	.REF	BIOS
	.REF	MON
	.REF	BIOSDRIV
	.REF	COMMREQ

BASNUM		= 0		; numros claviers = 0..n

NBKEY		= 20		;nb max de clavier
PORTNO		= PORT_KEY0	;port de comunication
CMD_PORTNO	= PORT_KEY1	;port de commandes

BAL_SIZE	= 48		;taille des fifos propres  chaque clavier

DREP1		= 10'40		; premier dlai si repeat
DREP2		= 10'2		; deuxime dlai si repeat

MAXLST		= 10'48		; lg max d'une liste de touches


CMD_REP		= 1		; cmd de changement des rptitions de touches CMD_PORTNO

CMD_READ	= 1		; msg sur PORTNO

;***************************************************************************
;------ Definition des variables globales ----------------------------------

		.LOC	0

OTAPKD:		.BLK.32	NBKEY		; table des ^descript claviers
OPTDKP:		.BLK.32	1		; ^desc clavier pseudo-p actuel
FILS:		.BLK.32	1		; processus fils
COMMBAR:	.BLK.32 1
REQUEST:	.BLK.8	RQ_LEN
REQ_SEND:	.BLK.16	1		; send CMD_READ
REQ_RECV:	.BLK.32	1		; key code received
REPLYSEM:	.BLK.32	1
GVARSEM:	.BLK.32	1
REP1:		.BLK.16	1		;repeat1 courant
REP2:		.BLK.16	1		;repeat2 courant
ACTIVKB:	.BLK.16	1		;no du clavier actuel (-1 = aucun)
NB_KOPEN:	.BLK.16	1		;nombre de claviers ouverts

CMDSEM:		.BLK.32	1		;exclusion sur les commandes
CMD_SEND:	.BLK.8	4		;commande envoye
CMD_RECV:	.BLK.16	1		;rponse de commande
CMD_REPLYSEM:	.BLK.32	1
CMD_REQ:	.BLK.8	RQ_LEN

OGKYIP:		.BLK.8	MAXLST		; liste globale touches inter-p

OKACTIF:	.BLK.32	1		; ^descr. du seul clavier actif
OACTIF:		.BLK.8	1		; Code/flag clavier (non-)actif


LGVAR:

;------ Definition des variables locales a chaque driver -------------------

		.LOC	0

KB_BAL:		.BLK.32	1
KB_LAST:	.BLK.32	1		; dernire touche envoye
NBKEY_BAL:	.BLK.16	1		; nombre de touches dans le fifo
WSK_SEM:	.BLK.32	1		; signal touche spciale
OWKEY:		.BLK.32	1		; touche spciale appuye
KREP1:		.BLK.16	1
KREP2:		.BLK.16	1
KNUM:		.BLK.16	1
OLKYIP:		.BLK.8	MAXLST		; liste touches inter-prog.
OLKYDP:		.BLK.8	MAXLST		; liste touches dans prog.

LGVARLOC:

;***************************************************************************
; Macro pour gnrer un header de driver @DM 22/7/94

   .MACRO _Header ; log num, phys num
   .LOCALMACRO Start,Name
Start:
	.16	KOPEN-K%1BASE
	.16	KCOMMAND-K%1BASE
	.16	KRSTATUS-K%1BASE
	.16	KREAD-K%1BASE
	.16	-1		; KWRITE
	.16	KCLOSE-K%1BASE
	.16	-1		; STOPTR
	.16	-1		; STARTR
	.16	-1		; AVORTTR
	.16	KAUX1-K%1BASE
	.16	-1		; KAUX2
      .IF %1.EQ.0
	.16	K0RESET-K%1BASE
	.16	K0KILL-K%1BASE
      .ELSE
	.16	KRESET-K%1BASE
	.16	KKILL-K%1BASE
      .ENDIF
	.16	-1		; KSTRT
	.16	-1		; KTSTRT
	.16	-1		; KSTART

Name:	.ASCII	"KEY_%1"	; Nom driver
	.FILL.8 LGDNAM-(APC-Name), 0

	.8	%2		; Numro driver
	.8	TYPKEY		; Type de priphrique

	.8	MajRevKey,MinRevKey	; Rvision - version
	.8	-1,0		; Priorit ds driver

	.8	0		; Attribut 1
      .IF %1.EQ.0
	.8	0		; Attribut 0
      .ELSE
	.8	2**BDRDOK.OR.2**BDAPRG; Attribut 0
      .ENDIF

	.FILL.8 	LGDDESC-(APC-Start), 0 ; Le reste.
K%1BASE:
; @DM 22/7/94
	.16	%1		; Numro logique (drivers plus conscutifs)
LASTDRIV == %1
   .ENDMACRO

;***************************************************************************
; Entte gnrale du fichier driver.
; ----------------------------------

	.LOC	0

	.16	10'0,K0BASE
	.16	10'1,K1BASE
	.16	10'2,K2BASE
	.16	10'3,K3BASE
	.16	10'4,K4BASE
	.16	10'5,K5BASE
	.16	10'6,K6BASE
	.16	10'7,K7BASE
	.16	10'8,K8BASE
	.16	10'9,K9BASE
	.16	10'10,K10BASE
	.16	10'11,K11BASE
	.16	10'12,K12BASE		; nouveau...
	.16	10'13,K13BASE
	.16	10'14,K14BASE
	.16	10'15,K15BASE		; ...nouveau
; @DM 22/7/94
	.16	10'16,K16BASE		; tout ...
	.16	10'17,K17BASE
	.16	10'18,K18BASE
	.16	10'19,K19BASE		; ... nouveau !
; @DM 22/7/94
	.16	2**7


;***************************************************************************
; Entte des diffrents drivers:
; ------------------------------
	_Header	0, BASNUM+16'00
	_Header	1, BASNUM+16'01
	_Header	2, BASNUM+16'02
	_Header	3, BASNUM+16'03
	_Header	4, BASNUM+16'04
	_Header	5, BASNUM+16'05
	_Header	6, BASNUM+16'06
	_Header	7, BASNUM+16'07
	_Header	8, BASNUM+16'08
	_Header	9, BASNUM+16'09
	_Header	10, BASNUM+16'0A
	_Header	11, BASNUM+16'0B
	_Header	12, BASNUM+16'0C
	_Header	13, BASNUM+16'0D
	_Header	14, BASNUM+16'0E
	_Header	15, BASNUM+16'0F
; Nouveaux pour pilote DISPLAY 8.0 (systme 10), @DM 22/7/94
	_Header	16, 16'18
	_Header 17, 16'19
	_Header 18, 16'1a
	_Header 19, 16'1b
; @DM : la tranche 16'18  16'1f est pour le clavier ...

.IF	LASTDRIV+1.NE.NBKEY
.ERROR	"nombre de drivers (NBKEY) faux !!!"
.ENDIF

;***************************************************************************

;----------\\
;  K0RESET  >
;==========/

; in	A0.L	^adresse de base du descipteur de $KEY_0
; out	D7.W	Si erreur:
;			Celles de ?GETMEM
;	A6	^variables
; mod	D0..A1, D7.W

K0RESET:	PUSHM.32 D2..D6|A0..A5

		MOVE.32	#LGVAR,D4
		MOVE.32	#MTYPBD,D1
		MOVE.32	A0,A1
		GESMEM	?GETMEM			;Alloue les variables globales
		JUMP,NE	ERR$

		MOVE.32	A4,A6
		GESMEM	?CLEARMEM

		MOVE.16	#-1,{A6}+ACTIVKB	;aucun clavier actif

RETRY$:		MOVE.32	#A8^1,D4
		MOVE.32	#R16^BARNAME,A3
		NTREL	?CREBAR			;ouvre la bar de communication
		JUMP,EQ	R8^OKBAR$
		MOVE.16	#4,D4
		NTREL	?DELMS			; on attend que pccomm dmarre
		JUMP	R8^RETRY$
OKBAR$:		MOVE.32	A5,{A6}+COMMBAR

		MOVE.32	#1,D4			; sm. d'exclusion
		NTREL	?CRESEM			; pour les var. globales
		JUMP,NE	ERR$
		MOVE.32	A5,{A6}+GVARSEM		; mmorise l'identificateur

		MOVE.32	#1,D4			; sm. d'exclusion
		NTREL	?CRESEM			; pour les commandes
		JUMP,NE	ERR$
		MOVE.32	A5,{A6}+CMDSEM		; mmorise l'identificateur


		MOVE.32	#0,D4			; sm. de synchro
		NTREL	?CRESEM			; pour rponse de commande
		JUMP,NE	ERR$
		MOVE.32	A5,{A6}+CMD_REPLYSEM	; mmorise l'identificateur

		MOVE.32	#{A6}+CMD_REQ,A4
		MOVE.8	#PRI_KEY,{A4}+RQ_PRI
		MOVE.16	#CMD_PORTNO,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM


		MOVE.32	#0,D4			; sm. de synchro
		NTREL	?CRESEM			; pour rponse de lecture
		JUMP,NE	ERR$
		MOVE.32	A5,{A6}+REPLYSEM	; mmorise l'identificateur

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.8	#PRI_KEY,{A4}+RQ_PRI
		MOVE.16	#PORTNO,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM


		MOVE.32	#1024,D5
		MOVE.32	#R16^PROC_FILS,A5
		MOVE.32	#R16^PROC_NAME,A3
		MOVE.32	#A8^5,D4
		NTREL	?CRETASK
		JUMP,NE	ERR$
		MOVE.32	A4,{A6}+FILS

		MOVE.32	#A8^0,D7
ERR$:
		POPM.32	D2..D6|A0..A5
		TEST.16	D7
		JUMP,EQ	KRESET
		RET

BARNAME:	.ASCIZE "#:PCCOMMBAR"
PROC_NAME:	.ASCIZE "PCKey Child"

;***************************************************************************
;----------\\
;  KRESET   >
;==========/

; in	A0.L	^descripteur du driver
; out	D7.W	si erreur
;	A6	^variables
; mod	D0..A1, D7.W

KRESET:		PUSHM.32 D2..D6|A0..A5

		MOVE.32	#LGVARLOC,D4		; rserve le descripteur du
		MOVE.32	#MTYPBD,D1		; clavier pseudo-physique
		MOVE.32	A0,A1			; sur le compte du driver
		GESMEM	?GETMEM			; A1 ^descripteur de driver
		JUMP,NE	ERR$			; erreur => ERR$
						; A4 ^descripteur de clavier
		MOVE.32	A4,A0			; initialise les variables  0
L10$:
		CLR.8	{A0+}
		DEC.32	D4
		JUMP,NE	L10$

		MOVE.32	#R16^K0BASE,A0
		COMP.32	A1,A0
		JUMP,EQ	NOGETVAR$		; sauf si juste aprs K0RESET
		MOVE.32	_INDNTR,A6
		CALL	{A6}+OIN_GETDRIVVAR	; A6 <-- ^var du driver $KEY_0
NOGETVAR$:
		MOVE.32	A1,A0
		CALL	MEMKPT
		MOVE.16	#DREP1,{A4}+KREP1
		MOVE.16	#DREP2,{A4}+KREP2

		MOVE.16	{A1},{A4}+KNUM		; mm no de clavier logique
	
		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree wsk sem.
		JUMP,NE	R16^ERR2$
		MOVE.32	A5,{A4}+WSK_SEM

		MOVE.16	#BAL_SIZE,D4
		NTREL	?CREBAL			; cre la BAL (Fifo)
		JUMP,NE	ERR3$
		MOVE.32	A5,{A4}+KB_BAL

		JUMP	EXIT$

ERR3$:		PUSH.16	D7
		MOVE.32	{A4}+WSK_SEM,A5
		NTREL	?KILLSEM
		POP.16	D7

ERR2$:		PUSH.16	D7			; sauve l'erreur originelle
		MOVE.32	#MTYPBD,D1
		GESMEM	?GBAMEM			; rend toute la mmoire
		POP.16	D7			; reprend l'erreur originelle

ERR$:
EXIT$:
		POPM.32	D2..D6|A0..A5
						;TRAP	#0
		RET

;***************************************************************************
;----------\\
;  K0KILL   >
;==========/
; Destruction des drivers clavier (KILLDRIV KEY_0)

K0KILL:
		MOVE.16	#ERKLPR,D7	;clavier indestructible
		RET

;***************************************************************************
;----------\\
;  KKILL    >
;==========/

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KKILL:		PUSHM.32 D2..D6|A5
		MOVE.32	A0,A1			; A1 ^descripteur de driver
		CALL	GETKPT			; A4 <-- le ^au descripteur
		CALL	CLRKPT			; enlve le ^au descripteur

		MOVE.32	{A4}+WSK_SEM,A5
		NTREL	?KILLSEM
		MOVE.32	#MTYPBD,D1
		GESMEM	?GBAMEM			; rend toute la mm associe

		POPM.32	D2..D6|A5
		RET

;***************************************************************************

;---------\\
;  OPEN    >
;=========/

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KOPEN:		PUSHM.32 D2|A4..A5
		CALL	GETKPT			; A4 <-- le ^au descripteur
		TEST.16	{A6}+NB_KOPEN		; premier clavier ouvert ?
		JUMP,NE	NOTFIRST$

		MOVE.32	{A6}+GVARSEM,A5		; etablit l'exclusion des autre
		NTREL	?LOCK			; attend l'exclusivit d'accs
		JUMP,NE	ERR$

		COMP.16	#-1,{A6}+ACTIVKB
		JUMP,NE	NOTFIRST2$

		MOVE.16	{A4}+KNUM,{A6}+ACTIVKB
		MOVE.32	A4,{A6}+OPTDKP		; c'est le clavier actuel

		MOVE.16	{A4}+KREP1,{A6}+REP1
		MOVE.16	{A4}+KREP2,{A6}+REP2

		MOVE.32	{A6}+GVARSEM,A5
		NTREL	?UNLOCK

		MOVE.8	#CMD_REP,D0
		MOVE.16	{A6}+REP1,D1
		MOVE.16	{A6}+REP2,D2
		CALL	SEND_CMD		; envoi les nouveaux dlais au pc

		JUMP	R8^NOTFIRST$

NOTFIRST2$:	MOVE.32	{A6}+GVARSEM,A5
		NTREL	?UNLOCK

NOTFIRST$:	INC.16	{A6}+NB_KOPEN

;;	MOVE.16	{A4}+KNUM,{A6}+ACTIVKB
;;	MOVE.32	A4,{A6}+OPTDKP		; c'est le clavier actuel


ERR$:		POPM.32	D2|A4..A5
		MOVE.32	#A8^0,D7
		RET

;***************************************************************************

;---------\\
;  CLOSE   >
;=========/

; Effectue la fonction CLOSE dans le driver

; in	A0.L	^descripteur du driver
;	A6	^variables
; out	D7.W	si erreur
; mod	D0..A1, D7.W

KCLOSE:		DEC.16	{A6}+NB_KOPEN		; un clavier ouvert de moins.
		RET

;***************************************************************************

;--------\\
;  READ   >
;========/

; in	A4.L	^buffer texte
;	D5.L	len  lire (ici doit tre <=  3)
;	A6	^variables
; out	D5.L	len effectivement lue
;	D7.W	erreur
; mod	D0..A1, D7.W, D5.L

KREAD:		PUSHM.32 D2..D6|A2..A5

		MOVE.32	#A8^0,D7
		TEST.8	D5			; lecture de zro byte ?
		JUMP,EQ	EXIT$

		COMP.32	#3,D5			; longueur correcte ?
		JUMP,HI	ERR$			; non => ERR$ (erreur)
		MOVE.32	A4,A1			; sauve le ^buffer

		CALL	GETKPT			; A4 <-- le ^au descripteur
		MOVE.32	A4,A3

		MOVE.32	{A4}+KB_BAL,A5
		MOVE.32	#A8^0,D3
		NTREL	?GETMS
		JUMP,NE	EXIT$			; timeout ?

		MOVE.32	A4,D0			; copie la touche dans D0

		MOVE.32	A3,A4
		DEC.16	{A4}+NBKEY_BAL		; une touche de moins dans le fifo

		MOVE.8	D0,{A1+}		; copie code
		DEC.16	D5
		JUMP,EQ	EXIT$
		RR.32	#8,D0
		MOVE.8	D0,{A1+}		; sshift
		DEC.16	D5
		JUMP,EQ	EXIT$
		RR.32	#8,D0
		MOVE.8	D0,{A1+}		; pseudo
		JUMP	EXIT$

ERR$:		MOVE.16	#ERIRDL,D7		; erreur 'longueur de READ ill'

EXIT$:		POPM.32	D2..D6|A2..A5
		RET

;***************************************************************************

;----------\\
;  WFSKEY   >	( Wait For Special Key )
;==========/

; in	A6	^variables
; out	D3.L	-pseudo-fonc-code press
;	D7.W	erreur
; mod	D0..A1, D3.L, D7.W, D5.L

KAUX1:		PUSHM.32 D4|A4|A5

		CALL	GETKPT			; A4 <-- le ^au descripteur

		MOVE.32	{A4}+WSK_SEM,A5
		NTREL	?WAITEV			; attend le signal
		JUMP,NE	TO$

		MOVE.32	{A4}+OWKEY,D3		; D3 <-- touche presse
TO$:
		POPM.32	D4|A4|A5
		RET

;***************************************************************************

;-----------\\
;  KRSTATUS  >
;===========/

; in	A4.L	^buffer
;	D4.L	longueur buffer
;	A6	^variables
; out	D4.L	longueur rendue effectivement
;	D7.W	erreur
; mod	D0..A1, D4.L, D7.W

KRSTATUS:	PUSHM.32 A2|A4
		MOVE.32	A4,A2			; A2 ^buffer
		CALL	GETKPT			; A4 ^descripteur de clavier

		COMP.32	#4,D4			; longueur de 4 pour la souris
		JUMP,NE	NOT4$

		MOVE.32	#{A4}+NBKEY_BAL,A0
		MOVE.32	A0,{A2}			; retourne ^nb de touches dans le fifo
		MOVE.32	#A8^0,D7
		JUMP	EXIT$

NOT4$:		MOVE.32	#R16^L00$,A0
		CALL	32^_CNVLGS			; D1 <-- profondeur d'investig.
		JUMP,NE	EXIT$

		MOVE.32	{A6}+OPTDKP,A1			; A1 <-- ^descr. clavier actuel
		MOVE.8	{A1}+KNUM+1,{A2}+OKYASS		; OKYASS: no du clavier assign act.
		CLR.8	{A2}+OKYLAM			; lampes allumes

		DEC.16	D1
		JUMP,EQ	OK$

		MOVE.8	{A4}+KREP1+1,{A2}+OKYRP1	; 1 er dlai de repeat
		MOVE.8	{A4}+KREP2+1,{A2}+OKYRP2	; 2 me dlai
		CLR.32	{A2}+OKYPRP			; paramtre abandonn

		MOVE.16	#BAL_SIZE,{A2}+OKYLGF		; longueur maximum du FIFO
		MOVE.16	{A4}+NBKEY_BAL,{A2}+OKYUSF	; nombre de caractres dans FIFO

		MOVE.32	#{A4}+OLKYIP,A0
		MOVE.32	A0,{A2}+OKYLIP			; ^liste touches inter-prog.

		MOVE.32	#{A4}+OLKYDP,A0
		MOVE.32	A0,{A2}+OKYLDP			; ^liste touches dans prog.

OK$:		CLR.16	D7				; D7 <-- ok

EXIT$:		POPM.32	A2|A4
		RET

; Table pour CNVLGS:

L00$:
	.16	LGKEY0			; profondeurs d'investigation
	.16	LGKEY1			; pour le RDSTATUS
	.16	0

;***************************************************************************

;------------\\
;  KCOMMAND   >
;============/

; in	A4.L	^table des commandes termine par zro
;	A6	^variables
; out	D7.W	erreur
;	A4.L	^commande innexistante, si erreur ERILLO
; mod	D0..A1, D7.W

KCOMMAND:	PUSHM.32 D2|D5|A2
		PUSH.32	A4
		MOVE.32	A4,A2			; A2 ^liste d'ordres
		CALL	GETKPT			; A4 ^descripteur de clavier
		MOVE.32	#A8^0,D7
LOOP$:
		CLR.16	D5
		MOVE.8	{A2+},D5		; lit une commande
		JUMP,EQ	FINLIST$		; fin de liste ?

		COMP.8	#MAXCMD,D5		; commande erronne ?
		JUMP,LS	OKCMD$			; non

		MOVE.16	#ERILLO,D7		; Prpare l'erreur, et
ERR$:						; Retour avec A2-->A4  l'endroit
		ADD.32	#4,SP			; skip POP.32 A4
		DEC.32	A2			; met A2 ^Paramtre faux
		MOVE.32	A2,A4			; rend le ^ds A4.
		JUMP	EXIT$			; retour avec erreur (sans A4)

OKCMD$:
		SL.16	#1,D5			; D5 * 2 --> .16
		MOVE.16	R8^ADRCOM+A16^{D5},D2	; D2 <-- adr rel rout
		MOVE.32	#R16^ADRCOM,A0		; A0 <-- adr abs dpart code
		CALL	{A0}+A16^{D2}		; appelle la routine d'exec
		TEST.16	D7			; de commande: params, cf fin
		JUMP,NE	ERR$			; erreur => ERR$
		JUMP	LOOP$			; regarde la commande suivante

FINLIST$:
		POP.32	A4
EXIT$:
		POPM.32	D2|D5|A2
		RET


		.INS 	PCKEYCOMM.ASI
		.INS	PCKEYFILS.ASI

;***************************************************************************


;==============================================================
;	SOUS-ROUTINES UTILITAIRES.
;==============================================================

;Envoi une commande sur le port de commande

;in	D0.8	CMD_NO
;	D1.8	para1
;	D2.8	para2
;	D3.8	para3
;out	D7.16	rsultat de la commande
;mod	D7

SEND_CMD:	PUSHM.32 D0..D4|A0|A4|A5

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM
		MOVE.32	{A6}+CMDSEM,A5
		NTREL	?LOCK

		MOVE.32	#{A6}+CMD_REQ,A4
		MOVE.32	#{A6}+CMD_SEND,A0
		MOVE.8	D0,{A0}			;Cmd no
		MOVE.8	D1,{A0}+1		;para 1
		MOVE.8	D2,{A0}+2		;para 2
		MOVE.8	D3,{A0}+3		;para 3
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.32	#4,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+CMD_RECV,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR	;envoi la requte au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+CMD_REPLYSEM,A5
		NTREL	?WAITEV		;attend la rponse du PC

		MOVE.16	{A6}+CMD_RECV,D7
		SWAP.16	D7

		MOVE.32	{A6}+CMDSEM,A5
		NTREL	?UNLOCK

		POP.16	D4
		NTREL	?SETTIM

		POPM.32	D0..D4|A0|A4|A5
		RET


;------------\\
;  GETKPT     >
;============/

; Rend le pointeur au ^descripteur d'un clavier pseudo-physique

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
; out	A4.L	^ l'identificateur du smaphore
; mod	A4.L, F

GETKPT:
	PUSH.16	D0			; Sauve D0
	CALL	CALCOFS			; Calcule l'offset
	MOVE.32	{A6}+A16^{D0}+OTAPKD,A4	; A4 <-- identificateur
	POP.16	D0			; Restitue D0
	RET

;------------\\
;  MEMKPT     >
;============/

; Mmorise le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
;	A4.L	^ l'identificateur du smaphore
; out	-
; mod	F

MEMKPT:
	PUSH.16	D0			; Sauve D0
	CALL	CALCOFS			; Calcule l'offset
	MOVE.32	A4,{A6}+A16^{D0}+OTAPKD	; Mmorise l'indentificateur
	POP.16	D0			; Restitue D0
	RET

;------------\\
;  CLRKPT     >
;============/

; Annule le pointeur au ^descripteur d'un clavier
; pseudo-physique.

; in	A6.L	^variables globales du programme
;	A0.L	^descripteur du driver
; out	-
; mod	F

CLRKPT:
	PUSH.32	A4
	MOVE.32	#0,A4
	CALL	MEMKPT
	POP.32	A4
	RET

;----------\\
; CALCOFS   >
;==========/

; Sous-routine utilitaire

; in	A0.L	^descripteur du driver
; out	#(A6)+(D0.W)+OTAPKD ^au ^descript du clavier
; mod	D0.W,F

CALCOFS:
.if true ; @DM 22/7/94
	MOVE.16	{A0},D0			; le no logique est aprs le header
.else ; @DM 22/7/94
	CLR.16	D0
	MOVE.8	{A0}+ODHNUM,D0		; D0.W <-- Numro du driver
	SUB.8	#BASNUM,D0		; D0.W <-- Position ds table
.endif
	SL.16	#2,D0			; *4 (.L) ==> offset
	RET


	.END

