

; Source du pilote souris pour carte Smaky SM400
; -----------------------------------------------

; Alain Malek Juin 1996
; -------------------------------------------------------------------------------
; 15/12/96  AM	0.1	Problme de WRITE fixe
; 24/09/99  PA	1.0	Ajout support drag & drop sous forme de commande 16'DD.
; -------------------------------------------------------------------------------

	.TITLE	MOUSE.ASD
	.BASE	10'10
	.LAYOUT	HEX
	.REF	MON

	.REF	COMMREQ

PORTNO		= PORT_MOUSE1	; port de communication
CMD_PORTNO	= PORT_MOUSE0	; port de commande (WRITE)

MajRev	= 1
MinRev	= 0

	.REV	MajRev, MinRev

	.PROC	M68020

.IDENT	"Pilote souris Smaky pour carte SM400"

	.REF	SMAKY
	.REF	BIOS
	.REF	BIOSDRIV

MOUDRAGDROP	= 16'DD

;***********************************************************************************

; Definition des variables
; ------------------------


	.LOC	0


		.BLK.8	LGMOU2		; table definie dans DRIVERS
;.... 	 Cf DRIVERS


COMMBAR:	.BLK.32 1
REQUEST:	.BLK.8	RQ_LEN
REPLYSEM:	.BLK.32 1
CMD_REQUEST:	.BLK.8	RQ_LEN
CMD_REPLYSEM:	.BLK.32 1
XPOS:		.BLK.16	1
YPOS:		.BLK.16	1
BUTTONS:	.BLK.16	1
READSEND:	.BLK.16	1		; pour envoyer CMD_READ
READ_SEM:	.BLK.32	1		; exclusion pour les READ
RECVBUFFER:	.BLK.8	6		; pour resultat de CMD_READ
CMDSEND:	.BLK.8	16		; pour envoyer des commandes
CMD_RESULT:	.BLK.16	1		; pour resultat de commande
CMD_SEM:	.BLK.32	1		; exclusion pour les commandes

READ_CMD	= 2
WRITE_CMD	= 3
DROP_CMD	= 4

LGVAR:

;***********************************************************************************

; Debut du code du driver
; -----------------------


	.LOC	0

	.16	0,D0BASE
	.16	2**7


; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $MOUSE_0		No H'10
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	-1			; D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"MOUSE_0"		; Nom driver
D0NAF:	.FILL.8 	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'10			; Numero driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Revision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK ;;!2**BDNORT	; Attribut 0

	.FILL.8 LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:

;***********************************************************************************

;--------
; RESET
;========

;in	-
;out	A6	^variables
;	D7.16	erreur

D0RESET:	PUSHM.32 D2|D3|D4|D5|A2|A3|A4|A5

		MOVE.32	#R16^D0BASE,A1
		MOVE.32	#MTYPBD,D1
		MOVE.32	#LGVAR,D4
		GESMEM	?GETMEM
		JUMP,NE	R16^ERROR$
		MOVE.32	A4,A6			;pour rendre ^var.
		GESMEM	?CLEARMEM


		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree reply sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+REPLYSEM

		MOVE.32	#{A6}+REQUEST,A4
		MOVE.8	#PRI_MOUSE,{A4}+RQ_PRI
		MOVE.16	#PORTNO,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM

		MOVE.32	#A8^1,D4
		NTREL	?CRESEM
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+READ_SEM

		MOVE.32	#A8^1,D4
		NTREL	?CRESEM
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+CMD_SEM

		MOVE.32	#A8^0,D4
		NTREL	?CRESEM			;cree cmd_reply sem.
		JUMP,NE	ERROR$
		MOVE.32	A5,{A6}+CMD_REPLYSEM

		MOVE.32	#{A6}+CMD_REQUEST,A4
		MOVE.8	#PRI_MOUSE,{A4}+RQ_PRI
		MOVE.16	#CMD_PORTNO,{A4}+RQ_PORTNO
		MOVE.32	A5,{A4}+RQ_REPLYSEM

		MOVE.32	#A8^1,D4
		MOVE.32	#R16^BARNAME,A3
		NTREL	?CREBAR
		JUMP,NE	R16^ERROR$
		MOVE.32	A5,{A6}+COMMBAR

		CLR.16	D7			;no error

		JUMP	R8^EXIT$

ERROR$:		MOVE.16	#1,D7

EXIT$:		POPM.32	D2|D3|D4|D5|A2|A3|A4|A5
		RET

BARNAME:	.ASCIZE "#:PCCOMMBAR"

;***********************************************************************************

;--------
; KILL
;========

;in	A6	^variables
;out	-
;mod	D0..D7

D0KILL:		PUSHM.32 A4|A5

		MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?KILLSEM

		MOVE.32	{A6}+CMD_REPLYSEM,A5
		NTREL	?KILLSEM

		MOVE.32	A6,A4
		MOVE.32	#R16^D0BASE,A1
		MOVE.32	#MTYPBD,D1
		GESMEM	?GIVMEM

		CLR.16	D7			;no error

		POPM.32	A4|A5

		RET

;***********************************************************************************

;--------
; OPEN
;========


D0OPEN:
		RET

;--------
; CLOSE
;========


D0CLOSE:
		RET

;***********************************************************************************

;--------
; COMMAND
;========

; in	A4.32	^table des commandes terminee par zero
;	A6.32	^variables
; out	D7.W	erreur
; mod	D0..A1, D7.16

D0COMMAND:
		PUSHM.32 A4

		MOVE.32	A6,A1			; A1 <-- ^variables

L10$:		TEST.8	{A4}			; fin de la table ?
		JUMP,EQ	R8^L50$
		CALL	WRONEC			; excute une commande
		TEST.16	D7			; commande ok ?
		JUMP,NE	R8^L90$			; non => 90$
		JUMP	L10$

L50$:		CLR.16	D7			; D7 <-- ok

L90$:		POPM.32	A4
		RET

;Execute une commande

WRONEC:		PUSHM.32 D0..D4|A5

		CLR.16	D7			; D7 <-- ok

		MOVE.8	{A4+},D0		; D0 <-- type de la commande
		COMP.8	#MOUPOS,D0
		JUMP,EQ	L20$			; Positionnement
		COMP.8	#MOUDRAGDROP,D0
		JUMP,EQ	L30$			; Drag & Drop (^buffer.32/op.16/taille.16)
		COMP.8	#MOUSCA,D0
		JUMP,EQ	L60$			; Changement d'chelle
		COMP.8	#MOUACC,D0
		JUMP,EQ	L70$			; Rglage de la bote  vitesses
		JUMP	L89$			; Retour avec erreur

L20$:			; Positionnement
			; --------------

		MOVE.16	{A4+},D1		; Y
		MOVE.16	{A4+},D0		; X

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	{A6}+CMD_SEM,A5
		NTREL	?LOCK

		PUSH.32	A4
		MOVE.32	#{A6}+CMD_REQUEST,A4

		MOVE.32	#{A6}+CMDSEND,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.16	#WRITE_CMD,D3
		SWAP.16	D3
		MOVE.16	D3,{A0+}
		SWAP.16	D0
		MOVE.16	D0,{A0+}
		SWAP.16	D1
		MOVE.16	D1,{A0+}

		MOVE.32	#16,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+CMD_RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR		; envoie la requte au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+CMD_REPLYSEM,A5
		NTREL	?WAITEV			; attend la rponse du PC

		POP.32	A4

		MOVE.32	{A6}+CMD_SEM,A5
		NTREL	?UNLOCK

		POP.16	D4
		NTREL	?SETTIM

		TEST.16	{A6}+RECVBUFFER
		JUMP,EQ	L89$

		CLR.16	D7
		JUMP	L90$


L30$:			; Drag & Drop
			; -----------

		MOVE.32	{A4+},D0		; ^ buffer
		MOVE.32	{A4+},D1		;   taille du buffer et opration

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		MOVE.32	{A6}+CMD_SEM,A5
		NTREL	?LOCK

		PUSH.32	A4
		MOVE.32	#{A6}+CMD_REQUEST,A4

		MOVE.32	#{A6}+CMDSEND,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.16	#DROP_CMD,D3
		SWAP.16	D3
		MOVE.16	D3,{A0+}
		MOVE.32	D0,{A0+}
		MOVE.32	D1,{A0+}

		MOVE.32	#16,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+CMD_RESULT,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#2,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR		; envoie la requte au PC
		NTREL	?ENDOFFERBAR

		MOVE.32	{A6}+CMD_REPLYSEM,A5
		NTREL	?WAITEV			; attend la rponse du PC

		POP.32	A4

		MOVE.32	{A6}+CMD_SEM,A5
		NTREL	?UNLOCK

		POP.16	D4
		NTREL	?SETTIM

		MOVE.16	{A6}+CMD_RESULT,D7
		JUMP	L90$


L60$:			; Changement d'chelle
			; --------------------
		MOVE.8	{A4+},D0		; D0 <-- l'chelle
		COMP.8	#2,D0			; Pas plus qu'chelle 1/3.
		JUMP,HI	L89$
		JUMP	L90$

L70$:			; Rglage de la bote  vitesses
			; ------------------------------
		CLR.16	D0
		MOVE.8	{A4+},D0		; D0 <-- limite 1re vitesse (5=moyen)
		CLR.16	D1
		MOVE.8	{A4+},D1		; D1 <-- limite 2me vitesse (5=moyen)

		COMP.16	#10,D0
		JUMP,HI	L89$			; Sur chelle de 10
		COMP.16	#10,D1
		JUMP,HI	L89$			; Valeur illgale => 89$: sortie avec erreur

		JUMP	L90$

L89$:
		MOVE.16	#ERIRLG,D7		; D7 <-- erreur
L90$:
		POPM.32	D0..D4|A5
		RET

;***********************************************************************************

;--------
; RSTATUS
;========

; in	A4.32	^buffer
;	D4.32	longeur buffer
;	A6.32	^variables
; out	D4.32	longeur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

D0RSTATUS:	MOVE.32	A6,A1

		CLR.8	{A4}+OMOSIM	;souris non simulee

		MOVE.32	#LGMOU1,D0
		COMP.32	#LGMOU2,D4	;a-t-on demande plus ?
		JUMP,LO	R8^SHORT$

		CLR.8	{A4}+OMOSCA	;rend l'echelle utilisee (1:1)
		MOVE.8	#5,{A4}+OMOVI2	;rend les 2 chg. de vitesse
		MOVE.8	#5,{A4}+OMOVI3
		MOVE.32	#LGMOU2,D0

SHORT$:		MOVE.32	D0,D4		;rend long. effective dans D4
		CLR.16	D7

		RET


;***********************************************************************************

;--------
; READ
;========

; in	A4.32	^buffer texte
;	D5.32	lg. lire
; out	D5.32	lg. effectivement lue
;	D7.16	erreur
; mod	D7.16, D5.32

D0READ:		PUSHM.32 D3|D4|A0|A4|A5

		COMP.32	#4,D5
		JUMP,LO	R16^ERROR$
		COMP.32	#6,D5
		JUMP,HI	R16^ERROR$

		MOVE.32	{A6}+READ_SEM,A5
		NTREL	?LOCK
		JUMP,EQ	R8^OKRS$

MON	?AFTIM
.ASCIZE	"Error on D0READ/LOCK<CR>"
TRAP	#1
JUMP	EXIT$

OKRS$:		TEST.16	{A6}+READSEND		; a-t-on deja envoye un read ?
		JUMP,NE	GOWAIT$			; oui => suite

		NTREL	?GETTIM
		PUSH.16	D4
		MOVE.16	#-1,D4
		NTREL	?SETTIM

		PUSH.32	A4
		MOVE.32	#{A6}+REQUEST,A4

		MOVE.32	#{A6}+READSEND,A0
		MOVE.32	A0,{A4}+RQ_SDATAPTR
		MOVE.16	#READ_CMD,D3
		SWAP.16	D3
		MOVE.16	D3,{A0}
		MOVE.32	#2,{A4}+RQ_SDATALEN
		MOVE.32	#{A6}+RECVBUFFER,A0
		MOVE.32	A0,{A4}+RQ_RDATAPTR
		MOVE.32	#6,{A4}+RQ_RDATALEN

		MOVE.32	{A6}+COMMBAR,A5
		NTREL	?OFFERBAR		; envoie la requte au PC
		NTREL	?ENDOFFERBAR

		POP.32	A4

		POP.16	D4
		NTREL	?SETTIM

GOWAIT$:	MOVE.32	{A6}+REPLYSEM,A5
		NTREL	?WAITEV			; attend la rponse du PC
		JUMP,EQ	GOTIT$			; timeout ?
		COMP.16	#ERTIMO,D7
		JUMP,EQ	R8^TIME$

TRAP	#1

TIME$:		MOVE.32	{A6}+READ_SEM,A5
		NTREL	?UNLOCK
		MOVE.16	#ERTIMO,D7
		JUMP	EXIT$

GOTIT$:		CLR.16	{A6}+READSEND

		MOVE.32	{A6}+READ_SEM,A5
		NTREL	?UNLOCK

		MOVE.32	#{A6}+RECVBUFFER,A0
		MOVE.16	{A0},D3
		RR.16	#8,D3
		MOVE.16	D3,{A4}		;x pos
		MOVE.16	{A0}+2,D3
		RR.16	#8,D3		;y pos
		MOVE.16	D3,{A4}+2

		COMP.8	#4,D5
		JUMP,EQ	R16^OK$

		MOVE.8	{A0}+4,{A4}+4	; boutons

		COMP.8	#5,D5
		JUMP,EQ	R16^OK$

		CLR.8	{A4}+5		;souris non simulee

OK$:		CLR.16	D7
		JUMP	R8^EXIT$


ERROR$:		MOVE.16	#ERIRDL,D7	;lg read illegal
EXIT$:		POPM.32	D3|D4|A0|A4|A5
		RET

;***********************************************************************************





