	.TITLE	USART.ASD

; Driver srie pour le Smaky 400.

	.BASE	10'10
	.LAYOUT HEX
	.REF	MON
	.PROC	M68020
	.REF	SMAKY
	.REF	BIOSDRIV
	.REF	BIOS
	.REF	COMMREQ

USART_NOP		= 0
USART_OPEN		= 1
USART_CLOSE		= 2
USART_WRITE		= 3
USART_READ		= 4
USART_COMMAND		= 5
USART_RDSTATUS		= 6

MajRev		= 2
MinRev		= 0

.REV	MajRev,MinRev

;***********************************************************************************

; Commande
; --------

		.LOC	0

OcmdOP:		.BLK.32	1		; opration  effectuer 
OcmdERROR:	.BLK.16	1		; code de l'erreur
OcmdTIMEOUT:	.BLK.16	1		; timeout
OcmdLENGTH:	.BLK.32	1		; longeur des donnes
OcmdDATA:	.BLK.32	1		; ^aux donnes
OcmdNODRIVER:	.BLK.16	1		; numro physique du driver ayant envoy la commande
OcmdRESERVE:	.BLK.16	1		; rserve pour aligner sur 32 bits
LGCMD:

; Structure spciale pour la lecture et l'criture de l'usart
		.LOC	0
ORWLength:	.BLK.32	1		; longueur  lire/crire
ORWData:	.BLK.32	1		; ^ aux donnes  lire/crire
ORWError:	.BLK.16	1		; erreur transmise par le PC
ORWComplete:	.BLK.16	1		; flags pour lecture/criture termine ou non
ORWOverlapped:	.BLK.32	1		; ^  une struture overlapped (seulement pour le PC)
ORWOneComPort:	.BLK.32	1		; ^  une structure oneComPort (seulement pour le PC)
LgReadWrite:

; Variables locales
; -----------------

		.LOC	0

OCOMMBAR:	.BLK.32 1
OREQUEST:	.BLK.8	RQ_LEN
OCMDOpen:	.BLK.8	LGCMD
OCMDClose:	.BLK.8	LGCMD
OCMDCommand:	.BLK.8	LGCMD
OCMDRStatus:	.BLK.8	LGCMD
OCMDWrite:	.BLK.8	LGCMD
OCMDRead:	.BLK.8	LGCMD
OSTRUCTREAD:	.BLK.8	LgReadWrite
OSTRUCTWRITE:	.BLK.8	LgReadWrite
OREPLYSEM:	.BLK.32 1
OGLOBVAR:	.BLK.32	1
ODRIVERID:	.BLK.32	1
LGlocVAR:

; Variables globales
; ------------------

		.LOC	0

OVARUSART0:	.BLK.8	LGlocVAR
OVARUSART1:	.BLK.8	LGlocVAR
OVARUSART2:	.BLK.8	LGlocVAR
OVARUSART3:	.BLK.8	LGlocVAR
LGVAR:

;***********************************************************************************

; Dbut du code du driver
; -----------------------

DEBUT:
	.LOC	0

	.16	0,D0BASE
	.16	1,D1BASE
	.16	2,D2BASE
	.16	3,D3BASE
	.16	2**7



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $USART_0		No H'80
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D0ID:
	.16	D0OPEN-D0BASE		; Adresse routines
	.16	D0COMMAND-D0BASE
	.16	D0RSTATUS-D0BASE
	.16	D0READ-D0BASE
	.16	-1			; D0WRITE-D0BASE
	.16	D0CLOSE-D0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D0AUX1-D0BASE
	.16	-1			; D0AUX2-D0BASE
	.16	D0RESET-D0BASE
	.16	D0KILL-D0BASE
	.16	-1			; D0STRT-D0BASE
	.16	-1			; D0TSTRT-D0BASE
	.16	-1			; D0START-D0BASE

D0NAB:	.ASCII	"USART_0"		; Nom driver
D0NAF:	.FILL.8	LGDNAM-(D0NAF-D0NAB), 0

	.8	16'80			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D0ID), 0	; Le reste.
D0BASE:

; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $USART_1		No H'81
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D1ID:
	.16	D1OPEN-D1BASE		; Adresse routines
	.16	D1COMMAND-D1BASE
	.16	D1RSTATUS-D1BASE
	.16	-1			; D1READ-D1BASE
	.16	D1WRITE-D1BASE
	.16	D1CLOSE-D1BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D1AUX1-D1BASE
	.16	-1			; D1AUX2-D1BASE
	.16	D1RESET-D1BASE
	.16	D1KILL-D1BASE
	.16	-1			; D1STRT-D1BASE
	.16	-1			; D1TSTRT-D1BASE
	.16	-1			; D1START-D1BASE

D1NAB:	.ASCII	"USART_1"		; Nom driver
D1NAF:	.FILL.8	LGDNAM-(D1NAF-D1NAB), 0

	.8	16'81			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D1ID), 0	; Le reste.
D1BASE:

; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $USART_2		No H'82
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D2ID:
	.16	D2OPEN-D2BASE		; Adresse routines
	.16	D2COMMAND-D2BASE
	.16	D2RSTATUS-D2BASE
	.16	D2READ-D2BASE
	.16	-1			; D2WRITE-D2BASE
	.16	D2CLOSE-D2BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D2AUX1-D2BASE
	.16	-1			; D2AUX2-D2BASE
	.16	D2RESET-D2BASE
	.16	D2KILL-D2BASE
	.16	-1			; D2STRT-D2BASE
	.16	-1			; D2TSTRT-D2BASE
	.16	-1			; D2START-D2BASE

D2NAB:	.ASCII	"USART_2"		; Nom driver
D2NAF:	.FILL.8	LGDNAM-(D2NAF-D2NAB), 0

	.8	16'82			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D2ID), 0	; Le reste.
D2BASE:

; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $USART_3		No H'83
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

D3ID:
	.16	D3OPEN-D3BASE		; Adresse routines
	.16	D3COMMAND-D3BASE
	.16	D3RSTATUS-D3BASE
	.16	-1			; D3READ-D3BASE
	.16	D3WRITE-D3BASE
	.16	D3CLOSE-D3BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; D3AUX1-D3BASE
	.16	-1			; D3AUX2-D3BASE
	.16	D3RESET-D3BASE
	.16	D3KILL-D3BASE
	.16	-1			; D3STRT-D3BASE
	.16	-1			; D3TSTRT-D3BASE
	.16	-1			; D3START-D3BASE

D3NAB:	.ASCII	"USART_3"		; Nom driver
D3NAF:	.FILL.8	LGDNAM-(D3NAF-D3NAB), 0

	.8	16'83			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	MajRev,MinRev		; rvision - version
	.16	0			; Variante

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDWROK.OR.2**BDNORT; Attribut 0

	.FILL.8	LGDDESC-(APC-D3ID), 0	; Le reste.
D3BASE:

;***********************************************************************************




; Points d'entres pour les routines de bases
; -------------------------------------------



;--------\\
; RESET   >
;========/

; in	-
; out	A6.32	^variables locales
; mod	D0..A1, D7.16

D0RESET:
	MOVE.32	#OVARUSART0,D0
	MOVE.32	#0,D1
	JUMP	DxRESET

D1RESET:
	MOVE.32	#OVARUSART1,D0
	MOVE.32	#1,D1
	JUMP	DxRESET

D2RESET:
	MOVE.32	#OVARUSART2,D0
	MOVE.32	#2,D1
	JUMP	DxRESET

D3RESET:
	MOVE.32	#OVARUSART3,D0
	MOVE.32	#3,D1
	JUMP	DxRESET



DxRESET:
	PUSHM.32 D0..D6|A0..A5

	MOVE.32	#LGVAR,D4
	MOVE.32	#R16^DEBUT,A4
	FOS	?GETComMem		; Demande la mmoire, rendue vent. par le FOS
	JUMP,NE	ERROR$

	MOVE.32	A4,A6			; ^variables globales

	MOVE.32	#A8^0,D4
	NTREL	?CRESEM			; cre reply sem.
	JUMP,NE	ERROR$

	MOVE.32	A5,{A6}+32^{D0}+OREPLYSEM

	MOVE.32	#{A6}+32^{D0}+OREQUEST,A4
	MOVE.8	#PRI_USART,{A4}+RQ_PRI
	MOVE.16	#PORT_USART0,{A4}+RQ_PORTNO
	ADD.16	D1,{A4}+RQ_PORTNO
	MOVE.32	A5,{A4}+RQ_REPLYSEM

	MOVE.32	#A8^1,D4
	MOVE.32	#R16^BARNAME,A3
	NTREL	?CREBAR			; ouvre la bar de communication
	JUMP,NE	R8^ERROR$

	MOVE.32	A5,{A6}+32^{D0}+OCOMMBAR
	MOVE.32	A6,{A6}+32^{D0}+OGLOBVAR
	MOVE.32	D1,{A6}+32^{D0}+ODRIVERID

	MOVE.32	#{A6}+32^{D0},A6	; ^variables locales
	CLR.16	D7

ERROR$:	POPM.32	D0..D6|A0..A5
	RET

BARNAME:
	.ASCIZE "#:PCCOMMBAR"



;***********************************************************************************


;--------\\
; KILL    >
;========/

; in	A6	^variables locales
; out	-
; mod	D0..A1

D0KILL:
D1KILL:
D2KILL:
D3KILL:
	PUSH.32 A5

	MOVE.32	{A6}+OREPLYSEM,A5
	NTREL	?KILLSEM

ERROR$:	POP.32	A5
	RET


;***********************************************************************************

;--------\\
; OPEN    >
;========/

; in	A6	^variables locales
; out	-
; mod	D0..A1

D0OPEN:
	MOVE.32	#{A6}+OCMDOpen,A0
	CLR.16	{A0}+OcmdNODRIVER
	JUMP	DxOPEN

D1OPEN:
	MOVE.32	#{A6}+OCMDOpen,A0
	MOVE.16	#1,{A0}+OcmdNODRIVER
	JUMP	DxOPEN

D2OPEN:
	MOVE.32	#{A6}+OCMDOpen,A0
	MOVE.16	#2,{A0}+OcmdNODRIVER
	JUMP	DxOPEN

D3OPEN:
	MOVE.32	#{A6}+OCMDOpen,A0
	MOVE.16	#3,{A0}+OcmdNODRIVER
	JUMP	DxOPEN

DxOPEN:
	PUSHM.32 D4

	NTREL	?GETTIM

	MOVE.32	#USART_OPEN,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	MOVE.32	#0,{A0}+OcmdLENGTH
	MOVE.32	#0,{A0}+OcmdDATA
	CALL	SendRequest
	MOVE.16	{A0}+OcmdERROR,D7

	POPM.32	D4
	CLR.16	D7
	RET



;--------\\
; CLOSE   >
;========/

; in	A6	^variables locales
; out	-
; mod	D0..A1

D0CLOSE:
	MOVE.32	#{A6}+OCMDClose,A0
	CLR.16	{A0}+OcmdNODRIVER
	JUMP	DxCLOSE

D1CLOSE:
	MOVE.32	#{A6}+OCMDClose,A0
	MOVE.16	#1,{A0}+OcmdNODRIVER
	JUMP	DxCLOSE

D2CLOSE:
	MOVE.32	#{A6}+OCMDClose,A0
	MOVE.16	#2,{A0}+OcmdNODRIVER
	JUMP	DxCLOSE

D3CLOSE:
	MOVE.32	#{A6}+OCMDClose,A0
	MOVE.16	#3,{A0}+OcmdNODRIVER
	JUMP	DxCLOSE

DxCLOSE:
	PUSHM.32 D4

	NTREL	?GETTIM

	MOVE.32	#USART_CLOSE,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	MOVE.32	#0,{A0}+OcmdLENGTH
	MOVE.32	#0,{A0}+OcmdDATA
	CALL	SendRequest
	MOVE.16	{A0}+OcmdERROR,D7

	POPM.32	D4
	CLR.16	D7
	RET

;***********************************************************************************

;--------\\
; COMMAND >
;========/

; in	A4.32	^table des commandes termine par zro
;	A6	^variables locales
; out	D7.16	erreur
; mod	D7.16

D0COMMAND:
	MOVE.32	#{A6}+OCMDCommand,A0
	CLR.16	{A0}+OcmdNODRIVER
	JUMP	DxCOMMAND

D1COMMAND:
	MOVE.32	#{A6}+OCMDCommand,A0
	MOVE.16	#1,{A0}+OcmdNODRIVER
	JUMP	DxCOMMAND

D2COMMAND:
	MOVE.32	#{A6}+OCMDCommand,A0
	MOVE.16	#2,{A0}+OcmdNODRIVER
	JUMP	DxCOMMAND

D3COMMAND:
	MOVE.32	#{A6}+OCMDCommand,A0
	MOVE.16	#3,{A0}+OcmdNODRIVER
	JUMP	DxCOMMAND

DxCOMMAND:
	PUSHM.32 D0|D4|D5|A1

	MOVE.32	A4,A1
	CLR.32	D5
BOUCLE$:
	CALL	GereCommV
	TEST.16	D7
	JUMP,EQ	BOUCLE$

	CALL	GereCommW
	TEST.16	D7
	JUMP,EQ	BOUCLE$

	CALL	GereCommX
	TEST.16	D7
	JUMP,EQ	BOUCLE$

	CALL	GereCommP
	TEST.16	D7
	JUMP,EQ	BOUCLE$

	CALL	GereCommHelp
	TEST.16	D7
	JUMP,EQ	BOUCLE$

	TEST.8	{A1+}
	JUMP,EQ	SORT_BOUCLE$
	INC.32	D5
	JUMP	BOUCLE$

SORT_BOUCLE$:
	NTREL	?GETTIM

	MOVE.32	#USART_COMMAND,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	MOVE.32	D5,{A0}+OcmdLENGTH
	MOVE.32	A4,{A0}+OcmdDATA
	CALL	SendRequest
	MOVE.32	{A0}+OcmdLENGTH,D5
	MOVE.16	{A0}+OcmdERROR,D7

	POPM.32	D0|D4|D5|A1
	RET

;***********************************************************************************

;----------\\
; GereCommV >
;==========/

; Vrifie s'il s'agit de la commande V et la gre en consquence.
; Cette commande peut en effet contenir des 0!

; in	A1.32	^table des commandes
;	D5.32	longueur de la commande
;	A6	^variables locales
; out	A1.32	^table des commandes (plus loin si la commande V a t traite)
;	D5.32	longueur de la commande si la commande V a t traite
;	D7.16	=  0   =>  la commande a t traite
;		= -1   =>  la commande n'a pas t traite
; mod	D7.16

GereCommV:
	MOVE.16	#-1,D7			; par dfaut la commande n'est pas traite

	COMP.8	#"V",{A1}
	JUMP,EQ	Gere$

	COMP.8	#"v",{A1}
	JUMP,NE	Fin$

Gere$:
	ADD.32	#3,A1			; traite le cas de la commande Vbb
	ADD.32	#3,D5			; qui peut contenir des 0
	CLR.16	D7

Fin$:
	RET

;***********************************************************************************

;----------\\
; GereCommW >
;==========/

; Vrifie s'il s'agit de la commande W et la gre en consquence.
; Cette commande peut en effet contenir des 0!

; in	A1.32	^table des commandes
;	D5.32	longueur de la commande
;	A6	^variables locales
; out	A1.32	^table des commandes (plus loin si la commande W a t traite)
;	D5.32	longueur de la commande si la commande W a t traite
;	D7.16	=  0   =>  la commande a t traite
;		= -1   =>  la commande n'a pas t traite
; mod	D7.16

GereCommW:
	MOVE.16	#-1,D7			; par dfaut la commande n'est pas traite

	COMP.8	#"W",{A1}
	JUMP,EQ	Gere$

	COMP.8	#"w",{A1}
	JUMP,NE	Fin$

Gere$:
	ADD.32	#3,A1			; traite le cas de la commande Wbb
	ADD.32	#3,D5			; qui peut contenir des 0
	CLR.16	D7

Fin$:
	RET

;***********************************************************************************

;----------\\
; GereCommX >
;==========/

; Vrifie s'il s'agit de la commande X et la gre en consquence.
; Cette commande peut en effet contenir des 0!

; in	A1.32	^table des commandes
;	D5.32	longueur de la commande
;	A6	^variables locales
; out	A1.32	^table des commandes (plus loin si la commande X a t traite)
;	D5.32	longueur de la commande si la commande X a t traite
;	D7.16	=  0   =>  la commande a t traite
;		= -1   =>  la commande n'a pas t traite
; mod	D7.16

GereCommX:
	MOVE.16	#-1,D7			; par dfaut la commande n'est pas traite

	COMP.8	#"X",{A1}
	JUMP,EQ	Gere0$

	COMP.8	#"x",{A1}
	JUMP,NE	Fin$

Gere0$:
	COMP.8	#"N",{A1}+1
	JUMP,EQ	Gere1$

	COMP.8	#"n",{A1}+1
	JUMP,EQ	Gere1$

	COMP.8	#"F",{A1}+1
	JUMP,EQ	Gere1$

	COMP.8	#"f",{A1}+1
	JUMP,NE	Fin$

Gere1$:
	ADD.32	#3,A1			; traite le cas de la commande XFb ou XNb
	ADD.32	#3,D5			; qui peut contenir des 0
	CLR.16	D7

Fin$:
	RET

;***********************************************************************************

;----------\\
; GereCommP >
;==========/

; Vrifie s'il s'agit de la commande P et la gre en consquence.
; Cette commande peut en effet contenir des 0!

; in	A1.32	^table des commandes
;	D5.32	longueur de la commande
;	A6	^variables locales
; out	A1.32	^table des commandes (plus loin si la commande P a t traite)
;	D5.32	longueur de la commande si la commande P a t traite
;	D7.16	=  0   =>  la commande a t traite
;		= -1   =>  la commande n'a pas t traite
; mod	D7.16

GereCommP:
	MOVE.16	#-1,D7			; par dfaut la commande n'est pas traite

	COMP.8	#"P",{A1}
	JUMP,EQ	Gere0$

	COMP.8	#"p",{A1}
	JUMP,NE	Fin$

Gere0$:
	COMP.8	#"R",{A1}+1
	JUMP,EQ	Gere1$

	COMP.8	#"r",{A1}+1
	JUMP,NE	Fin$

Gere1$:
	ADD.32	#4,A1			; traite le cas de la commande PRbb
	ADD.32	#4,D5			; qui peut contenir des 0
	CLR.16	D7

Fin$:
	RET

;***********************************************************************************

;-------------\\
; GereCommHelp >
;=============/

; Vrifie s'il s'agit de la commande ? et la gre en consquence.
; Cette commande peut en effet contenir des 0!

; in	A1.32	^table des commandes
;	D5.32	longueur de la commande
;	A6	^variables locales
;	D7.16	= -1   =>  comme si la commande n'avait pas t traite
; mod	D7.16

GereCommHelp:
	PUSHM.32 D0..D6|A0..A6
	MOVE.16	#-1,D7			; par dfaut la commande n'est pas traite

	COMP.8	#"?",{A1}
	JUMP,NE	Fin$

	MON	?AFTIM
	.ASCII	"<CR><CR>Aide pour le driver Usart<CR>"
	.ASCIZE	"=========================   (Dcembre 97 / P.-O. Vallat)"

Boucle$:
	MON	?AFTIM
	.ASCII	"<CR><CR>Introduire la lettre pour laquelle vous dsirez une aide<CR>"
	.ASCIZE	"et la barre d'espacement pour quitter l'aide<CR><CR>"
	MON	?GETCAR
	MON	?MINMAJ

	COMP.8	#" ",D3
	JUMP,EQ	Fin$

A$:	COMP.8	#"A",D3
	JUMP,NE	B$

	MON	?AFTIM
	.ASCII	"A :  AE    Affichage actif (Enable) sur leds, accepte par compatibilit<CR>"
	.ASCII	"           du SMAKY 8.<CR>"
	.ASCII	"     AD    Affichage inactif (Disable) sur leds, accepte par <CR>"
	.ASCIZE	"           compatibilit du SMAKY 8."
	JUMP	Boucle$


B$:	COMP.8	#"B",D3
	JUMP,NE	C$

	MON	?AFTIM
	.ASCII	"B :  Bnnn  Baud-rate clock-generator en bauds (nnn: chiffre ascii).<CR>"
	.ASCII	"           valeurs: 57600,38400 (SMAKY 324), 19200 (SMAKY 100 & 324),<CR>"
	.ASCII	"           9600,7200,4800,3600,2400,2000,1800,1200,600,300,150,134,<CR>"
	.ASCII	"           110,75 et 50.<CR>"
	.ASCII	"*          Exemple B9600 (mode par dfaut).<CR>"
	.ASCII	"           Utiliser plutt la commande V (B va disparatre).<CR>"
	.ASCII	"           NOTE: sur SMAKY 324, des baud-rates quelconques peuvent<CR>"
	.ASCII	"           tre envoys au drivers; la valeur relle est arrondie<CR>"
	.ASCII	"            la vitesse suprieure, celle-ci peut-tre connue avec<CR>" 
	.ASCII	"           l'appel read-status.<CR>"
	.ASCIZE	"     BE    envoie un BREAK sur la ligne TxDATA"
	JUMP	Boucle$

C$:	COMP.8	#"C",D3
	JUMP,NE	D$

	MON	?AFTIM
	.ASCII	"C :  C     Clear les erreurs sur les leds SM8 uniquement, (indpendant<CR>"
	.ASCII	"           des erreurs rendues aux appels), accepte par compatibilit<CR>"
	.ASCIZE	"           du SMAKY 8."
	JUMP	Boucle$

D$:	COMP.8	#"D",D3
	JUMP,NE	F$

	MON	?AFTIM
	.ASCII	"D :  D     Dbloque xon-xoff en mission.<CR>"
	.ASCII	"     Dd    Facteur de division pour la PLL de l'usart:<CR>" 
	.ASCIZE	"           d = 1 ,16(*), 32 ou 64 en binaire (SM324 seul)."
	JUMP	Boucle$

F$:	COMP.8	#"F",D3
	JUMP,NE	H$

	MON	?AFTIM
	.ASCII	"F :  FE    Fifo actif (Enable). Indispensable pour xon-xoff en mission.<CR>"
	.ASCIZE	"*    FD    Fifo inactif (Disable)."
	JUMP	Boucle$

H$:	COMP.8	#"H",D3
	JUMP,NE	L$

	MON	?AFTIM
	.ASCII	"H :  HE    Haut-parleur actif (Enable); (read et write), accepte par<CR>"
	.ASCII	"           compatibilit du SMAKY 8.<CR>"
	.ASCII	"     HD    Haut-parleur inactif (Disable), accepte par compatibilit<CR>"
	.ASCIZE	"           du SMAKY 8."
	JUMP	Boucle$

L$:	COMP.8	#"L",D3
	JUMP,NE	M$

	MON	?AFTIM
	.ASCII	"L :  Ln    Longueur du mot en bits (n: chiffre ascii).<CR>"
	.ASCII	"           valeurs: SMAKY 8 et 324: 5,6,7,8. SMAKY 100: 7,8 uniquement.<CR>"
	.ASCII	"           Attention sur SMAKY 324, les longueurs peuvent tre<CR>" 
	.ASCII	"           diffrentes en entre et en sortie; il faut donc les<CR>"
	.ASCII	"           spcifier deux fois: in et out.<CR>"
	.ASCIZE	"           Exemple L8 (mode par dfaut)."
	JUMP	Boucle$

M$:	COMP.8	#"M",D3
	JUMP,NE	N$

	MON	?AFTIM
	.ASCII	"M :  sur SMAKY 324 uniquement: (* = mode par dfaut)<CR>"
	.ASCII	"*    MR    Mode RS232: clock interne donn par le gnrateur de<CR>"
	.ASCII	"           baud-rate<CR>"
	.ASCII	"     MS    Mode SIMSER: clock externe donn par la ligne TxCK<CR>"
	.ASCII	"           de la prise S+.<CR>"
	.ASCII	"*    MHD   Mode HANDSHAKE disable: les lignes CTS et DCD sont inactive:<CR>"
	.ASCII	"           elle n'ont pas d'influence sur la rgulation de flux des<CR>"
	.ASCII	"           caractres.<CR>"
	.ASCII	"     MHE   Mode HANDSHAKE enable: les lignes CTS et DCD sont active:<CR>"
	.ASCII	"           elle rgulent le flux des caractres, CTS en mission DCD<CR>"
	.ASCII	"           en rception.<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM
	.ASCII	"     MHRE  Mode Handshake RTS Enable (RTS dsactiv pour XOFF, activ<CR>"
	.ASCII	"           pour XON)<CR>"
	.ASCII	"     MHRD  Mode Handshake RTS Disable<CR>"
	.ASCII	"     MHTE  Mode Handshake DTR Enable (DTR dsactiv pour XOFF,<CR>"
	.ASCII	"           activ pour XON)<CR>"
	.ASCII	"     MHTD  Mode Handshake DTR Disable<CR>"
	.ASCII	"     MED   Mode ERREUR anciennes: on gnre les anciens numros<CR>"
	.ASCII	"           d'erreurs par compatibilit.<CR>"
	.ASCII	"     MEE   Mode ERREUR EXACTES: on gnre des numros d'erreurs un peu<CR>"
	.ASCII	"           plus prcises.<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM
	.ASCII	"     MP=   Mode Prise directe: sans croisement cd le mode normal.<CR>"
	.ASCII	"     MPX   Mode Prise croise: on croise les prises 1 et 3 en vue de<CR>"
	.ASCII	"           transmission 1200/75.<CR>"
	.ASCII	"     MAD   Mode AUTOECHO disable: mode normal.<CR>"
	.ASCII	"     MAE   Mode AUTOECHO enable: on renvoye tout ce qu'on recoi, mais<CR>"
	.ASCII	"           on ne peut plus envoyer.<CR>"
	.ASCII	"*    MLD   Mode LOCAL_LOOP_BACK disable: mode normal.<CR>"
	.ASCII	"     MLE   Mode LOCAL_LOOP_BACK enable: on se renvoye tout ce qu'on<CR>"
	.ASCII	"           envoy, mais plus de rception.<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM
	.ASCII	"*    MB7   Quartz du gnrateur de baud-rate  7.3728Mhz plaques D.<CR>"
	.ASCII	"     MB3   Quartz du gnrateur de baud-rate  3.6864Mhz plaques C.<CR>"
	.ASCII	"     MB4   Quartz du gnrateur de baud-rate  4Mhz.<CR>"
	.ASCII	"     MB8   Quartz du gnrateur de baud-rate  8Mhz.<CR>"
	.ASCII	"     MBH   Quartz du gnrateur de baud-rate  16MHz.<CR>"
	.ASCII	"     MBQqqqq Change la valeur du quartz du gnrateur de baud-rate:<CR>"
	.ASCII	"             calcul des facteurs de division.<CR>"
	.ASCII	"     MIRaaaapppp Change l'adresse de la routine d'interruption en<CR>"
	.ASCII	"                 lecture du drivers.<CR>"
	.ASCII	"     MIWaaaapppp Change l'adresse de la routine d'interruption en<CR>"
	.ASCII	"                 criture du drivers.<CR>"
	.ASCII	"     MISaaaapppp Change l'adresse de la routine d'interruption spciale<CR>"
	.ASCII	"                 (DCD,BREAK,ERROR,CTS).<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM
	.ASCII	"     Ces trois routines d'interruptions doivent se terminer par un RET.<CR>"
	.ASCII	"     (pas de RETSF !!!)<CR>"
	.ASCII	"     A2.32 contient l'adresse du priphrique DATA du Z8530.<CR>"
	.ASCII	"     A3.32 contient l'adresse du priphrique COMMAND-STATUS du Z8530.<CR>"
	.ASCII	"     A6.32 contient le pointeur donn lors du command.<CR>"
	.ASCII	"           (par ex: pointeurs aux vars)<CR>"
	.ASCII	"     D0.32 contient l'adresse de la routine d'interruption excute<CR>"
	.ASCII	"           dans le drivers; pour excuter celle-ci normalement,<CR>"
	.ASCII	"           faire: add.32 #4,sp ;jump {d0}. Dans ce cas il ne faut<CR>"
	.ASCII	"           modifier absolument AUCUN registres. Dans le cas contraire,<CR>"
	.ASCII	"           D0,D1,D7,A0,A1,A2 et A6 peuvent tre modifi  volont.<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM	
	.ASCII	"     MDT   Active tous les dbugs du drivers.<CR>"
	.ASCII	"*    MDO   Enlve tous les dbugs du drivers.<CR>"
	.ASCII	"     MD0   Active le dbug d'entre des appels<CR>"
	.ASCII	"     MD1   Active le dbug d'entre des ROUTines.<CR>"
	.ASCII	"     MD2   Active le dbug des ERReurs de lecture.<CR>"
	.ASCII	"     MD3   Active le dbug des XONxoff envoys et reus.<CR>"
	.ASCII	"     MD4   Active le dbug du processus PROCX de gestion des xon-xoff.<CR>"
	.ASCII	"     MD5   Active le dbug de l'activit SIMser.<CR>"
	.ASCII	"     MD6   Active le dbug des INTerruptions.<CR>"
	.ASCII	"     MD7   Active le dbug des SIGNals envoys aux smaphores.<CR>"
	.ASCII	"     MD8   Active le dbug des lignes CTS et DCD.<CR>"
	.ASCIZE	"     MD9   Active le dbug des Commandes envoyes."
	JUMP	Boucle$

N$:	COMP.8	#"N",D3
	JUMP,NE	O$

	MON	?AFTIM
	.ASCII	"N :  N     Mode standard hardware, corr.  la chaine: L8S2PDW[9600.W]<CR>"
	.ASCII	"           C'est--dire: 8 bits, 2 stop-bits, pas de parit, 9600 bds.<CR>"
	.ASCII	"           Les variables softwares ne sont pas modifies !<CR>"
	.ASCII	"           La commande: NN, force un reset software qu'il faut<CR>"
	.ASCII	"           cependant viter.<CR>"
	.ASCII	"           ATTENTION: cette commande modifie les paramtres internes des<CR>"
	.ASCII	"           DEUX CANAUX (in et out) du circuit usart; il faut donc<CR>"
	.ASCII	"           l'utiliser q'UNE SEULE FOIS lors de la premire commande;<CR>"
	.ASCII	"           en effet avec une deuxime commande N on dtruirait	les<CR>"
	.ASCII	"           commandes spcifies prcdemment, y compris sur le premier<CR>"
	.ASCIZE	"           canal !!!"
	JUMP	Boucle$

O$:	COMP.8	#"O",D3
	JUMP,NE	P$

	MON	?AFTIM
	.ASCII	"O :  ODE   Ligne en sortie DTR (data terminal ready) active (Enable).<CR>"
	.ASCII	"     ODD   Ligne en sortie DTR (data terminal ready) inactive (Disable).<CR>"
	.ASCII	"     ODX   Ligne en sortie DTR (data terminal ready) inchange au close<CR>"
	.ASCII	"           read ni par read.<CR>"
	.ASCII	"*    ODC   Ligne en sortie DTR (data terminal ready) dsactive au close<CR>"
	.ASCII	"           read.<CR>"
	.ASCII	"     ORE   Ligne en sortie RTS (request to send) active (Enable).<CR>"
	.ASCII	"     ORD   Ligne en sortie RTS (request to send) inactive (Disable).<CR>"
	.ASCII	"     ORX   Ligne en sortie RTS (request to send) inchange au close<CR>"
	.ASCII	"           write ni par write.<CR>"
	.ASCII	"*    ORC   Ligne en sortie RTS (request to send) dsactive au close<CR>"
	.ASCII	"           write.<CR>"
	.ASCII	"*          Ces lignes sont actives automatiquement  chaque open,<CR>"
	.ASCII	"           et dsactives  chaque close (read: DTR, write: RTS).<CR><CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM	
	.ASCII	"in  OCaaaa Adresse du smaphore sur lequel le drivers effectue un<CR>"
	.ASCII	"           ?SIGNAL lors d'une variation de la ligne DCD, sur smaky 324<CR>"
	.ASCII	"           seulement.<CR>"
	.ASCII	"in  OBaaaa Adresse du smaphore sur lequel le drivers effectue un<CR>"
	.ASCII	"           ?SIGNAL lors d'une variation de la ligne RxDATA (BREAK),<CR>"
	.ASCII	"           sur smaky 324 seulement.<CR>"
	.ASCII	"in  OEaaaa Adresse du smaphore sur lequel le drivers effectue un<CR>"
	.ASCII	"           ?SIGNAL lors d'une erreur dtecte sur la ligne RxDATA<CR>" 
	.ASCIZE	"           (parit,framming,overrun) sur sm324 seulement."
	JUMP	Boucle$

P$:	COMP.8	#"P",D3
	JUMP,NE	R$

	MON	?AFTIM
	.ASCII	"P :  PE    Parit paire (even).<CR>"
	.ASCII	"     PO    Parit impaire (odd).<CR>"
	.ASCII	"*    PD    Parit inactive (Disable).<CR>"
	.ASCII	"PRpp       Caractres de remplacement en cas d'erreur de parit.<CR>"
	.ASCIZE	"           (0==>pas de remplacement)"
	JUMP	Boucle$

R$:	COMP.8	#"R",D3
	JUMP,NE	S$

	MON	?AFTIM
	.ASCII	"R :  RE    Rptition xon-xoff en criture active (Enable).<CR>"
	.ASCIZE	"*    RD    Rptition xon-xoff en criture inactive (Disable)."
	JUMP	Boucle$

S$:	COMP.8	#"S",D3
	JUMP,NE	T$

	MON	?AFTIM
	.ASCII	"S :  S1    1 Stop bit.<CR>"
	.ASCII	"     S1.5  1 Stop bit et demi. Sur SMAKY 8 et SMAKY 324 seulement.<CR>"
	.ASCIZE	"*    S2    2 Stop bits."
	JUMP	Boucle$

T$:	COMP.8	#"T",D3
	JUMP,NE	V$

	MON	?AFTIM
	.ASCII	"T :  Tnnn   Time-out par commande: aprs la commande YE seulement.<CR>"
	.ASCII	"            nnn: chiffre ascii. (les units sont de 20 ms).<CR>"
	.ASCII	"            Exemple T200 (valeur recommands de 4 secondes).<CR>"
	.ASCIZE	"            Utiliser plutt la commande W (T va disparatre)."
	JUMP	Boucle$

V$:	COMP.8	#"V",D3
	JUMP,NE	W$

	MON	?AFTIM
	.ASCII	"V :   Vbb   Baud-rate clock-generator en bauds (bb: 2 bytes en binaire).<CR>"
	.ASCII	"            Idem  la commande B, mais avec la syntaxe standard: [xx.W].<CR>"
	.ASCII	"            Valeurs bb:57600,38400 (SMAKY 324), 19200 (SMAKY 100 & 324),<CR>"
	.ASCII	"            9600,7200,4800,3600,2400,2000,1800,1200,600,300,150,134,110,<CR>"
	.ASCII	"            75 et 50. Seuls les baud-rates de cette liste sont permis.<CR>"
	.ASCIZE	"*           Exemple depuis le filer: V[9600.W] (mode par dfaut)."
	JUMP	Boucle$

W$:	COMP.8	#"W",D3
	JUMP,NE	X$

	MON	?AFTIM
	.ASCII	"W :  Wtt   Time-out par commande: aprs la commande YE seulement.<CR>"
	.ASCII	"           tt: 2 bytes en binaire; idem  la commande B, mais avec<CR>"
	.ASCII	"           la syntaxe standard: [xx.W]. xx: nombre de 20ms.<CR>"
	.ASCIZE	"           Exemple depuis le filer: W[200.W] (Time-out de 4 secondes)."
	JUMP	Boucle$

X$:	COMP.8	#"X",D3
	JUMP,NE	Y$

	MON	?AFTIM
	.ASCII	"X :  XE    Mode xon-xoff activ (Enable); read et write spar.<CR>"
	.ASCII	"*    XD    Mode xon-xoff dsactiv (Disable); read et write spar.<CR>"
	.ASCII	"     XS    Equivaut  un XOFF recu en entre ==> bloque mission;<CR>" 
	.ASCII	"           commande read seulement.<CR>"
	.ASCII	"     XG    Equivaut  un XON recu en entre ==> redmarre mission;<CR>"
	.ASCII	"           commande read seulement.<CR>"
	.ASCII	"     XX    Ne filtre pas les XON-XOFF en sortie donns par<CR>"
	.ASCII	"           l'utilisateur; write seulement.<CR>"
	.ASCII	"*    XC    Filtre les XON-XOFF en sortie (conflit avec usart),<CR>"
	.ASCII	"           si mode XE; write seulement.<CR>"
	.ASCIZE	"     Presser une touche  quelconque pour continuer...<CR><CR>"
	MON	?GETCAR

	MON	?AFTIM	
	.ASCII	"*    XNb   Code du caractre XON (b: byte en binaire),<CR>"
	.ASCII	"           par dfaut D'17 (ctrl-Q)<CR>"
	.ASCII	"*    XFb   Code du caractre XOFF (b: byte en binaire),<CR>"
	.ASCII	"           par dfaut D'19 (ctrl-S)<CR>"
	.ASCII	"           En lecture n'est possible que si la comm. FE a dja t faite<CR>"
	.ASCII	"           Le close supprime les modes xon-xoff; il faudra donc refaire<CR>"
	.ASCII	"           ces commandes  chaques utilisation du driver aprs le OPEN<CR>"
	.ASCII	"           Ces commandes ne peuvent donc pas tre utilises dans<CR>"
	.ASCII	"           la macro  de dmarrage."
	JUMP	Boucle$

Y$:	COMP.8	#"Y",D3
	JUMP,NE	Erreur$

	MON	?AFTIM
	.ASCII	"Y :  YE    Met le mode: Time-out par commandes. (utiliser Wbb ou Bnnn).<CR>"
	.ASCII	"*    YD    Met le mode: Time-out donn par le processus courant:<CR>"
	.ASCIZE	"           utiliser l'appel NTREL,?SETTIM pour dfinir le time-out."
	JUMP	Boucle$

Erreur$:
	MON	?AFCAR
	MON	?AFTIM				; commande inconnue
	.ASCIZE	"  commande inconnue"
	JUMP	Boucle$

Fin$:
	POPM.32	D0..D6|A0..A6
	RET

;***********************************************************************************

;--------\\
; RSTATUS >
;========/

; in	A4.32	^buffer
;	D4.32	longueur buffer
;	A6	^variables locales
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

D0RSTATUS:
	MOVE.32	#{A6}+OCMDRStatus,A0
	CLR.16	{A0}+OcmdNODRIVER
	JUMP	DxRSTATUS

D1RSTATUS:
	MOVE.32	#{A6}+OCMDRStatus,A0
	MOVE.16	#1,{A0}+OcmdNODRIVER
	JUMP	DxRSTATUS

D2RSTATUS:
	MOVE.32	#{A6}+OCMDRStatus,A0
	MOVE.16	#2,{A0}+OcmdNODRIVER
	JUMP	DxRSTATUS

D3RSTATUS:
	MOVE.32	#{A6}+OCMDRStatus,A0
	MOVE.16	#3,{A0}+OcmdNODRIVER
	JUMP	DxRSTATUS

DxRSTATUS:
	PUSHM.32 D4

	NTREL	?GETTIM

	MOVE.32	#USART_RDSTATUS,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	POPM.32	D4

	MOVE.32	D4,{A0}+OcmdLENGTH
	MOVE.32	A4,{A0}+OcmdDATA
	CALL	SendRequest
	MOVE.32	{A0}+OcmdLENGTH,D4
	MOVE.16	{A0}+OcmdERROR,D7

	RET

;; /****************************************************************************/
;; /*  Mode de fonctionnement des oprations Read/Write                        */
;; /*  Le Smaky 400 possde la main pour l'opration de Read/Write dans le     */
;; /*  driver.                                                                 */
;; /*  Le driver initialise la structure Read/Write                            */
;; /*  typedef struct                                                          */
;; /*  {                                                                       */
;; /*       Card32 length ;             // longueur  lire/crire              */
;; /*       void   *data ;              // pointeur aux donnes  lire/crire  */
;; /*       Card16 error ;              // erreur transmise par le PC          */
;; /*       Card16 complete ;           // flags pour Read/Write termin       */
;; /*  } ReadWriteStruct ;                                                     */
;; /*  Initialisation par le Smaky 400                                         */
;; /*  - ReadWriteStruct.length   = longueur  lire/crire                     */
;; /*  - ReadWriteStruct.data     = ^aux donnes  lire/crire                 */
;; /*  - ReadWriteStruct.error    = 0                                          */
;; /*  - ReadWriteStruct.complete = 0                                          */
;; /*  Le driver en outre pCmd                                                 */
;; /*  - pCmd->timeout            = timeout du processus appelant              */
;; /*  - pCmd->length             = sizeof (ReadWriteStruct)                   */
;; /*  - pCmd->data               = ^structure ReadWriteStruct initialise     */
;; /*  Le Smaky 400 lance la requte au PC et attend le rsultat               */
;; /*  Le PC dclenche l'opration Read/Write en faisant un ReadFile ou        */
;; /*  un WriteFile sur le port Usart avec un timeout de 20ms.                 */
;; /*  On peut alors avoir plusieurs situations dans le PC                     */
;; /*                                                                          */
;; /*  o L'opration ReadFile ou WriteFile se termine sans erreur              */
;; /*    - Le PC initialise les paramtres suivants                            */
;; /*      ReadWriteStruct.error      = 0                                      */
;; /*      ReadWriteStruct.length     = longueur effectivement lue/crite      */
;; /*      ReadWriteStruct.complete   = 1                                      */
;; /*    - Le PC retourne 0 au Smaky 400 (c'est--dire pas d'erreur)           */
;; /*    - Le Smaky 400 reprend la main, ne dtecte pas d'erreur. De ce fait   */
;; /*      il lit ReadWriteStruct.complete = 1 => le Read/Write est termin.   */
;; /*      Il transmet au processus ReadWriteStruct.length et retourne 0.      */
;; /*  o L'opration ReadFile ou WriteFile se termine avec une erreur          */
;; /*    ERROR_IO_PENDING.                                                     */
;; /*    - Le PC initialise ReadWriteStruct.complete avec 0                    */
;; /*    - Le PC lance le Thread qui fera un WaitForSingleObject avec le       */
;; /*      timeout dsir.                                                     */
;; /*    - Le PC retourne la valeur 0 au Smaky 400                             */
;; /*    - Le Smaky 400 reprend la main, ne dtecte pas d'erreur. De ce fait   */
;; /*      il lit ReadWriteStruct.complete = 0 => le Read/Write n'est pas      */
;; /*      termin.                                                            */
;; /*    - Le Smaky 400 entre dans une boucle infinie qui lui fait tester      */
;; /*      ReadWriteStruct.complete toutes les 20ms pour attendre son passage  */
;; /*       1.                                                                */
;; /*    - Le Thread du PC sort du WaitForSingleObject.                        */
;; /*    - Le Thread du PC fait un GetOverlappedResult.                        */
;; /*      + si GetOverlappedResult ne transmet pas d'erreur, le Thread place  */
;; /*        0 dans ReadWriteStruct.error si la longueur effectivement         */
;; /*        lue/crite est la mme que celle demande et il place ERDIOUT     */
;; /*        dans ReadWriteStruct.error si la longueur effectivement           */
;; /*        lue/crite n'est pas la mme que celle demande. En dernier       */
;; /*        le Thread place 1 dans ReadWriteStruct.complete                   */
;; /*      + si GetOverlappedResult transmet une erreur, le Thread place       */
;; /*        l'erreur ERBIOS dans ReadWriteStruct.error et 1 dans              */
;; /*        ReadWriteStruct.complete.                                         */
;; /*    - Le Thread place la longueur effectivement lue/crite dans           */
;; /*      ReadWriteStruct.length.                                             */
;; /*    - Le Thread dtruit le handle  l'objet de cr pour le               */
;; /*      WaitForSingleObject et se dtruit lui-mme                          */
;; /*    - Le Smaky dtecte ReadWriteStruct.complete = 1, il transmet le       */
;; /*      nombre d'octets effectivement lus/crits, ainsi que l'erreur        */
;; /*      (paramtres que lui a pass le Thread du PC dans ReadWriteStruct)   */
;; /****************************************************************************/

;***********************************************************************************

;--------\\
; WRITE   >
;========/

; in	A4.32	^buffer texte
;	D5.32	lg maximale du texte
;	A6	^variables locales
; out	D5.32	lg effectivement crite
;	D7.16	erreur
; mod	D7.16, D5.32

D1WRITE:
	MOVE.32	#{A6}+OCMDWrite,A0
	MOVE.16	#1,{A0}+OcmdNODRIVER
	JUMP	DxWRITE

D3WRITE:
	MOVE.32	#{A6}+OCMDWrite,A0
	MOVE.16	#3,{A0}+OcmdNODRIVER
	JUMP	DxWRITE

DxWRITE:
	PUSHM.32 D4|A1

	NTREL	?GETTIM

	MOVE.32	#USART_WRITE,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	MOVE.32	#LgReadWrite,{A0}+OcmdLENGTH
	MOVE.32	#{A6}+OStructWrite,A1
	MOVE.32	A1,{A0}+OcmdDATA
	MOVE.32	D5,{A6}+OStructWrite+ORWLength 		; initialise la structure R/W
	MOVE.32	A4,{A6}+OStructWrite+ORWData
	CLR.16	{A6}+OStructWrite+ORWError
	CLR.16	{A6}+OStructWrite+ORWComplete
	CALL	SendRequest

	CALL	GetResultRW

	POPM.32	D4|A1
	RET


;***********************************************************************************

;--------\\
; READ    >
;========/

; in	A4.32	^buffer texte
;	D5.32	lg maximale du texte
;	A6	^variables locales
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D7.16, D5.32

D0READ:
	MOVE.32	#{A6}+OCMDRead,A0
	CLR.16	{A0}+OcmdNODRIVER
	JUMP	DxREAD

D2READ:
	MOVE.32	#{A6}+OCMDRead,A0
	MOVE.16	#2,{A0}+OcmdNODRIVER
	JUMP	DxREAD


DxREAD:	PUSHM.32 D4|A1

	NTREL	?GETTIM

	MOVE.32	#USART_READ,{A0}+OcmdOP
	CLR.16	{A0}+OcmdERROR
	MOVE.16	D4,{A0}+OcmdTIMEOUT
	MOVE.32	#LgReadWrite,{A0}+OcmdLENGTH
	MOVE.32	#{A6}+OStructRead,A1
	MOVE.32	A1,{A0}+OcmdDATA
	MOVE.32	D5,{A6}+OStructRead+ORWLength 		; initialise la structure R/W
	MOVE.32	A4,{A6}+OStructRead+ORWData
	CLR.16	{A6}+OStructRead+ORWError
	CLR.16	{A6}+OStructRead+ORWComplete
	CALL	SendRequest

	CALL	GetResultRW

	POPM.32	D4|A1
	RET


;***********************************************************************************

;-----------\\
;GetResultRW >
;-----------/

; in	A1.32	^ la structure ReadWrite
;	A6	^variables locales
; out	D5.32	lg effetivement lue
;	D7.16	erreur
; mod	D7.16, D4.16, D5.32

; A partir de la structure transmise par le PC, le routine gre l'Usart et retourne
; les paramtres transmis par le PC

GetResultRW:
	MOVE.32	{A1}+ORWLength,D5		; ce qui a t lu/crit
	MOVE.16	{A1}+ORWError,D7		; regarde l'erreur (fatale?)
	JUMP,NE	End$

	MOVE.16	#1,D4				; attends 20ms dans la boucle
Loop$:
	TEST.16	{A1}+ORWComplete		; l'opration est termine?
	JUMP,NE	End$
	NTREL	?DELMS
	JUMP	Loop$		

End$:
	MOVE.32	{A1}+ORWLength,D5		; met  jour ce qui a t lu/crit
	MOVE.16	{A1}+ORWError,D7		; met  jour l'erreur
	RET


;***********************************************************************************

;-------------\\
; SendRequest  >
;-------------/

; in	A0.32	^  la commande  envoyer
;	A6.32	^ variables locales
; out	-
; mod	D7.16

SendRequest:
	PUSHM.32 D0|D4|A0|A4|A5

	MOVE.32	#{A6}+OREQUEST,A4
	MOVE.32	#-1,D4
	NTREL	?MODTIM			; ATTENTION: ne pas modifier D4 plus bas !

	MOVE.32	#LGCMD,D0

	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	D0,{A4}+RQ_SDATALEN
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	D0,{A4}+RQ_RDATALEN

	MOVE.32	{A6}+OCOMMBAR,A5
	NTREL	?OFFERBAR		; envoie la requte au PC
	NTREL	?ENDOFFERBAR

	MOVE.32	{A6}+OREPLYSEM,A5
	NTREL	?WAITEV			; attend la rponse du PC
	NTREL	?SETTIM			; remet le "bon" time-out

	POPM.32	D0|D4|A0|A4|A5
	RET


	.END

