	.proc	m68030F
	.start	start
	.ref	Smaky
	.ref	Quicc_reg.ref
	.ref	Sm400hard.ref

MBAR	=	16'3FF00	; Adresse de MBAR 

	.loc	0

start:

	;-----------------\\
	;  CALLSUPERVISOR  >
	;=================/
	
	; Appelle une routine en mode superviseur. La routine doit se
	; terminer par RETSF. Elle reoit tous les registres inchangs
	; en entre, mis  part D7.16 qui est mis  zro.
	
	; in	A5.32	^routine  appeler
	;	+ selon routine
	; out	D7.16	toujours 0, sauf si la routine modifie D7
	;	+ selon routine
	; mod	D7.16

Start:
	LIB	?OPELIB
	LIB	?aftim
	.ascize	"Dbut<CR>"
	Move.32	#R16^Prog,A5	; ^routine -> programme
	NTREL	?CALLSUPERVISOR	; et l'excute en mode superviseur
	LIB	?Aftim
	.ascize	"MBAR New: "
	LIB	?AFX8
	LIB	?AFCR

	LIB	?Aftim
	.ascize	"MBAR Old: "
	Move.32	d5,d4
	LIB	?AFX8
	LIB	?AFCR

	Jump	Suite
	lib	?getcar
	LIB	?CLOLIB
	Fos	?stop

Prog:
; Met accs zone RAM interne en mode utilisateur autoris: MBAR modifi
; Il faut tre en mode superviseur pour le faire

	Move.32	#7,D0		; Mode CPU Space pour accder MBAR
	Move.32	D0,SFC		; Spcifie mode FCx Source
	Move.32	D0,DFC		; Idem Destination
	Move.32	{SFC}^MBAR,D4	; Relit MBAR
	Move.32	d4,d5		; Sauvetage pour affichage

	and.32	#16'FFFFFFFF-(2**2),d4	; Accs autoris Data Space
;	and.32	#16'FFFFFFFF-16'3FE,d4
	Move.32	d4,{DFC}^MBAR	; Autorise accs mode user data zone RAM

; Modifie accs MMU pour page RAM interne

	Move.32	16'1510,A0	; ^GSMPageMMUD
	Move.32	{A0},A0		; ^routine de traitement du SHI
	Move.32	#8*1024,D1	; Taille page (8k)
	Move.32	#AdQuicc,A1	; ^Dbut page RAM interne (DPRBase, {MBAR})
	Move.32	#2**bPageNoCache,D3	; attribut de la page
	Call	{A0}		; Modif de la page

	RetSF

Suite:
;
	And.32	#16'FFFFE000,d4
	Move.32	d4,A0
;	Move.32	#AdQuicc,A0
Loop$:	Move.32	#16'ABCDEF01,{A0}
	Move.32	A0,d4
	Lib	?afx8
	Lib	?aftab
	Move.32	{A0+},D4
	Lib	?afx8
	Lib	?afcr
	Lib	?getcar
	Jump	Loop$

;---------\
; InitSCC3 >
;=========/
; Initialise les paramtres pour Z-Net
;
; In:	-
; Out:	-
; Mod:	A0.32	AdQuicc
;

InitSCC3:
	Move.32	#AdQuicc,A0	; Adresse DPRBase -> A0

; Gnration CLK6 par Timer 3

	And.16	#16'FFFF-2**10-2**9-2**8,{A0}+oTGCR	; Registre Contrle gnral des Timers, Reset Timer 3

	Or.16	#2**13,{A0}+oPAPAR	; PA13 mode TOUT3*
	Or.16	#2**13,{A0}+oPADIR

	Move.16	#16'00*(2**8)+2'00*(2**6)+2**5+2**3+2'01*(2**1),{A0}+oTMR3
					; Prescaler 1,
					; Mode Toggle,
					; Restart automatique,
					; internal clk
	Move.16	#0,{A0}+oTCN3		; Initialise compteur  0
	Move.16	#16,{A0}+oTRR3		; Toggle  500ns (clock 32 MHz)
;	Move.16	#64,{A0}+oTRR3		; Toggle  2us (clock 32 MHz)

	Or.16	#2**8,{A0}+oTGCR	; Registre Contrle gnral des Timers, Enable Timer 3

	Ret

	
	.end


