	.Title	Travail

	.proc	m68020
	.procset m68040
	.start	start
	.ref	Smaky
	.Ref	BiosDriv.ref
	.ref	Quicc.ref
	.ref	Quicc_reg.ref
	.ref	Sm400hard.ref

	.ins	Z_PAQUET.ASI
	.ins	Z_DESCATT.ASI

; 0.0	RB	98/02/25	Dbut du programme de test
; 0.0	RB 	98/06/30	Reprise en main (maison)

MBAR	=	16'3FF00	; Adresse de MBAR 
Mode250kbits	=	0	; 1 pour 250 kbits/s
Mode1Mbits	=	1	;

NbBDRxSCC3	=	10	; Nbr de BD Rception pour SCC3
NbBDTxSCC3	=	10	; Nbr de BD Emission pour SCC3

LgBufRxMax	=	LMaxRcv
	
; Zone en mmoire interne pour descripteurs de Buffer SCC

	.loc	0

oSCC3RxBD:	.blk.8	NbBDRxSCC3*LgBD	; Place pour BD Rception
oSCC3TxBD:	.blk.8	NbBDTxSCC3*LgBD	; Place pour BD Emission


; SCCE, SCCM:
bRxB	=	0	; Receive Buffer, but not complete
bTxB	=	1	; Transmit Buffer
bBsy	=	2	; Frame received discarded, lack of Frame
bRxF	=	3	; Frame Received
bTxE	=	4	; Transmit error (CTS lost)
bGRA	=	7	; graceful Stop Complete
bIDL	=	8	; Change on state Line
bFlg	=	9	; Flag received
bDCC	=	10	; DPLL CS Change
bGlt	=	11	; Glitch on Tx
bGlr	=	12	; Glitch on Rx

	.loc	0

start:

	;-----------------\\
	;  CALLSUPERVISOR  >
	;=================/
	
	; Appelle une routine en mode superviseur. La routine doit se
	; terminer par RETSF. Elle reoit tous les registres inchangs
	; en entre, mis  part D7.16 qui est mis  zro.
	
	; in	A5.32	^routine  appeler
	;	+ selon routine
	; out	D7.16	toujours 0, sauf si la routine modifie D7
	;	+ selon routine
	; mod	D7.16

Start:
	LIB	?OPELIB
	LIB	?aftim
	.ascize	"Dbut<CR>"
	Move.32	#R16^Prog,A5	; ^routine -> programme
	NTREL	?CALLSUPERVISOR	; et l'excute en mode superviseur
	LIB	?CLOLIB
	Fos	?stop


;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Accs en mode Superviseur
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Ncessaire pour debug avec ADB
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Prog:
; Met accs zone RAM interne en mode utilisateur autoris: MBAR modifi
; Il faut tre en mode superviseur pour le faire

	Move.32	CACR,D4

	LIB	?Aftim
	.ascize	"CACR: "
	LIB	?AFX8
	LIB	?AFTAB
	TClr.32	D4:#31
;	TSet.32	D4:#31
	Move.32	d4,cacr		; Cache Data Disabled
	LIB	?AFX8
	LIB	?AFCR

	Move.32	DTT0,D4
	LIB	?Aftim
	.ascize	"DTT0: "
	LIB	?AFX8
	LIB	?AFTAB

	Move.32	DTT1,D4
	LIB	?Aftim
	.ascize	"DTT1: "
	LIB	?AFX8
	LIB	?AFTAB

	Move.32	ITT0,D4
	LIB	?Aftim
	.ascize	"ITT0: "
	LIB	?AFX8
	LIB	?AFTAB

	Move.32	ITT1,D4
	LIB	?Aftim
	.ascize	"ITT1: "
	LIB	?AFX8
	LIB	?AFCR

	Move.32	VBR,D4
	LIB	?Aftim
	.ascize	"VBR: "
	LIB	?AFX8
	LIB	?AFCR

	Move.32	#7,D0		; Mode CPU Space pour accder MBAR
	Move.32	D0,SFC		; Spcifie mode FCx Source
	Move.32	D0,DFC		; Idem Destination
	Move.32	{SFC}^MBAR,D4	; Relit MBAR
	Move.32	d4,d5		; Sauvetage pour affichage

	and.32	#16'FFFFFFFF-(2**2),d4	; Accs autoris Data Space
;	and.32	#16'FFFFFFFF-16'3FE,d4
	Move.32	d4,{DFC}^MBAR	; Autorise accs mode user data zone RAM

; Modifie accs MMU pour page RAM interne

	Move.32	16'1510,A0	; ^GSMPageMMUD
	Move.32	{A0},A0		; ^routine de traitement du SHI
	Move.32	#8*1024,D1	; Taille page (8k)
	Move.32	#AdQuicc,A1	; ^Dbut page RAM interne (DPRBase, {MBAR})
	Move.32	#2**bPageNoCache,D3	; attribut de la page
	Call	{A0}		; Modif de la page

.if	1
; Affiche MBAR

	LIB	?Aftim
	.ascize	"MBAR New: "
	LIB	?AFX8
	LIB	?AFCR

	LIB	?Aftim
	.ascize	"MBAR Old: "
	Move.32	d5,d4
	LIB	?AFX8
	LIB	?AFCR
.endif
.if	0
	AND.32	#16'F0000000,d4		; Garde page de 16 Moctets
	Move.16	#2'1100000001000000,d4	; Mode Transparent pour accs 68360, Cache Disabled serialized
	Move.32	D4,ITT1

	LIB	?Aftim
	.ascize	"ITT1: "
	LIB	?AFX8
	LIB	?AFCR
.endif
	Call	Suite

	lib	?getcar
	retsf


;!!!!!!!!!!!!!!!!!!!!!!!!!!
;; Accs Mode User possible -> NON NON NON,
;; certains registres QUICC ne sont accessibles qu'en mode Superviseur !!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!
; In:	D4.32	MBAR
; Dans la routine A5.32 contient l'adresse de base de la mmoire interne du Quick

Suite:
	And.32	#16'FFFFE000,d4		; Masque Permission -> garde adresse DPRBase
	Move.32	d4,A5			; Adresse pour utiliser le Quick -> A5.32
;	Move.32	#AdQuicc,A5
	Lib	?afx8			; Affich pour Debug
	Lib	?afCR

	Move.16	{A5}+oSDCR,D4
	Lib	?afx4			; Affich pour Debug
	Lib	?afCR
	Move.16	#7*(2**8)+4*(2**4),{A5}+oSDCR	; Mode DMA plus haute priorit que interruptions
						; 4: priorit gnrale SDMA 

	Call	InitSCC3		; Initialise le SCC3 et les clocks
	Call	InitIntSCC3		; Initialise interruption SCC3

; Dsactive RTS3

	And.32	#16'FFFFFFFF-2**14,{A5}+oPBDAT		; RTS3/PB14 = 0

; Mmoire pour  buffer de rception

	Move.32	#LgBufRxMax,d4
	Move.32	#MTypCP,D1
	Gesmem	?Getmem
	Jump,ne	f$
	Move.32	A4,A3			; ^Buffer pour donnes  recevoir
; Se prpare  recevoir
	Or.32	#2'100000,{A5}+oGSMR_L3	; Enable  Rception
	Move.16	#2**bRxF,{A5}+oSCCM3	; Autorise interruption SCC3 RxF
LoopRcv$:
	Move.32	A3,A4			; ^Buffer rception
	Move.32	#LgBufRxMax,d4		; Longueur buffer Rception
	Call	RcvSCC3			; Prpare rception d'un paquet
	Call	WaitRcvSCC3
	Jump	LoopRcv$


; Se prpare  envoyer
	Or.32	#2'010000,{A5}+oGSMR_L3	; Enable  Transmit
	Move.16	#2**bTxB,{A5}+oSCCM3	; Autorise interruption SCC3 TxB
LoopSnd$:
	Move.32	#R16^DataSnd,A4		; ^Data  envoyer
	Move.16	#LgSnd,D4		; Longueur des Data
	Call	SndSCC3			; Envoi d'un paquet
					; A2.32 ^descr. d'mission
; Teste de l'mission d'un paquet
	Call	WaitSndEnd3

	Move.32	#R16^DataSnd,A4		; ^Data  envoyer
	Move.16	#LgSnd,D4		; Longueur des Data
	Call	SndAckSCC3		; Envoi d'un paquet Ack 
					; A2.32 ^descr. d'mission
; Teste de l'mission d'un paquet Ack
	Call	WaitSndAckEnd3
	Jump	LoopSnd$	
f$:
	Test.16	D7
	Ret

;---------\
; InitSCC3 >
;=========/
; Initialise les paramtres pour Z-Net
;
; In:	A5.32	AdQuicc
; Out:	-
; Mod:	
;

InitSCC3:
	Move.32	#0,{A5}+oGSMR_L3	; Disable Receive & Transmit

.if	0
; Test PA13, Toggle PA13 par soft, vrifier  l'oscillo J13, pin 5
; pour vrifier que la connexion est bonne sur pin CLK6

	And.16	#16'FFFF-2**13,{A5}+oPAPAR	;
	Or.16	#2**13,{A5}+oPADIR		; Sortie
l$:
	Or.16	#2**13,{A5}+oPADAT
	And.16	#16'FFFF-2**13,{A5}+oPADAT
	Jump,zc	l$
.endif

; Gnration BRG3 -> CLK5 

	Move.8	#2'00010010,{A5}+oSICR+1	; BRG3 pour SCC3
	Move.32	#2**17,{A5}+oBRGC3		; Reset BRG3
.if	Mode250kbits
	Move.32	#2**16+2'00*(2**14)+(32/4-1)*(2**1),{A5}+oBRGC3	; 4 Mbits pour Quartz 32MHz
.endif
.if	Mode1Mbits
	Move.32	#2**16+2'00*(2**14)+(32/16-1)*(2**1),{A5}+oBRGC3	; 16 Mbits pour Quartz 32MHz
								; /16 pour DPLL
.endif
	Or.16	#2**12,{A5}+oPAPAR		; PA12 mode BRGO3 (Clk5)
	Or.16	#2**12,{A5}+oPADIR

; Gnration CLK6 par Timer 3

	And.16	#16'FFFF-2**13,{A5}+oPADIR	; Input
	And.16	#16'FFFF-2**13,{A5}+oPAPAR	; Mode Port

	Or.16	#2**13,{A5}+oPADIR
	Or.16	#2**13,{A5}+oPAPAR		; PA13 mode TOUT3* -> Clk6

	And.16	#16'FFFF-2**15-2**10-2**9-2**8,{A5}+oTGCR
						; Registre Contrle gnral des Timers
						; Pas de Freeze Timer 3 (bit 10)
						; Mode Normal timer 3 (bit 9)
						; Reset Timer 3 (bit 8)


;	Move.16	#16'01*(2**8)+2'00*(2**6)+(2**5)+(2**3)+2'01*(2**1),{A5}+oTMR3
	Move.16	#2'0000000100101010,{A5}+oTMR3
						; Prescaler 1,
						; Mode Toggle,
						; Restart automatique,
						; internal clk
	Move.16	#0,{A5}+oTCN3			; Initialise compteur  0
.if Mode250kbits
	Move.16	#64-1,{A5}+oTRR3		; Toggle  2us (clock 32 MHz)
.endif
.if Mode1Mbits
	Move.16	#16-1,{A5}+oTRR3		; Toggle  500ns (clock 32 MHz)
.endif

	Move.16	#16'FFFF,{A5}+oTER3
;	Move.16	#16'01*(2**8)+2'00*(2**6)+(2**5)+(2**3)+2'01*(2**1),{A5}+oTMR3
;	Move.16	#4,{A5}+oTMR3

	Or.16	#2**8,{A5}+oTGCR		; Registre Contrle gnral des Timers, Enable Timer 3

; Pins RxD3/TxD3

	Or.16	#2**5+2**4,{A5}+oPAPAR		; PA5 TxD3 et PA4 RxD3
	And.16	#16'FFFF-2**5-2**4,{A5}+oPADIR

; Pin CTS3* PC8, autorise transmission si active ( "0"), p7-358

	And.16	#16'FFFF-2**8,{A5}+oPCPAR	; PCPAR.8 = 0	
	And.16	#16'FFFF-2**8,{A5}+oPCDIR	; Input
;	And.16	#16'FFFF-2**8,{A5}+oPCSO	; 
	Or.16	#2**8,{A5}+oPCSO		; Mode automatique CTS3* actif autorise mission

; Pin CD3* PC9, !! Utilis en Mode Port I/O en SORTIE pour 
; Si = 1, autorise la transmission inconditionnelle

	AND.16	#16'FFFF-2**9,{A5}+oPCDAT	; PC9 = 0
	And.16	#16'FFFF-2**9,{A5}+oPCPAR	; Mode I/O bit 9 (CD3)
	Or.16	#2**9,{A5}+oPCDIR		; Output
	And.16	#16'FFFF-2**9,{A5}+oPCSO	; Mode I/O

; Pin RTS3* PB14, demande de transmission si ligne libre, Mode I/O SORTIE
; Si = 1 -> demande de transmettre
; Attention: Mal utilis sur Sm400 RTS3* ne peut pas tre utilis en mode automatique !!
; Mettre en mode Output Pin en effectuer requte par soft !!
; Mettre sortie  "1" pour demander  transmettre normalement

	And.32	#16'FFFFFFFF-2**14,{A5}+oPBDAT		; RTS3/PB14 = 0
	And.32	#16'FFFFFFFF-2**14,{A5}+oPBPAR		; PB14 Mode Output
	Or.32	#2**14,{A5}+oPBDIR			; PB14, Output
	
; Mode de base SDMA

	move.16	#16'0740, {A5}+oSDCR

; Programmation SCC3

	Move.32	#2'00000000001110101001001000000000, {A5}+oGSMR_L3	; Mode Gnral b15..0
;		    | || |||  | || | |  |  | |||HDLC
;		    | || |||  | || | |  |  | ||EnT
;		    | || |||  | || | |  |  | |EnR
;		    | || |||  | || | |  |  |Diag: Normal
;		    | || |||  | || | |  |TEnc FM0
;		    | || |||  | || | |REnc: FM0
;		    | || |||  | || |RDCR: x16 DPLL 
;		    | || |||  | ||TDCR: x16 DPLL
;		    | || |||  | |TEnd: Frame Ending (0:line High, 1: Tx '1')
;		    | || |||  |TPP: Preamble type (11: all one)
;		    | || |||TPL: 1 octets preamble
;		    | || ||TInv
;		    | || |RInv
;		    | ||TSNC
;		    | |TCI
;		    |Edge: Both

	Move.32	#2'00000000000000000, {A5}+oGSMR_H3	; Mode Gnral SCC3 bits 31..16
;		   || ||||||||||| ||RSyn
;		   || ||||||||||| |RTSM
;		   || |||||||||||SynL
;		   || ||||||||||TxSY
;		   || |||||||||RFW: RxFIFO 32 bits
;		   || ||||||||TFL: 16 bytes FIFO (SCC3)
;		   || |||||||CTSS
;		   || ||||||CDS
;		   || |||||CTSP
;		   || ||||CDP
;		   || |||TTX
;		   || ||TRX
;		   || |RevD
;		   ||TCRC (16 bits CCITT)
;		   |GDE


	Move.16	#2'0001000000000000, {A5}+oPSMR3	; Mode protocol-specific SCC3
;	Move.16	#2'0001000001000000, {A5}+oPSMR3	; Mode protocol-specific SCC3
;		   |   | ||||||||-
;		   |   | |||||||MFF
;		   |   | ||||||BRM 
;		   |   | |||||Bus
;		   |   | ||||DRT: 1: Receiver Disabled during transmission
;		   |   | |||FSE
;		   |   | ||-
;		   |   | |RTE
;		   |   |CRC : 16 bits CCITT-CRC X16 + X12 + X5 + 1
;		   |NOF: 1 Flag

;	Move.16	#, {A5}+oTODR3				; Transmission sur demande SCC3
	Move.16	#16'7E7E, {A5}+oDSR3			; Donnes sync. SCC3 -> Flag HDLC
	Move.16	#16'FFFF, {A5}+oSCCE3			; Efface vnements SCC3 ventuels
	Move.16	#16'0000, {A5}+oSCCM3			; Mask Interrupt SCC3, 1 Enable interrupt

	Move.32	#{A5}+oSCC3,A1				; ^descr Scc3

;**********************************************
;*	Initialisation des ^BD de 	     *
;*	transmission et de rceptions        *
;**********************************************

	move.16	#oSCC3RxBD,{A1}+oRBASE	;init pointeur sur le descripteur de buffer Received
	move.16	#oSCC3TxBD,{A1}+oTBASE	;init pointeur sur le descripteur de buffer Transmitted
;	Move.16	#0000*(2**8)+2'1000*(2**4)+1,{A5}+oCR	; Init Tx & Rx params
	move.8	#2'10001,{A1}+oRFCR	;MOT init fonction code = user data 
	move.8	#2'10001,{A1}+oTFCR	;MOT init fonction code = user data 
;	move.8	#2'11000,{A1}+oRFCR	;MOT init fonction code = user data 
;	move.8	#2'11000,{A1}+oTFCR	;MOT init fonction code = user data 
	move.16 #LgBufRxMax,{A1}+oMRBLR	;init Longueur max du buffer de reception

	move.32	#16'0000F0B8,{A1}+ohC_MASK	;Initialisation pour un CRC-CCITT de 16 bits
	move.32	#16'0000FFFF,{A1}+ohC_PRES	;Initialisation pour un CRC-CCITT 16 bits
	move.16	#16'0000,{A1}+ohDISFC	;Initialisation du compteurs de trames erronne(s)
	move.16	#16'0000,{A1}+ohCRCEC	;Initialisation du compteurs d'erreur CRC detectees
	move.16	#16'0000,{A1}+ohABTSC	;Initialisation du compteurs de sequence interrompues
	move.16	#16'0000,{A1}+ohNMARC	;Initialisation du compteurs des adresses de receptions invalides 
	move.16	#16'0000,{A1}+ohRETRC	;Initialisation du compteurs de trames retransmises (collisions)
	move.16	#0,{A1}+ohRFCnt		; Nbre trame reues
	move.16	#LgBufRxMax,{A1}+ohMFLR	; Initialisation de la longueur max d'une trame	!!!!!
	move.16	#1,{A1}+ohRFTHR		; Nombre de buffer prevus a la reception
	move.16	#16'0,{A1}+ohHMASK	; on accepte toutes les adresses de provenances

	Clr.16	{A1}+ohHaddr1
	Clr.16	{A1}+ohHaddr2
	Clr.16	{A1}+ohHaddr3
	Clr.16	{A1}+ohHaddr4
	Move.16	#0000*(2**8)+2'1000*(2**4)+1,{A5}+oCR	; Init Tx & Rx params
	Ret
	


;--------\
; SndSCC3 >
;========/
; In:	A5.32	^DPRBAse
;	A4.32	^Data  envoyer
;	D4.16	Longueur des Data
; Out:	A2.32	^Descripteur de buffer SCC3 utilis
; Mod:	-

SndSCC3:
.if	0
 	pushm.32	d4|d0
	Move.32	CACR,D4

	LIB	?Aftim
	.ascize	"CACR: "
	LIB	?AFX8
	LIB	?AFCR
	Clr.32	d0
	Move.32	d0,cacr		; Cache Disabled
	popm.32	d4|d0
.endif
	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels
	Move.32	#{A5}+oSCC3TxBD,a2	;a2 = ^descript. de buffer SCC3 en mission 
	move.32	A4,{a2}+ooBDPntBuf	;^Buffer rception
	move.16	D4,{A2}+ooBDDataLength	;Lg  transmettre
	move.16	#2'1011110000000000,{A2}+ooBDStCtrl	;Status et Controle
;		   | |||||(1)Continuous Mode
;		   | ||||TC Transmit CRC
;		   | |||L Last Buffer in the Frame       
;		   | ||I TxB or TxE activated can performed Interrupt         
;		   | |Wrap and last BD         
;		   |Ready	
	Or.32	#2**14,{A5}+oPBDAT	; RTS3/PB14 = 1
	Move.16	#2**15,{A5}+oTODR3	; Emission immdiate	
	Ret

;-----------\
; SndAckSCC3 >
;===========/
; In:	A5.32	^DPRBAse
;	A4.32	^Data  envoyer
;	D4.16	Longueur des Data
; Out:	A2.32	^Descripteur de buffer SCC3 utilis
; Mod:	-

SndAckSCC3:
	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels
 	Move.32	#{A5}+oSCC3TxBD,a2	;a2 = ^descript. de buffer SCC3 en mission 
	move.32	A4,{a2}+ooBDPntBuf	;^Buffer rception
	move.16	D4,{A2}+ooBDDataLength	;Lg  transmettre
	move.16	#2'1011110000000000,{A2}+ooBDStCtrl	;Status et Controle
;		   | |||||(1)Continuous Mode
;		   | ||||TC Transmit CRC
;		   | |||L Last Buffer in the Frame       
;		   | ||I TxB or TxE activated can performed Interrupt         
;		   | |Wrap and last BD         
;		   |Ready	
	Or.16	#2**9,{A5}+oPCDAT	; CD3/PC9 = 1
	Move.16	#2**15,{A5}+oTODR3	; Emission immdiate	
	Ret

DataSnd:	.8	16'62,16'AA
LgSnd	=	APC-DataSnd
	.even

ooBDStCtrl	=	0	; .w	Status and Control
ooBDDataLength	=	2	; .w	Data Length
ooBDPntBuf	=	4	; .l	Pointeur au buffer de donnes
LgBD		=	8	; Longueur du descripteur de buffer

;---------------\
; WaitSndEnd3 >
;===============/
; Attend la fin de transmission d'un paquet
; In:	A5.32	^DPRBAse
;	A2.32	^decripteur mission attendu
; Out:	-
; Mod:	d0

.if	0
WaitSndEnd3:
	clr.32	d1
Loop$:
	inc.32	d1
	Move.16	{A5}+oSCCE3,D0		; Events
	test.32	d0:#1			; TxB
	Jump,BC	Loop$

	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels
	And.32	#16'FFFFFFFF-2**14,{A5}+oPBDAT		; RTS3/PB14 = 0
	Ret
.else
WaitSndEnd3:
	clr.32	d1
Loop$:
	inc.32	d1

	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
;	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels;
;	And.32	#16'FFFFFFFF-2**14,{A5}+oPBDAT		; RTS3/PB14 = 0
	Ret

.endif


;---------------\
; WaitSndAckEnd3 >
;===============/
; Attend la fin de transmission d'un paquet
; In:	A5.32	^DPRBAse
;	A2.32	^decripteur mission attendu
; Out:	-
; Mod:	d0

.if	0
WaitSndAckEnd3:
	clr.32	d1
Loop$:
	inc.32	d1
	Move.16	{A5}+oSCCE3,D0		; Events
	test.32	d0:#1			; TxB
	Jump,BC	Loop$

	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels
	And.16	#16'FFFF-2**9,{A5}+oPCDAT		; CD3/PC9 = 0
	Ret
.else
WaitSndAckEnd3:
	clr.32	d1
Loop$:
	inc.32	d1
	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
;;	Move.16	#2'10, {A5}+oSCCE3	; Efface vnements TxB SCC3 ventuels
;;	And.16	#16'FFFF-2**9,{A5}+oPCDAT		; CD3/PC9 = 0
	Ret
.endif

;--------\
; RcvSCC3 >
;========/
; In:	A5.32	^DPRBAse
;	A4.32	^Buffer rception
;	D4.16	Longueur des Data
; Out:	A2.32	^descripteur buffer rcv
; Mod:	-

RcvSCC3:
	Move.32	#{A5}+oSCC3RxBD,a2		;a2 = adresse du debut des descript. de buffer SCC1 en reception
	move.32	A4,{A2}+ooBDPntBuf		;pointe dbut Buffer Rx RAM Externe
	move.16	#0,{A2}+ooBDDataLength		;Remplit par Quicc
	move.16	#2'1011000000000000,{A2}+ooBDStCtrl	;Status et controle
;		   | ||  |(1)Continuous Mode        
;		   | ||RxB or RxF activated can performed Interrupt         
;		   | |Wrap and last BD         
;		   |Empty and Free
	Ret
	

;------------\
; WaitRcvSCC3 >
;============/
; Attend la fin de rception d'un paquet
; In:	A5.32	^DPRBAse
;	A2.32	^decripteur rception attendu
; Out:	-
; Mod:	d0

WaitRcvSCC3:
	clr.32	d1
Loop$:
	inc.32	d1
	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
	Ret



;------------\
; InitIntSCC3 >
;============/
; In:	A6.32	^variables reues dans A5.32 dans routine interrupt
; Out:	-
; Mod:	

; Interruptions:
; 1) registre CICR dfinit les priorits des interruptions du CPM,
;    il doit tre initialis par le SHI, mais les SCC n'y ont pas t inclus !
; - SCCEx est le registre vnement des SCCx
; - SCCMx permet d'autoriser(1)/Masquer(0) l'interruption de l'vnement du SCCEx
; - CIPR possde un bit de requte pour chacune des sources d'interruptions
; - CIMR est le registre d'Autorisation(1)/masquage(0) des interruptions
; - CISR est le registre des interruptions actives !! il est trs important, 
;        il permet d'autoriser des interruptions de plus hautes priorits,
;        si le niveau du masque (IPL2..IPL0 du registre SR (SF)) est plus bas 
;        que le niveau courant et que la requte CPM est de plus haute priorit 
;        que la routine en cours de traitement dfinit par CISR 
;        (Ouf, voir p.7-374)

bIntSCC3	=	28		; Traitement IntSCC3 dans registre CIPR, CIMR et CISR
vIntSCC3 	== 	2**bIntSCC3

InitIntSCC3:
	Pushm.32	A0..A2|D0
	MOVE.32	_INDNTR,A2

	MOVE.A16 #AdVectSCC3,A0		;  vecteur de l'interrupt SCC3
	MOVE.32	#R16^INTSCC3,A1		; ^routine de traitement
;	CALL	{A2}+OIN_InitFastV	;  initialise ^routine interruption SCC3
	call	{a2}+OIN_INITVECTOR	;  initialise ^routine interruption SCC3

;RB
	MOVE.32	{A5}+OquiccCICR,D0	; dfinit mode pour les IRQ SCC du CPM
	swap.32	d0
;	move.8	#2'00011011,d0		; Priorit des SCC Highest 4,3,2,1 (Lowest)
	move.8	#2'11100100,d0		; Priorit des SCC Highest 1, 2, 3, 4 (Lowest)
	swap.32	d0
	Move.32	d0,{A5}+OquiccCICR	

;;	Move.32	#2**bIntSCC3,{A5}+OquiccCIPR	; Ne sert  rien pour SCC -> SCCE
	Move.16	#0,{A5}+oSCCM3			; Interruptions SCC3 masques
	Move.16	#16'FFFF,{A5}+oSCCE3		; Enlve tous les vnements possibles de SCC3
	Move.32	#2**bIntSCC3,{A5}+OquiccCISR	; retire les interruptions SCC3 en traitement
	OR.32	#2**bIntSCC3,{A5}+OquiccCIMR	; autorise les interruptions SCC3
	Popm.32	A0..A2|D0
	Ret

;----------\\		 \ 
;  INTSCC3  >		  \  /\
;==========/		   \/  \

; Routine d'interruption SCC3 (Z).
; in	A0.32	^variables globales
; out	-
; mod	-

INTSCC3:
	AND.16	#16'F8FF,SF		;ION !!
;;	PUSHM.32 D0|D1|A0|A1

	MOVE.32	#AdQuicc,A0		; A0 <-- ^registres 68360

	Move.16	{A0}+oSCCE3,d0		; Evnements de l'interruption
	Test.32	d0:#bRxF		; Frame received
	Jump,bs	ZRcv$
	Test.32	d0:#bTxB		; transmission termine
	Jump,bs	ZSend$
	Test.32	d0:#bTxE		; Erreur de transmission
	Jump,bs	ZTxErr$

ZRcv$:
	Or.16	#2**9,{A0}+oPCDAT	; CD3/PC9 = 1
	And.16	#16'FFFF-2**9,{A0}+oPCDAT	; CD3/PC9 = 0
	Move.16	#2**bRxF,{A0}+oSCCE3	; Clear Event
	Jump	F$
ZSend$:
	Move.16	#2**bTxB,{A0}+oSCCE3	; Clear Event TxB SCC3 ventuels
	And.16	#16'FFFF-2**9,{A0}+oPCDAT	; CD3/PC9 = 0
	And.32	#16'FFFFFFFF-2**14,{A0}+oPBDAT	; RTS3/PB14 = 0
	Jump	F$

ZTxErr$:
	Move.16	#2**bTxE,{A0}+oSCCE3	; Clear Event
;	Jump	F$

F$:
	Move.32	#2**bIntSCC3,{A0}+OquiccCISR	; retire les interruptions SCC3 en traitement
	Ret

;;	JUMP	A16^_IPOPRETSF

