	.Title	Travail

	.proc	m68020
;	.procset m68040
	.start	start
	.ref	Smaky
	.ref	Quicc_reg.ref
	.ref	Sm400hard.ref

	.ins	Z_PAQUET.ASI
	.ins	Z_DESCATT.ASI

; 0.0	RB	98/02/25	Dbut du programme de test
; 0.0	RB 	98/06/30	Reprise en main (maison)

MBAR	=	16'3FF00	; Adresse de MBAR 


NbBDRxSCC3	=	10	; Nbr de BD Rception pour SCC3
NbBDTxSCC3	=	10	; Nbr de BD Emission pour SCC3

LgBufRxMax	=	LMaxRcv
	
; Zone en mmoire interne pour descripteurs de Buffer SCC

	.loc	0

oSCC3RxBD:	.blk.8	NbBDRxSCC3*LgBD	; Place pour BD Rception
oSCC3TxBD:	.blk.8	NbBDTxSCC3*LgBD	; Place pour BD Emission


	.loc	0

start:

	;-----------------\\
	;  CALLSUPERVISOR  >
	;=================/
	
	; Appelle une routine en mode superviseur. La routine doit se
	; terminer par RETSF. Elle reoit tous les registres inchangs
	; en entre, mis  part D7.16 qui est mis  zro.
	
	; in	A5.32	^routine  appeler
	;	+ selon routine
	; out	D7.16	toujours 0, sauf si la routine modifie D7
	;	+ selon routine
	; mod	D7.16

Start:
	LIB	?OPELIB
	LIB	?aftim
	.ascize	"Dbut<CR>"
	Move.32	#R16^Prog,A5	; ^routine -> programme
	NTREL	?CALLSUPERVISOR	; et l'excute en mode superviseur
	LIB	?CLOLIB
	Fos	?stop


;	LIB	?CLOLIB
;	Fos	?stop

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Accs en mode Superviseur
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Ncessaire pour debug avec ADB
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Prog:
; Met accs zone RAM interne en mode utilisateur autoris: MBAR modifi
; Il faut tre en mode superviseur pour le faire

	Move.32	#7,D0		; Mode CPU Space pour accder MBAR
	Move.32	D0,SFC		; Spcifie mode FCx Source
	Move.32	D0,DFC		; Idem Destination
	Move.32	{SFC}^MBAR,D4	; Relit MBAR
	Move.32	d4,d5		; Sauvetage pour affichage

	and.32	#16'FFFFFFFF-(2**2),d4	; Accs autoris Data Space
;	and.32	#16'FFFFFFFF-16'3FE,d4
	Move.32	d4,{DFC}^MBAR	; Autorise accs mode user data zone RAM

; Modifie accs MMU pour page RAM interne

	Move.32	16'1510,A0	; ^GSMPageMMUD
	Move.32	{A0},A0		; ^routine de traitement du SHI
	Move.32	#8*1024,D1	; Taille page (8k)
	Move.32	#AdQuicc,A1	; ^Dbut page RAM interne (DPRBase, {MBAR})
	Move.32	#2**bPageNoCache,D3	; attribut de la page
	Call	{A0}		; Modif de la page

; Affiche MBAR

	LIB	?Aftim
	.ascize	"MBAR New: "
	LIB	?AFX8
	LIB	?AFCR

	LIB	?Aftim
	.ascize	"MBAR Old: "
	Move.32	d5,d4
	LIB	?AFX8
	LIB	?AFCR

	Call	Suite
	lib	?getcar
	retsf


;!!!!!!!!!!!!!!!!!!!!!!!!!!
;; Accs Mode User possible -> NON NON NON,
;; certains registres QUICC ne sont accessibles qu'en mode Superviseur !!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!
; In:	D4.32	MBAR
; Dans la routine A0.32 contient l'adresse de base de la mmoire interne du Quick

Suite:
	And.32	#16'FFFFE000,d4		; Masque Permission -> garde adresse DPRBase
	Move.32	d4,A0			; Adresse pour utiliser le Quick -> A0.32
;	Move.32	#AdQuicc,A0
	Lib	?afx8			; Affich pour Debug
	Lib	?afCR

	Move.16	{A0}+oSDCR,D4
	Lib	?afx4			; Affich pour Debug
	Lib	?afCR
	Move.16	#7*(2**8)+4*(2**4),{A0}+oSDCR	; Mode DMA plus haute priorit que interruptions
						; 4: priorit gnrale SDMA 

	Call	InitSCC3		; Initialise le SCC3 et les clocks

; Mmoire pour  buffer de rception

	Move.32	#LgBufRxMax,d4
	Move.32	#MTypCP,D1
	Gesmem	?Getmem
	Jump,ne	f$
	Move.32	A4,A5			; ^Buffer pour donnes  recevoir
Loop$:
	Move.32	A5,A4			; ^Buffer rception
	Move.32	#LgBufRxMax,d4		; Longueur buffer Rception
	Call	RcvSCC3			; Prpare rception d'un paquet

; Dsactive RTS3

	And.32	#16'FFFFFFFF-2**14,{A0}+oPBDAT		; RTS3/PB14 = 0

; Se prpare  envoyer

	Move.32	#R16^DataSnd,A4		; ^Data  envoyer
	Move.16	#LgSnd,D4		; Longueur des Data
	Call	SndSCC3			; Envoi d'un paquet
					; A2.32 ^descr. d'mission

	Or.32	#2'110000,{A0}+oGSMR_L3	; Enable Receive & Transmit
; Teste de l'mission d'un paquet
	Call	WaitSndEnd3
	Jump	Loop$	
f$:
	Test.16	D7
	Ret

;---------\
; InitSCC3 >
;=========/
; Initialise les paramtres pour Z-Net
;
; In:	A0.32	AdQuicc
; Out:	-
; Mod:	
;

InitSCC3:
.if	0
; Test PA13
; pour vrifier que la connexion est bonne sur pin CLK6

	And.16	#16'FFFF-2**13,{A0}+oPAPAR	;
	Or.16	#2**13,{A0}+oPADIR		; Sortie
l$:
	Or.16	#2**13,{A0}+oPADAT
	And.16	#16'FFFF-2**13,{A0}+oPADAT
	Jump,zc	l$
.endif

; Gnration BRG3 -> CLK5 

	Move.8	#2'00010010,{A0}+oSICR+1	; BRG3 pour SCC3
	Move.32	#2**17,{A0}+oBRGC3		; Reset BRG3
	Move.32	#2**16+2'00*(2**14)+(32/16-1)*(2**1),{A0}+oBRGC3	; 16 Mbits pour Quartz 32MHz
								; /16 pour DPLL
;	Move.32	#2**16+2'00*(2**14)+(32/4-1)*(2**1),{A0}+oBRGC3	; 4 Mbits pour Quartz 32MHz

	Or.16	#2**12,{A0}+oPAPAR		; PA12 mode BRGO3 (Clk5)
	Or.16	#2**12,{A0}+oPADIR


; Gnration CLK6 par Timer 3

	And.16	#16'FFFF-2**13,{A0}+oPADIR	; Input
	And.16	#16'FFFF-2**13,{A0}+oPAPAR	; Mode Port
.if	1 ;@PA
	Or.16	#2**13,{A0}+oPADIR
	Or.16	#2**13,{A0}+oPAPAR	; PA13 mode TOUT3* -> Clk6

	And.16	#16'FFFF-2**15-2**10-2**9-2**8,{A0}+oTGCR	; Registre Contrle gnral des Timers
							; Pas de Freeze Timer 3 (bit 10)
							; Mode Normal timer 3 (bit 9)
							; Reset Timer 3 (bit 8)


;	Move.16	#16'01*(2**8)+2'00*(2**6)+(2**5)+(2**3)+2'01*(2**1),{A0}+oTMR3
	Move.16	#2'0000000100101010,{A0}+oTMR3
					; Prescaler 1,
					; Mode Toggle,
					; Restart automatique,
					; internal clk
	Move.16	#0,{A0}+oTCN3		; Initialise compteur  0
	Move.16	#16-1,{A0}+oTRR3		; Toggle  500ns (clock 32 MHz)
;	Move.16	#64-1,{A0}+oTRR3		; Toggle  2us (clock 32 MHz)

	Move.16	#16'FFFF,{A0}+oTER3
	Move.16	#16'01*(2**8)+2'00*(2**6)+(2**5)+(2**3)+2'01*(2**1),{A0}+oTMR3
;	Move.16	#4,{A0}+oTMR3

	Or.16	#2**8,{A0}+oTGCR	; Registre Contrle gnral des Timers, Enable Timer 3
	.endif

; Pins RxD3/TxD3

	Or.16	#2**5+2**4,{A0}+oPAPAR	; PA5 TxD3 et PA4 RxD3
	And.16	#16'FFFF-2**5-2**4,{A0}+oPADIR

; Pin CTS3* PC8, autorise transmission si active ( "0"), p7-358

	And.16	#16'FFFF-2**8,{A0}+oPCPAR	; PCPAR.8 = 0	
	And.16	#16'FFFF-2**8,{A0}+oPCDIR	; Input
;	And.16	#16'FFFF-2**8,{A0}+oPCSO	; 
	Or.16	#2**8,{A0}+oPCSO		; Mode automatique CTS3* actif autorise mission

; Pin CD3* PC9, !! Utilis en Mode Port I/O en SORTIE pour 
; Si = 1, autorise la transmission inconditionnelle

	AND.16	#16'FFFF-2**9,{A0}+oPCDAT	; PC9 = 0
	And.16	#16'FFFF-2**9,{A0}+oPCPAR	; Mode I/O bit 9 (CD3)
	Or.16	#2**9,{A0}+oPCDIR		; Output
	And.16	#16'FFFF-2**9,{A0}+oPCSO	; Mode I/O

; Pin RTS3* PB14, demande de transmission si ligne libre, Mode I/O SORTIE
; Si = 1 -> demande de transmettre
; Attention: Mal utilis sur Sm400 RTS3* ne peut pas tre utilis en mode automatique !!
; Mettre en mode Output Pin en effectuer requte par soft !!
; Mettre sortie  "1" pour demander  transmettre normalement

	And.32	#16'FFFFFFFF-2**14,{A0}+oPBDAT		; RTS3/PB14 = 0
	And.32	#16'FFFFFFFF-2**14,{A0}+oPBPAR		; PB14 Mode Output
	Or.32	#2**14,{A0}+oPBDIR			; PB14, Output
	
; Mode de base SDMA

	move.16	#16'0740, {A0}+oSDCR

; Programmation SCC3

	Move.32	#2'00000000001110101001001000000000, {A0}+oGSMR_L3	; Mode Gnral b15..0
;		    | || |||  | || | |  |  | |||HDLC
;		    | || |||  | || | |  |  | ||EnT
;		    | || |||  | || | |  |  | |EnR
;		    | || |||  | || | |  |  |Diag: Normal
;		    | || |||  | || | |  |TEnc FM0
;		    | || |||  | || | |REnc: FM0
;		    | || |||  | || |RDCR: x16 DPLL 
;		    | || |||  | ||TDCR: x16 DPLL
;		    | || |||  | |TEnd: Frame Ending (0:line High, 1: Tx '1')
;		    | || |||  |TPP: Preamble type (11: all one)
;		    | || |||TPL: 1 octets preamble
;		    | || ||TInv
;		    | || |RInv
;		    | ||TSNC
;		    | |TCI
;		    |Edge: Both

	Move.32	#2'00000000000000000, {A0}+oGSMR_H3	; Mode Gnral SCC3 bits 31..16
;		   || ||||||||||| ||RSyn
;		   || ||||||||||| |RTSM
;		   || |||||||||||SynL
;		   || ||||||||||TxSY
;		   || |||||||||RFW: RxFIFO 32 bits
;		   || ||||||||TFL: 16 bytes FIFO (SCC3)
;		   || |||||||CTSS
;		   || ||||||CDS
;		   || |||||CTSP
;		   || ||||CDP
;		   || |||TTX
;		   || ||TRX
;		   || |RevD
;		   ||TCRC (16 bits CCITT)
;		   |GDE


	Move.16	#2'0001000000000000, {A0}+oPSMR3	; Mode protocol-specific SCC3
;	Move.16	#2'0001000001000000, {A0}+oPSMR3	; Mode protocol-specific SCC3
;		   |   | ||||||||-
;		   |   | |||||||MFF
;		   |   | ||||||BRM 
;		   |   | |||||Bus
;		   |   | ||||DRT: 1: Receiver Disabled during transmission
;		   |   | |||FSE
;		   |   | ||-
;		   |   | |RTE
;		   |   |CRC : 16 bits CCITT-CRC X16 + X12 + X5 + 1
;		   |NOF: 1 Flag

;	Move.16	#, {A0}+oTODR3		; Transmission sur demande SCC3
	Move.16	#16'7E7E, {A0}+oDSR3	; Donnes sync. SCC3 -> Flag HDLC
	Move.16	#2'0001111110011111, {A0}+oSCCE3	; Efface vnements SCC3 ventuels
	Move.16	#16'0000, {A0}+oSCCM3	; Mask Interrupt SCC3, 1 Enable interrupt

	Move.32	#{A0}+oSCC3,A1		; ^descr Scc3

;**********************************************
;*	Initialisation des ^BD de 	     *
;*	transmission et de rceptions        *
;**********************************************

	move.16	#oSCC3RxBD,{A1}+oRBASE	;init pointeur sur le descripteur de buffer Received
	move.16	#oSCC3TxBD,{A1}+oTBASE	;init pointeur sur le descripteur de buffer Transmitted
;	Move.16	#0000*(2**8)+2'1000*(2**4)+1,{A0}+oCR	; Init Tx & Rx params
	move.8	#2'10001,{A1}+oRFCR	;MOT init fonction code = user data 
	move.8	#2'10001,{A1}+oTFCR	;MOT init fonction code = user data 
;	move.8	#2'11000,{A1}+oRFCR	;MOT init fonction code = user data 
;	move.8	#2'11000,{A1}+oTFCR	;MOT init fonction code = user data 
	move.16 #LgBufRxMax,{A1}+oMRBLR	;init Longueur max du buffer de reception

	move.32	#16'0000F0B8,{A1}+ohC_MASK	;Initialisation pour un CRC-CCITT de 16 bits
	move.32	#16'0000FFFF,{A1}+ohC_PRES	;Initialisation pour un CRC-CCITT 16 bits
	move.16	#16'0000,{A1}+ohDISFC	;Initialisation du compteurs de trames erronne(s)
	move.16	#16'0000,{A1}+ohCRCEC	;Initialisation du compteurs d'erreur CRC detectees
	move.16	#16'0000,{A1}+ohABTSC	;Initialisation du compteurs de sequence interrompues
	move.16	#16'0000,{A1}+ohNMARC	;Initialisation du compteurs des adresses de receptions invalides 
	move.16	#16'0000,{A1}+ohRETRC	;Initialisation du compteurs de trames retransmises (collisions)
	move.16	#0,{A1}+ohRFCnt		; Nbre trame reues
	move.16	#LgBufRxMax,{A1}+ohMFLR	;Initialisation de la longueur max d'une trame	!!!!!
	move.16	#1,{A1}+ohRFTHR		;Nombre de buffer prevus a la reception
	move.16	#16'0,{A1}+ohHMASK		;on accepte toutes les adresses de provenances

	Clr.16	{A1}+ohHaddr1
	Clr.16	{A1}+ohHaddr2
	Clr.16	{A1}+ohHaddr3
	Clr.16	{A1}+ohHaddr4
	Move.16	#0000*(2**8)+2'1000*(2**4)+1,{A0}+oCR	; Init Tx & Rx params
	Ret
	


;--------\
; SndSCC3 >
;========/
; In:	A0.32	^DPRBAse
;	A4.32	^Data  envoyer
;	D4.16	Longueur des Data
; Out:	A2.32	^Descripteur de buffer SCC3 utilis
; Mod:	-

SndSCC3:
	Move.32	#{A0}+oSCC3TxBD,a2	;a2 = ^descript. de buffer SCC3 en mission 
	move.32	A4,{a2}+ooBDPntBuf	;^Buffer rception
	move.16	D4,{A2}+ooBDDataLength	;Lg  transmettre
	move.16	#2'1011110000000000,{A2}+ooBDStCtrl	;Status et Controle
;		   | |||||(1)Continuous Mode
;		   | ||||TC Transmit CRC
;		   | |||L Last Buffer in the Frame       
;		   | ||I TxB or TxE activated can performed Interrupt         
;		   | |Wrap and last BD         
;		   |Ready	
	Move.16	#2'10, {A0}+oSCCE3	; Efface vnements TxB SCC3 ventuels
	Or.32	#2**14,{A0}+oPBDAT	; RTS3/PB14 = 1
	Ret

DataSnd:	.8	16'62,16'AA
LgSnd	=	APC-DataSnd
	.even

ooBDStCtrl	=	0	; .w	Status and Control
ooBDDataLength	=	2	; .w	Data Length
ooBDPntBuf	=	4	; .l	Pointeur au buffer de donnes
LgBD		=	8	; Longueur du descripteur de buffer


;------------\
; WaitSndEnd3 >
;============/
; Attend la fin de transmission d'un paquet
; In:	A2.32	^decripteur mission attendu
; Out:	-
; Mod:	-

WaitSndEnd3:
Loop$:
	Move.16	{A0}+oSCCE3,D0		; Events
	test.32	d0:#1			; TxB
	Jump,BS	f$

	move.16	{A2}+ooBDStCtrl,d0
	test.32	d0:#15

;	Test.8	{A2}+ooBDStCtrl:#15-8	;Status et Controle, Ready 
	Jump,BS	Loop$
f$:
	And.32	#16'FFFFFFFF-2**14,{A0}+oPBDAT		; RTS3/PB14 = 0
	Ret

;--------\
; RcvSCC3 >
;========/
; In:	A0.32	^DPRBAse
;	A4.32	^Buffer rception
;	D4.16	Longueur des Data
; Out:	-
; Mod:	-

RcvSCC3:
	Move.32	#{A0}+oSCC3RxBD,a2		;a2 = adresse du debut des descript. de buffer SCC1 en reception
	move.32	A4,{A2}+ooBDPntBuf		;pointe dbut Buffer Rx RAM Externe
	move.16	#0,{A2}+ooBDDataLength		;Remplit par Quicc
	move.16	#2'1011000000000000,{A2}+ooBDStCtrl	;Status et controle
;		   | ||  |(1)Continuous Mode        
;		   | ||RxB or RxF activated can performed Interrupt         
;		   | |Wrap and last BD         
;		   |Empty and Free
	Ret
	
	.end

