	.Title	Spy_scc.asm


; Rception des paquets Z
; Et affichage des paquets reus


	.proc	m68020
;	.procset m68040
	.start	start
	.ref	Smaky
	.Ref	BiosDriv.ref

SM8		=	False
SM100		=	False
SM130		=	True		; Assemblage pour Smaky 130
SM196		=	False
SM300		=	False
SM324		=	False
SM400		=	False
COS20		=	False
COS21		=	False
co2		=	False
SM070		=	False
SmM4k		=	False
SM100MUB	=	FALSE	; OK
SM8MUB		=	sm8	; OK
 SM8mubmod	=	TRUE.AND.sm8mub
 sm8mubnomod	=	.NOT.sm8mubmod.AND.sm8mub
SM324_MUB100	=	FALSE

ModSup	=	true
debaff	=	False
L	=	0
ad_low	=	0
ad_High	=	1

	.ins	Tst_Ref.asi
.if	Sm400
	.ref	Quicc.ref
	.ref	Quicc_reg.ref
.endif
	.ins	Z_erreur.asi

pccode		=	0
pc_code		=	0
pcvar		=	1
pc_var		=	1
pcdef		=	2
pc_record	=	2

VerSCC		=	True
VerQuicc	=	False
ZNETEXT		=	False

.if	Sm400
IOFZ	=	16'400+16'2000
.else
	.IF	SM300
	IOFZ		=	16'500+16'2000
	.ELSE
	iofZ		=	16'7*16'100+16'2000
	.ENDIF	SM300
.endif	Sm400

iofMax	=	16'2700

SDLCFLAG	=	16'7E

	.ins	Z_DefInt.asi
	.ins	Z_PAQUET.ASI
	.ins	Zt_DESCATT.ASI
	.ins	Z_Macro.asi
	.ins	Macros.asi
	.ins	MDebug.asi

	.MACRO	mfifofempt
	.endmacro

	.MACRO	mfifofnoempt
	.endmacro

; 0.0	RB	98/02/25	Dbut du programme de test
; 0.0	RB 	98/06/30	Reprise en main (maison)
;		98/07/14



MBAR	=	16'3FF00	; Adresse de MBAR 
Mode250kbits	=	0	; 1 pour 250 kbits/s
Mode1Mbits	=	1	;

NbBDRxSCC3	=	100	; Nbr de BD Rception pour SCC3
NbBDTxSCC3	=	10	; Nbr de BD Emission pour SCC3

LgBufRxMax	=	(LMaxRcv+3)/4*4			; car buffer doit tre multiple de 4!
ValAck		=	16'AA	; Valeur de l'Ack0

LgFileName	=	100	

; Zone en mmoire interne pour descripteurs de Buffer SCC
	.ins	zt_varglob.asi
;;OPntDebBufRcv:	.blk.32	1		; ^Buffer de rception absolu
;;oPntBufRcv:	.blk.32	1		; ^Buffer de rception
;;oFIFOFree:	.blk.32	1		; ^FifoFree
OFIFORECU:	.blk.32	1		; FIFOReu
oCntRcv:	.blk.32	1		; nbr paquet reus
;;oDriverName:	.blk.8	1
.even

oChFile:	.blk.16	1		; Canal fichier
oChDis:		.blk.16	1		; Canal affichage
oBufSndAck0:	.blk.8	2		; Buffer mission Ack0
;;oFlag0:		.blk.8	1
;; bTraAck0	=	3
;;oFlagglo:	.blk.8	1
;;BFIFOFREEEMPTY	=	0
.even
oBufFileName:	.blk.8	LgFileName	; Nom fichier pour debug

LgVarTot	=	APC

	.loc	0

.if	VerQuicc
oSCC3RxBD:	.blk.8	NbBDRxSCC3*LgBD	; Place pour BD Rception
oSCC3TxBD:	.blk.8	NbBDTxSCC3*LgBD	; Place pour BD Emission
oSCC3TxBDAck0:	.blk.8	LgBD		; BD Ack0

; SCCE, SCCM:
bRxB	=	0	; Receive Buffer, but not complete
bTxB	=	1	; Transmit Buffer
bBsy	=	2	; Frame received discarded, lack of Frame
bRxF	=	3	; Frame Received
bTxE	=	4	; Transmit error (CTS lost)
bGRA	=	7	; graceful Stop Complete
bIDL	=	8	; Change on state Line
bFlg	=	9	; Flag received
bDCC	=	10	; DPLL CS Change
bGlt	=	11	; Glitch on Tx
bGlr	=	12	; Glitch on Rx
.endif

	.loc	0

	.ins	zt_param.asi

	;-----------------\\
	;  CALLSUPERVISOR  >
	;=================/
	
	; Appelle une routine en mode superviseur. La routine doit se
	; terminer par RETSF. Elle reoit tous les registres inchangs
	; en entre, mis  part D7.16 qui est mis  zro.
	
	; in	A5.32	^routine  appeler
	;	+ selon routine
	; out	D7.16	toujours 0, sauf si la routine modifie D7
	;	+ selon routine
	; mod	D7.16

Start:
	LIB	?OPELIB
	Move.32	#LgVarTot,D4
	Move.32	#MTypCp,D1
	Gesmem	?GetMem
	Jump,ne	fin$
	Gesmem	?ClearMem
	Move.32	A4,A6		; ^Variables Globales

	LIB	?aftim
	.ascize	"Dbut<CR>"
.if	0
	Move.32	#R16^Prog,A5	; ^routine -> programme
	NTREL	?CALLSUPERVISOR	; et l'excute en mode superviseur
.else
	Sup
	Call	Prog
	User
.endif

	Move.32	A6,A4
	Move.32	#MTypCp,D1
	Gesmem	?GivMem
fin$:
	LIB	?CLOLIB
	Fos	?stop


;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Accs en mode Superviseur
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; Ncessaire pour debug avec ADB
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Prog:
; Met accs zone RAM interne en mode utilisateur autoris: MBAR modifi
; Il faut tre en mode superviseur pour le faire

	Call	Suite

	lib	?aftim
	.ascize	"<CR>Bye "

	lib	?getcar
	retsf


;!!!!!!!!!!!!!!!!!!!!!!!!!!
;; Accs Mode User possible -> NON NON NON,
;; certains registres QUICC ne sont accessibles qu'en mode Superviseur !!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!
; In:	D4.32	MBAR
; Dans la routine A5.32 contient l'adresse de base de la mmoire interne du Quick

Suite:
	Move.32	#R16^Command,A2		; ^Commande
	Call	MReset
;
; Se prpare  recevoir
LoopRcv$:
	Lib	?Getcar
;;	Call	WaitRcvSCC3
	nop
	Call	AffBufRcv
	nop
	Ret

Command:.8	0,0
	.even


; In:	A5.32	^Quicc
; Affiche dans un fichier dont le nom est demand

AffBufRcv:
	Pushm.32	A1..A3|D3..D4|D6
	Clr.16	{A6}+oChDis
	Clr.16	{A6}+oChFile
	lib	?aftim
	.ascize	"Fichier pour sauvetage:"

	Move.32	#{A6}+oBufFileName,A3
	Move.16	#LgFileName,D3
	Lib	?Getline

	Move.32	#2**BOpWr+2**bOpRd+2**bOpExtend+2**bOpCreate,D3
	FOS	?Argsopen
	Jump,ne	s$
	Move.16	D6,{A6}+oChFile

	Lib	?GChDis
	Move.16	d6,{A6}+oChDis

	Move.16	{A6}+oChFile,D6
	Lib	?PChDis				; Lib -> Fichier

s$:
	Move.16	#0,D2
l$:
	Lib	?ifcar
	jump,eq	s1$
	comp.8	#end,d3
	jump,eq	fin$
s1$:
	Move.32	{A6}+oCntRcv,D6
	Jump,eq	l$
LIRx$:
	Move.32	{A6}+oFIFORECU,a0
	Call	RdFIFO
	Jump,ne	LIRx$		; rien attend
	Move.32	D0,A0		;pointe dbut Buffer
	Move.16	{A0}-4,D0	;Longueur reue
	Move.16	{a0}-2,D1	;Status et controle
;	Clr.32	D2		;offset

	Call	AfLigne
l2$:
	Lib	?ifcar
	jump,eq	s2$
	comp.8	#end,d3
	jump,eq	fin$
s2$:
	inc.16	d2
	comp.16	#NMaxBloc-1,D2
	Jump,lo	LIRx$
Fin$:
	Move.16	{A6}+oChDis,D6
	Jump,eq	sf$
	Lib	?PChDis				; Lib -> Fichier
sf$:
	Move.16	{A6}+oChFile,D6
	Jump,eq	f$
	FOS	?Close
f$:
	Popm.32	A1..A3|D3..D4|D6
	ret


; In:	A0.32	ooBDPntBuf,		;pointe dbut Buffer Rx RAM Externe
;	D0.16	ooBDDataLength,D0	;Remplit par Quicc
;	D1.16	ooBDStCtrl,D1		;Status et controle
;	D2.32	offset

AfLigne:
	push.32	d4
	Lib	?AfCR
	Move.16	d2,d4			; offset descripteur RxD
	Lib	?afx4
	Lib	?AfSpace
	Move.16	d1,d4			; St Ctrl
	Lib	?afx4
	Lib	?AfSpace
	Move.16	d0,d4			; Lg
	Lib	?afx4
	Lib	?AfSpace
	Move.32	A0,d4			; ^Buf
	Lib	?afx8
	Lib	?AfSpace
la$:
	Move.8	{A0+},d4		; ^data
	test.16	d0
	Jump,eq	sa$
	Lib	?afx2
	Lib	?afspace
	dec.16	d0
	Jump	la$
sa$:
	pop.32	d4
	ret

	.ins	Z_RELBUFFRE.ASI
	.ins	Z_FIFO.asi
	.ins	Zt_init.asi

	.ins	IntSccRcv.asi


; Pour relBufFree

RelBufEth:
	ret

