; $bin: Z
	.TITLE	Z_710.asd

;; Pour Z version > 7.14 pour Sm400:
; Modif Hard sur connecteur J13:
; Mettre 2 transistor nMos (type BS170)
; Gate sur PC2 et R pullup de 10k
; Source sur Gnd
; Drain T1 sur RTS3*
; Drain T2 sur CD3*
;
;********************************************
; ?ASCOND actif			pour nom FZ
;********************************************
; ?ASCOND inactif		pour nom Z
;********************************************

;.IF	.NOT..DEFINED.EtherZ
EtherZ		=	FALSE
;.ENDIF

ZNETEXT		=	FALSE		; Module sur Mubus (fonctionnement  vrifier)
NameZE		=	EtherZ ;true	; Nom pour Z sur Ethernet
NameFZ		=	?ascond		; TRUE permet de nommer le pilote FZ (pour test)
NameFZE		=	ZNETEXT		
Tr8530		=	false		; version qui tourne avec le SCC 8530
Only85230	=	false.OR..NOT.Tr8530	; Test pour le 85230/85130 seulement effectu

assmile		=	false
astest		=	false 	;	; version avec programme de test en fin de driver
TestFZ		=	FALSE		; true 85130 ou 85230 seulement (et ne fonctionne pas!!)
ModSup		=	true ;.NOT.(astest.or.assmile)

NoPilote	==	16'56		; Z
.if	NameFZ.or.NameZE
NoPilote	==	16'5C
.endif	NameFZ
.if	NameFZE
NoPilote	==	16'55
.endif	NameFZE

;  rajouter dans Fos.ref
; Dfinitions pour la diffusion

SIMULT		=	TRUE		; pour que la simultanit soit utilise
BDiff		=	15		; diffusion accepte sur ce port et seulement diffusion
BOnlyDiff	=	14		; seulement la diffusion accepte
bSimul		=	7		; simultanit possible
AddDiff		=	-1		; adresse station diffusion


; RB		860320	Essai pour voir erreur 8934 8984
; RB 4.1	860523	Erreur trouve, BLEND pas correctement gr niveau 1
; RB 4.4	860526	Modif OPELOC, CLOLOC, demande de mmoire dans un FIFO
; Petite modif dans l'criture du FIFO de debug: plus de bit 2**7 actif
; RB 4.5	860529	Accs station locale permis
; RB 4.6	860718	Version mubus rajoute
; RB 4.7	860805	plus d'ASCOND?, enlev les indicateurs (if)
;		860806	
;		860815	test mubus 8 + ZM si mubus sur sm100
; RB 4.8	860819	gros bug trouv avec UIC (refaire ILDRM)
;		860820	bug pour mubus trouv: mauvaise adresse SCCACOM!!
;			DEL100 doit tre rallong pour SM8!!!!
; RB 4.9	860916	On va essaier de prendre moins de mmoire
; RB 4.10	861006	Et si on remettait les indicateurs seulement dans fentre 1
; 		861007	Bug dans actrcvblk A0 ne ^pas sur global data
; RB 4.11	861010	Modification du nombre de ressai (diminution)
;
; Bug  trouver comment dbloquer un deadlock survenant lorsque le serveur attend un 
; bloc d'une station au milieu d'un message, et que le client se plante
; Essai avec un compteur d'erreur 8933  la rception pour chaque port
; Il est initialis lorsque l'on rentre dans RCVABLK
;
; RB 4.12	861016	Dplacement #r16^var0,A0 dans M0read et m0write + time out diffrents
; RB 4.13	861218	Adjonction Ext SM324 sur Mubus SM100
; RB 4.14	870211	Enlve ICLISR dans routine d'interruption (problme d'interrupt !!)

; RB 5.0	870612	VERSION POUR SM324
; RB 5.01	870721	Accs SCC 1,7 us recovery time -> nop, rr.8 #8,D0  4fois
;			L'instruction: RR.8 #8, d0 ne modifie pas le registre et possde peu
;			de diffrences entre le best (5 clk) et le worst case (8 clk)11
; RB 5.02	870723	Modification de valeur de boucle active pour envoi CRC+Flag (pour 324)
; RB 5.03	870724	IOF niveau 7 lors de l'accs SCC pour registres de commande
; RB 5.04	870803	Modif numro de regnration (pas termin!!)
; RB 5.05	870819	TRADUCTION CALM3 -> CALM
;			+ IOF niveau 7 routines d'interruption (essai pour voir si blocage provient de l!!)
; RB 5.06	870824	enlever dans initinterrupt l'initialisation du vecteur d'interrupt
; RB 5.07	870826	mettre numro regnration sans les tester, comme avant ;; devant nouvelle version  tester
; RB 5.08	870828	modification macro de debug + indicateur SM324
; RB 5.09	870910	modification accs FIFO, il faut se mettre IOF pour lecture ou criture multiple
; RB 5.10	870914	modification indicateur activit
; RB 5.11	870924	compteur message rendu dans M0READ
; RB 5.12	870930	vrif gnrale, test longueur paquet routine interruption + validit port
;			le CRC n'tait pas test correctement car bit masqu
; RB 5.13	871005	bug dans indicateur fifofreefull dans routine interruption !! merci DD
;			+ indicateur suive avec sm100 IOF !!!
; RB 5.14	871008	rajout de ?WAITEV en cas de sortie de l'attente d'un bloc par time out et 
;			qu'il soit arriv entre temps
; RB 5.15	871009	grosse amlioration de la dure de vie du serveur avec 5.14
;			reprise des routine de gestion de FIFO dans le driver accs .32 uniquement
;			LOCK-UNLOCK remplac par compteur + WAITEV-SIGNEV
;			paramtrage selon serveur ou client, selon paramtre "S" lors de l'install
; RB 5.16	871011	compteurs un peu partout pouvant tre lu par ?RSTATUS
;			les compteurs sont de deux types: globaux, ou locaux  chaque port
;			ils sont spars pour l'mission et la rception
;			il faut assembler le driver avec table des symboles pour STATUSZNET
; RB 5.17	871012	testterm dans M0reset
; RB 5.18	871013	Un cas de blocage trouv: Une interruption TRANSMIT Buffer Empty arrive
;			le driver n'enlve pas la source de l'interruption et on boucle indfiniment!!!
;			Pourquoi? cette interruption arrive-t-elle ?? car elle est normalement masque
;			Remde: envoyer la commande Reset Tx int pending et remasquer cette interruption
;			Pour le sm100 on n'tait pas IOF pour l'accs au 8530 
;			<adresse regitre>-<donne registre>, si une interruption arrivait entre:
;			move.8	#reg05, sznet
;						<- interruption, commutation dans Z et accs SZNET
;			move.8	#DESRTSDTR,SZNET	devient acs pour spcifier registre  atteindre
;				#16'69			-> accs registre 1
;			move.8	#reg15, sznet		-> enable Txint et le blocage peut avoir lieu !!
;				#16'F
; RB 5.19	871014	autre erreur trouve le buffer rception n'est pas rendu dans le cas
;			o une erreur globale sur le paquet est arrive!!
; RB 5.20	871019	32^_IPOPRETSF pour sm100
; RB 5.21	871209	Version identique pour BOOT Sm100 et Sm324 (pas complet!!)
; RB 5.22	880215	Essaie moins souvent d'envoyer un bloc de donne si portBoot (2)
; RB 5.23	880217	Modifie NMAXBLOC et MAXTRY
; RB 5.25	880224	Modifie les paramtres pour le serveur
; RB 5.26	880309	Bug dans RESET: en cas d'erreur de paramtres faisait un appel LIB
; RB 5.27	880314
; RB 5.28	880315	modif ^var globales -> A6,
;			envoi noack routine d'interrupt si port n'attend rien
; RB 5.29	880712	enlve noack routine interruption (reprise routine interruption 5.26)
;			modification pour sm8mod
; RB 5.30	880712	modification pour nouveau NTR !!! 
;			attention incompatible avec ancien FOS <5.8 et NTR <4.50
; RB 5.31	880714	lecture de la source d'interruption par registre 3 dans routine d'interruption
;			les SCC version 8 MHz n'accepte pas de tourner sur SM100 avec module piggy-back
;			il faut y mettre une pull-up sur INTACK (pin 8) et couper la liaison avec la pal
; RB 5.32	880817	Adaptation pour systme Costronic
; RB 5.32a	880823	Bug WAITxxx, manque "if co2"
; RB 5.33	880925	Reprise 5.29b et copie ici, nouvelle variable d'assemblage conditionnel
;			newntr = true pour version en rom!!
; RB 5.34	880925	avorte par commande depuis cle
;			commande:
;			   - A[noport.B] ; avorte le port: noport
;			   - S		 ; dbloque smaphore d'attente mission routine d'interruption
;			   - T		 ; dbloque attente sur smaphore d'mission
; RB 5.35	880929	KILL effectue avort des ports avant de se tuer
; RB 5.36	881017
; RB 5.37	881020	Modifie paramtres pour serveur selon essais effectuer  la salle tudiants
; RB 5.38	890227	L'erreur RCVMFOS 8935 : ERMNQB semble ne pas tre une erreur -> modification
;			dans RCVABLK du traitement MNQBL$
;			changement des paramtres clients
;
; RB 5.39		Version non optimise
; RB 5.40		Remplacement de _ISIGNAL par _ISIGNEV dans la rout int SM8
; RB 5.41	890808	Essai Z_1 avec recopie de l'entte
; JFG		???	Adaptation S196
; JFG		8912xx	Adaptation pour 070
; RB 5.44	900109	Test pour faire fonctionner 070 (MARCHE PAS)
; RB 5.45	900115	ET POUR LE 196?
; RB 5.46	900115	rajoute dlai avant d'envoyer l'ack au tout bas niveau
;			car le 196 n'est pas fiable pour le dlai actif (20% de diffrence)
; RB 5.47	900116	enlve del20ms qui ne sert  rien
; RB 5.48	900417	dlais sous forme de variables
;			adaptation pour sm196, initialisation vecteur d'interruption
;			appel pour nombre de reset sur le systme
; RB 5.48e	911015	Met  jour avec modif de -> 5.52
;
; RB 5.60	911024	Dcoupe en .INS
; RB 5.61	920107	UN JOUR DE MALADIE BIENVENUE -> WAITLOWACKF250 POUR SM324 = 70 !!!
;			MET LE .INS Z_Prog_tst.asi en fin de driver pour les tests directs
;			LGRCV -> LgDescPort
;			Gestion des ports sans ALLPORT.ASI
;			BDiffusion ( terminer)
; RB		920205	Enlve ALLPORT
; RB		920526	Version fonctionnant  1 Mbit/s, essai  Computer 92 sur S300
;		....	Implmentation de la diffusion mission et routines d'interruption,  terminer
; RB 5.62	920726	S130 fonctionne  1Mbit/s avec 85230
;			Machines testes S324, S300 et S130. Il reste le S196
;		920806	Suite de l'implmentation de la diffusion, partie rception
; RB 5.70	920930	Essai pour pouvoir dsinstaller le pilote (a n'y est pas encore)
;			option Tr8530 pour assemblage possible pour 8530
;			test du circuit employ, si FZ -> 8530 donne une erreur
;		921004	FZE pour carte extension Sm196
; ***			un segment peut avoir une longueur nulle
; RB 5.71	921009	RCVBLK_RDFIFO parfois un signev est effectu sans rien dans le FIFO
;			-> reboucle ll$
;			En cas de rception d'un ACk ERMNQ en rception -> sort
;			en mission l'ack refait remmettre le tout
; RB 5.72	921012	Essai de rendre le pilote deinstallable avec un compteur d'accs global: {a6}+oCntAccess
;			+ un FLAGGLO:#BDeInstall
; RB 5.73	921017	Dans RCVBLK, si RDFIFO indique qu'il est vide -> attend  nouveau sur smaphore OSRCVDATA !!
;			il serait nanmoins intressant de trouver le pourquoi du problme
; RB 5.74	921025 921028
;		1)	Il semblerait que ce soit  cause de la nouvelle gestion des ports lors de l'OPEN-CLOSE
;			en  effet lors du close, les blocs en attente sont retirs du fifo du port
;			et placs dans le buffer des bloc libres. Si une commutation de tache a lieu entre le RDFIFO
;			et le WAITEV et que le port est rattribu, et qu'une lecture est effectue avec un bloc double
;			renvoy par l'metteur distant, le problme de 5.73 est possible ! ouf !
;			Solution: mettre un smaphore d'accs sur l'OPEN et le CLOSE
;			et test avant de fermer un port que personne ne s'y trouve (READ ou WRITE)
;		2)	Le test du circuit 8530/85130 pour les diverses actions effectues est sauv dans une 
;			variable globale oSCC. Selon cette variables les quelques instructions diffrentes sont 
;			excutes
; RB 5.75	921130	Modification dans le timeout de rception qui n'tait pas utilis !!
;			La DIFFUSION fonctionne
;**********************************************************************
; RB 6xx	??	Versions intermdiaires ne fonctionnant pas -> abandonn
;**********************************************************************
; Remaniement du pilote pour permettre de passer par Ethernet avec le protocole Z
; 1) Le pilote ETH est utilis pour permettre le transport des paquets directement,
;    un protocole non assign est utilis pour les besoins.
; 2) Dans un futur plus ou moins proche, le piulote devrait pouvoir utiliser TCP/IP 
;    pour le transport de ces paquets
;
; RB 7.00	940329	Dcoupe du pilote en plusieurs fichiers -> extraire ce qui est dpendant
;                       du bas niveau
;
; RB 7.02	940415	Processus fils de rception (CHILDTASK.asi) 
; RB 7.03	940418	En cas de rebouclement d'attente, remet les 
;			description de ce qui est fournit en entre S0READ
;			oEntRcvAtt: .blk.8 LgEEnt en plus dans les var
;			de l'accs
; RB 7.04	940421	Nom ZE pour ethernet
; DM 7.05	950121	Affichage de l'activit par SMA_SMAKY.
;			Corrig boulette dans Z_DRIVER qui faisait que Z pour
;			 Ethernet n'avait pas le bon nom de pilote.
; RB 7.06	950406	Assemblage conditionel avec SIMULT activ
; RB 7.07	960116	Commandes supplmentaires pour Time-out
; RB+PA 7.08	960425	Dans CreateTask, modif mode de cration Proc. fils
; PA 7.09	970404	Version de service, utilise D4:#BCBOPEN pour ?CREBAR (InitActExt)
;			Utilise LTIASYNC.REF plutt que ASYNC.REF (problmes avec l'autre
;			fichier ASYNC.REF utilis par DR et $AUDIO).
; RB 7.10	971231	Adaptation pour Sm400 avec 68360 QUICC
;		980803	Reprise pour adaptation Sm400 (enfin!)
;		980803	z.asd
;		980803	Z_Ref.ASI
;		980803	Z_Ident.ASI
;		980803	Z_DefInt.ASI	peut-tre  complter !
;		980803	Z_Parametre.ASI	rien de modifi
;		980803	Z_Erreur.ASI	rien de modifi
;
;		980803	Z_Merr.ASI	rien de modifi
;		980803	Z_Paquet.ASI	rien de modifi
;		980803	Z_DescAtt.ASI	LMaxRcv align.32 pour Quicc
;		980803	Z_VarLoc.ASI	.even sur partie entte, rien de modifi
;		980803	Z_VarPort.ASI	rien de modifi
;		980803	Z_VarGlob.ASI	oAdQuicc
;		980803	MDebug.ASI	rien de modifi
;		980803	Z_macro.ASI	MIofZ pour Sm400
;		980803	MACROS.ASI	rien de modifi
;
;		980803	Z_Driver.ASI	rien de modifi
;	
;		980803	ZHearts.ASI	rien de modifi	; +++ JMP
;		980803	Z_ResetKill.ASI	extrait appel processus fils
;					extrait SCC, ajoute QUICC
;					.INS	InHardSCC.ASI
;					.INS	InHardQUICC.ASI
;		980803	Z_OpenClose.ASI	rien de modifi (orthographe)
;		980803	Z_CommandSt.ASI	MV[250.w] ou MV[1000.w] (defaut) pour choix vitesse
;		980803	Z_Avort.ASI	rien de modifi
;		980803	Z_Write.ASI	rien de modifi
;		980803	Z_Read.ASI	rien de modifi
;		980803	Z_GVarLoc.ASI	rien de modifi
;	
;		980803	Z_SndABlk.ASI	rien de modifi
;		980803	Z_RcvABlk.ASI	rien de modifi
;
;		980803	Z_SndBlk.ASI	Coup avec 3 fichiers supplmentaires:
;		980803	 Z_SndSCC.asi	Pour Z avec SCC
;**			 Z_SndQuicc.asi	Pour Z avec Quicc, A modifier
;			 Z_SndDrExt.asi	Pour Z Externe (ETH, ZUSART)
;
;		980803	Z_RcvBlk.ASI	rien de modifi (tab)
;**		980803	Z_RelBufFre.ASI	A modifier
;		980803	Z_BIOS.ASI	rien de modifi
;		980803	Z_MiscChild.ASI	-- > New from Z_ResetKill.ASI <--
;		980803	Z_CHILDTASK.ASI	rien de modifi
;
;		980803	Z_Int574.ASI	rien de modifi, interruption pour SCC
;**		980803	Z_IntQuicc.asi	interruption pour Quicc

;	Z_Rdebug.ASI	???
;		980803	Z_FIFO.ASI	rien de modifi
;		980803	Z_Prog_tst.ASI	rien de modifi
;
; (PA 7.10	971124	Version avec SIMULT optionnel (nouvelle commande))
; RB 7.11	980824	Remis les modifs de PA (SIMULT) dans cette version
; RB 7.12	980825	Rajout des commandes de modif des attentes Ack0 dans Z_INT712.asi pour SCC
; RB 7.13	980831	Modif en cas d'erreur QUICC dans INTQUICC.asi
; RB 7.14	980902	Ncessite modif Hard sur commande au dmarrage des lignes RTS3* et CD3*
; PA 7.15	010613	Installation avec '!' poubellise les ack contenant des erreurs
;
;**********************************************************************
;		 Driver Rseau Z pour SM8 et SM100
;		**********************************
;	 Conforme aux dfinitions driver rseau du PSOS
;
;	1re rvision Daniel Roux  Epsitec System SA	83/84 NANET
;	2me rvision Ren Beuchat LAMI			85    NANET
;	3me rvision Ren Beuchat			85/12 NANET
;	     Modification pour utilisation circuit SCC	86/01 Z
;	5me rvision Ren Beuchat version 324		87/06 Z
;	5.60++  phase de mise en place FZ et diffusion	92
;	6me rvision Ren Beuchat 			90/91 abandonn !!
;	7me rvision Ren Beuchat 			94
;	7.10++	adaptation Sm400/Quicc	RB		98
;**********************************************************************
;
NREV	=	7
NVER	=	15
; 
; Amlioration 2me rvision par rapport 1re: le driver fonctionne
; et ne perd plus de caractres, ni n'en duplifie
; Par contre le driver est devenu plus lent car le protocole 
; est devenu plus complexe
;
; 3me rvision utilise des FIFO et des buffers de rception pour
; accrotre la vitesse de rception des paquets et diminuer le
; nombre de smaphores. Cette 3me rvision sera compatible
; avec le nouveau rseau utilisant le circuit SCC de Zilog
;
; 4me rvision utilise le circuit SCC de Zilog
;
; 5me rvision pour adaptation SM324 et autres nouveau Smaky
; 6me rvision essaie d'utiliser des listes chanes pas concluant abandonn
; 7me rvision pour dcoupage de Z

	.BASE	10'10
	.LAYOUT HEX
	.LAYOUT	LENGTH	0

NTREL?DBLPSEM	=	16'4E44003D
 _IPOPRETSF	=	16'1122		; Appel shi
 _ISIGNEV	=	16'1126		; Appel shi

BIOS?SEADRIV	=	16'4E440020
ODTYPE		=	16'FFFFFFDB



TstMubus	=	false
WrMubus		=	false ;TRUE
 ER	=	0				; Erreurs
 DelS	=	1				; Mubus + 1: Attente avant Ack DelSndAck
 DelRA	=	2				; DelWaitLowAck F (1) et N (3)

NewCoeur	==	true

.if	.not.(assmile.or.astest)
	.INS	TESTMACHINE.ASI

SM100MUB	=	FALSE	; OK
SM8MUB		=	sm8	; OK
 SM8mubmod	=	TRUE.AND.sm8mub
 sm8mubnomod	=	.NOT.sm8mubmod.AND.sm8mub
SM324_MUB100	=	FALSE

.else

SM100		=	FALSE	; OK		; VERSION Smaky 8/100, mubus
SM100MUB	=	FALSE	; OK

SM8		=	FALSE
SM8MUB		=	sm8	; OK
 SM8mubmod	=	TRUE.AND.sm8mub
 sm8mubnomod	=	.NOT.sm8mubmod.AND.sm8mub

SM400		=	true
SM324_MUB100	=	FALSE
SM324		=	false
SM196		=	FALSE
SM300		=	FALSE
SM130		=	FALSE
SM070		=	FALSE
SmM4k		=	False	; Pas implment
co2		=	FALSE
.endif

; Version SCC ou Quicc (68360)
.if	Sm400
VerQuicc	=	True
VerSCC		=	False	
.else
VerQuicc	=	False
VerSCC		=	True
.endif	Sm400

	
.IF	SM400
	.PROC	M68020
	.PROCSET M68040
.ELSE
	.IF	SM130.or.sm196.or.sm300
; @DM 21/1/95 : 68030F est bugg !
;!!!		.PROC	M68030F
		.PROC	M68020
		.PROCSET M68030
	.ELSE
		.if	sm324
			.PROC	M68020
		.else
			.PROC	M68000
		.ENDIF
	.endif
.ENDIF	Sm400

.if	Sm400
IOFZ	=	16'500+16'2000		;pour tre sur > IOF NTRL
.else
	.IF	SM300
	IOFZ		=	16'500+16'2000
	.ELSE
	iofZ		=	16'700+16'2000
	.ENDIF	SM300
.endif	Sm400

iofMax	=	16'2700

TSTINT		=	TRUE.AND.(SM100.OR.SM8)		; Pour version piggy back avec version 8 MHz SCC 
							; n'accepte pas INTA puls !
HeartsExt	=	TRUE.AND.(Sm130.OR.Sm300.OR.Sm400)		; coeurs affichs par programme externe

; Debug
;------

DEBAFF	=	false ;true			; Macro debug
DEBECR	=	false ;true			; Ecrit dans l'cran
DEBBUF	=	true			; Ecrit dans buffer

LGBUFDEB=	10'40*10'1024		; Buffer pour debug

pccode		=	0
pc_code		=	0
pcvar		=	1
pc_var		=	1
pcdef		=	2
pc_record	=	2

SERVEUR	=	0

.if	sm324.or.sm100.OR.sm8mubmod.or.sm196.or.sm300.or.sm130.or.Sm400
INDIC	=	TRUE
.else
INDIC	=	FALSE
.endif

	.REV	NREV,NVER

	.INS	Z_Ref.ASI

	.REF	LTIASYNC.REF

.if	astest.or.assmile
MTypMem		=	MTYPCP
.else
MTypMem		=	MTypBD
.endif

	.INS	Z_Ident.ASI
	.INS	Z_DefInt.ASI
	
; Dfinitions
; -----------

AD_LOW	=	0		; Offset adresse poids faible en mmoire (format Zilog + STI)
 L	=	ad_low
AD_HIGH	=	1		; Offset poids fort
 H	=	ad_high

PRIOSEM	=	4			; priorit d'accs smaphore
DRPRIO	=	PRIOSEM+1		; priorit du driver NET

MAPORT	=	16'60F0			; ^bitmap des ports

;TYPDACK=	1			; bloc de data suivit d'un ack
;TYPACK =	2			; bloc d'ack (aprs bloc data)
;TYPDATA=	3			; bloc de data sans ack

.if	.not.(sm196.or.sm300.or.sm130.or.Sm400)
REGEN		=	16'200-8-6	; Position mmoire absolue pour numro regnration
.endif

; Dfinitions diverses
;---------------------

SDLCFLAG=	2'01111110		; Flag SDLC
VALACK	=	16'AA			; Code de l'ack tout tout bas niveau
ADRGLOB	=	0*(2**(8*ad_low))	; Adresse globale de rception

	.INS	Z_Parametre.ASI
	.INS	Z_Erreur.ASI

	.INS	Z_Merr.ASI
	.INS	Z_Paquet.ASI
	.INS	Z_DescAtt.ASI
	.INS	Z_VarLoc.ASI
	.INS	Z_VarPort.ASI
	.INS	Z_VarGlob.ASI
	.INS	MDebug.ASI
	.INS	Z_macro.ASI
	.INS	MACROS.ASI

	.INS	Z_Driver.ASI
	
	.INS	ZHearts.ASI			; +++ JMP
	.INS	Z_ResetKill.ASI
	.INS	Z_OpenClose.ASI
	.INS	Z_CommandSt.ASI
	.INS	Z_Avort.ASI
	.INS	Z_Write.ASI
	.INS	Z_Read.ASI
	.INS	Z_GVarLoc.ASI
	
	.INS	Z_SndABlk.ASI
	.INS	Z_RcvABlk.ASI

	.INS	Z_SndBlk.ASI
.if	VerSCC
	.INS	Z_SndSCC.asi
.endif	VerSCC
.if	VerQuicc
	.INS	Z_SndQuicc.asi
.endif	VerQuicc
	.INS	Z_SndDrExt.asi
	.INS	Z_BIOS.ASI

	.INS	Z_RcvBlk.ASI
	.INS	Z_RelBufFre.ASI
	.INS	Z_MiscChild.ASI		; 7.10, enlev de ResetKill.asi
	.INS	Z_CHILDTASK.ASI	

.if	VerSCC
	.INS	Z_Int712.ASI
;;	.INS	Z_Int574.ASI		; Traitement de la diffusion dans la routine d'interruption
.endif	VerSCC
.if	VerQuicc
	.INS	Z_IntQuicc.asi
.endif	VerQuicc

;########################################################################################

.IF	DEBAFF.AND.DEBBUF
	.ins	Z_Rdebug.ASI
.ENDIF	DEBAFF.and.DEBBUF

	.INS	Z_FIFO.ASI

; Tables et textes
; ----------------

	.if	assmile.OR.astest
	.ins	Z_Prog_tst.ASI
	.endif

	.END
