
	.TITLE	ZWIN.ASD

	.PROC		M68000
	.BASE		10		; base 10 par defaut
	.LAYOUT		HEX		; listing en hexadecimal

	.REF		SMAKY		; reference generale
	.REF		MON
	.REF		BIOSDRIV
	.REF		COMMREQ


MajRev		=	1		; revision majeure
MinRev		=	1		; revision mineure

; Le programme de test est  excuter sous smile

	.REV		MajRev,MinRev
	.IDENT		"(C) 1999-2000 - Pierre Arnaud & EPSITEC SA"

; -------------------------------------------------------------------------
; 1.1   PA  24/02/00	Priorit promue  '1'
; 1.0	PA  29/09/99	Premier jet de ZWin bas sur ZUSART	
; 0.1	AD  20/04/95	Cration ( partir de la version 1.15 de ETH.ASD)
; -------------------------------------------------------------------------



;*************
; MODE TEST
;*************

DEBUG		= 	true		; commentaires de debug

;**************
; Def APC
;**************

PC_code		=	0
PC_var		=	1
PC_record	=	2

	.APC	PC_code
	.LOC	0
	.APC	PC_var
	.LOC	0
	.APC	PC_record
	.LOC	0

;**************
;  Definitions
;**************

	.INS		ASYNC.ASS	; Insere descripteur structure passage parametres
					; pour le mode asynchronr

	.INS		MACROS.ASI	; macros


PORT_ZWIN	= 10'42
PORT_ZWIN_BACK	= 10'43

PRI_ZWIN	= 10'1

;************************
; Codes Erreur du Driver
;************************

NO_ERR		=	0

;*******************
; Variables driver
;*******************

		.APC	PC_var
		.LOC	0

OReadPBFirst:	.BLK.32	1		; premier PB disponible en lecture
OReadLock:	.BLK.32	1		; smaphore d'accs  la liste OReadPBFirst

OCommBAR:	.BLK.32	1
ORequest1:	.BLK.8	RQ_LEN
ORequest2:	.BLK.8	RQ_LEN
OReplySem1:	.BLK.32 1
OReplySem2:	.BLK.32 1
OCmdSend1:	.BLK.32	2
OCmdSend2:	.BLK.32	1
OCmdRecv1:	.BLK.32	1
OCmdRecv2:	.BLK.32	1
LgVarZone:


;***************************
;* *********************** *
;* *   Debut du DRIVER   * *
;* *********************** *
;***************************


	.APC	PC_CODE


DEBUT:
	.16	10'0,S0BASE	; Pilote 0
	.16	2**7		; fin 1ere indirection



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $zwin_0	No H'5A
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:					; Adresse routines
	.16	S0OPEN-S0BASE
	.16	-1			; S0COMMAND-S0BASE
	.16	-1			; S0STATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"ZWIN_0"		; Nom driver
S0NAF:	.FILL.8 LGDNAM-(S0NAF-S0NAB),0

	.8	16'5A			; Numero driver (mme que $ETH)
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Revision - version -
	.16	0			; - Variante

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDNORT	; Attribut 0
	.FILL.8 LGDDESC-(APC-S0ID), 0	; Le reste.
S0BASE:


;--------\\
; S0RESET >
;========/

; Appelle lors de l'INSTALL 

; in	A2.32	^ligne de parametres d'installation
; out	A6.32	^variables globales du pilote
; mod	-

S0RESET:
	PUSHM.32 D4|D5|A3|A4|A5

	CALL	InitVar				; demande la mmoire, initialise les variables
	JUMP,NE	F$

; initialisation partie LECTURE

	CLR.32	{A6}+OReadPBFirst		; liste vide

	MOVE.32	#1,D4				; smaphore d'exclusion en lecture
	NTREL	?CRESEM
	JUMP,NE	F$
	MOVE.32	A5,{A6}+OReadLock

; initialise la couche de communication

	MOVE.32	#A8^0,D4
	NTREL	?CRESEM				; cre smaphore de communication
	JUMP,NE	F$

	MOVE.32	#{A6}+ORequest1,A4
	MOVE.8	#PRI_ZWIN,{A4}+RQ_PRI
	MOVE.16	#PORT_ZWIN,{A4}+RQ_PORTNO
	MOVE.32	A5,{A4}+RQ_REPLYSEM
	MOVE.32	A5,{A6}+OReplySem1

	MOVE.32	#A8^0,D4
	NTREL	?CRESEM				; cre smaphore de communication
	JUMP,NE	F$

	MOVE.32	#{A6}+ORequest2,A4
	MOVE.8	#PRI_ZWIN,{A4}+RQ_PRI
	MOVE.16	#PORT_ZWIN_BACK,{A4}+RQ_PORTNO
	MOVE.32	A5,{A4}+RQ_REPLYSEM
	MOVE.32	A5,{A6}+OReplySem2

	MOVE.32	#R16^CommBarName,A3
	MOVE.32	#2**BCBOPEN,D4
	NTREL	?CREBAR

	MOVE.32	A5,{A6}+OCommBar

; cre le processus fils

	MOVE.32	#200,D5
	MOVE.32	#R16^ProcFeedback,A5
	MOVE.32	#R16^NameFeedback,A3
	MOVE.32	#4,D4
	NTREL	?CRETASK

	CLR.16	D7

F$:	POPM.32	D4|D5|A3|A4|A5
	TEST.16	D7
	RET



;--------\\
; InitVar >
;========/

; Initialise les variables

; in	-
; out	A6.32	^variables du fichier driver
;	D7.16	erreur
; mod	A6.32, D7.16

InitVar:
	PUSHM.32 D4|A0|A3|A4
	MOVE.32	#R16^DEBUT,A4		; ^base du driver
	MOVE.32	#LgVarZone,D4		; longueur ncessaire
	FOS	?GETCOMMEM		; demande de la mmoire
	MOVE.32	A4,A6			; dans A6
	POPM.32	D4|A0|A3|A4
	TEST.16	D7
	RET


;-------\\
; S0KILL >
;=======/
;
; Appelle lors du DEINSTALL 
;
; in	A6.32	^variables globales du pilote
; out	-
; mod	-

S0KILL:
	MOVE.16	#1,D7
	RET


;-------\\
; S0OPEN >
;=======/

; in	A6.32	^variables globales du pilote
; out	D7.16	Erreur
; mod

S0OPEN:
	CLR.16	D7
	RET


;--------\\
; S0CLOSE >
;========/

; Ferme le driver et supprime la liste des requetes en attente

; in	A6.32	^variables globales du pilote
; out	D7.16	Erreur
; mod

S0CLOSE:
	CLR.16	D7
	RET


;-------\\
; S0READ >
;=======/

; in	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur (ignore)
; out	A4.32	PCB mis a jour
;	D7.16	Erreur
; mod	D7.16

S0READ:
	PUSHM.32 D3|D4

	MOVE.16	#-1,{A4}+OPB_RES		; descripteur utilis

; Il faut maintenant signaler au serveur qu'il y a un lment de plus dans la liste
; du pilote. Aucune attente ne doit tre faite ici...

	MOVE.32	#0,D3				; opration de lecture
	CALL	SendPCB				; envoie le PCB
	JUMP,EQ	R8^Fin$

	MOVE.16	D7,D4
	MON	?AFTIM
	.ASCIZE	"ZWIN/S0READ: Error with SendPCB : D7="
	MON	?AFX4, ?AFCR

Fin$:	POPM.32	D3|D4
	TEST.16	D7
	RET


;--------\\
; S0WRITE >
;========/

; in	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur (ignore)
; out	D7.16	erreur
; mod	D7.16

S0WRITE:
	PUSHM.32 D3|D4|A3..A5

	MOVE.16	#-1,{A4}+OPB_RES		; descripteur utilis

; Il faut envoyer le descripteur  crire au serveur...

	MOVE.32	#1,D3				; opration d'criture
	CALL	SendPCB				; envoie le PCB
	JUMP,NE	R8^Err$				; erreur => abandonne

	move.16	{a4}+opb_res,d4
	comp.16	#-1,d4
	jump,ne	R8^Sig$

	mon	?aftim
	.ascize	"ZWIN/S0Write: OPB_RES=-1<CR>"

Sig$:	MOVE.32	{A4}+OPB_SEMA,A5
	NTREL	?SIGNEV				; signale  Z que le boult a t fait
	JUMP,EQ	R8^Ret$

	MOVE.16	D7,D4
	MON	?AFTIM
	.ASCIZE	"ZWIN/S0WRITE: Error with SIGNEV : D7="
	MON	?AFX4,?AFCR
	JUMP	R8^Ret$

Err$:	MOVE.16	D7,D4
	MON	?AFTIM
	.ASCIZE	"ZWIN/S0WRITE: Error with SendPCB : D7="
	MON	?AFX4, ?AFCR

Ret$:	POPM.32	D3|D4|A3..A5
	TEST.16	D7
	RET


;----------\\
;  SendPCB  >
;==========/

; Envoie un PCB au serveur...

; in	A4.32	^PCB  envoyer
;	D3.32	type de l'opration
; out	-
; mod	D7.16

SendPCB:
	PUSHM.32 D4|A0|A1|A4|A5

	MOVE.32	{A6}+OReadLock,A5
	NTREL	?LOCK
	JUMP,NE	RET$

	MOVE.32	#-1,D4
	NTREL	?MODTIM

	MOVE.32	A4,A1				; ^PCB

	MOVE.32	#{A6}+ORequest1,A4
	MOVE.32	#{A6}+OCmdSend1,A0
	MOVE.32	D3,{A0}+0			; <-- opration
	MOVE.32	A1,{A0}+4			; <-- prend note du PCB
	MOVE.32	#8,{A4}+RQ_SDATALEN
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#{A6}+OCmdRecv1,A0
	MOVE.32	#4,{A4}+RQ_RDATALEN
	MOVE.32	A0,{A4}+RQ_RDATAPTR

	MOVE.32	{A6}+OCommBAR,A5
	NTREL	?OFFERBAR			; envoie la requte au PC
	NTREL	?ENDOFFERBAR

	MOVE.32	{A6}+OReplySem1,A5
	NTREL	?WAITEV				; attend la rponse du PC
	NTREL	?SETTIM

	MOVE.32	{A6}+OReadLock,A5
	NTREL	?UNLOCK

RET$:	POPM.32	D4|A0|A1|A4|A5
	TEST.16	D7
	RET

NameFeedback:
	.ASCIZ	"ZWin.Feedback"
CommBarName:
	.ASCIZ	"#:PCCOMMBAR"
	.EVEN

; Processus de transmission du feed-back (signale celui qui a mis
;  disposition des PCBs dans la liste d'attente en lecture).

ProcFeedback:

	NTREL	?GETMACHINE
	AND.32	#16'00FFFFFF,D4

	MOVE.32	#{A6}+OCmdSend2,A0
	MOVE.32	#{A6}+ORequest2,A4
	MOVE.32	D4,{A0}+0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#4,{A4}+RQ_SDATALEN
	CLR.32	{A4}+RQ_RDATAPTR
	CLR.32	{A4}+RQ_RDATALEN

	MOVE.32	{A6}+OCommBAR,A5
	NTREL	?OFFERBAR			; envoie la requte au PC
	NTREL	?ENDOFFERBAR

	MOVE.32	{A6}+OReplySem2,A5
	NTREL	?WAITEV				; attend la rponse du PC

LOOP$:	MOVE.32	#{A6}+ORequest2,A4
	MOVE.32	#{A6}+OCmdRecv2,A0
	MOVE.32	A0,{A4}+RQ_SDATAPTR
	MOVE.32	#4,{A4}+RQ_SDATALEN
	MOVE.32	A0,{A4}+RQ_RDATAPTR
	MOVE.32	#8,{A4}+RQ_RDATALEN

	MOVE.32	#1,D4
	NTREL	?DELMS

	MOVE.32	{A6}+OCommBAR,A5
	NTREL	?OFFERBAR			; envoie la requte au PC
	NTREL	?ENDOFFERBAR

	MOVE.32	{A6}+OReplySem2,A5
	NTREL	?WAITEV				; attend la rponse du PC

	MOVE.32	{A6}+OCmdRecv2+4,A4		; ^PCB trait par le PC
	MOVE.32	A4,D4				; le PCB est-il valide ?
	JUMP,F	R8^ErPCB$			; non => trange !

	TEST.16	{A4}+OPB_RES			; rsultat = OK ?
	JUMP,EQ	R8^Ok$				; oui => fait le signal sans autre forme de procs

ErPCB$:	MON	?AFTIM
	.ASCIZE	"ZWin.Feedback PCB "
	MOVE.32	A4,D4
	MON	?AFX8
	MON	?AFTIM
	.ASCIZE	" is wrong !<CR>"

Ok$:	MOVE.32	{A6}+OCmdRecv2+0,A5
	NTREL	?SIGNEV				; reu les donnes sur ce smaphore !
	JUMP,EQ	LOOP$

	MON	?AFTIM
	.ASCIZE	"ZWin.Feedback signal error D7="
	MOVE.16	D7,D4
	MON	?AFX4, ?AFCR
	JUMP	LOOP$


	.END

