
	.TITLE	WIN32.ASL

;	----------------------------------------
;		(C) 1998 - Pierre ARNAUD
;	----------------------------------------

REVMAJ	= 0
REVMIN	= 4

;	Date      Rv	Commentaire
;	-------------------------------------------------------------------------------
;	19/05/99  0.4	Nouvelles fonctions pour afficher des dialogues.
;	21/08/98  0.3	Supporte les oprations spciales (commandes pour SMAKY400.EXE).
;	05/05/98  0.2	Ajout fonction SendMail.
;	15/03/98  0.1	Premire version
;	-------------------------------------------------------------------------------


	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	WIN32
	.REF	COMMREQ
	.REF	MON

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C) Copyright 1998-1999, Pierre ARNAUD et EPSITEC SA"
	.START	-1


;	Dfinitions diverses
;	--------------------

	.INS	WIN32DEF.ASI

;	Variables d'un canal
;	--------------------

		.LOC	0

OBARID:		.BLK.32	1			; ID bar de service
OSEMID:		.BLK.32	1			; ID smaphore de synchronisation
OMDESC:		.BLK.32	1			; descripteur mmoire
OMTYP:		.BLK.16	1			; type de mmoire
OPORTNUM:	.BLK.16	1			; numro du port
OREQUEST:	.BLK.8	RQ_LEN			; requte
OCOMMAND:	.BLK.8	LGCMD			; commande
OSTATUS:	.BLK.8	LGSTATUS		; rsultat de la commande
LGVAR:



;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	WIN32_FIRST
	.16	WIN32_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"WIN32"
	.FILL.8	(LGHLIB-APC),0

	.16	_WIN32_CREATE
	.16	_WIN32_KILL
	.16	_WIN32_CLOSE

	.16	_WIN32_PIPECREATE
	.16	_WIN32_PIPECONNECT
	.16	_WIN32_PIPEDISCONNECT

	.16	_WIN32_FILEOPEN
	.16	_WIN32_FILECLOSE
	.16	_WIN32_FILEREAD
	.16	_WIN32_FILEWRITE

	.16	_WIN32_SLOTCREATE

	.16	_WIN32_EXECUTE
	.16	_WIN32_WAITEXECUTE

	.16	_WIN32_SENDMAIL
	.16	_WIN32_SPECIALOP


;---------------\\
;  WIN32_CREATE  >
;===============/

; Cre un nouveau port pour communiquer avec les services Win32.

; in	D1.16	type mmoire
;	A1.32	descripteur mmoire
; out	D5.32	canal
;	D7.16	erreur
; mod	D5.32, D7.16

_WIN32_CREATE:
	PUSHM.32 D3|D4|A0|A1|A3..A6

	MOVE.32	#R16^NMCOMMBAR,A3
	MOVE.32	#2**BCBOPEN,D4
	NTREL	?CREBAR				; ouvre la BAR pour la couche de communication
	JUMP,NE	R8^ERR$

	MOVE.32	#LGVAR,D4
	GESMEM	?GETMEM
	JUMP,NE	R8^ERR$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6

	MOVE.16	D1,{A6}+OMTYP
	MOVE.32	A1,{A6}+OMDESC			; prend note du compte mmoire
	MOVE.32	A5,{A6}+OBARID

	MOVE.32	#0,D4
	NTREL	?CRESEM				; smaphore pour attendre les rponses
	JUMP,NE	R8^ERR$

	MOVE.32	A5,{A6}+OSEMID

; Prpare l'envoi d'une requte...

	CALL	GetCmdStatus

	MOVE.8	#PRI_SYSTEM,{A4}+RQ_PRI		; priorit pour la requte Win32
	MOVE.16	#PORT_NT_REQUEST,{A4}+RQ_PORTNO	; numro de port bien connu...
	MOVE.32	A5,{A4}+RQ_REPLYSEM		; smaphore de synchronisation

	CALL	InitCmdStatus

	MOVE.16	#CMD_NEW_PORT,{A0}+OcmdCMD
	CALL	Transaction			; cre le nouveau port...
	JUMP,NE	R8^ERR$

	MOVE.32	{A1}+OstsID,D5			; numro du port  utiliser par la suite...
	MOVE.8	#PRI_FILE,{A4}+RQ_PRI		; <-- priorit normale
	MOVE.16	D5,{A4}+RQ_PORTNO		; <-- numro du port

	MOVE.16	D5,{A6}+OPORTNUM
	MOVE.32	A6,D5				; "canal"

ERR$:	POPM.32	D3|D4|A0|A1|A3..A6
	TEST.16	D7
	RET



_WIN32_KILL:
	MOVE.16	#1,D7
	RET


;--------------\\
;  WIN32_CLOSE  >
;==============/

; Ferme un canal ouvert au moyen de WIN32_CREATE.

; in	D5.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_WIN32_CLOSE:
	PUSHM.32 D3|D4|A0|A1|A3..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_RELEASE,{A0}+OcmdCMD
	CALL	Transaction
	JUMP,NE	R8^ERR$

	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?KILLSEM

	MOVE.16	{A6}+OMTYP,D1
	MOVE.32	{A6}+OMDESC,A1
	MOVE.32	A6,A4
	GESMEM	?GIVMEM

ERR$:	POPM.32	D3|D4|A0|A1|A3..A6
	TEST.16	D7
	RET


;-------------------\\
;  WIN32_PIPECREATE  >
;===================/

; Cre un "pipe" sur le serveur Win32.

; in	A3.32	^nom du pipe  crer
;	D5.32	canal
; out	D7.16	erreur
; mod	D7.16

_WIN32_PIPECREATE:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus

	MOVE.32	#{A0}+OcmdNAME,A2

COPY$:	MOVE.8	{A3+},{A2+}		; copie le nom du pipe  crer
	JUMP,NE	COPY$

	MOVE.16	#CMD_CREATE,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET


;--------------------\\
;  WIN32_PIPECONNECT  >
;====================/

; Attend la connexion d'un client  notre pipe.

; in	D5.32	canal
; out	D7.16	erreur
; mod	D7.16

_WIN32_PIPECONNECT:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_CONNECT,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET


;-----------------------\\
;  WIN32_PIPEDISCONNECT  >
;=======================/

; Dconnecte tous les clients.

; in	D5.32	canal
; out	D7.16	erreur
; mod	D7.16

_WIN32_PIPEDISCONNECT:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_DISCONNECT,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET


;-----------------\\
;  WIN32_FILEOPEN  >
;=================/

; Ouvre un fichier sur le serveur Win32.

; in	A3.32	^nom du fichier  ouvrir
;	D5.32	canal
; out	D7.16	erreur
; mod	D7.16

_WIN32_FILEOPEN:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus

	MOVE.32	#{A0}+OcmdNAME,A2

COPY$:	MOVE.8	{A3+},{A2+}		; copie le nom du pipe  crer
	JUMP,NE	COPY$

	MOVE.16	#CMD_OPEN,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET


;------------------\\
;  WIN32_FILECLOSE  >
;==================/

; Ferme un fichier.

; in	D5.32	canal
; out	D7.16	erreur
; mod	D7.16

_WIN32_FILECLOSE:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_CLOSE,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET


;-----------------\\
;  WIN32_FILEREAD  >
;=================/

; Lit des donnes.

; in	D5.32	canal
;	A4.32	^buffer
;	D4.32	taille  lire
; out	D7.16	erreur
; mod	D7.16

_WIN32_FILEREAD:
	PUSHM.32 D3|A0..A6

	MOVE.32	D5,A6
	MOVE.32	A4,A3

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_READ,{A0}+OcmdCMD
	MOVE.32	A3,{A0}+OcmdBUFFER
	MOVE.32	D4,{A0}+OcmdLENGTH
	CALL	Transaction

	MOVE.32	{A1}+OstsTRANSFER,D4

	POPM.32	D3|A0..A6
	TEST.16	D7
	RET


;------------------\\
;  WIN32_FILEWRITE  >
;==================/

; Ecrit des donnes.

; in	D5.32	canal
;	A4.32	^buffer
;	D4.32	taille  crire
; out	D7.16	erreur
; mod	D7.16

_WIN32_FILEWRITE:
	PUSHM.32 D3|A0..A6

	MOVE.32	D5,A6
	MOVE.32	A4,A3

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_WRITE,{A0}+OcmdCMD
	MOVE.32	A3,{A0}+OcmdBUFFER
	MOVE.32	D4,{A0}+OcmdLENGTH
	CALL	Transaction

	MOVE.32	{A1}+OstsTRANSFER,D4

	POPM.32	D3|A0..A6
	TEST.16	D7
	RET



_WIN32_SLOTCREATE:
	MOVE.16	#1,D7
	RET


_WIN32_EXECUTE:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus

	MOVE.32	#{A0}+OcmdNAME,A2

COPY$:	MOVE.8	{A3+},{A2+}		; copie le nom du pipe  crer
	JUMP,NE	COPY$

	MOVE.16	#CMD_EXECUTE,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET



_WIN32_WAITEXECUTE:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_WAITEXECUTE,{A0}+OcmdCMD
	CALL	Transaction

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET



_WIN32_SENDMAIL:
	PUSHM.32 D3|D4|A0..A6

	MOVE.32	D5,A6

	PUSH.32	A4
	PUSH.32	D4

	CALL	GetCmdStatus
	CALL	InitCmdStatus

	MOVE.32	#{A0}+OcmdNAME,A2

COPY$:	MOVE.8	{A3+},{A2+}		; copie le nom du pipe  crer
	JUMP,NE	COPY$

	MOVE.16	#CMD_SENDMAIL,{A0}+OcmdCMD
	MOVE.32	{SP}+4,{A0}+OcmdBUFFER
	MOVE.32	{SP}+0,{A0}+OcmdLENGTH
	CALL	Transaction

	ADD.A16	#8,SP

	POPM.32	D3|D4|A0..A6
;	TEST.16	D7
	RET



;------------------\\
;  WIN32_SPECIALOP  >
;==================/

; Opration spciale...

; in	D5.32	canal
;	D3.32	code de l'opration
;	A4.32	^buffer
;	D4.32	taille des donnes
; out	D7.16	erreur
; mod	D7.16

_WIN32_SPECIALOP:
	PUSHM.32 D3|A0..A6

	MOVE.32	D5,A6
	MOVE.32	A4,A3

	CALL	GetCmdStatus
	CALL	InitCmdStatus
	MOVE.16	#CMD_SPECIALOP,{A0}+OcmdCMD
	MOVE.32	A3,{A0}+OcmdBUFFER
	MOVE.32	D4,{A0}+OcmdLENGTH
	MOVE.32	D3,{A0}+OcmdID
	CALL	Transaction

	MOVE.32	{A1}+OstsTRANSFER,D4

	POPM.32	D3|A0..A6
	TEST.16	D7
	RET




	.INS	WIN32UTIL.ASI


NMCOMMBAR:	.ASCIZ	"#:PCCOMMBAR"
		.EVEN

END_MODULE:

	.END

