
	.TITLE	DALLAS.ASM

; Routines de test pour accder au circuit Dallas de mesure de
; temprature et au numro de srie contenu dans sa mmoire non
; volatile. En tout, 24 + 8 bytes non volatiles sont accessibles.

	.loc	0
	.start	start
	.proc	m68020
	.procset m68040
	.ref	smaky
	.ref	mon

REGB360		= 16'0FFF1000		; base of 68360 internal regs

A360PBPAR	= REGB360+16'6BC	; pin assignment reg (.32)
A360PBDIR	= REGB360+16'6B8	; I/O direction (.32)
A360PBODR	= REGB360+16'6C0	; open drain (.32)
A360PBDAT	= REGB360+16'6C4	; data (.32)

start:
	move.32	#r16^sup$,a5
	ntrel	?iep15trp
	trap	#15
	sub.32	a5,a5
	ntrel	?iep15trp
	exit

sup$:	TCLR.8	A360PBPAR+3:#0		; select PB0 as general I/O
	TSET.8	A360PBODR+3:#0		; PB0 is an open drain output

; Active la pulse "RESET"

	PUSH.16	SF
	IOFF
	TCLR.8	A360PBDAT+3:#0		; PB0  zro (pulse RESET)
	TSET.8	A360PBDIR+3:#0		; PB0 en sortie
	MOVE.32	#750,D0
	CALL	WAITUS
	TCLR.8	A360PBDIR+3:#0		; PB0 en entre
	MOVE.32	#100,D0
	CALL	WAITUS
	TEST.8	A360PBDAT+3:#0		; Dallas DS2434 present ?
	JUMP,T	NONE$			; non => laisse tomber
	MOVE.32	#500,D0
	CALL	WAITUS
	TEST.8	A360PBDAT+3:#0		; fin du reset OK ?
	JUMP,F	NONE$			; non => laisse tomber
	POP.16	SF

	LIB	?AFTIM
	.ASCIZE	"Dallas prt.<NOCURS><CR>"

	MOVE.32	#R16^DSDATA,A4
	MOVE.32	#0,D4
	CALL	DSWRITEPAGE2

	SUB.A16	#8*4,SP
	MOVE.32	SP,A4
	CALL	DSREADPAGE1
	LIB	?AFTIM
	.ASCIZE	"Page 1: "
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	LIB	?AFCR

	MOVE.32	SP,A4
	CALL	DSREADPAGE2
	LIB	?AFTIM
	.ASCIZE	"Page 2: "
	MOVE.32	{A4+},D4
	LIB	?AFX8
	MOVE.32	{A4+},D4
	LIB	?AFX8
	LIB	?AFTAB
	MOVE.32	SP,A4
	MOVE.32	#8-1,D4

DUMP2$:	MOVE.8	{A4+},D3
	LIB	?AFCODE
	DJ.16,NMO D4,DUMP2$

	LIB	?AFCR
	ADD.A16	#8*4,SP

T$:	CALL	DSREADTEMP
	MOVE.8	D4,D0
	MOVE.32	#2**BAFDCM,D2
	MOVE.32	#3,D3
	SR.8	D4
	LIB	?AFTIM
	.ASCIZE	"Temprature du 68040: "
	LIB	?AFDEC
	TEST.32	D0:#0
	JUMP,F	R8^END$
	LIB	?AFTIM
	.ASCIZE	".5"

END$:	LIB	?AFTIM
	.ASCIZE	" degrs<EFLI><CR><UP>"
	MOVE.32	#50,D4
	NTREL	?SETTIM
	LIB	?GETCAR
	JUMP,NE	T$
	JUMP	RET$

NONE$:	POP.16	SF
	MON	?AFTIM
	.ASCIZE	"Dallas DS2434 absent.<CR>"

RET$:	popm.32	d0|a0
	retsf

DSDATA:
	.ASCII	"SMAKY400"
	.EVEN


; in	A4.32	^buffer (24 bytes)
; out	{A4}++	contenu de la NOVRAM (page 1)
; mod	-

DSREADPAGE1:
	PUSHM.32 D0|D1|A4

	CALL	DSRESET
	MOVE.8	#16'71,D0	; transfert NOVRAM => SRAM
	CALL	DSWRITEBYTE
	CALL	DSRESET
	MOVE.8	#16'11,D0	; lecture depuis SRAM
	CALL	DSWRITEBYTE
	MOVE.8	#16'00,D0	; la page 1 est en $00-$17
	CALL	DSWRITEBYTE
	MOVE.32	#24-1,D1
LOOP$:	CALL	DSREADBYTE
	MOVE.8	D0,{A4+}
	DJ.16,NMO D1,LOOP$

	POPM.32	D0|D1|A4
	RET


; in	A4.32	^buffer (8 bytes)
; out	{A4}++	contenu de la NOVRAM (page 2)
; mod	-

DSREADPAGE2:
	PUSHM.32 D0|D1|A4

	CALL	DSRESET
	MOVE.8	#16'77,D0	; transfert NOVRAM => SRAM
	CALL	DSWRITEBYTE
	CALL	DSRESET
	MOVE.8	#16'11,D0	; lecture depuis SRAM
	CALL	DSWRITEBYTE
	MOVE.8	#16'20,D0	; la page 2 est en $20-$27
	CALL	DSWRITEBYTE
	MOVE.32	#8-1,D1
LOOP$:	CALL	DSREADBYTE
	MOVE.8	D0,{A4+}
	DJ.16,NMO D1,LOOP$

	POPM.32	D0|D1|A4
	RET


;---------------\\
;  DSWRITEPAGE2  >
;---------------/

; Ecrit 8 bytes dans la page de paramtres numro 2. Cette
; page n'est pas protge contre les critures abusives...
; On vrifie le contenu tlcharg avant de programmer la
; NOVRAM (EEPROM). Dallas indique que l'on peut faire plus
; de 50'000 critures. Ne pas en abuser, donc.

; in	A4.32	^buffer  crire (8 bytes)
;	D4.32	crit EEPROM si D4=55AA55AA
; out	D7.16	ok/erreur
; mod	D7.16

DSWRITEPAGE2:
	PUSHM.32 D0|D1|D4|A0

	MOVE.16	#1,D7
	CALL	DSRESET
	MOVE.8	#16'17,D0	; criture vers SRAM
	CALL	DSWRITEBYTE
	MOVE.8	#16'20,D0	; la page 2 est en $20-$27
	CALL	DSWRITEBYTE

	MOVE.32	A4,A0
	MOVE.32	#8-1,D1
WR$:	MOVE.8	{A0+},D0	; copie vers la SRAM
	CALL	DSWRITEBYTE
	DJ.16,NMO D1,WR$

	CALL	DSRESET
	MOVE.8	#16'11,D0	; lecture depuis SRAM
	CALL	DSWRITEBYTE
	MOVE.8	#16'20,D0	; la page 2 est en $20-$27
	CALL	DSWRITEBYTE
	MOVE.32	A4,A0
	MOVE.32	#8-1,D1
LOOP$:	CALL	DSREADBYTE
	COMP.8	{A4+},D0	; relit correctement ?
	JUMP,NE	R8^ERR$		; non => erreur
	DJ.16,NMO D1,LOOP$

	CLR.16	D7
	COMP.32	#16'55AA55AA,D4	; demande une vraie criture en EEPROM ?
	JUMP,NE	R8^ERR$		; non => ok comme a

	CALL	DSRESET
	MOVE.8	#16'25,D0
	CALL	DSWRITEBYTE	; dmarre le transfert

WAIT$:	MOVE.32	#1,D4
	NTREL	?DELMS		; laisse programmer (en principe 10ms)
	CALL	DSRESET
	MOVE.8	#16'B2,D0	; lecture page 4
	CALL	DSWRITEBYTE
	MOVE.8	#16'62,D0	; registre de statut
	CALL	DSWRITEBYTE
	CALL	DSREADBYTE
	TEST.32	D0:#1		; conversion encore en cours ?
	JUMP,T	WAIT$		; oui => attend encore

ERR$:	POPM.32	D0|D1|D4|A0
	TEST.16	D7
	RET


;-------------\\
;  DSREADTEMP  >
;-------------/

; Lit la temprature de la sonde DS2434. Le protocole
; 1-fil est simple: lancer la conversion, attendre le
; rsultat, relire la temprature.

; in	-
; out	D4.32	temprature * 2 (degrs Clsius)
; mod	D4.32

DSREADTEMP:
	PUSH.32	D0
	CALL	DSRESET
	MOVE.8	#16'D2,D0	; dbut de conversion de temp.
	CALL	DSWRITEBYTE

LOOP$:	MOVE.32	#1,D4
	NTREL	?DELMS		; laisse convertir (en principe 10ms)
	CALL	DSRESET
	MOVE.8	#16'B2,D0	; lecture page 4
	CALL	DSWRITEBYTE
	MOVE.8	#16'62,D0	; registre de statut
	CALL	DSWRITEBYTE
	CALL	DSREADBYTE
	TEST.32	D0:#0		; conversion encore en cours ?
	JUMP,T	LOOP$		; oui => attend encore

	CALL	DSRESET
	MOVE.8	#16'B2,D0	; lecture page 4
	CALL	DSWRITEBYTE
	MOVE.8	#16'60,D0	; registre de temprature au 1/2 degr prs
	CALL	DSWRITEBYTE
	CALL	DSREADBYTE	; lit la temprature
	MOVE.8	D0,D4
	POP.32	D0
	RET


DSWRITEBYTE:
	PUSH.32	D1
	MOVE.32	#8-1,D1
LOOP$:	RR.8	D0
	JUMP,CC	R8^ZERO$
	CALL	DSWRITEONE
	JUMP	R8^NEXT$
ZERO$:	CALL	DSWRITEZERO
NEXT$:	DJ.16,NMO D1,LOOP$
	POP.32	D1
	RET

DSREADBYTE:
	PUSH.32	D1
	MOVE.32	#8-1,D1
	CLR.8	D0
LOOP$:	CALL	DSREADBIT
	JUMP,EQ	R8^NEXT$
	TSET.32	D0:#0
NEXT$:	RR.8	D0
	DJ.16,NMO D1,LOOP$
	POP.32	D1
	RET



DSRESET:
	PUSH.32	D0
	PUSH.16	SF
	IOFF
	TCLR.8	A360PBDAT+3:#0		; PB0  zro (pulse RESET)
	TSET.8	A360PBDIR+3:#0		; PB0 en sortie
	MOVE.32	#750,D0
	CALL	WAITUS
	TCLR.8	A360PBDIR+3:#0		; PB0 en entre
	MOVE.32	#600,D0
	CALL	WAITUS
	POP.16	SF
	POP.32	D0
	RET

DSWRITEZERO:
	PUSH.32	D0
	PUSH.16	SF
	IOFF
	TCLR.8	A360PBDAT+3:#0		; PB0  zro
	TSET.8	A360PBDIR+3:#0		; PB0 en sortie
	MOVE.32	#80,D0
	CALL	WAITUS			; crit le zro
	TSET.8	A360PBDAT+3:#0		; PB0 flottant
	MOVE.32	#5,D0
	CALL	WAITUS			; "recovery"
	POP.16	SF
	POP.32	D0
	RET

DSWRITEONE:
	PUSH.32	D0
	PUSH.16	SF
	IOFF
	TCLR.8	A360PBDAT+3:#0		; PB0  zro
	TSET.8	A360PBDIR+3:#0		; PB0 en sortie
	MOVE.32	#2,D0
	CALL	WAITUS			; pulse de dbut de write
	TSET.8	A360PBDAT+3:#0		; PB0 flottant
	MOVE.32	#80,D0
	CALL	WAITUS			; crit le un
	POP.16	SF
	POP.32	D0
	RET


; in	-
; out	EQ	=> zro lu
;	NE	=> un lu

DSREADBIT:
	PUSHM.32 D0|D1
	PUSH.16	SF
	IOFF
	TCLR.8	A360PBDAT+3:#0		; PB0  zro
	TSET.8	A360PBDIR+3:#0		; PB0 en sortie
	MOVE.32	#2,D0
	CALL	WAITUS			; pulse de dbut de read
	TCLR.8	A360PBDIR+3:#0		; PB0 en entre
	MOVE.32	#5,D0
	CALL	WAITUS			; attend que la ligne se stabilise
	MOVE.32	A360PBDAT,D1		; teste si zro ou un
	MOVE.32	#120,D0
	CALL	WAITUS			; fin de la lecture
	POP.16	SF
	TEST.32	D1:#0			; tat du bit lu
	POPM.32	D0|D1
	RET



; Attend "n" microsecondes. Cette boucle fait une attente
; trs approximative, vu que l'on dpend fortement du cache
; et de la vitesse relle du processeur.

WAITUS:
	PUSH.32	D0
	MUL.32	#10,D0
	JUMP,EQ	R8^RET$
LOOP$:	DEC.32	D0			; environ 100ns par boucle
	JUMP,NE	LOOP$
RET$:	POP.32	D0
	RET

	.end
