
	.TITLE	NTSERVER.ASM

	.PROC	M68000
	.REF	SMAKY
	.REF	COMMREQ

;	Dfinitions pour la communication avec le serveur
;	-------------------------------------------------

PORT_NT_REQUEST	= 50

CMD_NEW_PORT	= 1
CMD_KILL_PORT	= 2

CMD_RELEASE	= 10
CMD_CREATE	= 11
CMD_CONNECT	= 12
CMD_DISCONNECT	= 13
CMD_OPEN	= 14
CMD_CLOSE	= 15
CMD_READ	= 16
CMD_WRITE	= 17
CMD_CREATESLOT	= 18

;	Structure pour les commandes
;	----------------------------

		.LOC	0

OcmdCMD:	.BLK.16	1		; commande (CMD_xxx)
OcmdRES1:	.BLK.16	1		; rserve (0)
OcmdRES2:	.BLK.32	1		; rserve (0)
OcmdID:		.BLK.32	1		; identificateur ventuel (CMD_KILL_PORT)
OcmdLENGTH:	.BLK.32	1		; longueur des donnes
OcmdBUFFER:	.BLK.32	1		; ^donnes
OcmdNAME:	.BLK.8	200		; nom ventuel
LGCMD:

;	Structure pour les statuts
;	--------------------------

		.LOC	0

OstsERROR:	.BLK.16	1		; erreur en retour
OstsRES1:	.BLK.16	1		; rserve (0)
OstsRES2:	.BLK.32	1		; rserve (0)
OstsID:		.BLK.32	1		; identificateur ventuel (CMD_NEW_PORT)
OstsLENGTH:	.BLK.32	1		; longueur des donnes retournes/lues
LGSTATUS:



;	Variables du programme
;	----------------------

		.LOC	0


OBARID:		.BLK.32	1
OREQUEST:	.BLK.8	RQ_LEN		; requtes
OCOMMAND:	.BLK.8	LGCMD
OSTATUS:	.BLK.8	LGSTATUS
OBUFFER:	.BLK.8	100
LGVAR:

	.LOC	0
	.START	START

START:
	MOVE.32	A4,A6

	MOVE.32	#R16^NMCOMMBAR,A3
	MOVE.32	#2**BCBOPEN,D4
	NTREL	?CREBAR			; ouvre la BAR pour la couche de communication
	JUMP,NE	ERR$

	MOVE.32	A5,{A6}+OBARID
	MOVE.32	#0,D4
	NTREL	?CRESEM			; smaphore de synchro pour attente de rponses
	JUMP,NE	ERR$

	MOVE.32	#{A6}+OREQUEST,A4
	MOVE.32	A5,{A4}+RQ_REPLYSEM	; <-- smaphore pour attendre les rponses

	MOVE.32	#{A6}+OCOMMAND,A0	; A0 <-- ^commande
	MOVE.32	#{A6}+OSTATUS,A1	; A1 <-- ^statuts

	MOVE.8	#PRI_SYSTEM,{A4}+RQ_PRI
	MOVE.16	#PORT_NT_REQUEST,{A4}+RQ_PORTNO
	CALL	InitCmdStatus

	MOVE.16	#CMD_NEW_PORT,{A0}+OcmdCMD
	CALL	Transaction		; cre le nouveau port...
	JUMP,NE	ERR$

	MOVE.32	{A1}+OstsID,D5		; numro du port  utiliser par la suite...
	MOVE.8	#PRI_FILE,{A4}+RQ_PRI	; <-- priorit normale
	MOVE.16	D5,{A4}+RQ_PORTNO	; <-- numro du port

	LIB	?AFTIM
	.ASCIZE	"Connexion russie, port = "
	MOVE.16	D5,D4
	LIB	?AFX4, ?AFCR

; Cre un slot...

	CALL	InitCmdStatus

	MOVE.32	#R16^NMTESTSLOT,A2
	MOVE.32	#{A0}+OcmdNAME,A3

COPY1$:	MOVE.8	{A2+},{A3+}		; copie le nom du slot  crer
	JUMP,NE	COPY1$

	MOVE.16	#CMD_CREATESLOT,{A0}+OcmdCMD
	CALL	Transaction		; cre le "slot"
	JUMP,NE	KILL$

	LIB	?AFTIM
	.ASCIZE	"Slot cr. Attend un message.<CR>"

	MOVE.32	#{A6}+OBUFFER,A3
	MOVE.32	#100,D3

	CALL	InitCmdStatus
	MOVE.16	#CMD_READ,{A0}+OcmdCMD
	MOVE.32	A3,{A0}+OcmdBUFFER
	MOVE.32	D3,{A0}+OcmdLENGTH
	CALL	Transaction
	JUMP,NE	KILL$

	LIB	?AFTIM
	.ASCIZE	"Reu: "
	LIB	?AFTEXT

	CALL	InitCmdStatus
	MOVE.16	#CMD_CLOSE,{A0}+OcmdCMD
	CALL	Transaction		; ferme le "slot"

KILL$:	LIB	?AFERROR, ?AFCR

	CALL	InitCmdStatus
	MOVE.16	#CMD_RELEASE,{A0}+OcmdCMD
	CALL	Transaction

EXIT$:	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?KILLSEM

ERR$:	LIB	?AFERROR
	LIB	?AFCR
	EXIT

NMCOMMBAR:	.ASCIZ	"#:PCCOMMBAR"
NMTESTSLOT:	.ASCIZ	"\\.\mailslot\test_slot"
		.EVEN


; Initialise les champs commande/statut de la requte et efface les
; buffers de commande et statut.

; in	A0.32	^commande
;	A1.32	^statuts
;	A4.32	^requte
; out	-
; mod	F

InitCmdStatus:
	PUSHM.32 D4|D7|A3|A4

	MOVE.32	A4,A3

	MOVE.32	#LGCMD,D4
	MOVE.32	A0,A4
	GESMEM	?CLEARMEM

	MOVE.32	A4,{A3}+RQ_SDATAPTR
	MOVE.32	D4,{A3}+RQ_SDATALEN

	MOVE.32	#LGSTATUS,D4
	MOVE.32	A1,A4
	GESMEM	?CLEARMEM

	MOVE.32	A4,{A3}+RQ_RDATAPTR
	MOVE.32	D4,{A3}+RQ_RDATALEN

	POPM.32	D4|D7|A3|A4
	RET


; Transaction avec le serveur

; in	-
; out	D7.16	ok/erreur
; mod	D7.16

Transaction:
	PUSHM.32 D4|A4|A5

	MOVE.32	#-1,D4
	NTREL	?MODTIM

	MOVE.32	#{A6}+OREQUEST,A4
	MOVE.32	{A6}+OBARID,A5
	NTREL	?OFFERBAR		; met la requte
	NTREL	?ENDOFFERBAR

	MOVE.32	{A4}+RQ_REPLYSEM,A5
	NTREL	?WAITEV			; attend la rponse
	NTREL	?SETTIM

	MOVE.16	{A6}+OSTATUS+OstsERROR,D7

	POPM.32	D4|A4|A5
	RET




	.END

