/*
 *	cache.h
 *
 *	Interface definition for the external world. This is used to communicate
 *	between FOS and the Cache classes.
 *
 *	(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#include <c++/portable.h>

#define	caOPOpen		1
#define	caOPClose		2
#define	caOPWrite		3
#define	caOPRead		4
#define	caOPSync		5
#define	caOPInvalidate	6

#define	caOPSyncAll		100
#define	caOPInvAll		101
#define	caOPAbout		102
#define	caOPConfig		103

class CacheData;

struct CacheRec
{
	Card32			bar_id;
	Card16			bios_no;
	Card8			unit_flags;
	Card8			unit_mode;
	const char*		unit_name;
	Card16			op;
	Card16			typ_error;
	Card32			arg_1;
	Card32			arg_2;
	void*			p_data;
	CacheData*		cache;
};

#define	cacheDATA	0
#define	cacheSYS	1
#define	cacheBD		2
#define	cacheBL		3


/*
 *	Information structure filled by the "caOPAbout" and "caOPConfig"
 *	calls.
 */

struct CaAboutRec
{
	Card32			rec_size;				//	length of record
	
	char			name[16];				//	name of device being cached
	Card32			max_total_size;			//	maximum total size (blocks)
	Card32			max_chunk_size;			//	maximum chunk size (blocks)
	Card32			current_size;			//	size of data currently in the cache (blocks)
	
	Bool			is_volatile;			//	TRUE => data is volatile
	Bool			is_dirty;				//	TRUE => cache is dirty
	Bool			use_lazy_write;			//	TRUE => use lazy write algorithm
};



