
#include <filer.h>
#include <stdio.h>
#include <stdlib.h>


static void
compare (const char* n1, const char* n2)
{
	FILE* f1 = fopen (n1, "rb");
	FILE* f2 = fopen (n2, "rb");
	
	if (f1 && f2) {
		int c1 = fgetc (f1);
		int c2 = fgetc (f2);
		
		while ( (c1 == c2) && (c1 != EOF) && (c2 != EOF) ) {
			c1 = fgetc (f1);
			c2 = fgetc (f2);
		}
		
		if (c1 != c2) printf ("%s != %s\n", n1, n2);
		
	} else {
		if (f1) printf ("%s missing\n", n2);
		if (f2) printf ("%s missing\n", n1);
	}
	
	if (f1) fclose (f1);
	if (f2) fclose (f2);
}

int
main (int argc, char* argv[])
{
	argc--;
	argv++;
	
	if (argc == 2) {
		compare (argv[0], argv[1]);
		return 0;
	}
	
	if (argc > 2) {
		const char* dir_1 = argv[0];
		const char* dir_2 = argv[1];
		argc -= 2;
		argv += 2;
		
		while (argc--) {
			char name_1[200];
			char name_2[200];
			strcpy (name_1, dir_1); strcat (name_1, argv[0]);
			strcpy (name_2, dir_2); strcat (name_2, argv[0]);
			compare (name_1, name_2);
			argv++;
		}
		return 0;
	}
	
	printf ("Usage: %s file1 file2\n"
			"       %s dir1 dir2 file1 .. fileN\n", argv[-1]);
	
	return 0;
}

