
	.REF	SMAKY
	.REF	BIOS
	.PROC	M68000
	.START	START


PCCODE		= 0
PCOFFSET	= 2

	.INS	DIFFDEF.ASI

		.LOC	0

oDescrDiff:	.BLK.8	LgDescrDiff		; 3 descripteurs de segments
oSegDiffComm:	.BLK.8	LgSegDiffComm		; Segment de commande
oNdDRI:		.BLK.16	1
LgVarDiff:

	.APC	PCCODE
	.LOC	0

START:
	MOVE.32		#0,D6
	MOVE.32		#lgVarDiff,D4
	MOVE.32		#MTYPCP,D1
	GESMEM		?GETMEM
	JUMP,NE		R8^Out$

	MOVE.32		A4,A6
	CLR.32		D3

; Ouvre le port

	CALL		OpenSndRcv	; Ouvre le pilote pour mettre et recevoir la rponse
	JUMP,NE		R8^F$

; Emission

	CALL		PrepSnd		; Prpare les descripteurs pour l'mission
	CALL		SendMess	; Envoi le message de diffusion
	JUMP,NE		R8^S$

; Rception

	CALL		PrepRcv		; Prpare les descripteurs de rception

	MOVE.32		#2*50,D4	; 2 sec d'attente
	NTREL		?MODTIM

	CALL		RcvMess		; Attend la rponse avec TIMEOUT
					; numro du serveur -> D3.32

	PUSH.16		D7		
	NTREL		?SETTIM
	POP.16		D7

S$:	CALL		CloseSndRcv

F$:	PUSH.16		D7
	MOVE.32		#MTYPCP,D1
	MOVE.32		A6,A4
	GESMEM		?GIVMEM
	POP.16		D7

Out$:	EXIT



;-----------\\
; OpenSndRcv >
;===========/

; Ouverture du pilote pour mettre le message de diffusion
; et recevoir la rponse

; in	A6.32	^variables locales
; out	D7.16
; mod	D4.32

OpenSndRcv:
	PUSH.32	D4
	MOVE.16	#PortDiffSnd+2**bDiff,D4
		 ^ valeur du symbole indefinie
	CALL	OpenDrNet
	POPM.32	D4
	TEST.16	D7
	RET


;--------\\
; PrepSnd >
;========/

; Prpare le message  transmettre
; Seul un minimum de paramtres sont transmis:
; 2 paramtres pour la commande
; 1 pour le 2me segment
; 1 pour le 3me segment

; in	A6.32	^variables locales
;	D6.32	identificateur de groupe
; out	D7.16	erreur
; mod	A0.32

PrepSnd:
	PUSHM.32 D4|A4|A5

	MOVE.32	#{A6}+oDescrDiff,A4
	MOVE.32	#LgDescrDiff,D4
	GESMEM	?CLEARMEM

	MOVE.32	#{A6}+oSegDiffComm,A5
	MOVE.32	#16'BABEC001,{A5}+oDiffComm
	MOVE.32	D6,{A5}+oDiffGrId

	MOVE.32	A5,{A4}+oDescSegComm+oSegAdr
	MOVE.16	#8,{A4}+oDescSegComm+oSegLg

	POPM.32	D4|A4|A5
	RET


;---------\\
; SendMess >
;=========/

; Emission du message de diffusion

; In	A6.32	^variables locales
; Out	D7.16	erreur
; Mod	

SendMess:
	PUSHM.32 A4|D3|D4

	MOVE.32	#{A6}+oDescrDiff,A4	; ^descr segment	-> A4.32
	MOVE.16	#1,D5			; nb segments		-> D5.8
	MOVE.32	#0,D4
	MOVE.16	#PortDiffSnd,D4		; Port local		-> D4.16
	MOVE.16	#16'FFFF,D3		; Adresse de diffusion	-> D3
	SWAP.32	D3			; Station distante	-> D3:#<31..16>
	MOVE.16	#PortDiffRcv,D3		; Port distant	(rception)-> D3.16

	CALL	WriteDrNet

	POPM.32	A4|D3|D4
	TEST.16	D7
	RET

;	A4.32		^table des segments
;	D5.8		nombre de segments  crire
;
;	D4.32:#<23..16> Compteur message envoy (si <>0 le prend, si = 0 driver le gnre)
;	D4.16:#<15..8>	numro regnration local (metteur) (diffrent  chaque OPEN-CLOSE sur le port) sur 4 bits
;	D4.16:#<7..0>	port local (metteur)
;
;	D3.32:#<31..24>	station distante (rcepteur) si: -1 (16'FFFF) -> message de diffusion
;                                                        ************************************
;	D3.16:#<15..8>	numro regnration distant (rcepteur) sur 4 bits
;	D3.16:#<7..0>	port distant (rcepteur)


;--------\\
; PrepRcv >
;========/

; Prpare les descripteurs pour recevoir la rponse du serveur

; In	A6.32	^variables locales
; Out	D7.16	erreur
; Mod	A0.32

PrepRcv:
	; initialise descripteurs de segments

	move.32		#{a6}+oSegDiffComm,A0
	move.32		A0,{a6}+oDescrDiff+oDescSegComm+oSegAdr			; ^1er buffer
	move.16		#LgSegDiffComm,{a6}+oDescrDiff+oDescSegComm+oSegMx	; lg buffer
	ret

;--------\\
; RcvMess >
;========/

; Attend la rception du message du serveur

; In	A6.32	^variables locales
;	d6.32	groupe local
; Out	D3.32	station serveur
;	D7.16	erreur
; Mod	

RcvMess:
	pushm.32	a4|d4|d5|d6
l$:
	move.32		#{a6}+oDescrDiff,A4	; ^descr segment	-> A4.32
	move.16		#1,d5			; nb segments		-> D5.8
	move.32		#0,d4
	move.16		#PortDiffSnd,d4		; Port local		-> D4.16
	move.16		#0,d3			; Adresse de rception	-> d3
	swap.32		d3			; Station distante	-> D3:#<31..16>
	move.16		#PortDiffRcv,d3		; Port distant		-> D3.16
	call		ReadDrNet
	jump,ne		r8^f$

	; si pas d'erreur, test si c'est un bon message


	clr.32	d3		; pas de station serveur
f$:
	popm.32	a4|d4|d5|d6
	test.16	d7
	ret

;	A4.32		^table des segments
;	D5.8		nombre de segments
;
;	D4.32:#<23..16>	compteur message attendu de l'metteur	(si <>0 on attend celui-ci , si = 0 quelconque)
;	D4.16:#<15..8>	numro regnration local du port (rcepteur) (donn OPEN)
;	D4.16:#<7..0>	port local (rcepteur)
;
;	D3.32:#<31..24>	station distante (metteur) 0=global
;	D3.16:#<15..8>	numro regnration distant attendu (metteur) 0=global
;	D3.16:#<7..0>	port distant (metteur) 0=global
;
;	TIMEOUT		entre en vigeur  partir du moment ou le port correspondant est actif, et pour chaque bloc
;			il faudra donc attendre au minimum, temps exec de tous les processus en attente sur le port
;			+ nbr bloc * TIMEOUT
;			Le time out doit tre prvu trs large, en cas de surcharge des serveurs!!
;
; out	D5.8		nombre de segments lus
;
;	D4.32:#<23..16> compteur message reu
;
;	D3.32:#<31..24>	station distante (metteur)
;	D3.16:#<15..8>	numro gnration distant (metteur)
;	D3.16:#<7..0>	port distant (metteur)
;
;	D7.16		erreur
;

;------------\\
; CloseSndRcv >
;============/
;
; Ferme le port d'mission/rception
; 
; In	A6.32	^variables locales
; Out	D7.16	erreur
; Mod	

CloseSndRcv:
	push.16		d7
	pushm.32	d4
	move.16		#PortDiffSnd,d4
	call		CloseDrNet
	popm.32		d4
	pop.16		d7
	ret


; Routines d'accs BIOS
;======================

;----------\\
; OpenDrNet >
;==========/

; Ouvre le driver rseau et sauve son numro

; In	A6.32	^variables locales
;	D4.16	no de port dsir (=0 si attribution dynamique)
;	D4.16	:#BDiff		diffusion accepte sur ce port (bit 15)
;	D4.16	:#BOnlyDiff	seulement la diffusion accepte (bit 14)
;	TIMEOUT	pour l'attribution de port
; Out	D4.8L	no de port attribu
;(	D4:<7>	1: simultanit possible de rception (pas implment))
;		0: ancienne version
;	D4.8H	no de regnration du port attribu (si D7.W=#0)
;	D4:<31..16>	0
;	D7.16	erreur:
;			ERNMPF	tous les ports utiliss (aprs timeout)
;			ERNMPS	port (dj) en utilisation
;			ErNIPO	port illgal
; mod	D0..A1, D7.16

OpenDrNet:
	pushm.32	a3|d0|d2
	move.32		#r16^TxZ_0$,a3			; A3.32 ^nom du driver "Z_0"
	BIOS		?OPEDNAM			; D2 <-- numro du driver
							; D4 <- numro du port
	MOVE.16		D2,{A6}+ONDDRI			; sauve le numro du driver

	popm.32		a3|d0|d2
	test.16		d7
	ret
TxZ_0$:	.ascize	"Z_0"

;-----------\\
; CloseDrNet >
;===========/

; Ferme le port dsign

; In	A6.32	^variables locales
;	D4.16	no de port  fermer
; Out	D7.16	erreur
; Mod	

CloseDrNet:
	pushm.32	d2
	move.16		{a6}+ONDDRI,D2		; Numro de driver
	BIOS		?DCLOSE
	popm.32		d2
	test.16		d7
	ret

;-----------\\
; WriteDrNet >
;===========/

; Ecrit sur pilote rseau
; 
; in	A6.32		^variables globales
;	A4.32		^table des segments
;	D5.8		nombre de segments  crire
;
;	D4.32:#<23..16> Compteur message envoy (si <>0 le prend, si = 0 driver le gnre)
;	D4.16:#<15..8>	numro regnration local (metteur) (diffrent  chaque OPEN-CLOSE sur le port) sur 4 bits
;	D4.16:#<7..0>	port local (metteur)
;
;	D3.32:#<31..24>	station distante (rcepteur) si: -1 (16'FFFF) -> message de diffusion
;                                                        ************************************
;	D3.16:#<15..8>	numro regnration distant (rcepteur) sur 4 bits
;	D3.16:#<7..0>	port distant (rcepteur)
;
;	TIMEOUT
; Out	D7.16	erreur
; Mod	

WriteDrNet:
	pushm.32	d2
	move.16		{a6}+ONDDRI,D2		; Numro de driver
	BIOS		?DWRITE
	popm.32		d2
	test.16		d7
	ret

;----------\\
; ReadDrNet >
;==========/

; Lit sur pilote rseau
; 
; in	A6.32		^variables globales
;	A4.32		^table des segments
;	D5.8		nombre de segments
;
;	D4.32:#<23..16>	compteur message attendu de l'metteur	(si <>0 on attend celui-ci , si = 0 quelconque)
;	D4.16:#<15..8>	numro regnration local du port (rcepteur) (donn OPEN)
;	D4.16:#<7..0>	port local (rcepteur)
;
;	D3.32:#<31..24>	station distante (metteur) 0=global
;	D3.16:#<15..8>	numro regnration distant attendu (metteur) 0=global
;	D3.16:#<7..0>	port distant (metteur) 0=global
;
;	TIMEOUT		entre en vigeur  partir du moment ou le port correspondant est actif, et pour chaque bloc
;			il faudra donc attendre au minimum, temps exec de tous les processus en attente sur le port
;			+ nbr bloc * TIMEOUT
;			Le time out doit tre prvu trs large, en cas de surcharge des serveurs!!
;
; out	D5.8		nombre de segments lus
;
;	D4.32:#<23..16> compteur message reu
;
;	D3.32:#<31..24>	station distante (metteur)
;	D3.16:#<15..8>	numro gnration distant (metteur)
;	D3.16:#<7..0>	port distant (metteur)
;
;	D7.16		erreur
;
; Mod	

ReadDrNet:
	pushm.32	d2
	move.16		{a6}+ONDDRI,D2		; Numro de driver
	BIOS		?DREAD
	popm.32		d2
	test.16		d7
	ret


	.END
