
	.REF	SMAKY
	.REF	BIOS
	.REF	DIFFUTIL
	.PROC	M68000
	.START	START


PCCODE		= 0
PCOFFSET	= 2


		.LOC	0

oDescrDiff:	.BLK.8	LgDescrDiff		; 3 descripteurs de segments
oSegDiffComm:	.BLK.8	LgSegDiffComm		; Segment de commande
oDrivCh:	.BLK.16	1			; canal du driver
oPortDiff:	.BLK.16	1			; port de diffusion (rception)
LgVarDiff:

	.APC	PCCODE
	.LOC	0

START:
	MOVE.32	#0,D6
	MOVE.32	#lgVarDiff,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM
	JUMP,NE	R8^Out$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6

	MOVE.16	#PortDiffRcv,{A6}+oPortDiff

	MOVE.32	#R16^NMZ$,A3
	CALL	OpenSndRcv	; ouvre le pilote pour mettre et recevoir la rponse
	JUMP,NE	R8^Err$

	CALL	PrepRcv		; prpare les descripteurs de rception

	MOVE.32	#10*50,D4	; 10 sec d'attente
	NTREL	?MODTIM

	MOVE.32	#1,D5
	CALL	RcvMess		; attend une requte
	JUMP,NE	Close$

	LIB	?AFTIM
	.ASCIZE	"Source : "
	MOVE.32	#2**BAFDSP,D2
	MOVE.32	D3,D4
	MOVE.32	#8,D3
	LIB	?AFDEC, ?AFCR

	PUSH.16	D7
	NTREL	?SETTIM
	POP.16	D7

Close$:	CALL	CloseSndRcv

Err$:	PUSH.16	D7
	MOVE.32	#MTYPCP,D1
	MOVE.32	A6,A4
	GESMEM	?GIVMEM
	POP.16	D7

Out$:	EXIT

NMZ$:	.ASCIZE	"Z_0"



;--------\\
; PrepSnd >
;========/

; Prpare le message  transmettre
; Seul un minimum de paramtres sont transmis:
; 2 paramtres pour la commande
; 1 pour le 2me segment
; 1 pour le 3me segment

; In	A6.32	^variables locales
;	d6.32	identificateur de groupe
; Out	D7.16	erreur
; Mod	A0.32

PrepSnd:
	RET



;--------\\
; PrepRcv >
;========/

; Prpare les descripteurs pour recevoir la rponse du serveur

; In	A6.32	^variables locales
; Out	D7.16	erreur
; Mod	A0.32

PrepRcv:
	MOVE.32	#{A6}+oSegDiffComm,A0
	MOVE.32	A0,{A6}+oDescrDiff+oDescSegComm+oSegAdr			; ^1er buffer
	MOVE.16	#LgSegDiffComm,{A6}+oDescrDiff+oDescSegComm+oSegMx	; lg buffer
	RET


	.INS	DIFFUTIL.ASI

	.END

