
#include <c++/portable.h>
#include <c++/mon.h>

struct SecurityCtx;
struct UnitCtx;

struct SecurityFunc
{
	Card32   (*GetUserID) (SecurityCtx* g_ctx, const char* login, Card32 password, Card32* gids);
	Card32   (*GetUserFromID) (SecurityCtx* g_ctx, Card32 id, char* login);
	UnitCtx* (*OpenUnitContext) (SecurityCtx* g_ctx, const char* name);
	void     (*CloseUnitContext) (UnitCtx* unit_ctx);
	Card16   (*QueryOp) (UnitCtx* unit_ctx, Card32 op, const Card32* ids);
};

struct SecurityCtx
{
	SecurityFunc*	funcs;
};


Card32
the_GetUserID (SecurityCtx* g_ctx, const char* login, Card32 password, Card32* gids)
{
	AfText ("GetUserID: "); AfText (login); AfText (" ["); AfX8 (password); AfText ("]\r");
	gids[0] = 0;
	return login[0]*256 + login[1];
}

Card32
the_GetUserFromID (SecurityCtx* g_ctx, Card32 id, char* login)
{
	AfText ("GetUserFromID: ["); AfX8 (id); AfText ("]\r");
	login[0] = 0;
	return 0;
}

UnitCtx*
the_OpenUnitContext (SecurityCtx* g_ctx, const char* name)
{
	return 0;
}

void
the_CloseUnitContext (UnitCtx* unit_ctx)
{
}

Card16
the_QueryOp (UnitCtx* unit_ctx, Card32 op, const Card32* ids)
{
	return 0;
}


int
main ()
{
	SecurityFunc funcs;
	SecurityCtx  ctx;

	ctx.funcs = & funcs;
	funcs.GetUserID = the_GetUserID;
	funcs.GetUserFromID = the_GetUserFromID;
	funcs.OpenUnitContext = the_OpenUnitContext;
	funcs.CloseUnitContext = the_CloseUnitContext;
	funcs.QueryOp = the_QueryOp;
	
	asm ("movel %0,a4\n\t.long 0x4E450074" : : "g" (&ctx) : "a4", "d7");
	asm ("movel #-1,d4\n\t.long 0x4E440008" : : : "d4", "d7");
	
	return 0;
}

