
#include <c++/portable.h>
#include <c++/mon.h>

typedef void (*pf)(...);

extern "C" pf   global_lib_table[2];

extern "C" void global_init ();
extern "C" void global_cleanup ();

extern "C" int  memory_type;
extern "C" long memory_desc;

extern "C" int G_getmem(long *length, int type, long *desc_memptr);
extern "C" int G_givmem(void *memptr, int type, long desc);

extern "C" void abort ();
extern "C" void* malloc (unsigned long);
extern "C" void free (void*);

int  memory_type;
long memory_desc;


//  First function...

static void
func_1 ()
{
}

//  Second function...

static void
func_2 ()
{
}


//  The global LIB table defines the pointers to each function
//  implemented by the C library. In this sample, there are just
//  2 functions, but there might be a lot of them...

pf global_lib_table[2] = { func_1, func_2 };


//  Global initilisation function called just after relocation.
//  This usually calls the global constructors.

void
global_init ()
{
	AfText ("Global init D1="); AfX8 (memory_type);
	AfText (", A1="); AfX8 (memory_desc);
	AfCR ();
}

//  Global cleanup function called when the library wants to
//  unload the module. This usually calls the global destructors.

void
global_cleanup ()
{
	AfText ("Cleanup D1="); AfX8 (memory_type);
	AfText (", A1="); AfX8 (memory_desc);
	AfCR ();
}

void*
malloc (unsigned long l)
{
	long len  = l;
	long ptr  = memory_desc;
	int error = G_getmem (&len, memory_type, &ptr);
	if (error == 0) return (void*)(ptr);
	return 0;
}

void
free (void* ptr)
{
	G_givmem (ptr, memory_type, memory_desc);
}

void
abort ()
{
	asm ("trap #0");
}
