/*
 *	menu.h
 *
 *	Menu related structures, used by the LIB mouse menu extender, which is
 *	being provided since system 10.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 Suscvaz
 */

#ifndef	_MENU_H_
#define	_MENU_H_

struct MenuBody;
struct MenuCell;
struct MenuText;

typedef unsigned char  Card8;
typedef unsigned short Card16;
typedef unsigned long  Card32;

typedef signed short   Int16;

typedef unsigned char  Bool;

#define	TRUE	((Bool)(1))
#define	FALSE	((Bool)(0))

enum MenuTextType
{
	MENU_TEXT_NONE,
	MENU_TEXT_STRING,
	MENU_TEXT_ICON
};



struct MenuBody
{
	Card16			x,  y;
	Card16			dx, dy;
	Card16			rank;
	
	Card16			cell_width;
	Card16			cell_ascender;
	Card16			cell_descender;
	Card16			cell_count;
	
	MenuCell*		cell;
	MenuCell*		cell_last;
	
	MenuBody ();
	~MenuBody ();
};

struct MenuCell
{
	MenuCell*		next;				//	next menu cell (if any)
	MenuBody*		submenu;			//	submenu (if any)
	
	Card16			width;
	Card16			position;
	Card16			ascender;
	Card16			descender;
	
	Bool			is_hilite;
	Bool			is_line;
	Bool			is_dimmed;
	
	MenuText*		text;
	MenuText*		text_last;
	
	MenuCell ();
	~MenuCell ();
};

struct MenuText
{
	MenuText*		next;
	MenuTextType	type;
	Card32			len;
	const Card8*	data;
	
	MenuText ();
	~MenuText ();
};

struct LibMenuParam
{
	Card32			inactive;			//	bitset of inactive cells
	Card16			select;				//	selected cell
	Card16			reserved[5];		//	should be 0
};

struct LibMenuRecord
{
	const Card8*	mmenu;				//	ptr. to hierarchical mouse menu
	LibMenuParam*	param;				//	ptr. to parameters
	Card32			flags;				//	menu flags
	Card32			res_chan;			//	resource channel (if any)
	Card32			res_key;			//	resource key (if any)
	Card16			y,x;				//	top left/right corner
	Card16			baseline;			//	baseline (if any)
	Card16			dis_chan;			//	channel of display
	Card32			dis_desc;			//	descriptor of display
	Card16			error;				//	if any
};

class Menu
{
	LibMenuParam*	param;
	Card16			rank;
	
	Card32			res_chan;
	Card32			res_key;
	Card32			res_mode;
	
	Card16			dis_chan;
	Card32			dis_desc;
	
	Card16			baseline;
	
	Card16			org_y,  org_x;
	Card16			org_dy, org_dx;
	
	Card16			wdo_dy, wdo_dx;
	
public:
	Menu ();
	~Menu ();
	
	void LibInteract (LibMenuRecord* record);
	
	void MenuPos (MenuBody* menu, Card16 x, Card16 y);
	Bool MenuOpen (MenuBody* menu, Card32 rank = 0);
	Bool MenuClose (MenuBody* menu, Card32 rank = 0);
	
	MenuBody* BuildBody (const Card8* menu);
	MenuCell* BuildCell (const Card8*& menu, const Card8* start);
	
	void CellAddIcon (MenuCell* cell, const Card8* icon);
	void CellAddText (MenuCell* cell, const Card8*& text);
	
	void LibString (const Card8* string, Card32 len);
	void GetFontTable (const Card8*& font, Card16& ascender, Card16& descender);
	
	const Card8* ResGet (Card32 id, Card32 type);
};


#endif

