
#include "menu.h"
#include "util.h"

void
draw_menu_frame (Menu* menu, Card16 dx, Card16 dy)
{
	struct {
		struct Rect {
			Card8		zero_4;				//	moveto
			Card8		cmd_4;
			Card16		x_4, y_4;
			Card8		zero_5;				//	4 times lineto
			Card8		cmd_5;
			Card16		x_5, y_5;
			Card8		mode_5;
			Card8		cmd_6;
			Card16		x_6, y_6;
			Card8		mode_6;
			Card8		cmd_7;
			Card16		x_7, y_7;
			Card8		mode_7;
			Card8		cmd_8;
			Card16		x_8, y_8;
			Card8		mode_8;
			Card8		zero_8;
		};
		
		Card8		zero_2;					//	light grey
		Card8		cmd_2;
		Card32		color_2;
		
		Card8		eop;					//	white
		Card8		cmd_3;
		Card32		color_3;
		
		Card8		zero_4;					//	black
		Card8		cmd_4;
		Card32		color_4;
		
		Rect		rect_1;
		
		Card8		zero_5;					//	dark grey
		Card8		cmd_5;
		Card32		color_5;
		
		Rect		rect_2;
		Rect		rect_3;
		
		Card8		zero_9;					//	black
		Card8		cmd_9;
		Card32		color_9;
		
	} wdo = {
		
		0x00, 0xBB, 0x00001101,				//	clear to light grey
		0x0C, 0xBB, 0x00000001,				//	nice, clean window, revert clear to white
		0x00, 0xBA, 0x0000000B,				//	draw with black
	  {	0x00, 0x81, 0, 0,					//	moveto
		0x00, 0xC1, dx-1, 0, 2,				//	lineto
			  0xC1, dx-1, dy-1, 2,			//	lineto
			  0xC1, 0, dy-1, 2,				//	lineto
			  0xC1, 0, 0, 2, 0x00 },		//	lineto
		0x00, 0xBA, 0x00000009,				//	draw with dark grey
	  {	0x00, 0x81, 1, dy-2,				//	moveto
		0x00, 0xC1, 1, 1, 3,				//	lineto
			  0xC1, dx-2, 1, 3,				//	lineto
			  0xC1, dx-2, dy-2, 2,			//	lineto
			  0xC1, 2, dy-2, 2, 0x00 },		//	lineto
	  {	0x00, 0x81, 2, dy-3,				//	moveto
		0x00, 0xC1, 2, 2, 3,				//	lineto
			  0xC1, dx-3, 2, 3,				//	lineto
			  0xC1, dx-3, dy-3, 2,			//	lineto
			  0xC1, 3, dy-3, 2, 0x00 },		//	lineto
		0x00, 0xBA, 0x00000002				//	draw with black (normal color)
	};
	
	menu->LibString (& wdo.zero_2, sizeof (wdo));
}

void
draw_sep_line (Menu* menu, Card16 x, Card16 y, Card16 dx)
{
	struct {
		
		Card8		zero_1;					//	window
		Card8		cmd_1;
		Card32		color_1;
		
		Card8		zero_2;
		Card8		cmd_2;
		Card16		x, y, dx, dy;
		Card8		mode;
		
		Card8		cmd_3;
		Card32		color_2;

		
	} wdo = {
		0x00, 0xBA, 0x00001104,				//	color to "separation color"
		0x00, 0xC2, x, y, dx, 0, 2,			//	draw segment
		      0xBA, 0x00000002				//	color to default
	};
	
	menu->LibString (& wdo.zero_1, sizeof (wdo));
}


void
set_cursor (Menu* menu, Card16 x, Card16 y)
{
	struct {
		
		Card8		zero_1;
		Card8		cmd_1;
		Card16		x;
		Card8		zero_2;
		Card8		cmd_2;
		Card16		y;
		
	} wdo = {
		0x00, 0xB0, x,
		0x00, 0xB1, y
	};
	
	menu->LibString (& wdo.zero_1, sizeof (wdo));
}

void
use_color_clear (Menu* menu, Card32 color)
{
	struct {
		
		Card8		zero_1;
		Card8		cmd_1;
		Card32		color;
		
	} wdo = {
		0x00, 0xBB, color
	};
	
	menu->LibString (& wdo.zero_1, sizeof (wdo));
}

void
use_color_set (Menu* menu, Card32 color)
{
	struct {
		
		Card8		zero_1;
		Card8		cmd_1;
		Card32		color;
		
	} wdo = {
		0x00, 0xBA, color
	};
	
	menu->LibString (& wdo.zero_1, sizeof (wdo));
}

void
make_window (Menu* menu, Card16 x, Card16 y, Card16 dx, Card16 dy)
{
	struct {
		
		Card8		zero_1;					//	window
		Card8		cmd_1;
		Card16		x, y, dx, dy;
		
	} wdo = {
		0x00, 0xAC, x, y, dx, dy			//	set window size
	};
	
	menu->LibString (& wdo.zero_1, sizeof (wdo));
}


