
		.REF	COLORS
		.REF	MODULES
		.REF	SMAKY
		.REF	MON
		.LOC	0
		.START	START
		.PROC	M68000

MAXMMENURES	= 200

		.LOC	0

OLMMODE:	.BLK.16	1		; mode de fonctionnement
 BLMMOUSEJUMP	= 0			;  MMENU avec mousejumping
 BLMMOUSENEAR	= 1			;  MMENU: les menus viennent
					;   ct de la flche de la souris

OLMDISTMMENU:	.BLK.16	1		; distance entre la flche de la souris
					; et le sous-menu en mode BLMMOUSENEAR
LLM:
		.LOC	0

OMSORY:		.BLK.16	1		; origine Y suprieure
OMSORX:		.BLK.16	1		; origine X gauche
OMSMAG:		.BLK.32	1		; bitmap des cases inactives
OMSNBC:		.BLK.16	1		; nb de cases
OMSLGX:		.BLK.16	1		; largeur d'une case
OMSLGY:		.BLK.16	1		; hauteur d'une case
OMSL1X:		.BLK.16	1		; largeur de la rfrence gauche
OMSL1Y:		.BLK.16	1		; hauteur dessus ligne de base
OMSNCX:		.BLK.16	1		; nb de colonnes
OMSNCY:		.BLK.16	1		; nb de cases par colonne
OMSAJX:		.BLK.16	1		; largeur suppl. 1re case pour modulo 8
OMSAJY:		.BLK.16	1		; hauteur suppl. 1re case pour modulo 2
OMSSVM:		.BLK.16	1		; sauvetage du mode
OMSWDO:		.BLK.16	1		; swdo originale
OMSFLG:		.BLK.32	1		; flags divers
OMSPSM:		.BLK.32	1		; position pour sous-menu
OMSCAP:		.BLK.16	1		; case pre
OMSPVP:		.BLK.32	1		; ^variables du menu pre
OMSRAN:		.BLK.16	1		; rang pour les paramtres
OMSLSTRES:	.BLK.8	MAXMMENURES*8	; liste des ressources
OMSPRES:	.BLK.32	1		; ^dans la liste des ressources
OMSDRAW3D:	.BLK.8	1		; TRUE => dessine en 3D
LGMVAR:
		.LOC	0

OBUFFER:	.BLK.8	100		; buffer
OPDDIS:		.BLK.32	1		; ^descripteur de la fentre rel
OFLAGS:		.BLK.8	1		; flags
 BUSEMO		= 3			;  utilise la souris
 BKEYMO		= 4			;  boutons souris par le clavier


OMGBASELINE:	.BLK.16	1		; mmenus: ligne de base
OMGMENUHANDLE:	.BLK.32	1		; mmenus: handle au type Mmenus
OMGRASTHANDLE:	.BLK.32	1		; mmenus: handle au type Raster
OMGRESCAN:	.BLK.32	1		; mmenus: canal RES
OMGRESCLE:	.BLK.32	1		; mmenus: cl RES
OMGRESMODE:	.BLK.32	1		; mmenus: mode de GET (avec ou sans clef)
OMGPMN:		.BLK.32	1		; mmenus: ^table du mmenu
OMGPPA:		.BLK.32	1		; mmenus: ^table des paramtres
OMGVPA:		.BLK.8	LMM		; mmenus: paramtres
OMGINI:		.BLK.8	1		; mmenus: initialisation
		.EVEN

OLMODE:		.BLK.8	LLM		; copie des ressources de mode
		.EVEN


		.LOC	0
START:
	MOVE.32	A4,A6
	LIB	?GETPDIS
	MOVE.32	A4,{A6}+OPDDIS
	MOVE.8	#2**BKEYMO,{A6}+OFLAGS
	MOVE.16	#3,D3
	LIB	?MOUSE

	MOVE.32	#16'55aa55aa,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF
	LIB	?GETDIM
	CLR.32	D3
	MOVE.32	#LOADDOT,D2
	LIB	?DRTRAME

	MOVE.32	#0,D3
	MOVE.32	#R16^MENU$,A3
	CALL	_MMENU

	EXIT


MENU$:	.ASCIZ	" "
	.8	-1
	.ASCIZ	" Prend "
	.ASCIZ	" Sauve "
	.8	-1
	.ASCIZ	" Quitte "
	.8	0
	.EVEN

_DRRECT3D:
	PUSHM.32 D1|D2|D3|D4

	LIB	?COLORPUSH

	TEST.16	D1			; enfonc ?
	JUMP,NS	R8^DROP$		; oui => permute les couleurs
	JUMP,EQ	LINE$

	PUSH.32	D3
	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORSR
	MOVE.32	#COLOR_PPDGREY,D3
	LIB	?COLORCR
	POP.32	D3
	JUMP	R8^DO$

DROP$:	PUSH.32	D3
	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORCR
	MOVE.32	#COLOR_PPDGREY,D3
	LIB	?COLORSR
	POP.32	D3
	NEG.16	D1

DO$:	mon	?afx8
	ex.32	d3,d4
	mon	?afspace
	mon	?afx8
	mon	?afcr
	ex.32	d3,d4

	CALL	RECT$			; dessine un rectangle en relief
	CALL	REDUCE$

	DEC.16	D1
	JUMP,NE	DO$

EXIT$:	LIB	?COLORPOP

	POPM.32	D1|D2|D3|D4
	RET

LINE$:	PUSH.32	D3
	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORCR
	MOVE.32	#COLOR_PPDGREY,D3
	LIB	?COLORSR
	POP.32	D3

	CALL	RECT$			; cadre enfonc
	CALL	REDUCE$			; rduit d'un point

	PUSH.32	D3
	MOVE.32	#COLOR_PPLGREY,D3
	LIB	?COLORCR
	MOVE.32	#COLOR_PPBLACK,D3
	LIB	?COLORSR
	POP.32	D3
	CALL	RECT$
	JUMP	EXIT$


REDUCE$:
	ADD.16	#1,D3
	SUB.16	#2,D4
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	#1,D3
	SUB.16	#2,D4
	SWAP.32	D3
	SWAP.32	D4
	RET


RECT$:	PUSH.32 D4
	PUSH.32	D3

	MOVE.32	#SETDOT,D2

;	MOVE.32	{SP}+0,D3			; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+4+2,D4
	INC.16	D4				; D4 <-- [0;dx]
	CALL	_DRSEG

	MOVE.32	{SP}+0,D3			; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+4+0,D4
	INC.16	D4
	SWAP.32	D4				; D4 <-- [dy;0]
	CALL	_DRSEG

	MOVE.32	#CLRDOT,D2
	MOVE.32	{SP}+0,D3
	ADD.32	#16'00010000,D3
	ADD.16	{SP}+4+2,D3			; D3 <-- [y;x]
	MOVE.32	{SP}+4+0,D4
	CLR.16	D4				; D4 <-- [dy;0]
	CALL	_DRSEG

	MOVE.32	{SP}+0,D3
	INC.16	D3
	SWAP.32	D3
	ADD.16	{SP}+4+0,D3
	SWAP.32	D3				; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+4+2,D4			; D4 <-- [0;dx]
	CALL	_DRSEG

	POP.32	D3
	POP.32	D4
	RET

_DRSEG:	LIB	?DRSEG
	RET

RLIBMENUGRIS  = 0
RLIBMENUOMBRE = 1

RESGETLMODE:
RESDEFTRAME:
	RET

RECTOMBRES:
	LIB	?DRRECTO
	RET

	.INS	LIBMMENU.ASI

	.END

