
#include "biosdriver.h"

const char*	BIOSDriver::driver_name = "TEST";
Card8		BIOSDriver::driver_attr = BIOS_ATTR_RDOK+BIOS_ATTR_WROK;
Card8		BIOSDriver::driver_prio = 0;
Card8		BIOSDriver::driver_type = BIOS_TYPE_IO;
Card16		BIOSDriver::driver_base = 0x006C;

static char buffer[100];

Int16
new_bios_driver (Card32 type, Card32 desc, BIOSDriver* & drv, Card32 num)
{
    if (num > 10) return 1;
    Int16 error = 0;
    drv = new (type, desc) BIOSDriver (error, num);
    return error;
}


BIOSDriver::BIOSDriver (Int16& error, Card32 num)
{
    error = (num == 0) ? 3 : 0;
}

BIOSDriver::~BIOSDriver ()
{
}

Int16
BIOSDriver::Open ()
{
    return 0;
}

Int16
BIOSDriver::Command (const char* cmd)
{
    return 1;
}

Int16
BIOSDriver::ReadStatus (void* buffer, Card32 length)
{
    return 1;
}

Int16
BIOSDriver::ReadData (void* buffer, Card32 pos, Card32 length)
{
    return 1;
}

Int16
BIOSDriver::WriteData (const void* buffer, Card32 pos, Card32 length)
{
	const char* t = (const char*)(buffer);
	while (length--) {
		asm volatile ( "moveb %0,d3; .word 0xa022" : : "g" (*t) : "d3" );
		t++;
	}
    return 0;
}

Int16
BIOSDriver::Close ()
{
    return 0;
}

Int16
BIOSDriver::Stop ()
{
    return 1;
}

Int16
BIOSDriver::Start ()
{
    return 1;
}

Int16
BIOSDriver::Abort ()
{
    return 1;
}

Int16
BIOSDriver::Aux1 (const char* cmd, Card32& wr, const void* pwr, Card32& rd, void* prd)
{
    return 1;
}

Int16
BIOSDriver::Aux2 (const char* cmd, Card32& wr, const void* pwr, Card32& rd, void* prd)
{
    return 1;
}

void*
BIOSDriver::operator new (long int size, Card32 type, Card32 desc)
{
    return (void*)(buffer);
}

void
BIOSDriver::operator delete (void* ptr)
{
}


