; $CALM:

	.TITLE	DBGSYS.ASL

;	----------------------------------------
;		(C) 1992 - Pierre Arnaud
;	----------------------------------------

;	Source du module de librairie de dverminage
;	systme, offrant des services d'exploration de
;	la mmoire.

	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	DBGSYS
	.REF	BIOSDRIV

REVMAJ	= 0
REVMIN	= 2

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC-system SA"
	.START	-1



;	Clefs d'accs aux routines et donnes du systme.
;	=================================================

BufPiste	= TRUE		; buffer pour une piste du disque
NewNMI		= FALSE		; nouvelle gestion du NMI

	.INS	..:SYSDEF.ASI
	.INS	..:NTRSDF.ASI
	.INS	..:GSMSDF.ASI
	.INS	..:BIOSDF.ASI

;	Dfinitions extraites de NTRSYSC.ASI
;	====================================

; offsets relatifs  _INDNTR

oin_OPMFRD	= 16'4
oin_CLORMF	= 16'8
oin_TSTMRK	= 16'C		; teste validit d'un pointeur GESMEM

oin_CPTA13	= 16'10
oin_MIMAWZ	= 16'14

oin_TERDY	= 16'18
oin_NBPRIO	= 16'1C
oin_TEWD1	= 16'1E
oin_TEWD2	= 16'22
oin_TEWD3	= 16'26
oin_PNOCRE	= 16'2A
oin_PDFIRST	= 16'2E		; processus premier
oin_TEFIME	= 16'32		; liste de la mmoire libre
oin_MFSYSEM	= 16'36
oin_MFSYDBAL	= 16'3A
oin_MFSYBAL	= 16'3E
oin_NBODPP	= 16'42
oin_SYSAGEHIW	= 10'90



;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	DBGSYS_FIRST
	.16	DBGSYS_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"DBGSYS"
	.FILL.8	(LGHLIB-APC),0
	.16	_DBGSYS_FORfreeMEM
	.16	_DBGSYS_WHATABOUT



;---------------------\\
;  _DBGSYS_FORfreeMEM  >
;=====================/

; Appelle une routine pour chaque lment de mmoire libre. La
; routine (*) possde l'interface suivante :
;
;	-->	D2.32	#DBGMEMFREE
;		D5.32	paramtre pour la routine
;		A4.32	^dbut de l'lment
;		D4.32	taille de l'lment
;	<--	D7.16	#0 => continuer / autre => arrter

; in	A5.32	^routine  appeler
;	D5.32	paramtre pour la routine (*)
; out	D7.16	erreur retourne par la routine
; mod	D7.16

_DBGSYS_FORfreeMEM:
	PUSHM.32 A1

	MOVE.32	_INDNTR,A1
	MOVE.32	{A1}+oin_TEFIME,A1		; ^descripteur de la liste des libres
	CALL	DBG_FORmcptLIST			; passe en revue le compte entier

ERR$:	POPM.32	A1
	TEST.16	D7
	RET



;--------------------\\
;  _DBGSYS_WHATABOUT  >
;====================/

; Essaie de dterminer  quoi correspond une adresse mmoire en
; parcourant successivement toutes les listes possibles et
; imaginables de GESMEM.

; in	A3.32	^record initialis
; out	{A3}++	record rempli
;	D7.16	ok/erreur
; mod	D7.16

_DBGSYS_WHATABOUT:
	PUSHM.32 D0..D6|A0..A6

	MOVE.32	A3,D5
	MOVE.32	#R16^FORPROCESS$,A5
	CALL	DBG_FOReveryPROCESS		; passe en revue tous les processus
	JUMP,NE	FOUND$

	MOVE.32	#R16^FORDRIVER$,A5
	CALL	DBG_FOReveryDRIVER		; passe en revue tous les pilotes
	JUMP,NE	FOUND$

	MOVE.32	#R16^FORMEMORY$,A5
	MOVE.32	_INDNTR,A1
	MOVE.32	{A1}+oin_TEFIME,A1		; ^descripteur de la liste des libres
	CALL	DBG_FORmcptLIST			; passe en revue le compte entier
	JUMP,NE	FOUND$

	MOVE.16	#MTYPSYS,{A3}+OdbRECS+OdbgTYPE	; compte systme..

	MOVE.32	#R16^FORMEMORY$,A5
	MOVE.32	_INDNTR,A1
	MOVE.32	{A1}+oin_TEFIME,A1		; ^descripteur de la liste des libres
	ADD.A16	#8,A1				; ^descripteur de la liste des sous-comptes systme
	CALL	DBG_FORmcptLIST			; passe en revue le compte entier
	JUMP,NE	FOUND$

	MOVE.16	#1,D7
	JUMP	R8^ERR$

FOUND$:	CLR.16	D7

ERR$:	POPM.32	D0..D6|A0..A6
	TEST.16	D7
	RET


; Pour tous les processus :

; in	D5.32	^variables de la routine
;	A1.32	^liste d'un compte
;	A2.32	^descripteur du processus
;		 {A2}+OPPTUSTK, ^sommet stack USER
;		 {A2}+OPLGUSTK, longeur du stack USER
;		 {A2}+OPPTSSTK, ^sommet du stack superviseur
;		 {A2}+OPNAME, nom du processus
;		 {A2}+OPNUM, numro du processus
; out	D7.16	#0 => continue / #1 => arrte
; mod	D7.16

FORPROCESS$:
	PUSHM.32 D5|A3|A4|A5|A6

	CLR.16	D7
	MOVE.32	D5,A5
	MOVE.32	{A5}+OdbCOUNT,D5
	MUL.16	#LGDBGREC,D5
	MOVE.32	#{A5}+32^{D5}+OdbRECS,A6	; A6 <-- sous-record

	MOVE.32	#{A2}+OPNAME,A3
	MOVE.32	A3,{A6}+OdbgNAME		; <-- ^nom du processus actuel
	MOVE.32	#DBGxPROCESS,{A6}+OdbgWHAT	; <-- processus
	MOVE.16	{A2}+OPNUM,{A6}+OdbgNUM		; <-- numro du processus actuel
	MOVE.32	A2,{A6}+OdbgPTEXEC		; <-- descripteur du processus actuel
	MOVE.16	#MTYPCP,{A6}+OdbgTYPE		; <-- compte propre au processus

	MOVE.32	{A5}+OdbADDRESS,A4		; A4 <-- adresse  chercher
	MOVE.32	{A2}+OPPTUSTK,A3		; A3 <-- ^sommet pile user
	ADD.32	#LGSUSTK,A3
	COMP.32	A3,A4				; sous la pile ?
	JUMP,LO	R8^NOUSTK$			; oui => pas a
	ADD.32	{A2}+OPLGUSTK,A3		; A3 <-- ^fond pile user
	COMP.32	A3,A4				; sur la pile ?
	JUMP,HS	R8^NOUSTK$			; oui => pas a

	MOVE.32	#DBGUSERSTACK,{A6}+OdbgWHAT	; <-- pile user
	MOVE.32	{A2}+OPPTUSTK,{A6}+OdbgSTART	; <-- dbut de la pile
	MOVE.32	{A2}+OPLGUSTK,{A6}+OdbgSIZE	; <-- longueur de la pile
	JUMP	STOPPROC$

NOUSTK$:
	MOVE.32	{A2}+OPPTSSTK,A3		; A3 <-- ^sommet pile superviseur
	COMP.32	A3,A4				; sous la pile ?
	JUMP,LO	R8^NOSSTK$			; oui => pas a
	ADD.32	#LGPSSTK,A3			; A3 <-- ^fond pile superviseur
	COMP.32	A3,A4				; sur la pile ?
	JUMP,HS	R8^NOSSTK$			; oui => pas a

	MOVE.32	#DBGSUPERSTACK,{A6}+OdbgWHAT	; <-- pile superivseur
	MOVE.32	{A2}+OPPTSSTK,{A6}+OdbgSTART	; <-- dbut de la pile
	MOVE.32	#LGPSSTK,{A6}+OdbgSIZE		; <-- longueur de la pile
	JUMP	STOPPROC$

NOSSTK$:
	INC.32	{A5}+OdbCOUNT
	MOVE.32	A5,D5
	MOVE.32	#R16^FORMEMORY$,A5
	CALL	DBG_FORmcptLIST			; passe en revue tout le compte mmoire
	JUMP,NE	R8^CONTPROC$
	MOVE.32	D5,A5
	DEC.32	{A5}+OdbCOUNT
	JUMP	R8^CONTPROC$

STOPPROC$:
	MOVE.16	#1,D7

CONTPROC$:
	POPM.32	D5|A3|A4|A5|A6
	TEST.16	D7
	RET

; Pour tous les (sous-)comptes

; in	D5.32	^variables de la routine
;	D2.32	type de l'lment de mmoire
;	+ ..	infos selon (A0/D4/A4/D3/D6/A3)
; out	D7.16	#0 => continue / #1 => arrte
; mod	D7.16

FORMEMORY$:
	PUSHM.32 D5|A0|A1|A5|A6

	CLR.16	D7
	MOVE.32	D5,A5
	MOVE.32	{A5}+OdbCOUNT,D5
	MUL.16	#LGDBGREC,D5
	MOVE.32	#{A5}+32^{D5}+OdbRECS,A6	; A6 <-- sous-record

	MOVE.32	D2,{A6}+OdbgWHAT

	COMP.32	#DBGFREEMEM,D2
	JUMP,EQ	MEMFREE$
	COMP.32	#DBGERRMEM,D2
	JUMP,EQ	MEMBLOCK$
	COMP.32	#DBGMEMCHUNK,D2
	JUMP,EQ	MEMCHUNK$
	COMP.32	#DBGHANDLEMEM,D2
	JUMP,EQ	MEMHANDLE$
	COMP.32	#DBGMEMACCOUNT,D2
	JUMP,EQ	MEMACCOUNT$
	JUMP	CONTMEM$

MEMACCOUNT$:
	MOVE.32	#{A0}+OMCLIST,A1	; A1 <-- ^liste des lments dans ce compte
	INC.32	{A5}+OdbCOUNT
	MOVE.16	#MTYPUSER,{A6}+LGDBGREC+OdbgTYPE
	MOVE.32	A3,{A6}+OdbgNAME
	MOVE.32	A5,D5
	MOVE.32	#R16^FORMEMORY$,A5
	CALL	DBG_FORmcptLIST		; appel rcursif
	JUMP,NE	R8^CONTMEM$
	EX.32	A5,D5
	DEC.32	{A5}+OdbCOUNT
	EX.32	A5,D5

	JUMP	R8^CONTMEM$

MEMHANDLE$:
	MOVE.32	A3,{A6}+OdbgHANDLE
	MOVE.16	D6,{A6}+OdbgLOCK
	MOVE.16	D3,{A6}+OdbgATTR

MEMFREE$:
MEMBLOCK$:
MEMCHUNK$:
MEMGENERAL$:
	MOVE.32	{A5}+OdbADDRESS,A0
	COMP.32	A4,A0
	JUMP,LO	CONTMEM$
	MOVE.32	#{A4}+32^{D4},A1
	COMP.32	A1,A0
	JUMP,HS	CONTMEM$

	MOVE.32	A4,{A6}+OdbgSTART
	MOVE.32	D4,{A6}+OdbgSIZE
	MOVE.16	#1,D7

CONTMEM$:
	POPM.32 D5|A0|A1|A5|A6
	TEST.16	D7
	RET

; Pour tous les drivers :

; in	D5.32	^variables de la routine
;	A4.32	^desc. pilote
;	D4.16	numro du pilote
;	A3.32	^nom du pilote
;	A1.32	^liste du compte
; out	D7.16	#0 => continue / #1 => arrte
; mod	D7.16

FORDRIVER$:
	PUSHM.32 D5|A0|A1|A5|A6

	CLR.16	D7
	MOVE.32	D5,A5
	MOVE.32	{A5}+OdbCOUNT,D5
	MUL.16	#LGDBGREC,D5
	MOVE.32	#{A5}+32^{D5}+OdbRECS,A6	; A6 <-- sous-record

	MOVE.32	#DBGxDRIVER,{A6}+OdbgWHAT
	MOVE.32	A3,{A6}+OdbgNAME
	MOVE.16	D4,{A6}+OdbgNUM

	INC.32	{A5}+OdbCOUNT
	MOVE.16	#MTYPBD,{A6}+LGDBGREC+OdbgTYPE

	MOVE.32	A5,D5
	MOVE.32	#R16^FORMEMORY$,A5
	CALL	DBG_FORmcptLIST		; appel rcursif
	JUMP,NE	R8^CONTDRIV$
	EX.32	A5,D5
	DEC.32	{A5}+OdbCOUNT
	EX.32	A5,D5

CONTDRIV$:
	POPM.32 D5|A0|A1|A5|A6
	TEST.16	D7
	RET




;------------------\\
;  DBG_FORmcptLIST  >
;==================/

; Appelle une fonction pour chaque lment de mmoire d'un compte
; (tranches mmoires, handles, comptes, etc...)

; in	A1.32	^liste d'un compte
;	A5.32	^routine  appeler
;	D5.32	paramtre pour la routine
; out	D7.16
; mod	D7.16

DBG_FORmcptLIST:
	PUSH.32	A0

	CLR.16	D7
	TEST.32	{A1}+OCFIRST		; teste si ^first OK
	JUMP,EQ	END$			; non => termin

	MOVE.32	{A1}+OCFIRST,A0

LOOP$:	CALL	DBG_FORmemELEMENT	; traite l'lment
	JUMP,NE	R8^END$			; erreur => termine

	TEST.8	{A0}+OEFLA0:#BELACH	; dernier lment de file ?
	JUMP,BS	END$			; oui => termin

	MOVE.32	{A0}+OENEXT,A0
	JUMP	LOOP$

END$:	POP.32	A0
	TEST.16	D7
	RET



;--------------------\\
;  DBG_FORmemELEMENT  >
;====================/

; Appelle une fonction pour l'lment de mmoire et ventuellement
; pour ses descendants (sous-comptes, ...).

; in	A0.32	^lment mmoire
;	A5.32	^routine  appeler
;	D5.32	variable pour la routine
; out	D7.16	erreur
; mod	D7.16

DBG_FORmemELEMENT:
	PUSHM.32 D2|D3|D4|D6|A1|A3|A4

	MOVE.32	A0,A4
	MOVE.32	_INDNTR,A1
	ADD.32	{A1}+oin_TSTMRK,A1
	CALL	{A1}			; teste validit du pointeur A4 => D7 et D0 erreur pointeur
	JUMP,EQ	NOER$			; pas d'erreur => ok

	TEST.16	D0			; erreur de pointeur ?
	JUMP,EQ	NOER$			; non => ok

	TEST.16	{A0}+OMCHECK		; checksum effac ?
	JUMP,NE	ERR$			; non => erreur

; On a trouv un vritable morceau de mmoire libre !

	MOVE.32	#DBGFREEMEM,D2		; D2 <-- mmoire libre
	JUMP	NOTACCOUNT$

ERR$:	MOVE.32	#DBGERRMEM,D2		; D2 <-- mmoire bitrange
	JUMP	NOTACCOUNT$

; Elment valide. Qu'est-ce ?

NOER$:	TEST.8	{A0}+OMFLA1:#BHANDLE	; est-ce un handle ?
	JUMP,BC	NOTHANDLE$		; non => suite

	MOVE.32	{A0}+OHSIZE,D4		; D4 <-- taille du handle
	JUMP,EQ	PURGED$			; rien => purg

	MOVE.32	#DBGHANDLEMEM,D2	; D2 <-- mmoire du handle
	MOVE.32	{A0}+OHPTMEM,A4		; A4 <-- ^mmoire associe au handle
	JUMP	EPU$

PURGED$:
	MOVE.32	#DBGPURGEHANDLE,D2	; D2 <-- handle purg

EPU$:	MOVE.16	{A0}+OHCNTLOCK,D6	; D6 <-- nombre de locks
	MOVE.16	{A0}+OHATTR,D3		; D3 <-- attributs
	MOVE.32	A0,A3
	CALL	{A5}			; appelle la routine de traitement
	JUMP	END$

; Ce n'est pas un handle, ce peut tre un compte ou une
; tranche mmoire.

NOTHANDLE$:
	MOVE.32	#DBGMEMCHUNK,D2		; D2 <-- tranche mmoire (par dfaut)

	TEST.8	{A0}+OMFLA1:#BCPT
	JUMP,BC	NOTACCOUNT$

	MOVE.32	#{A0}+OMCNAME,A3	; A3 <-- ^nom du compte mmoire
	MOVE.32	#DBGMEMACCOUNT,D2	; D2 <-- compte mmoire
	CALL	{A5}
	JUMP	END$

; Ce n'est pas un compte mmoire valide (liste des libres)...

NOTACCOUNT$:
	MOVE.32	{A0}+OMLEN,D4		; D4 <-- longeur de la tranche
	MOVE.32	A0,A4			; A4 <-- ^tranche
	CALL	{A5}			; appelle la routine de traitement

END$:	POPM.32	D2|D3|D4|D6|A1|A3|A4
	TEST.16	D7
	RET




;----------------------\\
;  DBG_FOReveryPROCESS  >
;======================/

; Passe en revue chaque processus connu (dans la liste
; des processus) et appelle la routine passe en entre.

; in	A5.32	^routine  appeler
;	D5.32	paramtre pour la routine
; out	D7.16	erreur
; mod	D7.16

DBG_FOReveryPROCESS:
	PUSHM.32 D0|A2

	CLR.16	D7
	MOVE.32	_INDNTR,A2
	MOVE.32	{A2}+oin_PDFIRST,A2	; A2 ^@^processus premier
	MOVE.32	{A2},A2			; A2 ^processus premier

LOOP$:	PUSH.32 A1
	MOVE.32	#{A2}+OPMDESC,A1	; A1 <-- ^tte file mmoire
	CALL	{A5}			; appelle la routine
	POP.32	A1
	JUMP,NE	END$			; flag => termine

	MOVE.32	{A2}+OPPTFI,D0		; 1er fils existant ?
	JUMP,NE	R8^SON$			; oui => ...

UNCLE$:	TEST.8	{A2}+OPFLA0:#BPFCPE	; frre cadet existant ?
	JUMP,EQ	R8^BROTHER$		; oui => ...

	MOVE.32	{A2}+OPPTFC,D0		; D0 ^pre
	JUMP,EQ	R8^END$			; inexistant => termin

	MOVE.32	D0,A2
	JUMP	UNCLE$			; cherche l'oncle cadet

SON$:	MOVE.32	D0,A2			; on descend d'un niveau
	JUMP	LOOP$

BROTHER$:
	MOVE.32	{A2}+OPPTFC,A2		; on reste au mme niveau
	JUMP	LOOP$

END$:	POPM.32	D0|A2
	TEST.16	D7
	RET



;---------------------\\
;  DBG_FOReveryDRIVER  >
;=====================/

; Passe en revue chaque driver connu (dans la liste
; des drivers) et appelle la routine passe en entre.

; in	A5.32	^routine  appeler (*)
;	D5.32	paramtre pour la routine
; out	D7.16	erreur
; mod	D7.16

DBG_FOReveryDRIVER:
	PUSH.32 A0

	CLR.16	D7
	MOVE.32	_INDNTR,A0
	MOVE.32	{A0}+oin_SYSAGEHIW,A0		; ^chane des BIOS
	ADD.A16	#6,A0				; ^TELIBI...hummm

	MOVE.32	{A0},A0				; ^lment premier

LOOP$:	PUSHM.32 D4|A1|A3|A4
	MOVE.32	{A0}+ODIptDRIV,A4		; A4 <-- ^desc. pilote
	MOVE.16	{A0}+ODINUM,D4			; D4 <-- numro du pilote
	MOVE.32	#{A4}+ODhNAME,A3		; A3 <-- nom du pilote
	MOVE.32	#{A0}+ODiMDESC,A1		; A1 <-- ^tte file mmoire
	CALL	{A5}
	POPM.32	D4|A1|A3|A4
	JUMP,NE	R8^END$

	TEST.8	{A0}+OEFLA0:#BELACH
	JUMP,BS	END$

	MOVE.32	{A0}+OENEXT,A0			; au suivant
	JUMP	LOOP$

END$:	POP.32	A0
	TEST.16	D7
	RET




END_MODULE:

	.END

