/*
 *	cleanup.cc
 *
 *	Le programme CLEANUP permet de nettoyer un ordinateur en vue de complter
 *	l'installation du systme 10.
 *
 *	En principe, START excute "SMA_SCLEAN #MM0:" lorsque l'on duplique le
 *	systme sur l'unit "#MM0:", juste aprs avoir fait le GENFBOOT.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 Suscvaz
 *
 *  -------------------------------------------------------------------------
 *	10.1	12/06/95	Ne copie plus le /D aprs un gnrateur de caractres
 *						plac dans le dossier systme.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cleanup.h"

Card32 _stksize = 10*1024;				// pile
Card32 _SMASOVER = 1;					// utilise entre OVERLAY de prfrence
Card8  _SMAPRIO = 16;					// priorit pas trop leve
Card8  _SMAREV = 10;					// rvision
Card8  _SMAVER = 1;						// version
Card32 _SMAUNIT = 0x000000A3;
char   _SMAIDE[] = "(C) 1995, Pierre ARNAUD et EPSITEC SA";

static Bool        g_stop;
static ExploreFunc g_func;
static const char* g_base;
static const char* g_crit;
static char*       g_sysdir;
static const char* g_sysunit;
static FILE*       g_historique;


static int
F_open (const char* name, Card32 mode, Card16* channel)
{
	short error = 0;
	
	asm volatile ( "movel %2,a3\n\t"
				   "movel %3,d3\n\t"
				   ".long 0x4E450000\n\t"
				   "movew d7,%0\n\t"
				   "movew d6,%1"
				 : "=g" (error), "=g" (*channel)
				 : "g" (name), "g" (mode)
				 : "d3", "d6", "d7", "a3" );
	
	return error;
}

static int
F_nrelease (const char* name, int mode)
{
	short error = 0;
	
	asm volatile ( "movel %1,a3\n\t"
				   "movel %2,d3\n\t"
				   ".long 0x4E450033\n\t"
				   "movew d7,%0"
				 : "=g" (error)
				 : "g" (name), "g" (mode)
				 : "d3", "d7", "a3" );
	
	return error;
}



static char tmp_buf[200];

/*
 *	Affiche les messages pendant le fonctionnement du programme.
 */

static void
print_message (const char* message)
{
	Point pos = { 0, 0 };
	L_getcurs (&pos);
	L_afcar (CHAR_NOCURS);
	L_aftext (message);
	L_afcar (CHAR_EFLI);
	L_setcurs (pos);
}



/*
 *	Explore le/les dossier(s) en utilisant le critre spcifi.
 *	Pour chaque nom de fichier, une fonction est appele.
 */

static void
explore (const char* dir, const char* crit, ExploreFunc func)
{
	Card32 mode   = FOS_OPEXTEND | FOS_OPNAME | FOS_OPNEXT | FOS_LIDOSSIER | FOS_LICNOM;
	Card16 nodep  = 0;
	Card32 nfiles = 0;
	int    error  = 0;
	Card16 chan   = 0;
	char   buffer[256];
	
	while (g_stop == FALSE) {
		
		error = F_listopen (dir, crit, mode, buffer, &nodep, &nfiles, &chan);
		if (error) break;
		
		const char*      name = 0;
		const SmakyArgs* args = 0;
		
		while (F_listnext (chan, &name, &args) == 0) {
			
			g_func = func;
			g_base = buffer;
			g_crit = crit;
	
			Card32 code = L_ifcar ();
			
			if ( ((code & 0xFF) == 0x92)		//	arrte si END ou F0
			  || ((code & 0xFF) == 0x80) ) {
				L_wrakey (code);				//	remet la touche dans le clavier..
				g_stop = TRUE;					//	..et stoppe tout !
				break;
			}
			
			(func)(buffer, name, args);
			
			if (g_stop) break;
		}
		
		F_listclose (chan);
		F_nrelease (dir, 1 << 31);
	}
}


static Bool genc_init = FALSE;
static Bool genc_ok   = FALSE;

static void
setup_genc ()
{
	if (genc_init == FALSE) {
		
		Card32      serialnumber = 0;
		Card32      smakytype    = 0;
		const char* text         = "";
		
		N_getmachine (&serialnumber, &smakytype, &text);
		
		if (smakytype == SMAKY130) {
			sprintf (tmp_buf, "%s%sGENC:", g_sysunit, g_sysdir);
			F_cdir (tmp_buf, 97);
			genc_ok = TRUE;
		}
		
		sprintf (tmp_buf, "%sA_RANGER:", g_sysunit);
		F_cdir (tmp_buf, 13);
	}
}
	

/*
 *	Dplace le fichier .GENC dans le dossier systme, si ceci
 *	est possible (un Smaky 130).
 */

static void
handle_genc_file (const char* name, const char* file)
{
	if (genc_ok == FALSE) {
		return;
	}
	
	char command[200];
	
	strcpy (command, "MV ");
	strcat (command, name);
	strcat (command, " ");
	strcat (command, g_sysunit);
	strcat (command, g_sysdir);
	strcat (command, "GENC:");
	strcat (command, file);
	system (command);
}

static void
genc_move (const char* pfix_unit, const char* pfix_dir, const char* name)
{
	char command[200];
	
	strcpy (command, "MV ");
	strcat (command, pfix_unit);
	strcat (command, pfix_dir);
	strcat (command, name);
	strcat (command, " ");
	strcat (command, g_sysunit);
	strcat (command, g_sysdir);
	strcat (command, "GENC:");
	system (command);
}

static void
trash_move (const char* pfix_unit, const char* pfix_dir, const char* name)
{
	char command[200];
	
	strcpy (command, "MV ");
	strcat (command, pfix_unit);
	strcat (command, pfix_dir);
	strcat (command, name);
	strcat (command, " ");
	strcat (command, g_sysunit);
	strcat (command, "A_RANGER:");
	system (command);
}


/*
 *	Copie un fichier dans un autre (qui doit exister) sans en modifier
 *	la date de cration...
 */

static void
copy_with_no_update (const char* src_name, const char* dst_name, const SmakyArgs* args)
{
	char   buffer[1024];
	Card32 length;
	Card16 src_ch;
	Card16 dst_ch;
	
	int src_err = F_open (src_name, FOS_OPRD, &src_ch);
	int dst_err = F_open (dst_name, FOS_OPWR, &dst_ch);
	
	if ( (src_err == 0)
	  && (dst_err == 0) ) {
		length = 1024;
		while (length == 1024) {
			F_rdbyte (src_ch, &length, buffer);
			F_wrbyte (dst_ch, &length, buffer);
		}
	}
	
	if (src_err == 0) F_close (src_ch);
	if (dst_err == 0) F_clomdc (dst_ch, &args->cre_date);
}


/*
 *	Corrige un fichier "!" si certains fichiers *.GENC ne sont
 *	pas correctement grs.
 */

static void
handle_start_file (const char* name, const SmakyArgs* args)
{
	FILE* input  = fopen (name, "rt");
	FILE* output = fopen ("#TMPSYSDIR:SHADOW_%N", "wt");
	
	Bool ok      = FALSE;
	Bool is_genc = FALSE;
	
	if (input && output) {
		
		char* ptr  = tmp_buf;
		int   code = 0;
		int   num  = 0;
		
		for (;;) {
			
			code = fgetc (input);
			
			if (code == EOF) break;
			if (num++ < 100) *ptr++ = code;
			
			if ((code == '\n') || (code == '\r')) {
				ptr[0] = 0;
				ptr    = tmp_buf;
				if ( (strnicmp (ptr, "SMA_", 4) == 0)
				  && (strnicmp (ptr+9, ".GENC", 5) == 0)
				  && (strnicmp (ptr+4, "I", 1) != 0)
				  && (strnicmp (ptr+4, "J", 1) != 0)
				  && (strnicmp (ptr+4, "X", 1) != 0)
				  && ( (strnicmp (ptr+6, "P", 1) == 0)
				    || (strnicmp (ptr+6, "F", 1) == 0) )
				  && (num < 100) ) {
					fprintf (output, "#:");
					ok      = TRUE;
					is_genc = TRUE;
				}
				
				if (num < 100) {
					if (is_genc) {
						while (*ptr) {
							if ( (ptr[0] == '/') && ((ptr[1] == 'd') || (ptr[1] == 'D'))) {
								ptr += 2;
							} else {
								fprintf (output, "%c", ptr[0]);
								ptr += 1;
							}
						}
					} else {
						fprintf (output, "%s", ptr);
					}
				}
				
				ptr     = tmp_buf;
				is_genc = FALSE;
				num     = 0;
			}
		}
	}
	
	if (input) fclose (input);
	if (output) fclose (output);
	
	if (ok) {
		fprintf (g_historique, "Corrige le fichier %s.\n", name);
		copy_with_no_update ("#TMPSYSDIR:SHADOW_%N", name, args);
	}
	
	F_delete ("#TMPSYSDIR:SHADOW_%N");
}

/*
 *	Corrige le module de librairie s'il y a lieu.
 */

static void
handle_lib_file (const char* name, const SmakyArgs* args)
{
	int    error   = 0;
	Card16 channel = 0;
	Card32 length  = 0;
	
	error = F_open (name, FOS_OPRD, &channel);
	
	if (error == 0) {
		
		struct {
			SmakyLongHead head;
			Card32        start[4];
			Card32        path;
		} head;
		
		length = sizeof (head);
		F_rdbyte (channel, &length, &head);
		F_close (channel);
		
		if ( ((head.head.type & 0x04) == 0)
		  && (head.path == 0x00000000)
		  && ((head.start[0] & 0xF000F000) == 0xA000A000) ) {
			
			head.path = 0xAFEE6C9C;
			
			sprintf (tmp_buf, "Corrige le module %s", name);
			print_message (tmp_buf);
			fprintf (g_historique, "%s.\n", tmp_buf);
			
			F_open (name, FOS_OPWR, &channel);
			F_wrbyte (channel, &length, &head);
			F_clomdc (channel, &args->cre_date);
			
			char command[200];
			
			strcpy (command, "SMA_FIXCHK ");
			strcat (command, name);
			system (command);
		}
	}
}


/*
 *	Traite un fichier, en fonction de sa nature.
 */

static void
check_file (const char* dir, const char* name, const SmakyArgs* args)
{
	Card32 len = strlen (name);
	char   full[256];
	
	strcpy (full, dir);
	strcat (full, name);
	
	sprintf (tmp_buf, "Vrifie %s", full);
	print_message (tmp_buf);
	
	if (name[len-1] == ':') {
		explore (full, g_crit, g_func);
		return;
	}
	
	//	Trouve la fin du prfixe du fichier (s'il existe). C'est utile
	//	pour certains tests...
	
	const char* pfix_end = name;
	Card32      pfix_len = 0;
	
	while (pfix_end[0]) {
		pfix_len++;
		if (*pfix_end++ == '_') {
			break;
		}
	}
	
	//	Les modules *.LIB doivent tre corrigs, si ncessaire. On leur
	//	applique un "patch" afin de les rendre compatibles avec LIB 10 !
	
	if ( (len > 4)
	  && (pfix_len == 4)
	  && (strcmp (name+len-4, ".LIB") == 0) ) {
		handle_lib_file (full, args);
		return;
	}
	
	//	Les fontes doivent tre dplaces dans le dossier systme, si cela
	//	n'est pas encore le cas... Sauf les fontes farfelues (qui sont soit
	//	des icones, soit n'importe quoi -- starfield par exemple).
	
	if ( (len > 5)
	  && (strcmp (name+len-5, ".GENC") == 0)
	  && (pfix_end[0] != 'I')
	  && (pfix_end[0] != 'J')
	  && (pfix_end[0] != 'X')
	  && ( (pfix_end[2] == 'F')
	    || (pfix_end[2] == 'P') ) ) {
		handle_genc_file (full, name);
		return;
	}
	
	const char* ptr = name;
	
	//	Vrifie la syntaxe des fichiers "!" afin de garantir que les .GENC
	//	seront pris au bon endroit.
	
	while (ptr[0]) {
		if (*ptr++ == '!') {
			handle_start_file (full, args);
			return;
		}
	}
}



int
main (int argc, char* argv[])
{
	if (argc == 2) {
		
		F_cache ("mv");
		
		g_stop    = FALSE;
		g_sysdir  = "";
		g_sysunit = argv[1];
		
		SmakyBootBlock block;
		F_infodisk (g_sysunit, &block);
		
		g_sysdir = block.sys;
		char* p  = g_sysdir;
		
		while (*p) {
			if ((p[0] != ':') && (p[1] == 0)) {
				p[1] = ':';
				p[2] = 0;
				break;
			}
			p++;
		}
		
		int subdriver = 0;
		F_install ("#TMPSYSDIR", "$MEM", "", 0, &subdriver);
		
		setup_genc ();
		
		strcpy (tmp_buf, g_sysunit);
		strcat (tmp_buf, "A_RANGER:JOURNAL.DOC");
		g_historique = fopen (tmp_buf, "at");
		if (g_historique == 0) return 1;
		
		fprintf (g_historique, "Installe le systme.\n");
		
		explore (argv[1], "*", check_file);
		
		print_message ("Range les ressources");
		
		trash_move (g_sysunit, g_sysdir, "???_ROM_?.RS");
		trash_move (g_sysunit, g_sysdir, "???_SYSTEM_?.RS");
		trash_move (g_sysunit, g_sysdir, "#:START_?.RS");
		
		print_message ("Range les dmarrages rapides");
		
		trash_move (g_sysunit, g_sysdir, "???_SYSTEM.BIN");
		trash_move (g_sysunit, g_sysdir, "???_ROM.BIN");
		
		if (genc_ok) {
			print_message ("Met  jour le dossier GENC:");
			genc_move (g_sysunit, g_sysdir, "SMA_GENC.INFO");
			genc_move (g_sysunit, g_sysdir, "SMA_XCAR.INFO");
			genc_move (g_sysunit, g_sysdir, "GENC*.INFO");
		}
		
		F_nrelease ("#TMPSYSDIR", 0);
		F_deinstall ("#TMPSYSDIR", 0);
		F_decache ("mv");
		fclose (g_historique);
		
	} else {
		printf ("%s: nombre de paramtres incorrect !\n", argv[0]);
		N_delms (50);
	}
	return 0;
}

