/*
 *	cleanup.h
 *
 *	Le programme CLEANUP permet de nettoyer un ordinateur en vue de complter
 *	l'installation du systme 10.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 Suscvaz
 */

#ifndef _CLEANUP_H_
#define	_CLEANUP_H_

typedef unsigned char   Bool;
typedef unsigned char	Card8;
typedef unsigned short	Card16;
typedef unsigned long	Card32;

#define	TRUE	((Bool)(1))
#define	FALSE	((Bool)(0))

struct SmakyDate
{
	Card8		day, month, year, hour, minute, second;
};

struct SmakyArgs
{
	Card8		type;			//	type of file
	Card8		open;			//	opening counter
	Card32		attributes;		//	file attributes
	Card32		block_num;		//	file length in blocks
	Card16		block_last_len;	//	# of bytes in the last block
	SmakyDate	cre_date;		//	creation date+time
	SmakyDate	mod_date;		//	last modification date+time
	SmakyDate	use_date;		//	last use date+time
	Card32		res_1;
	Card32		ptr_bd;
	Card32		file_len;		//	file length in bytes
	Card8		res_2[22];
};

struct SmakyShortHead
{
	Card8		type;
	Card8		priority;
	Card16		check;		
	Card32		load;
	Card32		start;
	Card32		length;
	Card32		stack;
	Card32		start_overlay;
	Card8		revmin, revmaj;
};

struct SmakyLongHead : SmakyShortHead
{
	Card8		stuff_1[102];
	Card8		identifier[128];
};

struct Point
{
	Card16		y;
	Card16		x;
};

struct SmakyBootBlock
{
    char		sys[44];
    char		name[16];
    Card32		check;
    char		message[172];
    Bool		change;
    Bool		ok_check;
    Card8		filler[18];
};

extern "C" int F_listopen (const char* dir, const char* crit,
			   Card32 mode, char* name, Card16* nodep, Card32* nfiles, Card16* canal);
extern "C" int F_listnext (Card16 canal, const char** name, const SmakyArgs** args);
extern "C" int F_listclose (Card16 canal);
extern "C" int F_cdir (const char* directory, int hash);
extern "C" int F_delete (const char* filename);
extern "C" int F_infodisk (const char* name, SmakyBootBlock* bootblk);
extern "C" int F_open (const char* filename, Card32 mode, Card16* canal);
extern "C" int F_close (Card16 canal);
extern "C" int F_clomdc (Card16 canal, const SmakyDate* ctime);
extern "C" int F_rdbyte (Card16 canal, Card32* len, void* data);
extern "C" int F_wrbyte (Card16 canal, Card32* len, void* data);
extern "C" int F_cache (const char* name);
extern "C" int F_decache (const char* name);
extern "C" int F_install (const char* logical, const char* physical, const void* params, int pid, int* subdriver);
extern "C" int F_deinstall (const char* logical, int pid);
extern "C" int F_nrelease (const char* dir, int mode);
extern "C" int L_afcar (int c);
extern "C" int L_aftext (const char* string);
extern "C" int L_setcurs (Point p);
extern "C" int L_getcurs (Point* p);
extern "C" Card32 L_ifcar ();
extern "C" int L_wrakey (Card32 code);

extern "C" int N_delms (int dt);
extern "C" int N_getmachine (Card32* serialnumber, Card32* smakytype, const char** textes);

typedef void (*ExploreFunc)(const char* dir, const char* name, const SmakyArgs* args);

#define	FOS_OPRD		0x00000002L		/* read open */
#define	FOS_OPWR		0x00000004L		/* write open */
#define	FOS_OPEXTEND	0x00000008L		/* extended mode */
#define	FOS_OPNAME		0x00000200L		/* ask access string to file */
#define	FOS_OPNEXT		0x00000400L		/* ask next */
#define	FOS_LIDOSSIER	0x00800000L		/* xxx.DIR -> xxx: */
#define	FOS_LICNOM		0x80000000L		/* sorted by name */

#define SMAKY130		8

#define	CHAR_EFLI		0x8A
#define CHAR_NOCURS		0x9D


#endif /* _CLEANUP_H_ */

