/*
 *	clepack.cc
 *
 *	CLEPACK permet d'analyser le contenu d'un fichier CLE et de gnrer
 *	un fichier compact pour une machine prcise.
 *
 *	(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned long _stksize   = 8*1024;
unsigned long _SMASOVER  = 1;
unsigned char _SMAPRIO   = 13;
unsigned char _SMAREV    = 0;
unsigned char _SMAVER    = 1;
unsigned long _SMAUNIT   = 0x000000A7;
unsigned short _SMADIS[] = {20, 2000, 20, 2000};
char _SMAIDE[] = "(C) 1996 Pierre ARNAUD, OPaC bright ideas";

#define	LINE_LEN	200

struct Context
{
	FILE*		file;
	int			line;
	const char*	name;
	int			level;
};

Context     g_ctx = { 0, 0, 0, 0 };
FILE*       g_out = 0;
const char* g_m   = "%m";
const char* g_n   = "%n";


void read_line (char* line);
void emit_line (const char* line);
void strip_spaces (char* line);
void error (const char* error);

void trash_to (char* line, const char*, const char* = 0);
void parse_to (char* line, const char*, const char* = 0);

void parse_file (const char* name);
void parse_line (char* line);


/*
 *	Lit une ligne depuis le fichier source.
 */

void
read_line (char* line)
{
	int count = LINE_LEN - 2;
	int c     = fgetc (g_ctx.file);
	
	while (c != EOF) {
		
		*line++ = c;
		
		if (c == '\n') break;
		if (c == '\r') break;
		
test:	if (count-- <= 0) {
			error ("Ligne trop longue");
		}
		
		c = fgetc (g_ctx.file);
		
		if (line[-1] == '%') {
			
			if ((c == 'm') || (c == 'M')) {
				int len = strlen (g_m);
				count  -= len - 1;
				if (count > 0) {
					strcpy (line-1, g_m);
					line += len - 1;
				}
				goto test;
			}
			
			if ((c == 'n') || (c == 'N')) {
				int len = strlen (g_n);
				count  -= len - 1;
				if (count > 0) {
					strcpy (line-1, g_n);
					line += len - 1;
				}
				goto test;
			}
		}
	}
	
	g_ctx.line++;
	
	line[0] = 0;
}


/*
 *	Emet une ligne...
 */

void
emit_line (const char* line)
{
	if ( (strnicmp (line, "endif", 5) == 0)
	  || (strnicmp (line, "else", 4) == 0) ) {
		g_ctx.level--;
	}
	
	int level = g_ctx.level;
	
	while (level-- > 0) fprintf (g_out, "  ");
	
	fprintf (g_out, "%s", line);
	
	if ( (strnicmp (line, "if", 2) == 0)
	  || (strnicmp (line, "else", 4) == 0) ) {
		g_ctx.level++;
	}
}


/*
 *	Supprime les espaces et le point ventuel qui trane en dbut
 *	de ligne.
 */

void
strip_spaces (char* line)
{
	char  buffer[LINE_LEN];
	char* ptr = buffer;
	
	strcpy (buffer, line);
	
	for (ptr = buffer; *ptr; ptr++) {
		if (ptr[0] == ' ') continue;
		if (ptr[0] == '\t') continue;
		if ((ptr[0] == '.') && (ptr[1] != '.')) continue;
		break;
	}

	strcpy (line, ptr);
}


/*
 *	Affiche un message d'erreur et quitte.
 */

void
error (const char* error)
{
	fprintf (stderr, "%s:%d: %s\n", g_ctx.name, g_ctx.line, error);
	exit (1);
}


/*
 *	Lit le fichier et poubellise son contenu jusqu' ce qu'un des
 *	marqueurs soit trouv.
 */

void
trash_to (char* line, const char* trash_0, const char* trash_1)
{
	int len_0 = trash_0 ? strlen (trash_0) : 0;
	int len_1 = trash_1 ? strlen (trash_1) : 0;
	
	for (;;) {
		read_line (line);
		strip_spaces (line);

		if (line[0] == 0) break;
		if (len_0 && (strnicmp (line, trash_0, len_0) == 0)) break;
		if (len_1 && (strnicmp (line, trash_1, len_1) == 0)) break;
		
		if (strnicmp (line, "if", 2) == 0) {
			trash_to (line, "endif");
		}
	}
}


/*
 *	Traite le fichier et poubellise son contenu jusqu' ce qu'un des
 *	marqueurs soit trouv.
 */

void
parse_to (char* line, const char* trash_0, const char* trash_1)
{
	int len_0 = trash_0 ? strlen (trash_0) : 0;
	int len_1 = trash_1 ? strlen (trash_1) : 0;
	
	for (;;) {
		read_line (line);
		strip_spaces (line);

		if (line[0] == 0) break;
		if (len_0 && (strnicmp (line, trash_0, len_0) == 0)) break;
		if (len_1 && (strnicmp (line, trash_1, len_1) == 0)) break;
		
		parse_line (line);
	}
}


/*
 *	Traite un fichier complet.
 */

void
parse_file (const char* name)
{
	char line[LINE_LEN];
	
	Context ctx = g_ctx;
	
	g_ctx.file = fopen (name, "rt");
	g_ctx.line = 0;
	g_ctx.name = name;
	
	if (g_ctx.file == 0) {
		g_ctx = ctx;
		error ("Fichier pas trouv.");
	}

	for (;;) {
		read_line (line);
		strip_spaces (line);
		if (line[0] == 0) break;
		parse_line (line);
	}

	fclose (g_ctx.file);
	g_ctx = ctx;
}


/*
 *	Traite une ligne du fichier CLE courant. Le buffer pass en entre
 *	contient le texte de la ligne  traiter.
 */

void
parse_line (char* line)
{
	if (strnicmp (line, "iff", 3) == 0) {
		
		char  name[LINE_LEN];
		
		strcpy (name, line + 3);
		strip_spaces (name);
		
		//	Gre les branches conditionnelles d'un IFF en fonction de l'existence
		//	du fichier ou de son absence.
		
		FILE* test = fopen (name, "rt"); if (test) fclose (test);
		
		if (test) {
			
			//	Le fichier existe  l'endroit spcifi. La condition est
			//	donc remplie.

			parse_to (line, "else", "endif");
			
			if (strnicmp (line, "else", 4) == 0) {
				trash_to (line, "endif");
			}
			
		} else {
			
			//	Le fichier n'existe pas. C'est donc la condition aprs
			//	ELSE qui est remplie (pour autant qu'il y en ait une).
			
			trash_to (line, "else", "endif");
			
			if (strnicmp (line, "else", 4) == 0) {
				parse_to (line, "endif");
			}
		}
		
		if (strnicmp (line, "endif", 5) != 0) {
			error ("Erreur de syntaxe. Manque ENDIF.");
		}
		
		return;
	}
	
	char* ptr = line;
	
	while (*ptr) {
		
		if (strnicmp (ptr, ".cle", 4) == 0) {
			
			ptr[4] = 0;
			parse_file (line);
			line[0] = 0;
			break;
		}
		
		if (ptr[0] == ' ') break;
		if (ptr[0] == '\t') break;
		ptr++;
	}

	if (line[0]) {
		emit_line (line);
	}
}


int
main (int argc, char* argv[])
{
	while ( (argv[1][0] == '-')
	     && (argc > 3) ) {
		
		if (strcmp (argv[1], "-m") == 0) {
			g_m = argv[2];
			argv += 2;
			argc -= 2;
			continue;
		}
		
		if (strcmp (argv[1], "-n") == 0) {
			g_n = argv[2];
			argv += 2;
			argc -= 2;
			continue;
		}
	}
	
	if (argc == 3) {
		g_out = fopen (argv[2], "wt");
		if (g_out == 0) {
			fprintf (stderr, "Cration de %s impossible.\n", argv[2]);
			exit (1);
		}
		g_ctx.name = argv[1];
		parse_file (argv[1]);
	}
	return 0;
}

