; $CALM:

	.TITLE	DBUG.ASL

; --------------------------------------------------------------
;   (C) 1991..1995, Copyright  Pierre ARNAUD, CH-1437 Suscvaz
; --------------------------------------------------------------

;	Source du module de librairie de D.Bug (utilis
;	par le dvermineur du mme nom).

;	Les modules RES et ICOLOR doivent dj tre chargs
;	lorsque l'on appelle DBUG.


	.PROC	M68020
	.PROCSET DEFR16
	.PROCSET M68030

	.REF	SMAKY
	.REF	MODULES
	.REF	DOLIB
	.REF	DBUG
	.REF	DISM68K
	.REF	MON
;;	.REF	BLOC
	.REF	DBGSYS

	.INS	SMA_DBUG.ASSR

REVMAJ	= 2
REVMIN	= 0

PCCODE	= 0
PCVAR	= 1

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC SA"
	.START	-1

;	Constantes diverses
;	-------------------

LGFNAM		= 200
BOA		= 92
MAXBINLOAD	= 32

;	Adresses globales utilises par DBUG
;	------------------------------------

DEBUGSAUVER	= 16'13E2		; ^routine pour sauver contexte
DEBUGRECUPERER	= 16'13E6		; ^routine pour installer contexte

WHATUP		= 16'13EE		; quel processeur
WHATFPU		= 16'13F2		; quel coprocesseur

PTEXEC		= 16'1150		; ^descripteur du processus actif
PTGLOBAL	= 16'970		; ^informations globales
PTCURCX		= 16'978		; ^contexte courant
PTFIRSTCX	= 16'97C		; ^premier contexte


;	Offsets du noyau temps rel (pas vraiment compatible...)
;	---------------------------

	.LOC	16'FFFFFF1A
OPSSP:	.BLK.32	1			; pointeur pile superviseur
OPUSP:	.BLK.32	1			; pointeur pile user

	.LOC	16'FFFFFF5A
OPNAME:	.BLK.8	16			; nom du processus
OPNUM:	.BLK.16	1			; numro du processus
	.BLK.8	6+2+4+2+4+4+4+8		; LGDATE = 6 / LGTECH = 8
	.BLK.32	1
OPTIMO:	.BLK.16	1			; timeout courant
	.BLK.8	24+44
OPPRAC:	.BLK.8	1			; priorit



;	Macros diverses
;	---------------

	.MACRO	PUSHCOLOR		; sauve les couleurs
	PUSH.32	{A0}+ODFCSF
	PUSH.32	{A0}+ODFCCF
	.ENDMACRO

	.MACRO	POPCOLOR		; reprend les couleurs
	POP.32	{A0}+ODFCCF
	POP.32	{A0}+ODFCSF
	.ENDMACRO


;	Couleurs utilises
;	------------------

COLFOND		= 16'8001
COLGRISCLAIR	= 16'8002
COLGRISMOYEN	= 16'8003
COLGRISFONCE	= 16'8004
COLAFFUSER	= 16'8005
COLAFFSUPER	= 16'8006
COLLEDVER1	= 16'8007
COLLEDVER2	= 16'8008
COLLEDROU1	= 16'8009
COLLEDROU2	= 16'800A
COLLEDOFF1	= 16'800B
COLLEDOFF2	= 16'800C
COLIPM		= 16'800E


;	Dfinition des erreurs
;	----------------------

ERILMACHINE	= 1			; machine pas supporte
ERILADDRESS	= 2			; adresse pas accessible (priphriques, I/O, etc.)
ERILMCPT	= 3			; comptes mmoire ne correspondent pas
ERILMPTR	= 4			; pointeur sur tranche mmoire illgal (pas connu)
ERILLSTFILE	= 5			; fichier .LST illgal
ERILPCREL	= 6			; PC relatif illgal (pas connu)


;	Dfinition d'un mode d'adressage
;	--------------------------------

		.LOC	0

OadrBASEREG:	.BLK.16	1		; registre de base  utiliser
OadrOFFSREG:	.BLK.16	1		; registre d'offset
OadrOFFSET:	.BLK.32	1		; offset extrieur (numrique)
OadrLAST:	.BLK.32	1		; dernire adresse calcule

OadrSHIFT:	.BLK.8	1		; 0..3 => ASL a effectuer sur l'offset
OadrNOBASE:	.BLK.8	1		; TRUE => pas de registre de base
OadrNOOFFSET:	.BLK.8	1		; TRUE => pas de registre d'offset
OadrSIGNEXT:	.BLK.8	1		; TRUE => offset avec extension du signe
OadrFORMAT:	.BLK.8	1		; 0 => byte / 1 => word / 2 => long
OadrREL:	.BLK.8	1		; TRUE => adresses relatives
		.ALIGN	4
LGADR:


;	Dfinition d'une comparaison
;	----------------------------

		.LOC	0

OcmpADR:	.BLK.8	LGADR		; dfinition de l'adresse
OcmpBVALUE:	.BLK.32	1		; valeur de rfrence
OcmpNAME:	.BLK.8	32		; nom de la condition

OcmpAisVALUE:	.BLK.8	1		; TRUE => utilise adresse comme valeur
OcmpMODE:	.BLK.8	1		; mode de comparaison
 cmpHI		= 8			; A > B
 cmpEQ		= 9			; A = B
 cmpLO		= 10			; A < B
 cmpHS		= 11			; A >= B
 cmpNE		= 12			; A <> B
 cmpLS		= 13			; A <= B
OcmpLOGIC:	.BLK.8	1		; TRUE => utilise nombres logiques
OcmpINIT:	.BLK.8	1		; TRUE => dj initialis
OcmpNEG:	.BLK.8	1		; TRUE => trace sauf si..
		.ALIGN	4
LGCMP:


;	Description d'un registre du Reg.Pan
;	------------------------------------

		.LOC	0

OregVALUE:	.BLK.32	1		; valeur ( afficher)
OregOLDVALUE:	.BLK.32	1		; ancienne valeur
OregY1:		.BLK.16	1		; [y] de dpart pour l'affichage du reg.
OregX1:		.BLK.16	1		; [x] de dpart pour l'affichage du reg.
OregY2:		.BLK.16	1		; [y] d'arrive pour l'affichage du reg.
OregX2:		.BLK.16	1		; [x] d'arrive pour l'affichage du reg.
OregCOLORSET:	.BLK.32	1		; couleur pour allumer
OregCOLORCLR:	.BLK.32	1		; couleur pour teindre
OregISSUPER:	.BLK.8	1		; TRUE => reg. superviseur
OregCHANGED:	.BLK.8	1		; TRUE => reg. modifi
		.BLK.8	2
LGREG:



;	Description d'un Reg.Pan
;	------------------------

		.LOC	0

OrpCAN:		.BLK.32	1		; canal D.Bug
OrpY:		.BLK.16	1		; [y]  de la fentre
OrpX:		.BLK.16	1		; [x]  de la fentre
OrpDY:		.BLK.16	1		; [dy] de la fentre
OrpDX:		.BLK.16	1		; [dx] de la fentre
OrpCADY:	.BLK.16	1		; [y]  du cadre
OrpCADX:	.BLK.16	1		; [x]  du cadre
OrpCADDY:	.BLK.16	1		; [dy] du cadre
OrpCADDX:	.BLK.16	1		; [dx] du cadre
OrpREGS:	.BLK.8	NBREG*LGREG	; table dcrivant les registres
LGRP:



;	Description d'un flag de SF du SF.Pan
;	-------------------------------------

		.LOC	0

OflagVALUE:	.BLK.8	1		; valeur ( afficher) (normalement TRUE ou FALSE)
OflagOLDVALUE:	.BLK.8	1		; ancienne valeur (normalement TRUE ou FALSE)
OflagISSUPER:	.BLK.8	1		; TRUE => flag SF superviseur
OflagISROND:	.BLK.8	1		; TRUE => flag affich est rond

OflagY1:	.BLK.16	1		; [y] de dpart pour l'affichage du flag
OflagX1:	.BLK.16	1		; [x] de dpart pour l'affichage du flag
OflagY2:	.BLK.16	1		; [y] d'arrive pour l'affichage du flag
OflagX2:	.BLK.16	1		; [x] d'arrive pour l'affichage du flag
OflagCOLOR1SET:	.BLK.32	1		; couleur pour allumer normalement
OflagCOLOR2SET:	.BLK.32	1		; couleur pour allumer en mode highlite (reflet brillant)
OflagCOLOR1CLR:	.BLK.32	1		; couleur pour teindre
OflagCOLOR2CLR:	.BLK.32	1		; couleur pour teindre
LGFLAG:

;	Description d'un SF.Pan
;	-----------------------

		.LOC	0

OspCAN:		.BLK.32	1		; canal D.Bug
OspY:		.BLK.16	1		; [y]  de la fentre
OspX:		.BLK.16	1		; [x]  de la fentre
OspDY:		.BLK.16	1		; [dy] de la fentre
OspDX:		.BLK.16	1		; [dx] de la fentre
OspCADY:	.BLK.16	1		; [y]  du cadre
OspCADX:	.BLK.16	1		; [x]  du cadre
OspCADDY:	.BLK.16	1		; [dy] du cadre
OspCADDX:	.BLK.16	1		; [dx] du cadre
OspFLAGS:	.BLK.8	NBFLAG*LGFLAG	; table dcrivant les fanions de SF
LGSP:


;	Variables du gestionnaire de "x-mem"
;	------------------------------------

		.LOC	0

OxmPTUSED:	.BLK.32	1		; ^premier lment utilis
OxmPTFREE:	.BLK.32	1		; ^premier lment libre
OxmBERRMAP:	.BLK.32	1		; ^map des bus errors

OxmFREESIZE:	.BLK.32	1		; taille libre
OxmUSEDSIZE:	.BLK.32	1		; taille utilise
OxmMARGSIZE:	.BLK.32	1		; taille d'une marge

OxmFREESEM:	.BLK.32	1		; sm. d'excl. pour accs  la liste des libres
OxmUSEDSEM:	.BLK.32	1		; sm. d'excl. pour accs  la liste des occupes
LGXM:


XMMARGSIZE	= 128			; marge de 128 octets..


;	Dfinition d'un EXIT
;	--------------------

		.LOC	0

OexitPC:	.BLK.32	1		; PC relatif
OexitOLDVALUE:	.BLK.16	1		; valeur contenue en mmoire avant son remplacement
		.BLK.16	1		; rserve
LGEXIT:


;	Dfinition d'un fichier .LST
;	----------------------------

		.LOC	0

OflCAN:		.BLK.32	1		; canal D.Bug

OflBINNAME:	.BLK.8	16		; nom du binaire
OflLSTNAME:	.BLK.8	LGFNAM		; nom du fichier .L(I)ST trouv

OflLIST8:	.BLK.8	1		; listage avec PC relatif de 8 car...
		.ALIGN	4

OflMAXPCREL:	.BLK.32	1		; PC relatif le plus grand
OflSTARTPC:	.BLK.32	1		; PC de dpart en mmoire
OflSTOPPC:	.BLK.32	1		; PC d'arrive en mmoire
OflPCACT:	.BLK.32	1		; PC actuel trouv
OflPCxACT:	.BLK.32	1		; PC courant (pas forcment le vrai PC du code)
OflACTLINE:	.BLK.32	1		; ^dbut de la ligne en cours

OflPTEXIT:	.BLK.32	1		; table dfinissant  quels offsets se trouvent les "exit"
OflNBEXIT:	.BLK.32	1		; nombre d'lments dans la table d'exit

OflPTTABLE:	.BLK.32	1		; ^table d'offsets sur les lignes en fonction du PC rel
OflPTFILE:	.BLK.32	1		; ^fichier charg en mmoire (et retouch)
OflLGFILE:	.BLK.32	1		; taille du fichier en mmoire

OflSYMTABLE:	.BLK.32	1		; ^table des symboles
OflSYMSIZE:	.BLK.32	1		; taille du buffer
OflSYMINSERT:	.BLK.32	1		; point d'insertion
LGFL:

;	Dfinition d'une ligne
;	----------------------

		.LOC	0

OlineOFFSET:	.BLK.32	1		; offset de la ligne
OlineY1:	.BLK.16	1		; [y] de dpart pour l'affichage de la ligne
OlineX1:	.BLK.16	1		; [x] de dpart pour l'affichage de la ligne
OlineY2:	.BLK.16	1		; [y] d'arrive pour l'affichage de la ligne
OlineX2:	.BLK.16	1		; [x] d'arrive pour l'affichage de la ligne
LGLINE:

NBLINE		= 100			; maximum 100 lignes  l'cran dans une liste


;	Dfinition d'une fentre pour le listing
;	----------------------------------------

		.LOC	0

OtxwCAN:	.BLK.32	1		; canal D.Bug
OtxwFL:		.BLK.32	1		; canal FileLst de rfrence

OtxwNBLINES:	.BLK.16	1		; nombre de lignes
OtxwNBCAR:	.BLK.16	1		; nombre de caractres
OtxwPCLINE:	.BLK.32	1		; offset de la ligne du PC relatif actuel
OtxwMEVLINE:	.BLK.32	1		; offset de la ligne  mettre en vidence
OtxwLUPDATE:	.BLK.32	1		; offset de la ligne lors du dernier UPDATE

OtxwY:		.BLK.16	1		; [y]  de la fentre
OtxwX:		.BLK.16	1		; [x]  de la fentre
OtxwDY:		.BLK.16	1		; [dy] de la fentre
OtxwDX:		.BLK.16	1		; [dx] de la fentre
OtxwCADY:	.BLK.16	1		; [y]  du cadre
OtxwCADX:	.BLK.16	1		; [x]  du cadre
OtxwCADDY:	.BLK.16	1		; [dy] du cadre
OtxwCADDX:	.BLK.16	1		; [dx] du cadre

OtxwLINES:	.BLK.8	NBLINE*LGLINE	; buffer pour dfinition des lignes

OtxwSCROLL:	.BLK.8	LSCVAR		; variables pour l'ascenceur
OtxwDOAFLIST:	.BLK.8	1		; TRUE => montre fichier de listage
		.EVEN
LGTXW:


;	Dfinition d'un processus (infos pour utilisateur)
;	--------------------------------------------------

		.LOC	0

OprocTPT:	.BLK.32	1		; task pointer
OprocPNUM:	.BLK.16	1		; numro du processus
OprocPNAM:	.BLK.32	1		; ^nom du processus
OprocPC:	.BLK.32	1		; PC du processus
OprocSTATE:	.BLK.16	1		; tat du processus
OprocWAITID:	.BLK.32	1		; identificateur sur lequel l'attente est faite
OprocCX:	.BLK.32	1		; ^contexte (interne  D.Bug)
LGPROC:


;	Dfinition du canal D.Bug
;	-------------------------

		.LOC	0

OcanPDDIS:	.BLK.32	1		; ^descripteur fentre rel
OcanPGC:	.BLK.32	1		; ^gencar NEF07
OcanMCPT:	.BLK.32	1		; ^descripteur compte "D.Bug"
OcanGRA2RASTER:	.BLK.32	1		; ^routine GRA2_RASTER
OcanRESCAN:	.BLK.32	1		; canal de RES

OcanEXCWAIT:	.BLK.32	1		; exception attend prise en compte
OcanVI:		.BLK.32	1		; ^var. visuelles

OcanKEYSTART:	.BLK.32	1		; smaphore pour dmarrer lecture du clavier par le fils
OcanKEYACK:	.BLK.32	1		; smaphore pour signaler lecture au pre
OcanKEYCODE:	.BLK.8	4		; code clavier reu
OcanKEYMOUSE:	.BLK.16	2		; [y;x] de la souris
OcanKEYBOUT:	.BLK.8	1		; boutons de la souris
OcanKEYOUT:	.BLK.8	1		; TRUE => souris hors de l'cran
		.ALIGN	4

OcanPTTXTCRET:	.BLK.32	1		; ^textes de la CRET
OcanCRET:	.BLK.32	1		; canal de la CRET
OcanSIZECRET:	.BLK.32	1		; taille de la CRET
OcanREGLAGE:	.BLK.32	1		; bitset des rglages
OcanONLYCRET:	.BLK.8	1		; TRUE => que la CRET, pas de CLUT
OcanUSEAUDIO:	.BLK.8	1		; TRUE => on peut utiliser #AUDIO
OcanADRREL:	.BLK.8	1		; TRUE => utilise adresses relatives
OcanSHOWREGCHG:	.BLK.8	1		; TRUE => affiche registres modifis
OcanOLDREGCHG:	.BLK.8	1		; TRUE => faut rafficher tout en mode `CLR'
OcanDISCRET:	.BLK.8	1		; TRUE => ne signale pas BUS ERROR en lecture
		.EVEN

OcanCOLSUPLED1:	.BLK.32	1		; couleur des LEDs superviseur
OcanCOLSUPLED2:	.BLK.32	1		; couleur des LEDs superviseur (brillante)
OcanCOLUSRLED1:	.BLK.32	1		; couleur des LEDs user
OcanCOLUSRLED2:	.BLK.32	1		; couleur des LEDs user (brillante)
OcanCOLOFFLED1:	.BLK.32	1		; couleur des LEDs teintes
OcanCOLOFFLED2:	.BLK.32	1		; couleur des LEDs teintes (brillante)
OcanCOLSUPLCD:	.BLK.32	1		; couleur des LCDs superviseur (afficheurs)
OcanCOLUSRLCD:	.BLK.32	1		; couleur des LCDs user (afficheurs)
OcanCOLIPM:	.BLK.32	1		; couleur pour Interrupt Priority Mask

OcanCOLFOND:	.BLK.32	1		; couleur du fond
OcanCOLGR1:	.BLK.32	1		; gris clair
OcanCOLGR2:	.BLK.32	1		; gris moyen
OcanCOLGR3:	.BLK.32	1		; gris fonc

OcanPTmDIGITS:	.BLK.32	16		; ^matrices des 16 digits
OcanPTmMKNORM:	.BLK.32	1		; ^matrice normale pour marque
OcanPTmMKEXIT:	.BLK.32	1		; ^matrice EXIT pour marque
OcanPTmREGMARK:	.BLK.32	1		; ^matrice d'une marque pour registre

OcanFPUNUM:	.BLK.32	1		; numro de la FPU active
OcanCPUNUM:	.BLK.32	1		; numro du CPU actif
OcanCPUPTDREG:	.BLK.32	1		; ^dfinition des reg. du proc.
OcanCPUPTDFLG:	.BLK.32	1		; ^dfinition des flags de SF du proc.
OcanCPUPTmTIT:	.BLK.32	1		; ^matrice du titre (du processeur)
OcanCPUPTmAUT:	.BLK.32	1		; ^matrice du nom de l'auteur
OcanCPUPTmREC:	.BLK.32	1		; ^matrice de LED rectangulaire
OcanCPUPTmRON:	.BLK.32	1		; ^matrice de LED ronde
OcanCPUREGSET:	.BLK.32	1		; bitset des registres utiliss
OcanCPUFLGSET:	.BLK.16	1		; bitset des flags utiliss
		.BLK.8	2
OcanCPUDYREG:	.BLK.16	1		; [dy] ncessaire pour les reg.
OcanCPUDXREG:	.BLK.16	1		; [dx] ncessaire pour les reg.
OcanCPUDYFLG:	.BLK.16	1		; [dy] ncessaire pour les flags de SF
OcanCPUDXFLG:	.BLK.16	1		; [dx] ncessaire pour les flags de SF

OcanBUTEXT:	.BLK.8	128		; texte quelconque
OcanBUARGS:	.BLK.8	LGARGS		; buffer pour arguments d'un fichier
OcanBUDBOX:	.BLK.8	128		; variables diverses pour DBOX
OcanBUSCROLL:	.BLK.8	100		; buffer pour construire lm. de scroll-list

OcanPTMMREGXi:	.BLK.32	1		; ^menu pour {Xi}
OcanPTMMREGXj:	.BLK.32	1		; ^menu pour {Xj}
OcanMMSSP:	.BLK.8	1		; TRUE => menu avec SSP, sinon avec ISP/MSP
		.BLK.8	3
OcanMMREGXi:	.BLK.8	3*LMM		; place pour menu {Xi}
OcanMMREGXj:	.BLK.8	4*LMM		; place pour menu {Xj}
OcanSLVAR:	.BLK.32	1		; ^var. supp. pour SCROLL

OcanSIZSMAREF:	.BLK.32	1		; taille des symboles
OcanPTSMAREF:	.BLK.32	1		; ^symboles

OcanMOREINFO:	.BLK.32	1		; ^routine pour plus d'infos

OcanNBBINLOAD:	.BLK.32	1		; nombre de binaires chargs
OcanTBINLOAD:	.BLK.32	MAXBINLOAD	; table des ^binaires chargs soi-mme
OcanBINLOADNAM:	.BLK.8	LGFNAM		; nom du fichier  charger

OcanNOTRAPVAR:	.BLK.32	1		; ^variables de SMA_noTRAP...
OcanOLDnoTRAP:	.BLK.32	64		; copie des var. de SMA_noTRAP

OcanICOIMAHEAD:	.BLK.8	LGHIMA		; en-tte de l'image pour les icones
OcanICOIMAPTR:	.BLK.32	1		; ^image pour les icones

OcanCOPYRX:	.BLK.8	OrxSTACK+100	; copie de l'tat de la pile fourni lors du dernier TRAP
OcanWHATPROC:	.BLK.32	1		; ^table pour "DBX_WHATPROC"

OcanFNCTNAME:	.BLK.8	40		; buffer pour nom d'une fonction (32 car + ..)
OcanFNCTLIST:	.BLK.32	1		; ^liste de noms de fonctions
OcanFNCTNB:	.BLK.32	1		; nombre d'lments dans la liste

OcanDBGSYSCAN:	.BLK.16	1		; canal du module DBGSYS (si existe)
OcanDBGSYSFFM:	.BLK.32	1		; ^routine DBGSYS_FORfreeMEM

OcanM68KBEG:	.BLK.32	1		; ^dbut DISM68K
OcanM68KEND:	.BLK.32	1		; ^fin DISM68K


LGCAN:

;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	DBUG_FIRST
	.16	DBUG_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"DBUG"
	.FILL.8	(LGHLIB-APC),0
	.16	_DBUG_OPEN
	.16	_DBUG_USECOLORS
	.16	_DBUG_CLOSE
	.16	_DBUG_REGPAN
	.16	_DBUG_SFPAN
	.16	_DBUG_FILELST
	.16	_DBUG_TEXTWDO
	.16	_DBUG_ACCEPT
	.16	_DBUG_ENDACCEPT
	.16	_DBUG_INTERFACE
	.16	_DBUG_LOADFILE


NMMCPT:	.ASCIZ	"D.Bug"
NMRES:	.ASCIZ	"(,#):SMA_DBUG(_%L,).RS"
NMAUDIO:.ASCIZ	"#AUDIO:"
NMDBSYS:.ASCIZ	"DBGSYS"
NMD68:	.ASCIZ	"SMA_DISM68K.LIB"
	.EVEN


;-------------\\
;  _DBUG_OPEN  >
;=============/

; Initialise le module D.Bug pour un logiciel donn.

; in	-
; out	A5.32	canal D.Bug
;	D7.16	erreur
; mod	A5.32, D7.16

_DBUG_OPEN:
	PUSHM.32 D1..D5|A0..A4

	MOVE.32	#0,D5				; D5 <-- pas d'erreur !
	LIB	?GETPDIS
	MOVE.32	A4,A0				; A0 <-- ^descripteur fentre rel

	MOVE.32	#R16^NMMCPT,A3
	MOVE.32	#MTYPSYS,D1
	GESMEM	?CREMCPT			; A2 <-- ^desc. compte mmoire
	JUMP,NE	ERR$

	MOVE.32	A2,A1
	MOVE.32	#MTYPUSER,D1
	MOVE.32	#LGCAN,D4
	GESMEM	?GETMEM				; A4 <-- ^mmoire pour canal D.Bug
	MOVE.16	D7,D5
	JUMP,NE	ER1$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A5

	MOVE.32	A0,{A5}+OcanPDDIS		; <-- descripteur fentre rel
	MOVE.32	A1,{A5}+OcanMCPT		; <-- compte mmoire

	MOVE.16	#GRA2_RASTER,D3
	LIB_	GETAD
	MOVE.32	A3,{A5}+OcanGRA2RASTER		; <-- ^routine GRA2_RASTER

	CALL	WAITKEYINIT			; initialise la gestion du clavier
	MOVE.16	D7,D5
	JUMP,NE	ER2$

	NTREL	?GETMACHINE			; quelle machine utilise-t-on ?
	RR.32	#8,D4				; D4.8 <-- id. de la machine
	COMP.8	#SMAKY324,D4			; plus vieux que le 324 ?
	JUMP,LT	R8^noAUDIO$			; oui => utilise pas audio (trop lent)

	MOVE.32	#R16^NMAUDIO,A3
	MOVE.32	#0,D3
	FOS	?VASSIGN			; est-ce que "#AUDIO:" existe ?
	JUMP,NE	R8^noAUDIO$			; non => ne fait rien !

	COMP.8	#"$",{A4}			; local ?
	JUMP,NE	R8^noAUDIO$			; non => ne fait rien !
	SET.8	{A5}+OcanUSEAUDIO		; oui => on peut utiliser #AUDIO:

noAUDIO$:
	MOVE.32	#R16^NMRES,A3
	MOVE.32	#16'10000*REVMAJ+REVMIN,D4
	MOVE.32	#2**BRSOPCACHE+2**BRSOPMTYP,D2	; utilise notre compte mmoire !
	RES_	OPEN				; ouvre le fichier de ressources
	MOVE.16	D7,D5
	JUMP,NE	ER2$

	MOVE.32	A2,{A5}+OcanRESCAN		; <-- canal du fichier de ressources
	MOVE.32	#.BIT.24,{A5}+OcanREGLAGE	; <-- rglages : clear mmoire par dfaut
	BLOC_	OPEN

	CALL	INITICONES			; initialise les icones
	MOVE.16	D7,D5
	JUMP,NE	ER3$

	MOVE.32	#{A5}+OcanPTmDIGITS,A3		; A3 <-- ^table pour stocker les ^matrices
	MOVE.32	#rNum0,D1			; D1 <-- premire ressources
	MOVE.32	#16,D2				; D2 <-- traite 16 ressources

INIT1$:	CALL	GETRASTPTR			; A4 <-- ^matrice
	MOVE.32	A4,{A3+}
	INC.32	D1
	DEC.32	D2
	JUMP,GT	INIT1$

	MOVE.32	#rMarkNormal,D1
	CALL	GETRASTPTR			; A4 <-- ^matrice de la marque normale
	MOVE.32	A4,{A5}+OcanPTmMKNORM

	MOVE.32	#rMarkExit,D1
	CALL	GETRASTPTR			; A4 <-- ^matrice de la marque pour EXIT
	MOVE.32	A4,{A5}+OcanPTmMKEXIT

	MOVE.32	#rRegMark,D1
	CALL	GETRASTPTR
	MOVE.32	A4,{A5}+OcanPTmREGMARK

	LIB	?AFTIM
	.8	LOADGC,"N","E"+128,7
	.8	USEGC,"N","E"+128,7
	.8	0
	.EVEN

	MOVE.32	{A0}+ODFPGC,{A5}+OcanPGC	; <-- ^gencar pour afficher les infos
	LIB	?RSTGC				; reprend gencar normal

	CALL	LOADREF				; charge le fichier (DBUG,)SMAKY.REF pour symboles

	MOVE.32	#R16^BASE,A4
	MOVE.32	#1,D4
	FOS	?GETcomMEM			; demande mmoire commune
	TSET.8	{A4}:#0				; dj en cours d'utilisation ?
	JUMP,BC	R8^SEUL$			; non => nous sommes les seuls

	MOVE.32	#rStrOnlyOne,D1
	CALL	TERROR				; affiche l'erreur fatale !

RETERR$:
	MOVE.32	#1,D5				; rend erreur bidon
	JUMP	ER3$

; On va quand-mme tester pour voir si le NTR correspond  nos attentes...

SEUL$:
	PUSHM.32 D4|A3|A4
	NTREL	?GETTPT
	COMP.32	A16^PTEXEC,A4			; descripteur correspond-il ?
	JUMP,NE	NTR_INCOMPATIBLE$		; non => NTREL pas compatible
	NTREL	?GTPNUM				; process number au bon endroit ?
	COMP.16	{A4}+OPNUM,D4
	JUMP,NE	NTR_INCOMPATIBLE$
	NTREL	?GETTIM				; time-out au bon endroit ?
	COMP.16	{A4}+OPTIMO,D4
	JUMP,NE	NTR_INCOMPATIBLE$
	NTREL	?GETPRIO			; priorit au bon endroit ?
	COMP.8	{A4}+OPPRAC,D4
	JUMP,NE	NTR_INCOMPATIBLE$

	CLR.16	D7
	JUMP	R8^OKNTR$

NTR_INCOMPATIBLE$:
	MOVE.32	#rStrNtrIncompatible,D1
	CALL	TERROR
	MOVE.16	#1,D7

OKNTR$:	POPM.32	D4|A3|A4
	TEST.16	D7
	JUMP,NE	ERR$

; Vrifie maintenant si SMA_noTRAP est en cours de fonctionnement.

HASnoTRAP$:
	CALL	INFOnoTRAP			; noTRAP existe ?
	JUMP,NE	R8^OLDnoTRAP$			; non ou vieux => supprime de la mmoire

	PUSHM.32 A5|A6
	MOVE.32	{A4}+4,A5			; A5 <-- ^routine de PATCH
	MOVE.32	A4,A6				; A6 <-- ^variables de SMA_noTRAP.CODE
	CALL	{A5}				; supprime les patches effectus  ce jour
	POPM.32	A5|A6

	MOVE.32	A4,{A5}+OcanNOTRAPVAR		; prend note du ^aux var. de SMA_noTRAP
	JUMP	R8^OKnoTRAP$			; suite..

; Vieux noTRAP, il faut le supprimer de la mmoire, il ne sert  rien !

OLDnoTRAP$:
	MOVE.32	#R16^NMNOTRAP,A3		; A3 <-- ^nom de notre pire ennemi..
	FOS	?DECACHE			; supprime de la mmoire
	JUMP,EQ	SEUL$				; tant qu'il est encore en mmoire, dcharge

	COMP.16	#ERFDNE,D7			; fichier encore en mmoire ?
	JUMP,EQ	R8^OKnoTRAP$			; non => super.. personne ne l'excutait

	MOVE.32	#rStrSorryNoTrap,D1
	CALL	TERROR				; signale que nous ne fonctionnons pas avec notrap !
	JUMP	RETERR$

OKnoTRAP$:
	PUSHM.32 D5|A3|A4

	MOVE.32	#R16^NMD68,A3
	CALL	IFCACHE
	JUMP,NE	R8^NO68$

	MOVE.32	A4,{A5}+OcanM68KBEG
	ADD.32	D5,A4
	MOVE.32	A4,{A5}+OcanM68KEND


NO68$:	POPM.32	D5|A3|A4

	CALL	CPU_INIT			; initialise les paramtres associs au processeur
	COMP.32	#68000,{A5}+OcanCPUNUM		; est-ce un 68000 ?
	JUMP,NE	R8^GOODPROC$			; non => c'est un bon processeur !

	MOVE.32	#rStrSorry68000,D1
	CALL	TERROR				; affiche l'erreur fatale (fonctionne pas avec 68000) !
	JUMP	RETERR$

GOODPROC$:
	MOVE.16	#DBGSYS_FIRST,D3
	MOVE.32	#R16^NMDBSYS,A3
	LIB_	OPEN				; tente de charger le module DBGSYS
	JUMP,NE	R8^NODBGSYS$			; n'existe pas => tant pis

	MOVE.16	D1,{A5}+OcanDBGSYSCAN		; prend note..

	MOVE.16	#DBGSYS_FORfreeMEM,D3
	LIB_	GETAD				; routine pour explorer la mmoire libre
	MOVE.32	A3,{A5}+OcanDBGSYSFFM

NODBGSYS$:
	CALL	CXMASTER_OPEN			; initialise la gestion des exceptions
	JUMP,NE	ERR$				; erreur => trs fatal

	MOVE.32	{A5}+OcanNOTRAPVAR,D4		; est-ce qu'il y a des variables de noTRAP ?
	JUMP,F	EXIT$				; non => termin !

	MOVE.32	D4,A4				; A4 <-- ^var. de SMA_noTRAP
	CALL	LOWLEVnoTRAPPATCH
	JUMP	EXIT$				; termin avec succs !


; Libre ce qui a t initialis pour des prunes.

ER3$:	MOVE.32	{A5}+OcanRESCAN,A2
	MOVE.32	#0,D2
	RES_	CLOSE				; ferme le fichier de ressources

ER2$:	MOVE.32	#MTYPUSER,D1
	GESMEM	?GBAMEM				; rend toute la mmoire de notre compte

ER1$:	MOVE.32	A1,A2
	MOVE.32	#MTYPSYS,D1
	GESMEM	?KILLMCPT

EXIT$:	MOVE.16	D5,D7				; D7 <-- erreur  prendre en compte

ERR$:	POPM.32	D1..D5|A0..A4
;	TEST.16	D7
	RET



;--------------\\
;  _DBUG_CLOSE  >
;==============/

; Libre le module D.Bug pour le logiciel donn.

; in	A5.32	canal D.Bug
; out	D7.16	erreur
; mod	D7.16

_DBUG_CLOSE:
	PUSHM.32 D1|D2|D4|A1..A4

	CALL	CXMASTER_CLOSE			; libre la gestion des exceptions

	MOVE.16	{A5}+OcanDBGSYSCAN,D1
	LIB_	CLOSE				; libre DBGSYS (si il a t utilis)

	MOVE.32	{A5}+OcanNOTRAPVAR,D4		; est-ce qu'il y a des variables de noTRAP ?
	JUMP,F	NEXT$				; non => suite

	MOVE.32	D4,A4				; A4 <-- ^var. de SMA_noTRAP

	PUSHM.32 D4|A3|A4
	MOVE.32	#{A4}+16,A4			; A4 <-- ^table des vieux vecteurs de SMA_noTRAP
	MOVE.32	#{A5}+OcanOLDnoTRAP,A3		; A3 <-- ^valeurs originales de cette table
	MOVE.32	#64*4,D4
	GESMEM	?COPYMEM			; remet les anciennes valeurs
	POPM.32	D4|A3|A4

	PUSHM.32 A5|A6
	MOVE.32	{A4}+8,A5			; A5 <-- ^routine de PATCH
	MOVE.32	A4,A6				; A6 <-- ^variables de SMA_noTRAP.CODE
	CALL	{A5}				; remet les patches tout neufs
	POPM.32	A5|A6

NEXT$:	MOVE.32	{A5}+OcanRESCAN,A2
	MOVE.32	#0,D2
	RES_	CLOSE				; libre le fichier de ressources

	BLOC_	CLOSE

	MOVE.32	D2,A16^PTGLOBAL
	MOVE.32	D2,A16^PTCURCX
	MOVE.32	D2,A16^PTFIRSTCX

	MOVE.32	{A5}+OcanMCPT,A1
	MOVE.32	#MTYPUSER,D1
	GESMEM	?GBAMEM				; rend toute la mmoire de notre compte

	MOVE.32	A1,A2
	MOVE.32	#MTYPSYS,D1
	GESMEM	?KILLMCPT			; supprime le compte

	MOVE.32	#R16^BASE,A4
	MOVE.32	#1,D4
	FOS	?GETcomMEM			; demande mmoire commune
	CLR.8	{A4}				; plus de D.Bug actif..

ERR$:	POPM.32	D1|D2|D4|A1..A4
;	TEST.16	D7
	RET



;------------------\\
;  _DBUG_USECOLORS  >
;==================/

; Met en place la CLUT de D.Bug et aussi la CRET. Le logiciel
; qui exploite D.Bug doit s'accomoder des couleurs du module ou
; dfinir une CRET lui-mme..

; in	A5.32	canal D.Bug
; out	D7.16	erreur
; mod	D7.16

_DBUG_USECOLORS:
	PUSHM.32 D0..D6|A0..A4

	CLR.16	D7
	MOVE.32	{A5}+OcanPDDIS,A0
	TEST.8	{A0}+ODFCMD			; mode couleur ?
	JUMP,F	BW$				; non => ne fait rien !

	MOVE.32	#RtypTableCRET,D0
	MOVE.32	#rMainTableCRET,D1
	MOVE.32	#2**BRSGETPOINTER+2**BRSGETnoHAND,D2
	MOVE.32	{A5}+OcanRESCAN,A2
	RES_	GET				; A4 <-- ^textes pour la CRET
	MOVE.32	A4,{A5}+OcanPTTXTCRET		; prend note pour plus tard

	MOVE.32	#RtypCRET,D0
	MOVE.32	#rMainCRET,D1
	MOVE.32	#2**BRSGETPOINTER+2**BRSGETnoHAND+2**BRSGETSIZE,D2
	RES_	GET				; A4 <-- ^CRET + CLUT par dfaut
	MOVE.32	D4,{A5}+OcanSIZECRET		; D4 <-- taille de la CRET

	SET.8	{A5}+OcanONLYCRET		; que la CRET..
	MOVE.32	{A0}+ODFCPF,D6			; D6 <-- canal TCOLOR
	MOVE.32	#2**BTCTABLE,D3			; D3 <-- initialise  partir d'une table
	MOVE.32	A4,A3				; A3 <-- ^table
	TCOL_	LOADCRET			; utilise la CRET..
	JUMP,EQ	OKCRET$				; ok => suite

; En cas d'erreur, il faut voir si c'tait d au fait que la table
; commence par une CLUT, puis continue par une CRET..

	COMP.16	#ERTCTYPE,D7			; erreur de type ?
	JUMP,NE	ERR$				; non => vraiment erreur

	CLR.8	{A5}+OcanONLYCRET

	TCOL_	LOADCLUT			; utilise d'abord la CLUT..
	JUMP,NE	ERR$				; pas bon => erreur

	ADD.32	{A3}+OCTLG,A3
	ADD.A16	#LCTHEAD,A3			; saute la CLUT
	TCOL_	LOADCRET			; utilise maintenant la CRET
	JUMP,NE	ERR$

OKCRET$:
	CLR.32	D3
	TCOL_	ADDCRET				; ajoute la CRET comme une CRET locale

	MOVE.32	D5,{A5}+OcanCRET

	MOVE.32	#RtypCRET,D0
	MOVE.32	#rMainCRET,D1
	MOVE.32	#2**BRSGIVnoHAND,D2
	MOVE.32	{A5}+OcanRESCAN,A2
	RES_	GIVE				; libre la ressource CRET..

; Initialise les couleurs en fonction de la palette. Cherche
; les fausses couleurs associes.

REFAITCOULEURS$:
	MOVE.32	#COLAFFUSER,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLUSRLCD

	MOVE.32	#COLAFFSUPER,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLSUPLCD

	MOVE.32	#COLFOND,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLFOND

	MOVE.32	#COLGRISCLAIR,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLGR1

	MOVE.32	#COLGRISMOYEN,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLGR2

	MOVE.32	#COLGRISFONCE,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLGR3

	MOVE.32	#COLLEDVER1,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLUSRLED1

	MOVE.32	#COLLEDVER2,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLUSRLED2

	MOVE.32	#COLLEDROU1,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLSUPLED1

	MOVE.32	#COLLEDROU2,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLSUPLED2

	MOVE.32	#COLLEDOFF1,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLOFFLED1

	MOVE.32	#COLLEDOFF2,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLOFFLED2

	MOVE.32	#COLIPM,D3
	LIB	?COLORSR
	MOVE.32	{A0}+ODFCSF,{A5}+OcanCOLIPM

	MOVE.32	#15,D3
	MOVE.32	D3,{A0}+ODFCSF
	MOVE.32	{A5}+OcanCOLGR2,{A0}+ODFCCF
	MOVE.32	#EOP,D3
	LIB	?AFCAR

	MOVE.32	{A5}+OcanCOLFOND,{A0}+ODFCCF
	JUMP	ERR$

BW$:	MOVE.32	#16'55AA55AA,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF

	MOVE.32	#0,D3
	MOVE.32	{A0}+ODFDY,D4
	MOVE.32	#LOADDOT,D2
	LIB	?DRTRAME

ERR$:	POPM.32	D0..D6|A0..A4
	TEST.16	D7
	RET



;---------------\\
;  _DBUG_REGPAN  >
;===============/

; Opration avec un panneau affichant des registres.

; in	D0.16	#REGPAN_..
;	+ ..
; out	D7.16	erreur
;	+ ..
; mod	D7.16, ..

_DBUG_REGPAN:
	COMP.16	#REGPAN_DEFREGS,D0
	JUMP,LE	R8^OK$

	MOVE.16	#1,D7				; rend une erreur si appel pas implment
	RET

OK$:	MOVE.16	R8^TABLE$+A16^{D0},D7		; D7 <-- offset sur le code
	PUSH.32	#R8^TABLE$+A16^{D7}		; <-- adresse de retour sur la pile
	CLR.16	D7
	RET					; <-- saute  la bonne adresse


TABLE$:	.16	_REGPAN_CREATE-TABLE$
	.16	_REGPAN_KILL-TABLE$
	.16	_REGPAN_DEFPOS-TABLE$
	.16	_REGPAN_GETSIZE-TABLE$
	.16	_REGPAN_DRAW-TABLE$
	.16	_REGPAN_UPDATE-TABLE$
	.16	_REGPAN_AFX8-TABLE$
	.16	_REGPAN_DEFREG-TABLE$
	.16	_REGPAN_DEFREGS-TABLE$


;--------------\\
;  _DBUG_SFPAN  >
;==============/

; Opration avec un panneau affichant les flags de SF.

; in	D0.16	#SFPAN_..
;	+ ..
; out	D7.16	erreur
;	+ ..
; mod	D7.16, ..

_DBUG_SFPAN:
	COMP.16	#SFPAN_DEFSF,D0
	JUMP,LE	R8^OK$

	MOVE.16	#1,D7				; rend une erreur si appel pas implment
	RET

OK$:	MOVE.16	R8^TABLE$+A16^{D0},D7		; D7 <-- offset sur le code
	PUSH.32	#R8^TABLE$+A16^{D7}		; <-- adresse de retour sur la pile
	CLR.16	D7
	RET					; <-- saute  la bonne adresse


TABLE$:	.16	_SFPAN_CREATE-TABLE$
	.16	_SFPAN_KILL-TABLE$
	.16	_SFPAN_DEFPOS-TABLE$
	.16	_SFPAN_GETSIZE-TABLE$
	.16	_SFPAN_DRAW-TABLE$
	.16	_SFPAN_UPDATE-TABLE$
	.16	_SFPAN_DEFSF-TABLE$


;----------------\\
;  _DBUG_FILELST  >
;================/

; Opration avec un fichier .LST.

; in	D0.16	#FILELST_..
;	+ ..
; out	D7.16	erreur
;	+ ..
; mod	D7.16, ..

_DBUG_FILELST:
	COMP.16	#FILELST_LASTLINE,D0
	JUMP,LE	R8^OK$

	MOVE.16	#1,D7				; rend une erreur si appel pas implment
	RET

OK$:	MOVE.16	R8^TABLE$+A16^{D0},D7		; D7 <-- offset sur le code
	PUSH.32	#R8^TABLE$+A16^{D7}		; <-- adresse de retour sur la pile
	CLR.16	D7
	RET					; <-- saute  la bonne adresse


TABLE$:	.16	_FILELST_OPEN-TABLE$
	.16	_FILELST_CLOSE-TABLE$
	.16	_FILELST_FINDPC-TABLE$
	.16	_FILELST_PREVLINE-TABLE$
	.16	_FILELST_NEXTLINE-TABLE$
	.16	_FILELST_LASTLINE-TABLE$



;----------------\\
;  _DBUG_TEXTWDO  >
;================/

; Opration avec une fentre affichant le texte d'un fichier
; de listage.

; in	D0.16	#TEXTWDO_..
;	+ ..
; out	D7.16	erreur
;	+ ..
; mod	D7.16, ..

_DBUG_TEXTWDO:
	COMP.16	#TEXTWDO_DEFPC,D0
	JUMP,LE	R8^OK$

	MOVE.16	#1,D7				; rend une erreur si appel pas implment
	RET

OK$:	MOVE.16	R8^TABLE$+A16^{D0},D7		; D7 <-- offset sur le code
	PUSH.32	#R8^TABLE$+A16^{D7}		; <-- adresse de retour sur la pile
	CLR.16	D7
	RET					; <-- saute  la bonne adresse


TABLE$:	.16	_TEXTWDO_CREATE-TABLE$
	.16	_TEXTWDO_KILL-TABLE$
	.16	_TEXTWDO_UPDATE-TABLE$
	.16	_TEXTWDO_SCROLLUP-TABLE$
	.16	_TEXTWDO_SCROLLDOWN-TABLE$
	.16	_TEXTWDO_DEFPC-TABLE$



;---------------\\
;  _DBUG_ACCEPT  >
;===============/

; Attend un vnement "exception" en provenance du gestionnaire
; d'exceptions.

; in	A5.32	canal D.Bug
;	timeout
; out	A4.32	^Orx.. (record d'exception)
;	D7.16	erreur
; mod	A4.32, D7.16

_DBUG_ACCEPT:
	JUMP	ACCEPTglobalBAR


;------------------\\
;  _DBUG_ENDACCEPT  >
;==================/

; Dbloque le processus qui a provoqu une exception. Le processus
; excute encore la routine donne en entre avant de restaurer
; son contexte et de continuer.

; in	A5.32	canal D.Bug
;	A4.32	^routine  appeler (ou NIL)
; out	D7.16	erreur
; mod	D7.16

_DBUG_ENDACCEPT:
	JUMP	ENDACCEPTglobalBAR



;------------------\\
;  _DBUG_INTERFACE  >
;==================/

; Gre l'interface graphique de A  Z. Sort de cet appel que lorsque
; l'utilisateur a demand "Fin".

; in	A5.32	canal D.Bug
;	A0.32	^descripteur fentre
;	D2.32	mode (0)
; out	D7.16	erreur
; mod	D7.16

_DBUG_INTERFACE:
	PUSHM.32 A6

	CALL	VISUAL_OPEN
	JUMP,NE	ERR$

	CALL	VISUAL_MAIN
	CALL	VISUAL_CLOSE

ERR$:	POPM.32	A6
	TEST.16	D7
	RET



;-----------------\\
;  _DBUG_LOADFILE  >
;=================/

; Charge un fichier en mmoire pour pouvoir ensuite l'utiliser
; pour le dverminage.

; in	A5.32	canal D.Bug
;	A3.32	^nom du binaire (.CODE)
;	D3.32	mode (0 pour l'instant)
; out	D7.16	erreur
; mod	D7.16

_DBUG_LOADFILE:
	PUSHM.32 D1|D3|D4|A3|A4

	MOVE.32	#MTYPCP,D1
	MOVE.32	#256,D4
	GESMEM	?GETMEM
	JUMP,NE	ERR$

	GESMEM	?CLEARMEM
	SUB.32	#4,D4
	GESMEM	?COPYMEM

	MOVE.32	A4,A3				; A3 <-- ^copie de la ligne

	MOVE.32	#R16^EXT$,A4			; met extension ".CODE"

	MOVE.32	#"X",D3
	LIB	?IFSWITCH
	JUMP,NE	R8^ADDEXT$

	MOVE.32	#0,D3
	LIB	?ADDEXT				; "xxx.CODE"
	MOVE.32	A3,A4

TEST$:	TEST.8	{A4+}
	JUMP,NE	TEST$

	MOVE.8	#"/",{A4}-1
	MOVE.8	#"X",{A4+}
	CLR.8	{A4}
	JUMP	R8^LOAD$

ADDEXT$:
	MOVE.32	#0,D3
	LIB	?ADDEXT

LOAD$:	CALL	R32^LOADforDEBUG		; charge & met en cache & modifie

	PUSH.16	D7
	MOVE.32	A3,A4
	GESMEM	?GIVMEM
	POP.16	D7

ERR$:	POPM.32	D1|D3|D4|A3|A4
	TEST.16	D7
	RET

EXT$:	.ASCIZ	"CODE"
	.EVEN


NMNOTRAP:	.ASCIZ	"SMA_noTRAP"
NMDBUG:		.ASCIZ	"D.Bug"
NMNTREL:	.ASCIZ	"SMA_NTR.BIN"
		.EVEN


	.INS	DBUG_DIAGNO.ASI
	.INS	DBUG_INTERF.ASI
	.INS	DBUG_MISC.ASI
	.INS	DBUG_LOWLEV.ASI
	.INS	DBUG_REGPAN.ASI
	.INS	DBUG_LST.ASI
	.INS	DBUG_DBOX.ASI
	.INS	DBUG_CPU.ASI
	.INS	DBUG_LOAD.ASI




END_MODULE:

	.END

