;---------------\\
;  DBX_CHOIXADR  >
;===============/

; Choix de l'adresse de base pour afficher le contenu de
; la mmoire ou bien du mode de dsassemblage.

; in	A5.32	canal D.Bug
;	A2.32	^Oadr.. record pour afficher mmoire
; out	D3.16	F0 => annule, F1 => d'accord
;	D7.16	erreur
; mod	D3.32 (!), D7.16

DBX_CHOIXADR:
	PUSHM.32 D0..D2|D4..D6|A0..A4

	MOVE.32	#0,D4
	TEST.8	{A2}+OadrDESASS			; dsassemble instructions ?
	JUMP,F	R8^SHOWMEM$			; non => montre mmoire
	TEST.8	{A2}+OadrDESASSPC		; dsassemble aussi selon PC ?
	JUMP,F	R8^DESASS1$			; non => que pos. courante

	TSET.32	D4:#18				; <-- dsassemble aussi selon next instr.
	JUMP	R8^START$			; commence..

SHOWMEM$:
	TSET.32	D4:#16				; <-- affiche contenu de la mmoire
	CALL	DBX_INITADRMENU			; initialise les menus..
	JUMP	R8^START$

DESASS1$:
	TSET.32	D4:#17				; <-- dsassemble selon position courante

START$:	TEST.8	{A2}+OadrREL			; relatif ?
	JUMP,F	R8^JOB$
	TSET.32	D4:#0				; <-- met la croix "relatif"

JOB$:	MOVE.32	#rDboxDefVisu,D1
	MOVE.32	#R16^GDBOX$,A1
	CALL	OPENDBOX			; affiche la DBOX

	CALL	DBX_ADRUPDATE

	MOVE.32	#{A5}+OcanBUARGS,A3
	MOVE.32	A3,A4
	PUSH.32 D4
	MOVE.32	{A2}+OadrOFFSET,D4
	MOVE.32	#8,D3
	CALL	PUTHEX
	CLR.8	{A4}				; <-- nombre hexa en dition
	POP.32	D4

EDIT$:	MOVE.32	#-1,D3
	TEST.32	D4:#16				; dite ligne ditable ?
	JUMP,BC	R8^NOEDIT$

	MOVE.32	#0,D3

NOEDIT$:
	DBOX_	MEDIT				; dite ligne ou rien du tout..
	CALL	EDITDBOX

	TEST.16	D3
	JUMP,EQ	EDIT$

	COMP.16	#CLEAR,D3
	JUMP,EQ	R8^UNDO$
	COMP.16	#UNDO,D3
	JUMP,NE	R8^noUNDO$

UNDO$:	TEST.32	D4:#16
	JUMP,BC	BIP$

	CLR.8	{A3}
	MOVE.32	A3,A4
	JUMP	EDIT$

noUNDO$:
	COMP.16	#F1,D3
	JUMP,EQ	OK$
	COMP.16	#F0,D3
	JUMP,EQ	END$
	COMP.16	#16'7E00,D3
	JUMP,EQ	REGX1$
	COMP.16	#16'7E01,D3
	JUMP,EQ	REGX2$
	COMP.16	#16'7E02,D3
	JUMP,EQ	REGX3$
	COMP.16	#16'7E03,D3
	JUMP,EQ	OFFSET$

	SWAP.16	D3
	COMP.8	#16'7E,D3
	JUMP,EQ	EDIT$				; pas de bip..


BIP$:	MOVE.32	#BIPLIT,D3
	LIB	?BEEP
	JUMP	EDIT$

; Affiche le mouse-menu pour choisir le registre de base.

REGX1$:
	PUSHM.32 D5|A3|A4
	MOVE.32	{A5}+OcanPTMMREGXi,A3
	MOVE.32	#{A5}+OcanMMREGXi,A4
	CLR.16	{A4}+OMMSEL			; ne mmorise pas la dernire case !
	MOVE.32	#0,D5				; pas de fanions
	LIB	?MMENUS				; affiche le menu hirarchique des choix

	MOVE.16	{A4}+LMM*0+OMMSEL,D3		; D3 <-- choix effectu
	JUMP,EQ	REGX1FINI$			; aucun => ne change rien

	DEC.16	D3				; pas de base ?
	SET.8,EQ {A2}+OadrNOBASE		; pas de registre de base si "choix = 0"
	JUMP,EQ	REGX1FINI$			; pris "0" => termin

	DEC.16	D3				; registre de donne ?
	JUMP,EQ	R8^REGX1Di$			; oui => ok
	DEC.16	D3				; registre d'adresse ?
	JUMP,EQ	R8^REGX1Ai$			; oui => ok

	MOVE.32	#regUSP,D5
	DEC.16	D3				; registre USP ?
	JUMP,EQ	R8^REGX1MEM$			; oui => prend note

	MOVE.32	#regSSP,D5
	TEST.8	{A5}+OcanMMSSP			; utilise SSP ?
	JUMP,T	R8^REGX1SSP$			; oui => version spciale
	MOVE.32	#regISP,D5
	DEC.16	D3				; registre ISP ?
	JUMP,EQ	R8^REGX1MEM$			; oui => prend note
	MOVE.32	#regMSP,D5

REGX1SSP$:
	DEC.16	D3				; registre MSP/SSP ?
	JUMP,EQ	R8^REGX1MEM$			; oui => prend note
	MOVE.32	#regVBR,D5
	DEC.16	D3				; registre VBR ?
	JUMP,EQ	R8^REGX1MEM$			; oui => prend note
	MOVE.32	#regPC,D5
	DEC.16	D3				; registre PC ?
	JUMP,EQ	R8^REGX1MEM$			; oui => prend note

	MOVE.32	#regPCrel,D5			; triche.. le dernier est le ^programme
	JUMP	R8^REGX1MEM$			; prend note

REGX1Ai$:
	MOVE.32	#regA0,D5
	ADD.16	{A4}+LMM*2+OMMSEL,D5		; <-- registre de base A0..A6
	JUMP	R8^REGX1MEM$

REGX1Di$:
	MOVE.32	#regD0,D5
	ADD.16	{A4}+LMM*1+OMMSEL,D5		; <-- registre de base D0..D7

REGX1MEM$:
	MOVE.16	D5,{A2}+OadrBASEREG

REGX1FINI$:
	POPM.32	D5|A3|A4

UPDATE$:
	CALL	DBX_ADRUPDATE			; met  jour le nom du registre
	JUMP	OFFSET$

; Affiche le mous-menu pour choisir le registre d'offset.

REGX2$:
	PUSHM.32 D5|A3|A4
	MOVE.32	{A5}+OcanPTMMREGXj,A3
	MOVE.32	#{A5}+OcanMMREGXj,A4
	CLR.16	{A4}+OMMSEL			; ne mmorise pas la dernire case !
	MOVE.32	#0,D5				; pas de fanions
	LIB	?MMENUS				; affiche le menu hirarchique des choix
	MOVE.16	{A4}+OMMSEL,D3
	JUMP,EQ	R8^REGX2FINI$
	DEC.16	D3				; premire case ?
	SET.8,EQ {A2}+OadrNOOFFSET		; si "0" => pas d'offset
	JUMP,EQ	R8^REGX2FINI$

	MOVE.32	#regD0,D5
	ADD.A16	#LMM,A4
	DEC.16	D3				; case "A16^" ?
	SET.8,EQ {A2}+OadrSIGNEXT		; oui => tend le signe
	JUMP,EQ	R8^OKREGX2$			; oui => forcment registre de donne
	ADD.A16	#LMM,A4
	DEC.16	D3				; case "32^{Di}" ?
	JUMP,EQ	R8^OKREGX2$			; oui => aussi un reg. de donne
						; non => registre d'adresse
	MOVE.32	#regA0,D5
	ADD.A16	#LMM,A4

OKREGX2$:
	ADD.16	{A4}+OMMSEL,D5			; D5 <-- numro du registre
	MOVE.16	D5,{A2}+OadrOFFSREG

REGX2FINI$:
	POPM.32	D5|A3|A4
	JUMP	UPDATE$

; Choix du facteur de multiplication (parmi 1, 2, 4 et 8)

REGX3$:
	PUSHM.32 A3
	MOVE.32	#R16^MMENU$,A3
	MOVE.32	#0,D3
	LIB	?MMENU
	POPM.32	A3
	JUMP,NE	BIP$

	TEST.16	D3
	JUMP,EQ	EDIT$

	DEC.16	D3
	MOVE.8	D3,{A2}+OadrSHIFT
	JUMP	UPDATE$

; Cliqu dans la ligne avec l'indication de l'offset. Il faut
; slectionner le premier mode..

OFFSET$:
	AND.32	#2'11111111111110001111111111111111,D4
	TSET.32	D4:#16
	JUMP	EDIT$

; Valide les paramtres choisis.

OK$:	TEST.32	D4:#0				; adresses relatives ?
	SET.8,BS {A2}+OadrREL			; on se souvient du choix..

	PUSH.32 D4
	MOVE.32	A3,A4
	CALL	GETHEX
	MOVE.32	D4,{A2}+OadrOFFSET		; mmorise la valeur numrique
	POP.32	D4

	TEST.32	D4:#16				; adressage plutt que dsassemblage ?
	SET.8,BC {A2}+OadrDESASS		; on se souvient du choix..
	TEST.32	D4:#18				; mode "dsassemble aussi au PC actuel" ?
	SET.8,BS {A2}+OadrDESASSPC		; on se souvient du choix..

END$:	CALL	CLOSEDBOX

ERR$:	POPM.32	D0..D2|D4..D6|A0..A4
	TEST.16	D7
	RET

MMENU$:
	.ASCIZ	"   "
	.8	-1
	.ASCIZ	" 1"
	.8	-1
	.ASCIZ	" 2"
	.ASCIZ	" 4"
	.ASCIZ	" 8"
	.8	0

GDBOX$:
	.8	GDBHORFROM+GDBHORTO,100
	.8	GDBHORFROM+GDBHORTO,101
	.8	GDBEND
	.EVEN


