/*
 *	dcachemain.cxx
 *
 *	Fichier grant le dialogue principal ainsi que l'initialisation
 *	des modules ncessaires.
 *
 *	Repris de DEF_MONSEL.
 */

#include <c++/ntrel.h>
#include <c++/fos.h>
#include <c++/mon.h>

#include "dcachemisc.h"
#include "dcachescrl.h"
#include "dcacheutil.h"

#include "lib/gra.h"

/****************************************************************/

unsigned long _stksize	 = 10*1024;		// pile
unsigned long _SMASOVER	 = 1;			// utilise entre OVERLAY de prfrence
unsigned char _SMAPRIO	 = 11;
unsigned char _SMAREV	 = 0;			// rvision
unsigned char _SMAVER	 = 2;			// version
unsigned long _SMAUNIT	 = 0x00000027;	// normal

unsigned short _SMADIS[] = {640, 2000, 340, 2000};
char           _SMAIDE[] = "(C) 1997, Pierre ARNAUD et EPSITEC SA";

/****************************************************************/

static const Card32 res_rv = (0 << 16) | 1;

/****************************************************************/

ResFile	 g_res_file ("(,#):DEF_CACHE(_%L,).RS", RSOPCACHE, res_rv);
ResType  g_rtyp_dbox  (g_res_file, RtypDbox);
ResType  g_rtyp_image (g_res_file, RtypImageCod);
ColorMan g_color_man;
dbox     g_dbox;

Res*     g_dbox_res = 0;
void*    g_pdis = 0;

/****************************************************************/

static short l_dbox_convtable[] = {
    F1, F2, F3,			/* ====> */	F1, 0,
    F4, F5, F6,			/* ====> */	F4, 0,
    F7, F8, F9,			/* ====> */ F7, 0,
    F0, F13, F14, F15,	/* ====> */ F0, 0,
    0
};

static dboxgroup l_dbox_group = { 0, { 0 } };

/****************************************************************/

#define	MAX_LIST_ITEM	32

struct ListItem {
	int				device_ID;				//	real device ID in cache
	char			name[16];				//	name of device being cached
	Card32			max_total_size;			//	maximum total size (blocks)
	Card32			max_chunk_size;			//	maximum chunk size (blocks)
	Card32			current_size;			//	size of data currently in the cache (blocks)
	Bool			is_volatile;			//	TRUE => data is volatile
	Bool			is_dirty;				//	TRUE => dirty cache
	Bool			is_valid;				//	TRUE => record is valid
};

static ListItem l_list_z[1] = { { 0, { 0 }, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, FALSE, FALSE } };
static ListItem l_list_array[MAX_LIST_ITEM] = { { 0, { 0 }, 0, 0, 0, FALSE, FALSE } };

const char*
get_list_item (int num)
{
	if ( (num < MAX_LIST_ITEM)
	  && (num >= 0)
	  && (l_list_array[num].is_valid) ) {
		return l_list_array[num].name;
	}
	
	return "";
}

static void
list_item_insert (const ListItem& item, int max)
{
	ListItem* ptr = l_list_array;
	
	while ( (max)
	     && (strcmp (ptr[0].name, item.name) < 0) ) {
		max--;
		ptr++;
	}
	
	while (max) {
		ptr[max] = ptr[max-1];
		max--;
	}
	ptr[0] = item;
}

static int
refresh_list_item ()
{
	int      num  = 0;
	ListItem item = { 0, { 0 }, 0, 0, 0, FALSE, FALSE };
	
	while (get_cache_info (num,
						   item.name,
						   item.max_total_size,
						   item.max_chunk_size,
						   item.is_volatile,
						   item.current_size,
						   item.is_dirty)) {
		
		item.device_ID = num;
		item.is_valid  = TRUE;
		
		list_item_insert (item, num);
		
		num++;
	}
	
	l_list_array[num].is_valid = FALSE;
	return num;
}

/****************************************************************/

static void
set_curs_after_dbox_label (int label)
{
	Point p1, p2;
	dboxgetco (&g_dbox, label, &p1, &p2);
	L_setcurs (p2);
}

static void
rect_below_dbox_label (int label, int val, int max)
{
	Point p1, p2;
	dboxgetco (&g_dbox, label, &p1, &p2);
	p1.y += 8;
	p2.x  = 252;
	p2.y  = 20;
	
	static const Trame88 empty = { 0, 0, 0, 0, 0, 0, 0, 0 };
	static const Trame88 full  = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
	
	if (max == 0) {
		L_drmdef (empty);
		p2.x += 1;
		p2.y += 1;
		L_drtrame (p1, p2, 0);
		return;
	}
	
	if (val > max) val = max;
	
	L_colorpush ();
	L_colorsa (0, 0, 0);
	L_drmdef (full);
	L_drrect (p1, p2, 0);
	
	if (max > 1024*128) {
		val /= 1024;
		max /= 1024;
	}
	
	p1.y += 1;
	p1.x += 1;
	p2.y -= 1;
	p2.x  = 251 * val / max;
	
	L_colorsa (0, 0, 32768);
	L_drtrame (p1, p2, 0);
	L_colorsa (65535, 65535, 65535);
	
	p1.x += p2.x;
	p2.x  = 251 - p2.x;
	L_drtrame (p1, p2, 0);
	
	L_colorpop ();
}

static void
display_after_dbox_label (int label, int value, int max)
{
	int val = value;
	char buffer[32];
	set_curs_after_dbox_label (label);
	const char* dim = "KB";
	value /= 4;
	if (value >= 1024*10) {
		value /= 1024;
		dim    = "MB";
	}
	
	if (val == 0xFFFFFFFF) {
		L_string ("          ", 10);
		rect_below_dbox_label (label, 0, 0);
	} else {
		sprintf (buffer, "%d %s        ", value, dim);
		L_string (buffer, 10);
		rect_below_dbox_label (label, val, max);
	}
}

static void
box_after_dbox_label (int label, Bool on, Bool draw)
{
	Point p1, p2;
	dboxgetco (&g_dbox, label, &p1, &p2);
	
	p1.x  = p2.x;
	p1.y -= 12;
	p2.x  = 16;
	p2.y  = 16;
	
	static const Trame88 empty = { 0, 0, 0, 0, 0, 0, 0, 0 };
	static const Trame88 full  = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
	
	if (!draw) {
		p2.x++;
		p2.y++;
		L_drmdef (empty);
		L_drtrame (p1, p2, 0);
		return;
	}
	
	L_colorpush ();
	L_colorsa (0, 0, 0);
	L_drmdef (full);
	L_drrect (p1, p2, 0);
	
	p1.y++;
	p1.x++;
	p2.y--;
	p2.x--;
	
	if (on) {
		L_colorsa (0, 0xFFFF, 0);
	} else {
		L_colorsa (0xFFFF, 0, 0);
	}
	
	DisDesc* dis = (DisDesc*)(g_pdis);
	
	if (dis->cmd || on) {
		L_drtrame (p1, p2, 0);
	}
	
	L_colorpop ();
}

void
display_cache_info (int num)
{
	Card32 max_memory_in_system = 0;
	Card32 max_avail_to_user    = 0;
	
	asm volatile ( ".long 0x4E440030\n\t"	// GESMEM?ARGLGM
				   "movel d4,%0\n\t"
				   "movel d5,%1\n\t"
				 : "=g" (max_memory_in_system), "=g" (max_avail_to_user)
				 :
				 : "d4", "d5", "d7" );
	
	display_after_dbox_label (100, l_list_array[num].current_size,
								   l_list_array[num].max_total_size);
	display_after_dbox_label (101, l_list_array[num].max_total_size,
								   max_memory_in_system / 256);
	display_after_dbox_label (102, l_list_array[num].max_chunk_size,
								   l_list_array[num].max_total_size);
	
	box_after_dbox_label (103, ! l_list_array[num].is_dirty, (num >= 0));
}

/****************************************************************/

int
main (int argc, char* argv[])
{
	int   err;
	Bool  stop = FALSE;
	Card8 buttons;
	Point point;
	char  sel_name[16] = { 0 };
	int   sel_info = -1;
	int   info_num = 0;
	
	err = init_res_stuff ();
	if (err) return err;
	
	if (&l_list_z[0] != &l_list_array[-1]) return 0;
	
	if (open_cache_bar () == FALSE) {
		u_int canal = 0;
		L_pushmenu (&canal);
		dbox_terror ("Le cache n'est actuellement pas actif !\r"
					 "Consultez la documentation fournie dans\r"
					 "le fichier SMA_CACHE.NEWS.",
					 1 /* BDBSAV */, point);
		L_popmenu (canal);
		return 0;
	}
	
	info_num = refresh_list_item ();
	
	//	Initialize hldbox
	
	if (err = dboxinit ((u_char *)(g_dbox_res->GetData ()),
						&g_dbox, &l_dbox_group, l_dbox_convtable)) {
		return err;
	}
	
	//	Open dbox
	
	dboxopen (&g_dbox);
	
	draw_dbox_adornment ();
	draw_scroll_list ();
	draw_softkeys ();
	update_scroll_list (info_num, sel_info);
	
	//	Main loop
	
	do {
		short touche;
		Ntr::SetTim (25);
		dboxedit (&g_dbox, &touche);
		Ntr::SetTim (0xFFFF);
		
		if (touche == 0) {
			ListItem old_item = l_list_array[sel_info];
			
			touche = 1;					//	comme si on avait cliqu "refait"
			int old_num = info_num;
			info_num = refresh_list_item ();
			if (old_num == info_num) {
				if (sel_info == -1) continue;
				if (sel_info < info_num) {
					if ( (l_list_array[sel_info].current_size == old_item.current_size)
					  && (l_list_array[sel_info].max_total_size == old_item.max_total_size)
					  && (l_list_array[sel_info].max_chunk_size == old_item.max_chunk_size)
					  && (l_list_array[sel_info].device_ID == old_item.device_ID) ) {
						continue;
					}
				}
			}
		}
		
		switch ((Card16)(touche)) {
			
			case F1:		// termine
			case F0:
				stop = TRUE;
				break;
			
			case KEYMGP:
				L_ifmouse (&point, &buttons);
				
				if (track_scroll_list (point.x, point.y, sel_info)) {
					if (sel_info != -1) {
						display_cache_info (sel_info);
						strcpy (sel_name, l_list_array[sel_info].name);
					} else {

					}
				} else {
					dboxbip (&g_dbox, touche);
				}
				break;
			
			case 3:
				if (sel_info >= 0) {
					sync_invalidate (l_list_array[sel_info].device_ID, TRUE);
				}
				goto update;
				
			case 2:
				if (sel_info >= 0) {
					sync_invalidate (l_list_array[sel_info].device_ID, FALSE);
				}
				
				//	fall through
			
			case 1:
update:			info_num = refresh_list_item ();
				for (sel_info = 0; sel_info < info_num; sel_info++) {
					if (strcmp (sel_name, l_list_array[sel_info].name) == 0) {
						break;
					}
				}
				if (sel_info >= info_num) sel_info = -1;
				update_scroll_list (info_num, sel_info);
				display_cache_info (sel_info);
				break;
			
			case 0:
				break;
			
			default :
				dboxbip (&g_dbox, touche);
		}

	} while (!stop);
	
	dboxclose (&g_dbox);
	
	return 0;
}


