/*
 *	dcachemisc.cxx
 *
 *	Fonctions diverses d'initialisation et de dessin utiles pour
 *	la gestion de (jolies) DBOX.
 *
 *	Repris de DEF_MONSEL.
 */

#include "dcachemisc.h"

/****************************************************************/

static int
init_libs ()
{
    int err;
    
    if (err = dbox_opelib ()) return err;
    atexit ((void (*)(void))(dbox_clolib));
    
    return 0;
}

/****************************************************************/

void
draw_softkeys ()
{
	static const char menu[] = {
		"\0"
		"\0"
		"\0"
		"Vu\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
	};
	
	L_afmenu ((void *)(menu));
}

/****************************************************************/

void
draw_dbox_adornment ()
{
	Point p1, p2;
	Point wdim, dummy;
	int nowdo;
	int i;
	
	L_getwdo (&dummy, &wdim, &nowdo);
	
	//	Draw rivets
	
	Dim rivetdim;
	g_color_man.GetIconSize (rIconRivet, rivetdim);
	
	const Int16 rivetborder = 6;
	const Pos rivetpos[] = {
		{ rivetborder, rivetborder},
		{ rivetborder, wdim.x - rivetborder - rivetdim.dx },
		{ wdim.y - rivetborder - rivetdim.dy, rivetborder },
		{ wdim.y - rivetborder - rivetdim.dy, wdim.x - rivetborder  - rivetdim.dx }
	};
	
	for (i = 0; i < 4; i++) {
		g_color_man.DrawIcon (rIconRivet, rivetpos[i]);
	}
	
	//	Draw lines
	
	dboxgetco (&g_dbox, 2, &p1, &p2);
	p1.x = 0;
	p1.y -= 20;
	
	Box b1 = { { p1.y, p1.x }, { 0, wdim.x } };
	g_color_man.DrawLine (b1);
	
	dboxgetco (&g_dbox, 3, &p1, &p2);
	p1.x = 0;
	p1.y -= 14;
	
	Box b2 = { { p1.y, p1.x }, { 0, wdim.x } };
	g_color_man.DrawLine (b2);
}

/****************************************************************/

int
init_res_stuff ()
{
	int  err;
	
	//	Load libraries
	
	if (err = g_res_file.GetError ()) return err;
	if (err = init_libs ()) return err;
	
	g_dbox_res = new Res (g_rtyp_dbox, RS_DBOX_MAIN);
	if (err = g_dbox_res->GetError ()) return err;
	
	//	Find monochrome image
	
	Res mres (g_rtyp_image, RS_IMAGE_MONO);
	if (err = mres.GetError ()) return err;
	const void *mdata = mres.GetData ();
	
	//	Find color image
	
	Res cres (g_rtyp_image, RS_IMAGE_COLOR);
	if (err = cres.GetError ()) return err;
	const void *cdata = cres.GetData ();
	
	//	Init color management class
	
	g_color_man.Init (mdata, cdata, ICONS_NUMBER, icons_def);
	g_color_man.Update ();
	
	L_getpdis (&g_pdis);
	
	return 0;
}

