/*
 *	dcachemisc.h
 *
 *	Symboles utiliss par la majeure partie des fichiers
 *	d'implmentation du projet.
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <c++/portable.h>

#include "lib/colorman.h"
#include "lib/res.h"

#include "def_cache.h"				//	ressources
#include "dcacheicons.h"			//	icones dans les images des ressources

/****************************************************************/

typedef struct { short y,x; } Point;
typedef u_char Trame88[8];

extern "C"
{
#include "lib/hldbox.h"

extern int L_drseg (Point origine, Point dim, u_short mode);
extern int L_afmenu (const void* liste);
extern int L_getwdo (Point* UpperLeft, Point* Dim, int* nowdo);
extern int L_string (const char* string, unsigned long length);
extern int L_rstgc ();
extern int L_setcurs (Point p);
extern int L_getcurs (Point*);
extern int L_getpdis (void* dis_desc);
extern int L_ifmouse (Point* pos, u_char* boutons);
extern int L_pushmenu (u_int* canal);
extern int L_popmenu (u_int canal);

extern int L_flush ();
extern int L_drmdef (Trame88 trame);
extern int L_drtrame (Point origine, Point dim, u_short mode);
extern int L_drrect (Point origine, Point dim, u_short mode);

extern int L_colorpush ();
extern int L_colorpop ();
extern int L_colorsa (u_short red, u_short green, u_short blue);
extern int L_colorca (u_short red, u_short green, u_short blue);


extern int dbox_opelib (void);
extern int dbox_clolib (void);
extern int dbox_terror (const char* texte, long mode, Point pos);
}

/****************************************************************/

#define F0		0x80
#define F1		0x81
#define F2		0x82
#define F3		0x83
#define F4		0x84
#define F5		0x85
#define F6		0x86
#define F7		0x87
#define F8		0x88
#define F9		0x89
#define F10		0x8A
#define F11		0x8B
#define F12		0x8C
#define F13		0x8D
#define F14		0x8E
#define F15		0x8F

#define	UNDO	0x90
#define	HELP	0x91
#define	END		0x92
#define	MACRO	0x93
#define	FNCT	0x94
#define	DEFINE	0x95
#define POINT	0x97
#define	ENTER	0x98
#define	DELETE	0x9E
#define	CLEAR	0x9F
#define RETURN	0x0d

#define	KEYMGP	0x7F01

/****************************************************************/

extern ResFile  g_res_file;
extern ResType  g_rtyp_dbox;
extern ResType  g_rtyp_image;
extern ColorMan g_color_man;
extern dbox     g_dbox;
extern Res*     g_dbox_res;
extern void*	g_pdis;

/********* dcachemisc.cxx ***************************************/

extern int  init_res_stuff ();

extern void draw_softkeys ();
extern void draw_dbox_adornment ();

/********* dcachemain.cxx ***************************************/

extern const char* get_list_item (int num);


