/*
 *	dcachescrl.cxx
 *
 *	Gestion d'une scroll list.
 *
 *	Repris de DEF_MONSEL.
 */

#include "dcachemisc.h"
#include "dcachescrl.h"

#include "lib/scroll.h"

/****************************************************************/

#define	SCROLL_LIST_DY	18

static ListStruct l_list = { { 0 } };

/****************************************************************/

void
draw_scroll_list ()
{
	Point p1, p2, p3;
	
	dboxgetco (&g_dbox, 0, &p1, &p2);
	dboxgetco (&g_dbox, 1, &p2, &p3);
	
	l_list.slvid   = FALSE;
	l_list.slpos.x = p1.x;
	l_list.slpos.y = p1.y - 16;
	l_list.sldim.x = p2.x - l_list.slpos.x;
	l_list.sldim.y = p2.y - l_list.slpos.y;
	
	scroll_ldim (& l_list, g_pdis);
	
	l_list.slcar.y = SCROLL_LIST_DY;
	l_list.slc1y   = SCROLL_LIST_DY - l_list.slc2y - 1;
	l_list.slc2y   = SCROLL_LIST_DY - l_list.slc1y;
	l_list.slnby   = (l_list.sldim.y / l_list.slcar.y) - 1;
	l_list.sldim.y = l_list.slcar.y * (l_list.slnby + 1) + 2;
	l_list.slsptr  = & l_list;
	
	scroll_ldraw (& l_list, g_pdis, 0);
}

static short
update_func (void* calleevar, Card16 cell, Card16 numchars, Card16 firstchar)
{
	Point point;
	
	Point trame_org;
	Point trame_dim;
	
	Trame88 trame;
	for (int i = 0; i < 8; i++) trame[i] = 0x00;
	
	L_flush ();
	L_getcurs (&point);
	
	trame_org.x = point.x - 1;
	trame_org.y = point.y - l_list.slc1y;
	trame_dim.x = l_list.sldim.x - 16;
	trame_dim.y = l_list.slcar.y;
	
	L_drmdef (trame);
	L_drtrame (trame_org, trame_dim, 0);
	
	const char* text = get_list_item (cell);
	L_string (" ", 1);
	L_string (text, strlen (text));
	L_flush ();
	
	return 0;
}


void
update_scroll_list (int num, int select)
{
	l_list.slcyn = num;
	l_list.slcys = select;
	
	if ( (num == 0) && (l_list.slcys != -1) ) {
		l_list.slcys = -1;
	}
	
	scroll_lupdate (& l_list, g_pdis, 0, update_func, 0);
}

int
get_scroll_list_select ()
{
	return l_list.slcys;
}

Bool
track_scroll_list (Card16 x, Card16 y, int& sel)
{
	Point wdim, wpos;
	int   nowdo;
	
	L_getwdo (&wpos, &wdim, &nowdo);
	x -= wpos.x;
	y -= wpos.y;
	
	Point p = { y, x };
	
	if (scroll_lmove (& l_list, g_pdis, p, 0, update_func, 0)) {
		return FALSE;
	}
	
	sel = l_list.slcys;
	return TRUE;
}


