
#include "dcacheutil.h"

#include "cache.h"

#include <c++/ntrel.h>
#include <stdio.h>


NtrBar* g_cache_bar = 0;


/*
 *	Connecte au serveur de cache (s'il existe).
 */

Bool
open_cache_bar ()
{
	NtrBar* bar = new NtrBar ("#:FosCacheBlk", 1);
	if (bar->GetError ()) return FALSE;
	g_cache_bar = bar;
	return TRUE;
}


/*
 *	Change les paramtres de configuration d'une unit cache.
 */

Bool
set_cache_info (int index, Card32 max_total_size, Card32 max_chunk_size, Bool is_volatile)
{
	void*      ptr   = 0;
	CaAboutRec about = { 0 };
	CacheRec   rec   = {
		0, 0, 0, 0, 0,
		caOPAbout, 0,
		index, sizeof (CaAboutRec), &about, 0
	};
	
	//	On doit d'abord faire un "about" afin d'obtenir le pointeur
	//	 l'instance (rec.cache) qui sert de validation  l'appel
	//	"config".
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	if (rec.typ_error) return FALSE;
	
	//	Si tout s'est bien pass, on fait la demande de changement
	//	de taille(s).
	
	rec.op = caOPConfig;
	
	about.max_total_size = max_total_size;
	about.max_chunk_size = max_chunk_size;
	about.is_volatile    = is_volatile;
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	return (rec.typ_error == 0) ? TRUE : FALSE;
}


/*
 *	Retourne les informations sur une des units caches.
 */

Bool
get_cache_info (int index,
				char* name,
				Card32& max_total_size, Card32& max_chunk_size,
				Bool& is_volatile,
				Card32& current_size,
				Bool &is_dirty)
{
	void*      ptr   = 0;
	CaAboutRec about = { 0 };
	CacheRec   rec   = {
		0, 0, 0, 0, 0,
		caOPAbout, 0,
		index, sizeof (CaAboutRec), &about, 0
	};
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	if (rec.typ_error == 0) {
		
		max_total_size = about.max_total_size;
		max_chunk_size = about.max_chunk_size;
		is_volatile    = about.is_volatile;
		current_size   = about.current_size;
		is_dirty       = about.is_dirty;
		
		strcpy (name, about.name);
		return TRUE;
	}
	
	return FALSE;
}

/*
 *	Synchronise et invalide le contenu d'un disque cach.
 */

Bool
sync_invalidate (int index, Bool invalidate)
{
	void*      ptr   = 0;
	CaAboutRec about = { 0 };
	CacheRec   rec   = {
		0, 0, 0, 0, 0,
		caOPAbout, 0,
		index, sizeof (CaAboutRec), &about, 0
	};
	
	//	On doit d'abord faire un "about" afin d'obtenir le pointeur
	//	 l'instance (rec.cache) qui sert de validation  l'appel
	//	"config".
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	if (rec.typ_error) return FALSE;
	
	//	Si tout s'est bien pass, on fait la demande de synchronisation
	//	puis celle d'invalidation.
	
	rec.op = caOPSync;
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	if (rec.typ_error) return FALSE;
	if (invalidate == FALSE) return TRUE;
	
	rec.op = caOPInvalidate;
	
	g_cache_bar->Offer ();
	g_cache_bar->EndOffer (&rec, ptr);
	
	if (rec.typ_error) return FALSE;
	
	return TRUE;
}


/*
int
main ()
{
	if (open_cache_bar ()) {
		
		int    index = 0;
		char   name[16];
		Card32 max_total_size;
		Card32 max_chunk_size;
		Bool   is_volatile;
		Card32 current_size;
		
		while (get_cache_info (index, name, max_total_size, max_chunk_size,
							   is_volatile, current_size)) {
			
			printf ("%s\n  currently cached   : %d blocks\n", name, current_size);
			printf (	 "  maximum total size : %d blocks\n", max_total_size);
			printf (	 "  largest chunk size : %d blocks\n", max_chunk_size);
			printf (	 "  unit is %svolatile\n\n", is_volatile ? "" : "not ");
			
			index++;
		}
	}
	
	return 0;
}
*/

