/*
 *	scroll.h
 *
 *	Interface avec le module SCROLL.
 *
 *	Jean-Michel Pulfer, 23.1.91
 *	Pierre Arnaud, 16.11.96 (C++)
 */

enum ScrollButt
{
	SCROLLFUP = 1,
	SCROLLFDOWN = 2,
	SCROLLPUP = 3,
	SCROLLPDOWN = 4
};


/*
 *	Fonctions appeles par la fonction scroll_lupdate
 */

typedef short (*ListFunL)(void*   calleevar,
						  Card16  cell,
						  Card16* divider,
						  char**  contents);

typedef short (*ListFunA)(void*   calleevar,
						  Card16  cell,
						  Card16  numchars,
						  Card16  firstchar);


/*
 *	Un descripteur d'ascenseur.
 */

struct ScrollStruct
{
	char		schor ;			/* != 0 => ascenseur vertical */
	char		scpage ;		/* != 0 => dplacement par pages possible */
	short		scdebo ;		/* Coordonne parallle  l'ascenseur */
	short		scdebl ;		/* Coordonne perpendiculaire  l'ascenseur */
	short		schtr ;			/* Hauteur relle de l'ascenseur [pixels] */
	short		schtv ;			/* Hauteur virtuelle de l'ascenseur */
	short		scposr ;		/* Position relle */
	short		scposv ;		/* Position virtuelle */
	short		scinc ;			/* Incrment par les flches */
	char		scmark ;		/* != 0 => marqueur dans la cabine */
	char		scresvd1 ;		/* Rserve */
	short		schtc ;			/* Hauteur de la cabine */
	u_char		scfill1[16];	/* Rserve */
};

typedef ScrollStruct* ScrollDesc;


/*
 *	Un descripteur de scroll-liste.
 */

struct ListStruct
{
	ScrollStruct	slasv;		/* Description de l'ascenseur vertical */
	char			slcabv;		/* != 0 => cabine verticale dessine */
	char			slresvd1;	/* Rserve */
	
	ScrollStruct	slash;		/* Ascenseur horizontal */
	char			slcabh;		/* != 0 => cabine horizontale dessine */
	char			slresvd2;	/* Rserve */
	
	char			slvid;		/* != 0 => case vide en haut de la liste */
	char			slhor;		/* != 0 => ascenseur horizontal existe */
	char			slvii;		/* != 0 => case vide inverse */
	char			slresvd3;	/* Rserve */
	
	void*			sladl;		/* ^fonction 1 */
	void*			slada;		/* ^fonction 2 */
	
	Point			slpos;		/* Point en haut  gauche */
	Point			sldim;		/* Dimensions */
	
	Point			slcar;		/* Dimensions d'un caractre */
	short			slc1x;		/* Rfrence gauche */
	short			slc1y;		/* Hauteur au-dessus de la ligne de base */
	short			slc2y;		/* Hauteur en-dessous de la ligne de base */
	
	u_short			slnby;		/* Nombre de lignes visibles */
	u_short			slnbx;		/* Nombre de caractres visibles */
	
	u_short			slcyn;		/* Nombre de lignes dans la liste */
	short			slcys;		/* Ligne slectionne */
	short			slcya;		/* Ligne affiche en haut */
	
	u_short			slcxn;		/* Nombre de colonnes dans la liste */
	short			slcxa;		/* Colonne affiche  gauche */
	
	void*			slsptr;		/* pointeur sur soi-mme */
	u_char			slfill[28];	/* Rserve */
};

typedef ListStruct* ListDesc;

extern "C"
{

extern int	scroll_open ();
extern int	scroll_close ();

extern int	scroll_draw (ScrollDesc scroller);

extern int	scroll_scale (ScrollDesc scroller,
						  void* fenetre,
						  short ndivisions,
						  short longdivisions,
						  const char* textes);

extern int	scroll_update (ScrollDesc scroller);

extern int	scroll_move  (ScrollDesc scroller,
						  Point mousepos,
						  Card16* lastkey,
						  ScrollButt* bouton);

extern int	scroll_press (ScrollDesc scroller,
						  ScrollButt bouton);

extern int	scroll_ldim (ListDesc liste,
						 void* fenetre);

extern int	scroll_ldraw (ListDesc liste,
						  void* fenetre,
						  const char* textvide);

extern int	scroll_lupdate (ListDesc liste,
							void* fenetre,
							ListFunL foncl,
							ListFunA fonca,
							void* calleevar);

extern int	scroll_lmove (ListDesc liste,
						  void* fenetre,
						  Point mousepos,
						  ListFunL foncl,
						  ListFunA fonca,
						  void* calleevar);

extern int	scroll_linvcase (ListDesc liste, short numcase);

}

