/*
 *
 *	tcolor.h
 *
 *	TCOLOR access
 *
 *	(C)	1994 Erik BRUCHEZ
 */


#include "gra.h"

/****************************************************************/

/*
 *	TColor miscellaneous modes.
 */

enum TCMode
{
	TC_GLOB = 1,
	TC_FORCE = 2,
	TC_GIVE = 4,
	TC_TABLE = 8,
	TC_NAME = 0x10,
	TC_CHFOS = 0x20,
	TC_T8X8 = 0x40,
	TC_ACTIVE = 0x80
};


enum TCTableType
{
	TC_TYPE_CLUT = 0x90,
	TC_TYPE_CRET = 0x91
};

/****************************************************************/

/*
 *	Clut definition.
 */

struct GColor
{
	Card16	r, g, b;
};


struct TCEntry
{
	Card32		index;
	GColor		color;
};


struct TCClut
{
	Card8		type;
	Card8		reserve_1;
	Card32		size;
	Card16		number;
	Card8		reserve_2[24];
	TCEntry		entry[0];
};

/****************************************************************/

/*
 *	TColor interface class.
 */

class TColor {
	
private:
	Card32	tchannel;

public:
	void Update (Card32 channel);
	
	Card16 Open (Card16& channel);
	Card16 Close (Card16 channel);
	Card16 LoadClut (Card32 mode, void *table, char *name = 0, Card16 channel = 0);
	Card16 SaveClut (Card32 mode, void *table, char *name = 0, Card16 channel = 0);
	Card16 SrcClut ();
	Card16 PutClut (Card32 mode, GColor *rgb, Card16& num);
	static Card16 PpssClut ();
	Card16 GpssClut ();
	Card16 LoadCret ();
	Card16 KillCret ();
	Card16 AddCret ();
	Card16 SubCret ();
	Card16 SrcCret (Card32 relcolor, GColor& namedrgb, GColor& exactrgb, Card32& color);
	Card16 PutCret ();
	Card16 DelCret ();
	Card16 ListCret ();
	Card16 MakeTrame ();
};

/****************************************************************/

/* 
 *	Initialize the TColor module. This must be done at least once
 *	in the beginning of the application.
 */

inline void
TColor::Update (Card32 channel)
{
	//TColor::tchannel = descr->cpf;
	this->tchannel = channel;
}


/*
 *	Open the TColor module. This call mustn't be used by a normal
 *	program.
 */

inline Card16
TColor::Open (Card16& channel)
{
  char *name = "TCOLOR";
  
  register Card16 _channel asm ("d1");
  register Card16 _error asm ("d7");
  
  asm volatile ("
    movel %0,a3
    movew 0xaab0,d3
    .short 0xa102
    "
  	:
  	: "g" (name)
  	: "d1", "d7", "a3"
  );
  
  channel = _channel;
  return _error;
}



/*
 *	Close the TColor module. This call musn't be used by a normal
 *	program.
 */

inline Card16
TColor::Close (Card16 channel)
{
  register Card16 _error asm ("d7");
  register Card16 _channel asm ("d1");
  _channel = channel;
  
  asm volatile (".short 0xa103"
  	:
  	: "g" (_channel)
  	: "d1", "d7"
  );
  
  return _error;
}



/*
 *	Define a new clut for the program. The clut can be loaded from
 *	an open file, a closed file whose name is given, or from a
 *	structure in memory.
 */

inline Card16
TColor::LoadClut (Card32 mode, void *table, char *name = 0, Card16 channel = 0)
{
  register Card16 _error asm ("d7");
  register Card32 _tchannel asm ("d6");
  register Card32 _mode asm ("d3");
  register Card32 _ad asm ("a3");
  register Card16 _channel asm ("d4");
  
  _tchannel = this->tchannel;
  _mode = mode;
  _channel = channel;
  
  if (mode & TC_TABLE)
    _ad = (long)(table);
  else if (mode & TC_NAME)
    _ad = (long)(name);
  else
    _ad = 0;
  
  asm volatile (".short 0xaab3"
  	:
  	: "g" (_tchannel), "g" (_mode), "g" (_ad), "g" (_channel)
  	: "d3", "d4", "d6", "d7", "a3"
  );
  
  return _error;
}


inline Card16
TColor::SaveClut (Card32 mode, void *table, char *name = 0, Card16 channel = 0)
{
  register Card16 _error asm ("d7");
  register Card32 _tchannel asm ("d6");
  register Card32 _mode asm ("d3");
  register Card32 _ad asm ("a3");
  register Card32 _channel asm ("d4");
  
  _tchannel = this->tchannel;
  _mode = mode;
  _channel = channel;
  
  if (mode & TC_TABLE) {
    _ad      = (long) table;
    _channel = 32 + 256*10;	// hack: taille du buffer
    _mode   |= 0x00010000;	// (voir doc SRCCLUT, nouveau, 256 couleurs)
  } else if (mode & TC_NAME)
    _ad = (long) name;
  else
    _ad = 0;
  
  asm volatile (".short 0xaab4"
  	:
  	: "g" (_tchannel), "g" (_mode), "g" (_ad), "g" (_channel)
  	: "d3", "d4", "d6", "d7", "a3"
  );
  
  return _error;
}


inline Card16
TColor::SrcClut ()
{
}


inline Card16
TColor::PutClut (Card32 mode, GColor *rgb, Card16& num)
{
  register unsigned short _error asm ("d7");
  register short _num asm ("d4");
  
  _num = num;
  
  asm volatile ("
  	movel %0,d6
  	movel %1,d3
  	movel %2,a4
  	movel %3,d4
  	.short 0xaab6"
  	:
  	: "g" (this->tchannel), "g" (mode), "g" (rgb), "g" (num)
  	: "d3", "d4", "d6", "d7", "a4"
  );
  
  num = _num;
  return _error;
}


inline Card16
TColor::PpssClut ()
{
}


inline Card16
TColor::GpssClut ()
{
}


inline Card16
TColor::LoadCret ()
{
}


inline Card16
TColor::KillCret ()
{
}


inline Card16
TColor::AddCret ()
{
}


inline Card16
TColor::SubCret ()
{
}


inline Card16
TColor::SrcCret (Card32 relcolor, GColor& namedrgb, GColor& exactrgb, Card32& color)
{
	Card16 error;
	
	asm volatile (	"movel	%1,d6	\n\t"
			"moveql	#4,d3	\n\t"	//	BTCGIVE
			"movel	%2,d4	\n\t"
			"movel	%3,a4	\n\t"
			"movel	%4,a3	\n\t"
			".short	0xaabc	\n\t"	//	TCOL_SRCCRET
			"movel	%5,a3	\n\t"
			"movel	d4,a3@	\n\t"
			"movew	d7,%0"
			
		: "=g" (error)
		: "g" (this->tchannel), "g" (relcolor), "g" (&namedrgb), "g" (&exactrgb), "g" (&color)
		: "d3", "d4", "d6", "d7", "a3", "a4" );
	
	return error;
}


inline Card16
TColor::PutCret ()
{
}


inline Card16
TColor::DelCret ()
{
}


inline Card16
TColor::ListCret ()
{
}


inline Card16
TColor::MakeTrame ()
{
}




