/*
 *	colorman.h
 *
 *	Little color manager for def_sms
 *
 *	Code taken from SMA_SMAKY lookman.cxx
 *	for most part
 *
 *	(C)	1995 Erik BRUCHEZ
 */

#ifndef _COLOR_MAN_H_
#define _COLOR_MAN_H_

#include "lib/grastructs.h"

enum SSColor
{
	SSWHITE 	= 0,		//	white
	SSLGRAY		= 1,		//	light gray
	SSMGRAY		= 2,		//	middle gray
	SSDGRAY		= 3,		//	dark gray
	SSBLACK		= 4,		//	black
	SSBG		= 5			//	background
};

#define SS_COL_NUM (SSBG + 1)

struct ImageDescr
{
	Box		box;			// image box
	void	*data;			// image data
	Card16	bwidth;			// image width in bytes
	Card32	datalen;		// data length
};

class Gra;
class TColor;
struct TCClut;
struct GColor;

class ColorMan {
	
	Gra*			gra;
	TColor*			tcolor;
	
	void*			cdata;
	Card8			depth;
	Bool			use_color;
	
	Card32			colors[SS_COL_NUM];
	
	TCClut*			clut256;
	Card8			ctable[16];
	
	Card16			icnumber;
	const Box*		icons_def;
	
	Card16			err;
	
	//	Pseudo-static members
	
	ImageDescr		mimage;			// monochrome image
	ImageDescr		cimage;			// color image
	
	TCClut*			clutimg;		// color image clut
	Bool			force_mono;		// force monochrome drawing
	
	void LoadMonoImage (const void *mdata);
	void LoadColorImage (const void *gcdata);
	
	void OpenIColor ();
	void *GetPDis ();
	
	void ConvC (const ImageDescr *src, void *dest, const Card8 *tbl); 
	Bool FindColor (const GColor& color, Card32& index);
	
public:
	
	ColorMan ();
	~ ColorMan ();
	
	//	Init must be called (normally) once in the beginning of the program
	
	void Init (const void *mresdata, const void *cresdata, Card16 icnumber, const Box *icons_def);
	
	//	Mode
	
	void SetColorMode (Bool force_mono) { this->force_mono = force_mono; }
	Bool GetColorMode () const { return this->force_mono; }
	
	//	Update must be called when the clut is changed
	
	void Update ();
	
	//	Drawing methods
	
	void DrawIcon (Card16 num, Pos pos);
	void DrawRectDown (Box box);
	void DrawLine (Box box);
	
	void SetColorBack (SSColor color);
	void SetColorFore (SSColor color);
	
	void RestoreColors ();
	
	//	Inquiry method
	
	Bool UseColor () const { return this->use_color; }
	void GetIconSize (Card16 num, Dim& dim) const;
	Card16 GetError () const { return this->err; }
};

#endif /* _COLOR_MAN_H_ */

