#ifndef _HLDBOX_H
#define _HLDBOX_H

#define DBOXFIRSTBUTT	0x7e40
#define DBOXLASTBUTT	0x7e5f
#define DBOXFIRSTLINE	0x7e00
#define DBOXLASTLINE	0x7e3f

#define dboxisbutton(code) (code >= DBOXFIRSTBUTT && code <= DBOXLASTBUTT)
#define dboxisline(code) (code >= DBOXFIRSTLINE && code <= DBOXLASTLINE)
#define dboxnbutton(code) (code - DBOXFIRSTBUTT)
#define dboxnline(code) (code - DBOXFIRSTLINE)
#define dboxbuttonpress(code,butt) (dboxisbutton(code) && dboxnbutton(code) == butt)
#define dboxlinepress(code,line) (dboxisline(code) && dboxnline(code) == line)

#define DBOXARROWUP 0
#define DBOXARROWDOWN 1

typedef
struct dboxgroup
  {
    int nbgroup;		/* nombre de groupes */
    u_long groups[32];		/* groupes de boutons ronds */
  } Dboxgroup;

struct dboxline
  {
    Point coorfleche ;		/* coordonne dbut de la flche	*/
    char fleche;		/* la ligne possde des flches +/-	*/
    char length;		/* longueur de la ligne			*/
    char scrlength;		/* longueur visible de la ligne 	*/
    char *ptr;			/* pointeur  la ligne			*/
    char *oldptr;		/* pointeur  l'ancienne ligne		*/
    short position;		/* position de la ligne pour GETCO 	*/
    short key;			/* touche associe  la ligne 		*/
    char editord;		/* ordre d'dition			*/
    char sort;			/* 1 => sort lorsqu'on clique dessus	*/    
    char label;			/* no. de label de la ligne (-1) pas de label */
    char grey ;			/* 1 => touche grise			*/
  };

struct dboxbutton
  {
    short key;			/* touche associe au bouton		*/
    char isradio;		/* bouton "radio"			*/
    char number;		/* numro de bouton (bit)		*/
    char sort;			/* 1 => sort lorsqu'on clique dessus	*/
  };

struct dboxtouche
  {
    short code ;
    char label ;
  } ;

typedef
struct dbox
  {
    u_char nbtouches ;
    struct dboxtouche touches[10];
    u_char greymap[32];		/* bitmap des labels griss		*/
    struct dboxline lines[20];	/* description des lignes ditables	*/
    u_char nblines;		/* nombre de lignes			*/
    char editline;		/* no. de la ligne  diter		*/
    char *cursor;		/* pointeur  la position du curseur	*/
    u_long flags;		/* tat des boutons			*/
    u_long oldflags;		/* ancien tat des boutons		*/
    u_long canal;		/* canal DBOX, ou NULL si pas ouvert	*/
    u_char *dbptr;		/* pointeur  la table de description	*/
    struct dboxgroup *group;	/* pointeur  la description des groupes */
    struct dboxbutton buttons[32];
    				/* boutons 				*/
    u_char nbbuttons;		/* nombre de boutons 			*/
    short *convtable;		/* table de conversion des touches	*/
    u_int menuc;		/* canal pour L_pushmenu		*/
    int (*arrowfunc)(struct dbox *dbox, int nline, int direct) ;
    				/* fonction pour flches 		*/
  } Dbox ;

typedef int (*Dboxfunc) (Dbox *dbox, int nline, int direct) ;



extern int dboxputlined (struct dbox *dbox, int nline, double nombre, int nodec) ;
extern int dboxgetlined (struct dbox *dbox, int nline, double *nombre) ;
extern int dboxputlinel (struct dbox *dbox, int nline, long nombre, int radix) ;
extern int dboxgetlinel (struct dbox *dbox, int nline, long *nombre, int radix) ;
extern int dboxputarrowfunc (struct dbox *dbox, Dboxfunc func) ;
extern int dboxinit (u_char * pdbox, struct dbox *dbox, struct dboxgroup *group, short *convtable);
extern int dboxchline (struct dbox *dbox, int num);
extern int dboxopen (struct dbox *dbox);
extern int dboxclose (struct dbox *dbox);
extern int dboxedit (struct dbox *dbox, short *touche);
extern int dboxcancel (struct dbox *dbox);
extern int dboxsetcurs ( struct dbox *dbox, int label );
extern int dboxputline ( struct dbox *dbox, int noline, char *string );
extern int dboxgetline ( struct dbox *dbox, int noline, char **line );
extern int dboxgetlinecpy ( struct dbox *dbox, int noline, char *line );
extern int dboxgrey ( struct dbox *dbox, int label );
extern int dboxfull ( struct dbox *dbox, int label );
extern int dboxgreyif ( struct dbox *dbox, int label, int condition );
extern int dboxisgrey (struct dbox *dbox, int label);
extern int dboxgetco ( struct dbox *dbox, int label, Point *p1, Point *p2 );
extern int dboxshowline (struct dbox *dbox, int nline);
extern int dboxundoline (struct dbox *dbox) ;
extern int dboxbip (struct dbox *dbox, short touche) ;
extern void dboxputflags (struct dbox *dbox, long flags);
extern void dboxsetflag (struct dbox *dbox, int nflag) ;
extern void dboxclrflag (struct dbox *dbox, int nflag) ;
extern long dboxgetflags (struct dbox *dbox) ;
extern int dboxifflag (struct dbox *dbox, int nflag) ;

#endif
