/*
 *	gra.h
 *
 *	Gra2 and display descriptor interface for SMA_SMAKY
 *
 *	(C)	1994 Daniel MARMIER
 */

#ifndef _GRA_H_
#define _GRA_H_

#include "grastructs.h"

#define	LOADDOT	(0)
#define INVDOT	(1)
#define SETDOT	(2)
#define CLRDOT	(3)

#define	PENDOT	(1<<2)
#define	TTTDOT	(1<<3)
#define	NCTDOT	(1<<4)

#define	CPLDOT	(1<<6)
#define	GREDOT	(1<<7)
#define	SRCCOUL	(1<<11)
#define	DSTCOUL	(1<<12)


struct DisDesc
{
	Pos		p, pg;		// typo/graphical position

	Box		wind_box;	// box of display in pixmap
	Dim		c,c1,c2;	// char dims
	Int16	cix;
	Card8	tra[8];
	Box		clip_box;	// clipping box in display

	Gencar*	pgc;		// current gencar
	Card8	mod,flg;
	Card8	cav, cah;
	Card8	mca;
	Card8	now;		// display number
	Card16	cad;
	void*	pim;		// ^ to alpha image
	
	DisDesc	**pde;		// ^ to list of ^ to DisDesc
	Card16	cam;
	Card8	nom;
	Card8	mgr;		// graphical mode
	Card8	gcf, gcs, gct;
	Card8	big;
	Pos		ca;
	
	Card8	pen[8];
	void*	fip;

//	Private & secrete variables
	
	Card16	chhwd;		// HWDIS channel
	Card8	pflags;		// bit 0 : no menu bar ; bit 1 : no soft-keys
	Card8	hwres;		// reserve
	Card32	chdm;		// display manager channel
	Card32	pmid;		// pixmap id
	Dim		pdim;		// pixmap dim
	void	*bdraw;		// "begin draw" function
	void	*edraw;		// "end draw" function
	void	*drawfuncs;	// drawing functions
	Card8	var[12];

//
	
	Card8	ttm, tts;
	Card16	ttc;
	void* 	abs;		// ^ to pixmap
	void*	pst;
	
	Seg		w;			// upper left & lower right corners of window
	void*	pms;
	void*	pmc;
	
	Card16	iix;		// gap between chars ???EBK
	Card16	iiy;		// # of bytes per pixmap line
	Card8	fix[4];		// font prefix
	Card32	psk;
	Card32	crg;		// clipping region ID

// mouse cursor

	void*	mps;
	void*	mpc;
	Box		m;
	Card8	mfl, fl2;

//	color

	Card32	clg;
	Card16	cnb;			// # of colors
	Card8	cnp;			// depth
	Card8	cmd;			// TRUE if depth > 1
	Card16	csa[3], cca[3];
	Card32	csr, ccr;
	Card32	csf, ccf;		// foreground/background pixel values
	Card32	cpf;			// TCOLOR channel
	Card16	cnr, cmr;
	void*	cpr;
	Card16	cns, cms;		// # of pushs, max pushs
	void*	cps;			// ^ to color stack
	void*	cab;			// ^ to pixmap
	Card8	res2[12];

// pen

	void*	ppm;
	Box		pbox;
	Card16	pii;
	Card16	pt[8];
	Card8	res3[8];

// stipple

	void*	tpm;
	Box		tbox;
	Card16	tii;
	Pos		tor;
	Card8	res4[4];

//
	
	DisDesc	*check;				// pointer on myself
	void	*grabsem;			// grabbing semaphore id
	Int16	grabcnt;			// fastlock counter (-1 if no lock)
	
	Int8	hoty;				// mouse hot-point y
	Int8	hotx;				// mouse hot-point x
	
	void	*grvar;				// global gra2 variables
	void	*tpgr[32];			// internal gra2 routines
	void	*pgrbef;			// routine called "before"
	void	*pgraft;			// routine called "after"

//
	
	Card16	maxlg;				// descriptor maximal size
	Card8	rev;				// major revision of display driver
	Card8	vers;				// minor revision of display driver
	
//
	
	Box		i_wind_box;			// unalterable copy of "wind_box" for MOUSE
	Card16	adr;
	Card16	nxt;
	Card16	cpt;
	Card16	cct;
	char	com[30];
	Card8	map[8];
	Card16	psv;
	Card32	ssv[10];
	char	ngc[24];
	
	DisDesc* GetPDis (Card8 disp) { return pde[disp]; }
};


enum JustMode
{
	JUST_LEFT,
	JUST_CENTER,
	JUST_RIGHT
};


class Gra {

private:
	DisDesc* dd;
	Card16 mode;
	Card16 err;
	
	void SpeedRaster(const void *source, Card16 swidth, void *dest, Card16 dwidth, Card16 posx,
					 Card16 dx, Card16 dy);

public:
	Gra (DisDesc* dd) : dd(dd)		{ }
	~ Gra ()						{ }

	Card16	GetMode () const		{ return this->mode; }
	Card16	GetError () const		{ return this->err; }
	
	DisDesc	*GetDescr () const		{ return this->dd; }
	void*	GetAddr () const		{ return this->dd->abs; }
	Box		GetWindowBox () const	{ return this->dd->wind_box; }
	Box		GetClipBox () const		{ return this->dd->clip_box; }
	Card8	GetDepth () const		{ return this->dd->cnp; }
	Card32	GetTChannel () const	{ return this->dd->cpf; }

	void SetMode (Card16 mode)		{ this->mode = mode; }
	void SetFgPixel (Card32 val)	{ this->dd->csf = val; }
	void SetBgPixel (Card32 val)	{ this->dd->ccf = val; }
	void SetClipBox (Box clip);

	void Line (Box line);
	void Rect (Box rect);
	void RasterMono (Box box, Pos pos, const void* raster, Card16 rbytes);
	void RasterColor (Box box, Pos pos, const void *raster, Card16 rbytes);
	void Icon (Pos pos, void* icon);
	void Clear (Box zone);
	void Set (Box zone);
	void Trame (Box zone, void *trame);
	
	void SetGencar (Gencar *gencar);
	Card8 GetGencarHeight () const;
	Card16 GetGencarAscent () const;
	
	void DrawChar (Pos& p, char c, Card8 hole = 0);
	void DrawText (Pos p, const char *text, Card8 hole = 0);
	void DrawText (Pos p, const char *text, void *buffer, Card16 bwidth);
	
	void DrawBText (const char *text, void *buffer, Card16 bwidth);
	
	void DrawCText (Box b, const char *text, JustMode mode = JUST_LEFT,
					Card8 hole = 0);
	void DrawCText (Box b, const char *text, void *buffer, Card16 bwidth,
					JustMode mode = JUST_LEFT);
	
	Card32 TextWidth (const char *text);
	Card32 CharWidth (char c);

	void DecodeImage (void* decoded, const void* encoded, Image* header) const;
};

#endif /* _GRA_H_ */

